/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.pullcheck;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.pullcheck.Data;
import kd.fi.ict.pullcheck.ICalculatorPuchAmt;
import kd.fi.ict.pullcheck.Key;
import kd.fi.ict.pullcheck.Log;
import kd.fi.ict.pullcheck.LogList;
import kd.fi.ict.pullcheck.acct.AcctCalculatorCheckAmt;
import kd.fi.ict.pullcheck.acct.AcctCalculatorNoCheckAmt;
import kd.fi.ict.pullcheck.acct.AcctCalculatorPullAmt;
import kd.fi.ict.pullcheck.cf.CfCalculatorCheckAmt;
import kd.fi.ict.pullcheck.cf.CfCalculatorNoCheckAmt;
import kd.fi.ict.pullcheck.cf.CfCalculatorPullAmt;
import kd.fi.ict.util.PeriodUtil;

public abstract class AbstractCalculatorPuchAmt<D extends Data, L extends Log, K extends Key>
implements ICalculatorPuchAmt {
    private OperationType operationType;
    private static final int MAX_RECORD_NUM = 200;
    private static final int MAX_UPDATE_PARAM_NUM = 2000;
    protected static final DBRoute ICT = DBRoute.of((String)"fi");

    public AbstractCalculatorPuchAmt(OperationType operationType) {
        this.operationType = operationType;
    }

    @Override
    public int calculate(long orgId, long bookTypeId) {
        DataSet ds = DB.queryDataSet((String)"AbstractCalculatorPuchAmt.calculate", (DBRoute)ICT, (String)this.getLogSql(), (Object[])this.getLogParams(orgId, bookTypeId));
        return this.updatePuchAmt(orgId, bookTypeId, ds, false, 0L);
    }

    @Override
    public int reCalculate(long orgId, long bookTypeId, long periodId) {
        DataSet ds = DB.queryDataSet((String)"AbstractCalculatorPuchAmt.reCalculate", (DBRoute)ICT, (String)this.getBillSql(), (Object[])this.getBillParams(orgId, bookTypeId, periodId));
        ds = ds.orderBy(this.getOrderBy());
        return this.updatePuchAmt(orgId, bookTypeId, ds, true, periodId);
    }

    private int updatePuchAmt(long orgId, long bookTypeId, DataSet ds, boolean reCal, long periodId) {
        LogList<K> noCheckAmtData = this.getNoCheckAmtData(orgId, bookTypeId, periodId, reCal);
        ArrayList<Long> logIds = new ArrayList<Long>();
        LogList<K> logList = new LogList<K>();
        List periodIdList = null;
        Object pk = null;
        long period = 0L;
        long pdId = 0L;
        int index = 0;
        String groupKey = "";
        HashSet<K> exisDatas = null;
        for (Row rs : ds) {
            if (!reCal) {
                logIds.add(rs.getLong("fid"));
            }
            String lGroupKey = this.getGroupKey(rs);
            K lpk = this.getPk(rs);
            if (!(logList.isEmpty() || lGroupKey.equals(groupKey) && (((Key)lpk).equals(pk) || logList.size() < 200))) {
                if (period != pdId) {
                    pdId = period;
                    periodIdList = PeriodUtil.getAvailableEndPeriodIds((String)this.getTab(), (String)">=", (Long)period, (Long[])new Long[]{orgId});
                }
                this.updatePuchAmt(orgId, bookTypeId, period, logList, logIds, periodIdList, reCal, noCheckAmtData);
            }
            logList.add(lpk, (Log)this.getLogData(reCal, rs));
            pk = lpk;
            groupKey = lGroupKey;
            period = rs.getLong(this.getPeriodField());
            ++index;
            if (!reCal) continue;
            if (exisDatas == null) {
                exisDatas = new HashSet<K>(16);
            }
            exisDatas.add(lpk);
        }
        if (!logList.isEmpty()) {
            if (period != pdId) {
                periodIdList = PeriodUtil.getAvailableEndPeriodIds((String)this.getTab(), (String)">=", (Long)period, (Long[])new Long[]{orgId});
            }
            this.updatePuchAmt(orgId, bookTypeId, period, logList, logIds, periodIdList, reCal, noCheckAmtData);
        }
        if (noCheckAmtData != null && !noCheckAmtData.isEmpty()) {
            if (periodId != pdId) {
                periodIdList = PeriodUtil.getAvailableEndPeriodIds((String)this.getTab(), (String)">=", (Long)periodId, (Long[])new Long[]{orgId});
            }
            this.updatePuchAmt(orgId, bookTypeId, periodId, noCheckAmtData, new ArrayList<Long>(0), periodIdList, reCal, null);
        }
        if (reCal) {
            if (periodId != pdId) {
                periodIdList = PeriodUtil.getAvailableEndPeriodIds((String)this.getTab(), (String)">=", (Long)periodId, (Long[])new Long[]{orgId});
            }
            this.updateNoDataPuchAmt(orgId, bookTypeId, periodId, periodIdList, exisDatas);
        }
        return index;
    }

    private String getGroupKey(Row rs) {
        StringBuilder key = new StringBuilder();
        if (this instanceof AcctCalculatorPullAmt || this instanceof CfCalculatorPullAmt) {
            key.append(rs.getString("foriperiodid"));
        } else {
            key.append(rs.getString("fperiodid"));
        }
        if (this.operationType == OperationType.DELETE) {
            key.append("-").append(rs.getString("fperiodid"));
        } else if (this.operationType == OperationType.CANCELCHECK) {
            key.append("-").append(rs.getString("foriperiodid"));
            key.append("-").append(rs.getString("fcurperiodid"));
        }
        return key.toString();
    }

    private void updatePuchAmt(long orgId, long bookTypeId, long periodId, LogList<K> logList, List<Long> logIds, List<Long> periodList, boolean reCal, LogList<K> noCheckAmtData) {
        Map<Key, List<D>> puchData = this.getPuchAmtData(orgId, bookTypeId, logList, periodList, reCal);
        Params params = new Params();
        for (Map.Entry<K, Log> entry : logList.getData().entrySet()) {
            List puchList;
            Log noCheckD;
            Key key = (Key)entry.getKey();
            Log logData = entry.getValue();
            if (reCal && noCheckAmtData != null && !noCheckAmtData.isEmpty() && (noCheckD = noCheckAmtData.getData().get(key)) != null) {
                logData.add(noCheckD);
                noCheckAmtData.getData().remove(key);
            }
            if ((puchList = puchData.computeIfAbsent(key, k -> null)) != null && !puchList.isEmpty()) {
                Iterator it = puchList.iterator();
                if (!it.hasNext()) continue;
                Data puchRow = (Data)it.next();
                Data prePuch = null;
                if (OperationType.CANNEXTPERIOD == this.getOperationType()) {
                    if (puchRow.getEndPeriodId() == periodId && it.hasNext()) {
                        prePuch = puchRow = (Data)it.next();
                        if (it.hasNext()) {
                            prePuch = puchRow;
                            puchRow = (Data)it.next();
                        }
                    } else if (puchRow.getPeriodId() == periodId && it.hasNext()) {
                        prePuch = puchRow;
                        puchRow = (Data)it.next();
                    }
                } else if (puchRow.getEndPeriodId() == periodId && it.hasNext()) {
                    prePuch = puchRow;
                    puchRow = (Data)it.next();
                }
                if (this instanceof AcctCalculatorNoCheckAmt || this instanceof CfCalculatorNoCheckAmt) {
                    this.buildNextParam(orgId, bookTypeId, periodId, params, key, logData, puchRow, prePuch, reCal);
                    continue;
                }
                if (puchRow.getPeriodId() == periodId) {
                    this.dealInvalidPeriod(puchRow, prePuch, logData, params, reCal);
                    Object[] param = this.getUpdateAmtParam(periodId, logData, puchRow, prePuch, reCal);
                    if (param.length <= 0) continue;
                    params.addUpdateAmtParam(param);
                    if (reCal) {
                        this.recalDealNext(periodId, logData, it, params, puchRow);
                        continue;
                    }
                    this.dealNext(periodId, logData, it, params, puchRow);
                    continue;
                }
                if (puchRow.getPeriodId() < periodId) {
                    long endPeriodId = puchRow.getEndPeriodId();
                    if (puchRow.getEndPeriodId() == periodId && !it.hasNext()) {
                        endPeriodId = PeriodUtil.MAX_PERIOD;
                    }
                    params.addUpdateEndPeriodParam(new Object[]{periodId, puchRow.getId()});
                    params.addNewAmtParam(this.getNewAmtParam(orgId, bookTypeId, periodId, key, logData, puchRow, endPeriodId, reCal));
                    this.dealNext(periodId, logData, it, params, puchRow);
                    continue;
                }
                long endPeriodId = puchRow.getPeriodId();
                params.addNewAmtParam(this.getNewAmtParam(orgId, bookTypeId, periodId, key, logData, null, endPeriodId, reCal));
                this.dealNext(periodId, logData, puchList.iterator(), params, puchRow);
                continue;
            }
            params.addNewAmtParam(this.getNewAmtParam(orgId, bookTypeId, periodId, key, logData, null, PeriodUtil.MAX_PERIOD, reCal));
        }
        this.storeDB(params, logIds, reCal);
        logList.clear();
    }

    private void updateNoDataPuchAmt(long orgId, long bookTypeId, long periodId, List<Long> periodList, Set<K> exisDatas) {
        Map<K, List<D>> puchData = this.getPuchAmtData(orgId, bookTypeId, null, periodList, true);
        Params params = new Params();
        this.updateNoDataRecord(puchData, periodId, exisDatas, params);
        this.storeDB(params, new ArrayList<Long>(0), true);
    }

    private void updateNoDataRecord(Map<K, List<D>> puchData, long periodId, Set<K> exisDatas, Params params) {
        for (Map.Entry<K, List<D>> entry : puchData.entrySet()) {
            Object[] param;
            Iterator<D> it;
            List<D> puchList;
            Key key = (Key)entry.getKey();
            if (exisDatas != null && exisDatas.contains(key) || (puchList = entry.getValue()) == null || puchList.isEmpty() || !(it = puchList.iterator()).hasNext()) continue;
            Data puchRow = (Data)it.next();
            Data prePuch = null;
            if (puchRow.getEndPeriodId() == periodId && it.hasNext()) {
                prePuch = puchRow;
                puchRow = (Data)it.next();
            }
            if (puchRow.getPeriodId() != periodId || (param = this.getUpdateAmtParam(periodId, null, puchRow, prePuch, true)).length <= 0) continue;
            params.addUpdateAmtParam(param);
        }
    }

    private void buildNextParam(long orgId, long bookTypeId, long periodId, Params params, K key, L logData, D puchRow, D prePuch, boolean reCal) {
        if (((Data)puchRow).getPeriodId() >= periodId) {
            Object[] noCheckPrePeriodParam;
            Object[] noCheckPeriodParam = this.getUpdateAmtParam(periodId, logData, puchRow, prePuch, reCal);
            if (noCheckPeriodParam.length > 0) {
                if (OperationType.CFRNEXTPERIOD == this.getOperationType()) {
                    params.addUpdateNoCheckAddParams(noCheckPeriodParam);
                } else {
                    params.addUpdateNoCheckSubParams(noCheckPeriodParam);
                    if (this.isPuchZero(puchRow, logData, reCal)) {
                        params.addRemovePuchId(((Data)puchRow).getId());
                        if (prePuch != null) {
                            params.addUpdateEndPeriodParam(new Object[]{((Data)puchRow).getEndPeriodId(), ((Data)prePuch).getId()});
                        }
                    }
                }
            }
            if (prePuch != null && (noCheckPrePeriodParam = this.getUpdateAmtParam(periodId, logData, prePuch, null, reCal)).length > 0) {
                if (OperationType.CFRNEXTPERIOD == this.getOperationType()) {
                    params.addUpdateNoCheckSubParams(noCheckPrePeriodParam);
                } else {
                    params.addUpdateNoCheckAddParams(noCheckPrePeriodParam);
                }
            }
        } else if (((Data)puchRow).getPeriodId() < periodId) {
            long endPeriodId = ((Data)puchRow).getEndPeriodId();
            params.addUpdateEndPeriodParam(new Object[]{periodId, ((Data)puchRow).getId()});
            Object[] noCheckSubParam = this.getUpdateAmtParam(periodId, logData, puchRow, prePuch, reCal);
            if (noCheckSubParam.length > 0) {
                params.addUpdateNoCheckSubParams(noCheckSubParam);
            }
            params.addNewAmtParam(this.getNewAmtParam(orgId, bookTypeId, periodId, key, logData, puchRow, endPeriodId, false));
        }
    }

    private Object[] getUpdateAmtParam(long periodId, L logData, D puchData, D preDal, boolean reCal) {
        List<BigDecimal> updParam = this.getUpdatePuchAmtParam(periodId, logData, puchData, preDal, reCal);
        if (reCal && this.equals(puchData, updParam.toArray(new BigDecimal[0]))) {
            return new Object[0];
        }
        ArrayList<Number> param = new ArrayList<Number>();
        param.addAll(updParam);
        param.add(((Data)puchData).getId());
        return param.toArray();
    }

    private Map<K, List<D>> getPuchAmtData(long orgId, long bookTypeId, LogList<K> logList, List<Long> periodIdList, boolean reCal) {
        HashMap<Key, List> data = new HashMap<Key, List>();
        SqlBuilder sqlBuilder = this.getPuchSqlBuilder(orgId, bookTypeId, periodIdList, logList, reCal);
        DataSet ds = DB.queryDataSet((String)"AbstractCalculatorPuchAmt.getPuchAmtData", (DBRoute)ICT, (SqlBuilder)sqlBuilder);
        for (Row rs : ds) {
            K key = this.getPk(rs);
            List dataList = data.computeIfAbsent((Key)key, k -> new ArrayList());
            dataList.add(this.getPuchData(rs, reCal));
        }
        return data;
    }

    protected Object[] getNewAmtParam(long orgId, long bookTypeId, long periodId, K pk, L logData, D prePuchData, long endPeriodId, boolean reCal) {
        long[] keys = ((Key)pk).getKeyValues();
        ArrayList<Number> param = new ArrayList<Number>(keys.length);
        long blaId = this.genId();
        param.add(blaId);
        param.add(orgId);
        param.add(bookTypeId);
        param.add(periodId);
        param.add(endPeriodId);
        for (int i = 0; i < keys.length; ++i) {
            param.add(keys[i]);
        }
        param.addAll(this.getNewPuchAmtParam(pk, periodId, logData, prePuchData, reCal));
        return param.toArray();
    }

    private void storeDB(Params params, List<Long> logIds, boolean relCal) {
        try {
            if (!params.getRemovePuchIds().isEmpty()) {
                DB.execute((DBRoute)ICT, (String)this.getRemovePuchSql(params.getRemovePuchIds().size()), (Object[])params.getRemovePuchIds().toArray());
            }
            if (!params.getUpdateEndPeriodParams().isEmpty()) {
                DB.executeBatch((DBRoute)ICT, (String)(" UPDATE " + this.getTab() + " SET FENDPERIODID = ? WHERE FID = ?;"), params.getUpdateEndPeriodParams());
            }
            if (!params.getNewAmtParams().isEmpty()) {
                DB.executeBatch((DBRoute)ICT, (String)this.getInsertPuchSql(), params.getNewAmtParams());
            }
            if (!params.getUpdateAmtParams().isEmpty()) {
                DB.executeBatch((DBRoute)ICT, (String)this.getUpdAmtSql(relCal), params.getUpdateAmtParams());
            }
            if (!params.getUpdateCurrYAmtParams().isEmpty()) {
                DB.executeBatch((DBRoute)ICT, (String)this.getUpdCurrYAmtSql(), params.getUpdateCurrYAmtParams());
            }
            if (!params.getUpdateLaterYAmtParams().isEmpty()) {
                DB.executeBatch((DBRoute)ICT, (String)this.getUpdLaterYAmtSql(), params.getUpdateLaterYAmtParams());
            }
            if (!params.getUpdateNoCheckSubAmtParams().isEmpty()) {
                DB.executeBatch((DBRoute)ICT, (String)this.getUpdateNoCheckSubAmtSql(), params.getUpdateNoCheckSubAmtParams());
            }
            if (!params.getUpdateNoCheckAddAmtParams().isEmpty()) {
                DB.executeBatch((DBRoute)ICT, (String)this.getUpdateNoCheckAddAmtSql(), params.getUpdateNoCheckAddAmtParams());
            }
            this.setCalculateStatus(logIds);
        }
        catch (Exception e) {
            logIds.clear();
            throw e;
        }
    }

    private void setCalculateStatus(List<Long> logIds) {
        if (logIds.isEmpty()) {
            return;
        }
        int batchCount = (int)Math.ceil((double)logIds.size() * 1.0 / 2000.0);
        for (int i = 0; i < batchCount; ++i) {
            int fromIndex = i * 2000;
            int toIndex = Math.min((i + 1) * 2000, logIds.size());
            List<Long> idlst = logIds.subList(fromIndex, toIndex);
            this.executeSql(idlst);
        }
    }

    private void executeSql(List<Long> idlst) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.appendIn(String.format(this.getUpdateLogCaledSql(), this.getLogTable()), idlst.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
    }

    private long genId() {
        return DB.genLongId((String)this.getTab());
    }

    private SqlBuilder getPuchSqlBuilder(long orgId, long bookTypeId, List<Long> periodIdList, LogList<K> logList, boolean reCal) {
        String[] keys;
        SqlBuilder sql = new SqlBuilder();
        sql.append(" SELECT fid,fschemeid,fperiodid,fendperiodid,forgid,fbooktypeid,", new Object[0]);
        for (String string : keys = this.getKeyFields()) {
            sql.append(string, new Object[0]).append(",", new Object[0]);
        }
        sql.append(this.getPullAmtSelectFields(reCal), new Object[0]);
        if (this instanceof AcctCalculatorCheckAmt || this instanceof CfCalculatorCheckAmt) {
            sql.append(",", new Object[0]);
            sql.append(this.getCheckAmtSelectFields(reCal), new Object[0]);
        }
        sql.append(" FROM", new Object[0]).append(this.getTab(), new Object[0]).append(" where forgid = ?", new Object[]{orgId}).append(" and fbooktypeid=? and", new Object[]{bookTypeId}).appendIn(" fendperiodid", periodIdList.toArray());
        if (logList != null && !logList.isEmpty()) {
            Object[] params = new Object[keys.length];
            for (int j = 0; j < keys.length; ++j) {
                params[j] = new HashSet(200);
            }
            Set<K> logKeys = logList.getData().keySet();
            for (Key key : logKeys) {
                int i = 0;
                long[] lArray = key.getKeyValues();
                int n = lArray.length;
                for (int j = 0; j < n; ++j) {
                    Long p = lArray[j];
                    ((Set)params[i]).add(p);
                    ++i;
                }
            }
            for (int j = 0; j < keys.length; ++j) {
                sql.append(" and ", new Object[0]);
                sql.appendIn(keys[j], ((Set)params[j]).toArray());
            }
        }
        sql.append(" ORDER BY fendperiodid", new Object[0]);
        return sql;
    }

    protected abstract String getLogTable();

    protected abstract String getLogSql();

    protected abstract String getUpdateLogCaledSql();

    private Object[] getLogParams(long orgId, long bookTypeId) {
        return new Object[]{orgId, bookTypeId};
    }

    protected abstract K getPk(Row var1);

    protected abstract L getLogData(boolean var1, Row var2);

    protected Integer reCalculate(long orgId, long bookTypeId, long periodId, ResultSetHandler<Integer> handler) {
        return (Integer)DB.query((DBRoute)ICT, (String)this.getBillSql(), (Object[])this.getBillParams(orgId, bookTypeId, periodId), handler);
    }

    protected abstract String getBillSql();

    protected Object[] getBillParams(long orgId, long bookTypeId, long periodId) {
        if (this instanceof AcctCalculatorCheckAmt || this instanceof CfCalculatorCheckAmt) {
            return new Object[]{orgId, periodId};
        }
        return new Object[]{orgId, bookTypeId, periodId};
    }

    protected LogList<K> getNoCheckAmtData(long orgId, long bookTypeId, long periodId, boolean reCal) {
        LogList<K> logList = new LogList<K>();
        if (reCal && (this instanceof AcctCalculatorPullAmt || this instanceof CfCalculatorPullAmt)) {
            DataSet ds = DB.queryDataSet((String)"AbstractCalculatorPuchAmt.getNoCheckAmtData", (DBRoute)ICT, (String)this.getRecordSql(), (Object[])new Object[]{orgId, bookTypeId, periodId});
            for (Row rs : ds) {
                K key = this.getPk(rs);
                logList.add(key, (Log)this.getNoCheckData(rs));
            }
        }
        return logList;
    }

    protected L getNoCheckData(Row rs) {
        return null;
    }

    protected String getRecordSql() {
        return "";
    }

    protected abstract String getTab();

    protected abstract String[] getKeyFields();

    protected abstract String getPullAmtSelectFields(boolean var1);

    protected abstract String getCheckAmtSelectFields(boolean var1);

    protected abstract D getPuchData(Row var1, boolean var2);

    protected abstract List<BigDecimal> getNewPuchAmtParam(K var1, long var2, L var4, D var5, boolean var6);

    protected abstract String getInsertPuchSql();

    private String getRemovePuchSql(int count) {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from ").append(this.getTab()).append(" where fid in (").append(String.join((CharSequence)",", Collections.nCopies(count, "?"))).append(')');
        return sql.toString();
    }

    protected abstract String getUpdAmtSql(boolean var1);

    protected abstract List<BigDecimal> getUpdatePuchAmtParam(long var1, L var3, D var4, D var5, boolean var6);

    protected abstract boolean equals(D var1, BigDecimal[] var2);

    protected abstract String getUpdCurrYAmtSql();

    protected abstract String getUpdLaterYAmtSql();

    protected String getUpdateNoCheckSubAmtSql() {
        return null;
    }

    protected String getUpdateNoCheckAddAmtSql() {
        return null;
    }

    protected abstract void dealNext(long var1, L var3, Iterator<D> var4, Params var5, D var6);

    protected abstract void recalDealNext(long var1, L var3, Iterator<D> var4, Params var5, D var6);

    protected abstract boolean isPuchZero(D var1, L var2, boolean var3);

    protected abstract String[] getOrderBy();

    public D dealInvalidPeriod(D pullData, D prePuchData, L puchLog, Params params, boolean reCal) {
        if (this.isPuchZero(pullData, puchLog, reCal)) {
            params.addRemovePuchId(((Data)pullData).getId());
            if (prePuchData != null) {
                params.addUpdateEndPeriodParam(new Object[]{((Data)pullData).getEndPeriodId(), ((Data)prePuchData).getId()});
            }
            return prePuchData;
        }
        return pullData;
    }

    protected String getPeriodField() {
        return "fperiodid";
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    protected class Params {
        private List<Object[]> newAmtParams = new ArrayList<Object[]>();
        private List<Object[]> updateEndPeriodParams = new ArrayList<Object[]>();
        private List<Object[]> updateAmtParams = new ArrayList<Object[]>();
        private List<Object[]> updateCurrYAmtParams = new ArrayList<Object[]>();
        private List<Object[]> updateLaterYAmtParams = new ArrayList<Object[]>();
        private List<Object[]> updateNoCheckSubParams = new ArrayList<Object[]>();
        private List<Object[]> updateNoCheckAddParams = new ArrayList<Object[]>();
        private Set<Long> removePuchIds = new HashSet<Long>();

        protected Params() {
        }

        public void addNewAmtParam(Object[] param) {
            this.newAmtParams.add(param);
        }

        public List<Object[]> getNewAmtParams() {
            return this.newAmtParams;
        }

        public void addUpdateEndPeriodParam(Object[] param) {
            this.updateEndPeriodParams.add(param);
        }

        public List<Object[]> getUpdateEndPeriodParams() {
            return this.updateEndPeriodParams;
        }

        public void addUpdateAmtParam(Object[] param) {
            this.updateAmtParams.add(param);
        }

        public List<Object[]> getUpdateAmtParams() {
            return this.updateAmtParams;
        }

        public void addUpdateCurrYAmtParam(Object[] param) {
            this.updateCurrYAmtParams.add(param);
        }

        public List<Object[]> getUpdateCurrYAmtParams() {
            return this.updateCurrYAmtParams;
        }

        public void addUpdateLaterYAmtParam(Object[] param) {
            this.updateLaterYAmtParams.add(param);
        }

        public List<Object[]> getUpdateLaterYAmtParams() {
            return this.updateLaterYAmtParams;
        }

        public void addUpdateNoCheckSubParams(Object[] param) {
            this.updateNoCheckSubParams.add(param);
        }

        public List<Object[]> getUpdateNoCheckSubAmtParams() {
            return this.updateNoCheckSubParams;
        }

        public void addUpdateNoCheckAddParams(Object[] param) {
            this.updateNoCheckAddParams.add(param);
        }

        public List<Object[]> getUpdateNoCheckAddAmtParams() {
            return this.updateNoCheckAddParams;
        }

        public void addRemovePuchId(long puchId) {
            this.removePuchIds.add(puchId);
        }

        public Set<Long> getRemovePuchIds() {
            return this.removePuchIds;
        }
    }
}

