/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.pullcheck.acct;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.Row;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.pullcheck.AbstractCalculatorPuchAmt;
import kd.fi.ict.pullcheck.Data;
import kd.fi.ict.pullcheck.Key;
import kd.fi.ict.pullcheck.Log;
import kd.fi.ict.pullcheck.acct.AcctCheckAmtData;
import kd.fi.ict.pullcheck.acct.AcctPuchAmtKey;
import kd.fi.ict.pullcheck.acct.AcctPuchAmtLog;
import kd.fi.ict.pullcheck.acct.AcctPuchNoCheckData;
import kd.fi.ict.util.PeriodUtil;

public class AcctCalculatorCheckAmt<D extends Data, L extends Log, K extends Key>
extends AbstractCalculatorPuchAmt<AcctPuchNoCheckData, AcctPuchAmtLog, AcctPuchAmtKey> {
    private static final String LOG_SQL = "SELECT L.FID, L.FSCHEMEID, L.FORGID, L.FBOOKTYPEID, L.FORIPERIODID, L.FPERIODID,R.FPERIODID FCURPERIODID, L.FCURRENCYID, L.FASSGRPID,L.FOPERATION, L.FRELRECORDID, L.FCHECKAMTCALED, L.FOPORGID, L.FCREATETIME, L.FACCOUNTTABLEID, L.FACCOUNTID, L.FDEBITFOR, L.FCREDITFOR, L.FDEBITLOCAL, L.FCREDITLOCAL FROM T_ICT_ACCTPUCHAMT_LOG L INNER JOIN T_ICT_RELACCTRECORD R ON R.FID = L.FRELRECORDID WHERE L.FORGID = ? AND L.FBOOKTYPEID = ? AND FCHECKAMTCALED = '0' AND FOPERATION IN ('MANUALCHECK','AUTOCHECK','CANCELCHECK') ORDER BY FPERIODID,FACCOUNTTABLEID,FACCOUNTID,FCURRENCYID,FASSGRPID;";
    private static final String BILL_SQL = "SELECT A.FMASTERID FACCOUNTID,E.FASSGRPID,E.FAMTVERIFY,E.FAMTVERIFYLOC,E.FDC,E.FCURRENCYID,E.FLOCCURID FCURRENCYLOCID,R.FPERIODID FPERIODID,T.FORIPERIODID,T.FPERIODID FCURPERIODID,R.FVERIFYSCHEMEID FSCHEMEID,E.FORGID,E.FOPPORGID FOPORGID,T.FACCOUNTTABLEID,E.FENTRYID FROM T_ICT_CROSS_ENTRY E INNER JOIN T_ICT_CROSS_RECORD R ON E.FID = R.FID INNER JOIN T_ICT_RELACCTRECORD T ON E.FRELRECORDID = T.FID INNER JOIN T_BD_ACCOUNT A ON E.FACCOUNTID = A.FID WHERE E.FORGID = ? AND R.FPERIODID = ?;";
    private static final String INSERT_PUCH_SQL = "INSERT INTO T_ICT_ACCTPUCHAMT (FID,FORGID,FBOOKTYPEID ,FPERIODID,FENDPERIODID,FSCHEMEID,FACCOUNTTABLEID,FACCOUNTID,FCURRENCYID ,FASSGRPID,FOPORGID,FPBEGINFOR,FPBEGINLOCAL,FPYEARDEBITFOR,FPYEARDEBITLOCAL,FPYEARCREDITFOR,FPYEARCREDITLOCAL,FPENDFOR,FPENDLOCAL,FCBEGINFOR,FCBEGINLOCAL,FCDEBITFOR,FCDEBITLOCAL,FCCREDITFOR,FCCREDITLOCAL,FCYEARDEBITFOR,FCYEARDEBITLOCAL,FCYEARCREDITFOR,FCYEARCREDITLOCAL,FCENDFOR,FCENDLOCAL,FCURCDEBITFOR,FCURCDEBITLOCAL,FCURCCREDITFOR,FCURCCREDITLOCAL,FCURNDEBITFOR,FCURNDEBITLOCAL,FCURNCREDITFOR,FCURNCREDITLOCAL) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
    private static final String RE_UPD_PUCH_AMT_SQL = "UPDATE T_ICT_ACCTPUCHAMT SET FCBEGINFOR = ?, FCBEGINLOCAL = ?, FCDEBITFOR = ?, FCDEBITLOCAL = ?,FCCREDITFOR = ?,FCCREDITLOCAL = ?,FCYEARDEBITFOR = ?, FCYEARDEBITLOCAL = ?, FCYEARCREDITFOR = ? , FCYEARCREDITLOCAL = ? ,FCENDFOR = ? , FCENDLOCAL = ? , FCURCDEBITFOR = ?,FCURCDEBITLOCAL = ?,FCURCCREDITFOR = ? ,FCURCCREDITLOCAL = ? WHERE FID = ?;";
    private static final String UPD_PUCH_AMT_SQL = "UPDATE T_ICT_ACCTPUCHAMT SET FCDEBITFOR = FCDEBITFOR + ?, FCDEBITLOCAL = FCDEBITLOCAL + ?, FCCREDITFOR = FCCREDITFOR + ?, FCCREDITLOCAL = FCCREDITLOCAL + ?, FCYEARDEBITFOR = FCYEARDEBITFOR + ?, FCYEARDEBITLOCAL = FCYEARDEBITLOCAL + ?, FCYEARCREDITFOR = FCYEARCREDITFOR + ?, FCYEARCREDITLOCAL = FCYEARCREDITLOCAL + ?, FCENDFOR=FCENDFOR + ?, FCENDLOCAL=FCENDLOCAL + ?, FCURCDEBITFOR = FCURCDEBITFOR + ?,FCURCDEBITLOCAL = FCURCDEBITLOCAL + ?,FCURCCREDITFOR = FCURCCREDITFOR + ? ,FCURCCREDITLOCAL = FCURCCREDITLOCAL + ?, FCURNDEBITFOR = FCURNDEBITFOR - ?,FCURNDEBITLOCAL = FCURNDEBITLOCAL - ?,FCURNCREDITFOR = FCURNCREDITFOR - ? ,FCURNCREDITLOCAL = FCURNCREDITLOCAL - ? WHERE FID = ?;";
    private static final String UPD_CURR_Y_PUCH_SQL = "UPDATE T_ICT_ACCTPUCHAMT SET FCBEGINFOR = FCBEGINFOR+?,FCBEGINLOCAL = FCBEGINLOCAL+?,FCYEARDEBITFOR = FCYEARDEBITFOR+?,FCYEARDEBITLOCAL = FCYEARDEBITLOCAL+?,FCYEARCREDITFOR = FCYEARCREDITFOR+?,FCYEARCREDITLOCAL = FCYEARCREDITLOCAL+?,FCENDFOR = FCENDFOR+?,FCENDLOCAL = FCENDLOCAL+? WHERE FID = ?;";
    private static final String UPD_LATER_Y_PUCH_SQL = "UPDATE T_ICT_ACCTPUCHAMT SET  FCBEGINFOR = FCBEGINFOR+?,FCBEGINLOCAL = FCBEGINLOCAL+?,FCENDFOR = FCENDFOR+?,FCENDLOCAL = FCENDLOCAL+? WHERE FID = ?;";
    private static final String UPD_PUCH_NoCheckAMT_ADD_SQL = "UPDATE T_ICT_ACCTPUCHAMT SET FCURNDEBITFOR = FCURNDEBITFOR - ?,FCURNDEBITLOCAL = FCURNDEBITLOCAL - ?,FCURNCREDITFOR = FCURNCREDITFOR - ? ,FCURNCREDITLOCAL = FCURNCREDITLOCAL - ? WHERE FID = ? ;";

    public AcctCalculatorCheckAmt(OperationType operationType) {
        super(operationType);
    }

    @Override
    protected String getLogTable() {
        return "t_ict_acctpuchamt_log";
    }

    @Override
    protected String getLogSql() {
        return LOG_SQL;
    }

    @Override
    protected String getUpdateLogCaledSql() {
        return " UPDATE %S SET FCHECKAMTCALED='1' WHERE FID ";
    }

    @Override
    protected AcctPuchAmtKey getPk(Row rs) {
        return new AcctPuchAmtKey(rs.getLong("fschemeid"), rs.getLong("faccounttableid"), rs.getLong("faccountid"), rs.getLong("fcurrencyid"), rs.getLong("fassgrpid"), rs.getLong("foporgid"));
    }

    @Override
    protected AcctPuchAmtLog getLogData(boolean reCal, Row rs) {
        AcctPuchAmtLog log = new AcctPuchAmtLog();
        long foriperiodid = rs.getLong("foriperiodid");
        long fperiodid = rs.getLong("fperiodid");
        log.setOriPeriodId(foriperiodid);
        log.setPeriodId(fperiodid);
        log.setCurPeriodId(rs.getLong("fcurperiodid"));
        BigDecimal debitFor = BigDecimal.ZERO;
        BigDecimal debitLocal = BigDecimal.ZERO;
        BigDecimal creditFor = BigDecimal.ZERO;
        BigDecimal creditLocal = BigDecimal.ZERO;
        if (reCal) {
            BigDecimal amt = rs.getBigDecimal("famtverify");
            BigDecimal amtloc = rs.getBigDecimal("famtverifyloc");
            if ("1".equals(rs.getString("fdc"))) {
                debitFor = amt;
                debitLocal = amtloc;
            } else {
                creditFor = amt;
                creditLocal = amtloc;
            }
        } else {
            debitFor = rs.getBigDecimal("fdebitfor");
            debitLocal = rs.getBigDecimal("fdebitlocal");
            creditFor = rs.getBigDecimal("fcreditfor");
            creditLocal = rs.getBigDecimal("fcreditlocal");
        }
        log.setDebitFor(debitFor);
        log.setDebitLocal(debitLocal);
        log.setCreditFor(creditFor);
        log.setCreditLocal(creditLocal);
        if (foriperiodid == fperiodid) {
            log.setCurcDebitFor(debitFor);
            log.setCurcDebitLocal(debitLocal);
            log.setCurcCreditFor(creditFor);
            log.setCurcCreditLocal(creditLocal);
        }
        return log;
    }

    @Override
    protected String getBillSql() {
        return BILL_SQL;
    }

    @Override
    protected String getTab() {
        return "t_ict_acctpuchamt";
    }

    @Override
    protected String[] getKeyFields() {
        return new String[]{"fschemeid", "faccounttableid", "faccountid", "fcurrencyid", "fassgrpid", "foporgid"};
    }

    @Override
    protected String getPullAmtSelectFields(boolean reCal) {
        String select = "FPBEGINFOR,FPBEGINLOCAL,FPENDFOR,FPENDLOCAL,FPYEARDEBITFOR,FPYEARDEBITLOCAL,FPYEARCREDITFOR,FPYEARCREDITLOCAL,FPDEBITFOR,FPDEBITLOCAL,FPCREDITFOR,FPCREDITLOCAL,FCDEBITFOR,FCDEBITLOCAL,FCCREDITFOR,FCCREDITLOCAL,FCURCDEBITFOR,FCURCDEBITLOCAL,FCURCCREDITFOR,FCURCCREDITLOCAL,FCURNDEBITFOR,FCURNDEBITLOCAL,FCURNCREDITFOR,FCURNCREDITLOCAL";
        return select;
    }

    @Override
    protected String getCheckAmtSelectFields(boolean reCal) {
        String select = "FCBEGINFOR,FCBEGINLOCAL,FCENDFOR,FCENDLOCAL,FCYEARDEBITFOR,FCYEARDEBITLOCAL,FCYEARCREDITFOR,FCYEARCREDITLOCAL";
        return select;
    }

    @Override
    protected AcctPuchNoCheckData getPuchData(Row rs, boolean reCal) {
        AcctPuchNoCheckData data = new AcctPuchNoCheckData(rs.getLong("fid"));
        data.setPeriodId(rs.getLong("fperiodid"));
        data.setEndPeriodId(rs.getLong("fendperiodid"));
        data.setAccountTableId(rs.getLong("faccounttableid"));
        data.setAccountId(rs.getLong("faccountid"));
        data.setOrgId(rs.getLong("forgid"));
        data.setOpOrgId(rs.getLong("foporgid"));
        data.setBookTypeId(rs.getLong("fbooktypeid"));
        data.setPullEndFor(rs.getBigDecimal("fpendfor"));
        data.setPullEndLocal(rs.getBigDecimal("fpendlocal"));
        data.setPullYearDebitFor(rs.getBigDecimal("fpyeardebitfor"));
        data.setPullYearDebitLocal(rs.getBigDecimal("fpyeardebitlocal"));
        data.setPullYearCreditFor(rs.getBigDecimal("fpyearcreditfor"));
        data.setPullYearCreditLocal(rs.getBigDecimal("fpyearcreditlocal"));
        data.setCheckBeginFor(rs.getBigDecimal("fcbeginfor"));
        data.setCheckBeginLocal(rs.getBigDecimal("fcbeginlocal"));
        data.setCheckYearDebitFor(rs.getBigDecimal("fcyeardebitfor"));
        data.setCheckYearCreditFor(rs.getBigDecimal("fcyearcreditfor"));
        data.setCheckYearDebitLocal(rs.getBigDecimal("fcyeardebitlocal"));
        data.setCheckYearCreditLocal(rs.getBigDecimal("fcyearcreditlocal"));
        data.setCheckEndFor(rs.getBigDecimal("fcendfor"));
        data.setCheckEndLocal(rs.getBigDecimal("fcendlocal"));
        data.setPullDebitFor(rs.getBigDecimal("FPDEBITFOR"));
        data.setPullDebitLocal(rs.getBigDecimal("FPDEBITLOCAL"));
        data.setPullCreditFor(rs.getBigDecimal("FPCREDITFOR"));
        data.setPullCreditLocal(rs.getBigDecimal("FPCREDITLOCAL"));
        data.setCheckDebitFor(rs.getBigDecimal("FCDEBITFOR"));
        data.setCheckDebitLocal(rs.getBigDecimal("FCDEBITLOCAL"));
        data.setCheckCreditFor(rs.getBigDecimal("FCCREDITFOR"));
        data.setCheckCreditLocal(rs.getBigDecimal("FCCREDITLOCAL"));
        data.setCurcDebitFor(rs.getBigDecimal("FCURCDEBITFOR"));
        data.setCurcDebitLocal(rs.getBigDecimal("FCURCDEBITLOCAL"));
        data.setCurcCreditFor(rs.getBigDecimal("FCURCCREDITFOR"));
        data.setCurcCreditLocal(rs.getBigDecimal("FCURCCREDITLOCAL"));
        data.setCurnDebitfor(rs.getBigDecimal("FCURNDEBITFOR"));
        data.setCurnDebitlocal(rs.getBigDecimal("FCURNDEBITLOCAL"));
        data.setCurnCreditfor(rs.getBigDecimal("FCURNCREDITFOR"));
        data.setCurnCreditlocal(rs.getBigDecimal("FCURNCREDITLOCAL"));
        return data;
    }

    @Override
    protected List<BigDecimal> getNewPuchAmtParam(AcctPuchAmtKey pk, long periodId, AcctPuchAmtLog logData, AcctPuchNoCheckData prePuchAmt, boolean reCal) {
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>(18);
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getPullEndFor());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getPullEndLocal());
        if (prePuchAmt != null && periodId / PeriodUtil.YEAR_PERIOD_L == prePuchAmt.getPeriodId() / PeriodUtil.YEAR_PERIOD_L) {
            param.add(prePuchAmt.getPullYearDebitFor());
            param.add(prePuchAmt.getPullYearDebitLocal());
            param.add(prePuchAmt.getPullYearCreditFor());
            param.add(prePuchAmt.getPullYearCreditLocal());
        } else {
            param.add(BigDecimal.ZERO);
            param.add(BigDecimal.ZERO);
            param.add(BigDecimal.ZERO);
            param.add(BigDecimal.ZERO);
        }
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getPullEndFor());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getPullEndLocal());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getCheckEndFor());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getCheckEndLocal());
        param.add(logData.getDebitFor());
        param.add(logData.getDebitLocal());
        param.add(logData.getCreditFor());
        param.add(logData.getCreditLocal());
        if (prePuchAmt != null && periodId / PeriodUtil.YEAR_PERIOD_L == prePuchAmt.getPeriodId() / PeriodUtil.YEAR_PERIOD_L) {
            param.add(prePuchAmt.getCheckYearDebitFor().add(logData.getDebitFor()));
            param.add(prePuchAmt.getCheckYearDebitLocal().add(logData.getDebitLocal()));
            param.add(prePuchAmt.getCheckYearCreditFor().add(logData.getCreditFor()));
            param.add(prePuchAmt.getCheckYearCreditLocal().add(logData.getCreditLocal()));
        } else {
            param.add(logData.getDebitFor());
            param.add(logData.getDebitLocal());
            param.add(logData.getCreditFor());
            param.add(logData.getCreditLocal());
        }
        BigDecimal endfor = BigDecimal.ZERO;
        BigDecimal endlocal = BigDecimal.ZERO;
        if (prePuchAmt != null) {
            endfor = prePuchAmt.getCheckEndFor();
            endlocal = prePuchAmt.getCheckEndLocal();
        }
        param.add(endfor.add(logData.getDebitFor()).subtract(logData.getCreditFor()));
        param.add(endlocal.add(logData.getDebitLocal()).subtract(logData.getCreditLocal()));
        param.add(logData.getCurcDebitFor());
        param.add(logData.getCurcDebitLocal());
        param.add(logData.getCurcCreditFor());
        param.add(logData.getCurcCreditLocal());
        param.add(BigDecimal.ZERO);
        param.add(BigDecimal.ZERO);
        param.add(BigDecimal.ZERO);
        param.add(BigDecimal.ZERO);
        return param;
    }

    @Override
    protected String getInsertPuchSql() {
        return INSERT_PUCH_SQL;
    }

    @Override
    protected String getUpdAmtSql(boolean reCal) {
        return reCal ? RE_UPD_PUCH_AMT_SQL : UPD_PUCH_AMT_SQL;
    }

    @Override
    protected List<BigDecimal> getUpdatePuchAmtParam(long periodId, AcctPuchAmtLog logData, AcctPuchNoCheckData puchData, AcctPuchNoCheckData prePuchData, boolean reCal) {
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>(18);
        if (reCal) {
            param.add(prePuchData == null ? puchData.getCheckBeginFor() : prePuchData.getCheckEndFor());
            param.add(prePuchData == null ? puchData.getCheckBeginLocal() : prePuchData.getCheckEndLocal());
        }
        BigDecimal debitFor = logData == null ? BigDecimal.ZERO : logData.getDebitFor();
        BigDecimal debitLocal = logData == null ? BigDecimal.ZERO : logData.getDebitLocal();
        BigDecimal creditFor = logData == null ? BigDecimal.ZERO : logData.getCreditFor();
        BigDecimal creditLocal = logData == null ? BigDecimal.ZERO : logData.getCreditLocal();
        BigDecimal curcDebitFor = logData == null ? BigDecimal.ZERO : logData.getCurcDebitFor();
        BigDecimal curcDebitLocal = logData == null ? BigDecimal.ZERO : logData.getCurcDebitLocal();
        BigDecimal curcCreditFor = logData == null ? BigDecimal.ZERO : logData.getCurcCreditFor();
        BigDecimal curcCreditLocal = logData == null ? BigDecimal.ZERO : logData.getCurcCreditLocal();
        param.add(debitFor);
        param.add(debitLocal);
        param.add(creditFor);
        param.add(creditLocal);
        if (reCal && (prePuchData == null || periodId / PeriodUtil.YEAR_PERIOD_L == prePuchData.getPeriodId() / PeriodUtil.YEAR_PERIOD_L)) {
            if (prePuchData == null) {
                param.add(debitFor);
                param.add(debitLocal);
                param.add(creditFor);
                param.add(creditLocal);
            } else {
                param.add(prePuchData.getCheckYearDebitFor().add(debitFor));
                param.add(prePuchData.getCheckYearDebitLocal().add(debitLocal));
                param.add(prePuchData.getCheckYearCreditFor().add(creditFor));
                param.add(prePuchData.getCheckYearCreditLocal().add(creditLocal));
            }
        } else {
            param.add(debitFor);
            param.add(debitLocal);
            param.add(creditFor);
            param.add(creditLocal);
        }
        if (reCal) {
            param.add(((BigDecimal)param.get(0)).add(debitFor).subtract(creditFor));
            param.add(((BigDecimal)param.get(1)).add(debitLocal.subtract(creditLocal)));
        } else {
            param.add(debitFor.subtract(creditFor));
            param.add(debitLocal.subtract(creditLocal));
        }
        param.add(curcDebitFor);
        param.add(curcDebitLocal);
        param.add(curcCreditFor);
        param.add(curcCreditLocal);
        if (!reCal) {
            if (this.getOperationType() == OperationType.CANCELCHECK && logData != null && logData.getCurPeriodId() != puchData.getPeriodId()) {
                param.add(BigDecimal.ZERO);
                param.add(BigDecimal.ZERO);
                param.add(BigDecimal.ZERO);
                param.add(BigDecimal.ZERO);
            } else {
                param.add(debitFor);
                param.add(debitLocal);
                param.add(creditFor);
                param.add(creditLocal);
            }
        }
        return param;
    }

    @Override
    protected boolean equals(AcctPuchNoCheckData puchData, BigDecimal[] amount) {
        return false;
    }

    @Override
    protected String getUpdCurrYAmtSql() {
        return UPD_CURR_Y_PUCH_SQL;
    }

    @Override
    protected String getUpdLaterYAmtSql() {
        return UPD_LATER_Y_PUCH_SQL;
    }

    @Override
    protected void dealNext(long periodId, AcctPuchAmtLog logData, Iterator<AcctPuchNoCheckData> puchIt, AbstractCalculatorPuchAmt.Params params, AcctPuchNoCheckData prePuch) {
        long curPeriodId = 0L;
        if (this.getOperationType() == OperationType.CANCELCHECK) {
            curPeriodId = logData.getCurPeriodId();
        }
        BigDecimal difffor = logData.getDebitFor().subtract(logData.getCreditFor());
        BigDecimal difflocal = logData.getDebitLocal().subtract(logData.getCreditLocal());
        while (puchIt.hasNext()) {
            AcctCheckAmtData checkAmtData = puchIt.next();
            long puchId = checkAmtData.getId();
            ArrayList<Number> param = new ArrayList<Number>(4);
            param.add(difffor);
            param.add(difflocal);
            if (periodId / PeriodUtil.YEAR_PERIOD_L == checkAmtData.getPeriodId() / PeriodUtil.YEAR_PERIOD_L) {
                param.add(logData.getDebitFor());
                param.add(logData.getDebitLocal());
                param.add(logData.getCreditFor());
                param.add(logData.getCreditLocal());
                param.add(difffor);
                param.add(difflocal);
                param.add(puchId);
                params.addUpdateCurrYAmtParam(param.toArray());
            } else {
                param.add(difffor);
                param.add(difflocal);
                param.add(puchId);
                params.addUpdateLaterYAmtParam(param.toArray());
            }
            if (curPeriodId == 0L) continue;
            this.transAmtToCurPeriod(logData, checkAmtData, params, curPeriodId);
        }
    }

    @Override
    protected void recalDealNext(long periodId, AcctPuchAmtLog logData, Iterator<AcctPuchNoCheckData> balIt, AbstractCalculatorPuchAmt.Params params, AcctPuchNoCheckData prePuchData) {
        BigDecimal diffDebitfor = logData.getDebitFor().subtract(prePuchData.getCheckDebitFor());
        BigDecimal diffDebitlocal = logData.getDebitLocal().subtract(prePuchData.getCheckDebitLocal());
        BigDecimal diffCreditfor = logData.getCreditFor().subtract(prePuchData.getCheckCreditFor());
        BigDecimal diffCreditlocal = logData.getCreditLocal().subtract(prePuchData.getCheckCreditLocal());
        BigDecimal difffor = diffDebitfor.subtract(diffCreditfor);
        BigDecimal difflocal = diffDebitlocal.subtract(diffCreditlocal);
        while (balIt.hasNext()) {
            AcctCheckAmtData bal = balIt.next();
            long balId = bal.getId();
            ArrayList<Number> param = new ArrayList<Number>();
            param.add(difffor);
            param.add(difflocal);
            if (periodId / PeriodUtil.YEAR_PERIOD_L == bal.getPeriodId() / PeriodUtil.YEAR_PERIOD_L) {
                param.add(diffDebitfor);
                param.add(diffDebitlocal);
                param.add(diffCreditfor);
                param.add(diffCreditlocal);
                param.add(difffor);
                param.add(difflocal);
                param.add(balId);
                params.addUpdateCurrYAmtParam(param.toArray());
                continue;
            }
            param.add(difffor);
            param.add(difflocal);
            param.add(balId);
            params.addUpdateLaterYAmtParam(param.toArray());
        }
    }

    @Override
    protected String getUpdateNoCheckAddAmtSql() {
        return UPD_PUCH_NoCheckAMT_ADD_SQL;
    }

    private void transAmtToCurPeriod(AcctPuchAmtLog logData, AcctCheckAmtData puchData, AbstractCalculatorPuchAmt.Params params, long periodId) {
        ArrayList<Number> param = new ArrayList<Number>(5);
        if (periodId == puchData.getPeriodId()) {
            param.add(logData.getDebitFor());
            param.add(logData.getDebitLocal());
            param.add(logData.getCreditFor());
            param.add(logData.getCreditLocal());
            param.add(puchData.getId());
            params.addUpdateNoCheckAddParams(param.toArray());
        }
    }

    @Override
    protected boolean isPuchZero(AcctPuchNoCheckData checkAmtData, AcctPuchAmtLog logData, boolean reCal) {
        boolean isZero = false;
        if (reCal) {
            isZero = checkAmtData.getPullCreditFor().compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getPullCreditLocal().compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getPullDebitFor().compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getPullDebitLocal().compareTo(BigDecimal.ZERO) == 0 && logData.getCreditFor().compareTo(BigDecimal.ZERO) == 0 && logData.getCreditLocal().compareTo(BigDecimal.ZERO) == 0 && logData.getDebitFor().compareTo(BigDecimal.ZERO) == 0 && logData.getDebitLocal().compareTo(BigDecimal.ZERO) == 0 && logData.getCurcCreditFor().compareTo(BigDecimal.ZERO) == 0 && logData.getCurcCreditLocal().compareTo(BigDecimal.ZERO) == 0 && logData.getCurcDebitFor().compareTo(BigDecimal.ZERO) == 0 && logData.getCurcDebitLocal().compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCurnCreditfor().compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCurnCreditlocal().compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCurnDebitfor().compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCurnDebitlocal().compareTo(BigDecimal.ZERO) == 0;
        } else {
            BigDecimal curnCreditFor = logData.getCreditFor();
            BigDecimal curnCreditLocal = logData.getCreditLocal();
            BigDecimal curnDebitFor = logData.getDebitFor();
            BigDecimal curnDebitLocal = logData.getDebitLocal();
            if (this.getOperationType() == OperationType.CANCELCHECK && logData.getCurPeriodId() != checkAmtData.getPeriodId()) {
                curnCreditFor = BigDecimal.ZERO;
                curnCreditLocal = BigDecimal.ZERO;
                curnDebitFor = BigDecimal.ZERO;
                curnDebitLocal = BigDecimal.ZERO;
            }
            isZero = checkAmtData.getPullCreditFor().compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getPullCreditLocal().compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getPullDebitFor().compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getPullDebitLocal().compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCheckCreditFor().add(logData.getCreditFor()).compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCheckCreditLocal().add(logData.getCreditLocal()).compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCheckDebitFor().add(logData.getDebitFor()).compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCheckDebitLocal().add(logData.getDebitLocal()).compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCurcCreditFor().add(logData.getCurcCreditFor()).compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCurcCreditLocal().add(logData.getCurcCreditLocal()).compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCurcDebitFor().add(logData.getCurcDebitFor()).compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCurcDebitLocal().add(logData.getCurcDebitLocal()).compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCurnCreditfor().add(curnCreditFor).compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCurnCreditlocal().add(curnCreditLocal).compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCurnDebitfor().add(curnDebitFor).compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCurnDebitlocal().add(curnDebitLocal).compareTo(BigDecimal.ZERO) == 0;
        }
        return isZero;
    }

    @Override
    protected String[] getOrderBy() {
        return new String[]{"faccountid", "fcurrencyid", "fassgrpid", "foporgid", "fschemeid"};
    }
}

