/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.pullcheck.acct;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.Row;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.pullcheck.AbstractCalculatorPuchAmt;
import kd.fi.ict.pullcheck.acct.AcctCalculatorCheckAmt;
import kd.fi.ict.pullcheck.acct.AcctPuchAmtKey;
import kd.fi.ict.pullcheck.acct.AcctPuchAmtLog;
import kd.fi.ict.pullcheck.acct.AcctPuchNoCheckData;

public class AcctCalculatorNoCheckAmt
extends AcctCalculatorCheckAmt<AcctPuchNoCheckData, AcctPuchAmtLog, AcctPuchAmtKey> {
    private static final String LOG_SQL = "SELECT FID, FSCHEMEID, FORGID, FBOOKTYPEID, FORIPERIODID, FPERIODID,FPERIODID FCURPERIODID, FCURRENCYID, FASSGRPID, FOPERATION, FRELRECORDID, FCHECKAMTCALED, FOPORGID, FCREATETIME, FACCOUNTTABLEID, FACCOUNTID, FDEBITFOR, FCREDITFOR, FDEBITLOCAL, FCREDITLOCAL FROM T_ICT_ACCTPUCHAMT_LOG WHERE FORGID = ? AND FBOOKTYPEID = ? AND FCHECKAMTCALED = '0' AND FOPERATION IN ('CFRNEXTPERIOD','CANNEXTPERIOD') ORDER BY FPERIODID,FACCOUNTTABLEID,FACCOUNTID,FCURRENCYID,FASSGRPID;";
    private static final String UPD_PUCH_NoCheckAMT_SUB_SQL = "UPDATE T_ICT_ACCTPUCHAMT SET FCURNDEBITFOR = FCURNDEBITFOR - ?,FCURNDEBITLOCAL = FCURNDEBITLOCAL - ?,FCURNCREDITFOR = FCURNCREDITFOR - ? ,FCURNCREDITLOCAL = FCURNCREDITLOCAL - ? WHERE FID = ? ;";
    private static final String INSERT_PUCH_NoCheckAMT_SQL = "INSERT INTO T_ICT_ACCTPUCHAMT (FID,FORGID,FBOOKTYPEID ,FPERIODID,FENDPERIODID,FSCHEMEID,FACCOUNTTABLEID,FACCOUNTID,FCURRENCYID ,FASSGRPID,FOPORGID,FPBEGINFOR,FPBEGINLOCAL,FPENDFOR,FPENDLOCAL,FPYEARDEBITFOR,FPYEARDEBITLOCAL,FPYEARCREDITFOR,FPYEARCREDITLOCAL,FCBEGINFOR,FCBEGINLOCAL,FCENDFOR,FCENDLOCAL,FCYEARDEBITFOR,FCYEARDEBITLOCAL,FCYEARCREDITFOR,FCYEARCREDITLOCAL,FCURNDEBITFOR,FCURNDEBITLOCAL,FCURNCREDITFOR ,FCURNCREDITLOCAL) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
    private static final String UPD_PUCH_NoCheckAMT_ADD_SQL = "UPDATE T_ICT_ACCTPUCHAMT SET FCURNDEBITFOR = FCURNDEBITFOR + ?,FCURNDEBITLOCAL = FCURNDEBITLOCAL + ?,FCURNCREDITFOR = FCURNCREDITFOR + ? ,FCURNCREDITLOCAL = FCURNCREDITLOCAL + ? WHERE FID = ? ;";

    public AcctCalculatorNoCheckAmt(OperationType operationType) {
        super(operationType);
    }

    @Override
    protected String getLogSql() {
        return LOG_SQL;
    }

    @Override
    protected String getUpdateLogCaledSql() {
        return " UPDATE %S SET FCHECKAMTCALED='1' WHERE (FOPERATION = 'CFRNEXTPERIOD' OR FOPERATION = 'CANNEXTPERIOD') AND FID ";
    }

    @Override
    protected String getInsertPuchSql() {
        return INSERT_PUCH_NoCheckAMT_SQL;
    }

    @Override
    protected String getUpdateNoCheckSubAmtSql() {
        return UPD_PUCH_NoCheckAMT_SUB_SQL;
    }

    @Override
    protected String getUpdateNoCheckAddAmtSql() {
        return UPD_PUCH_NoCheckAMT_ADD_SQL;
    }

    @Override
    protected String getCheckAmtSelectFields(boolean reCal) {
        String select = "FCBEGINFOR,FCBEGINLOCAL,FCENDFOR,FCENDLOCAL,FCYEARDEBITFOR,FCYEARDEBITLOCAL,FCYEARCREDITFOR,FCYEARCREDITLOCAL, FCURNDEBITFOR ,FCURNDEBITLOCAL ,FCURNCREDITFOR ,FCURNCREDITLOCAL";
        if (reCal) {
            select = select + ",FCDEBITFOR,FCDEBITLOCAL,FCCREDITFOR,FCCREDITLOCAL";
        }
        return select;
    }

    @Override
    protected AcctPuchNoCheckData getPuchData(Row rs, boolean reCal) {
        AcctPuchNoCheckData data = new AcctPuchNoCheckData(rs.getLong("fid"));
        data.setPeriodId(rs.getLong("fperiodid"));
        data.setEndPeriodId(rs.getLong("fendperiodid"));
        data.setAccountTableId(rs.getLong("faccounttableid"));
        data.setAccountId(rs.getLong("faccountid"));
        data.setOrgId(rs.getLong("forgid"));
        data.setOpOrgId(rs.getLong("foporgid"));
        data.setBookTypeId(rs.getLong("fbooktypeid"));
        data.setPullBeginFor(rs.getBigDecimal("fpbeginfor"));
        data.setPullBeginLocal(rs.getBigDecimal("fpbeginlocal"));
        data.setPullEndFor(rs.getBigDecimal("fpendfor"));
        data.setPullEndLocal(rs.getBigDecimal("fpendlocal"));
        data.setPullYearDebitFor(rs.getBigDecimal("fpyeardebitfor"));
        data.setPullYearDebitLocal(rs.getBigDecimal("fpyeardebitlocal"));
        data.setPullYearCreditFor(rs.getBigDecimal("fpyearcreditfor"));
        data.setPullYearCreditLocal(rs.getBigDecimal("fpyearcreditlocal"));
        data.setCheckBeginFor(rs.getBigDecimal("fcbeginfor"));
        data.setCheckBeginLocal(rs.getBigDecimal("fcbeginlocal"));
        data.setCheckYearDebitFor(rs.getBigDecimal("fcyeardebitfor"));
        data.setCheckYearCreditFor(rs.getBigDecimal("fcyearcreditfor"));
        data.setCheckYearDebitLocal(rs.getBigDecimal("fcyeardebitlocal"));
        data.setCheckYearCreditLocal(rs.getBigDecimal("fcyearcreditlocal"));
        data.setCheckEndFor(rs.getBigDecimal("fcendfor"));
        data.setCheckEndLocal(rs.getBigDecimal("fcendlocal"));
        data.setPullDebitFor(rs.getBigDecimal("FPDEBITFOR"));
        data.setPullDebitLocal(rs.getBigDecimal("FPDEBITLOCAL"));
        data.setPullCreditFor(rs.getBigDecimal("FPCREDITFOR"));
        data.setPullCreditLocal(rs.getBigDecimal("FPCREDITLOCAL"));
        data.setCheckDebitFor(rs.getBigDecimal("FCDEBITFOR"));
        data.setCheckDebitLocal(rs.getBigDecimal("FCDEBITLOCAL"));
        data.setCheckCreditFor(rs.getBigDecimal("FCCREDITFOR"));
        data.setCheckCreditLocal(rs.getBigDecimal("FCCREDITLOCAL"));
        data.setCurcDebitFor(rs.getBigDecimal("FCURCDEBITFOR"));
        data.setCurcDebitLocal(rs.getBigDecimal("FCURCDEBITLOCAL"));
        data.setCurcCreditFor(rs.getBigDecimal("FCURCCREDITFOR"));
        data.setCurcCreditLocal(rs.getBigDecimal("FCURCCREDITLOCAL"));
        data.setCurnDebitfor(rs.getBigDecimal("FCURNDEBITFOR"));
        data.setCurnDebitlocal(rs.getBigDecimal("FCURNDEBITLOCAL"));
        data.setCurnCreditfor(rs.getBigDecimal("FCURNCREDITFOR"));
        data.setCurnCreditlocal(rs.getBigDecimal("FCURNCREDITLOCAL"));
        return data;
    }

    @Override
    protected List<BigDecimal> getNewPuchAmtParam(AcctPuchAmtKey pk, long periodId, AcctPuchAmtLog logData, AcctPuchNoCheckData prePuchAmt, boolean reCal) {
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>(4);
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getPullEndFor());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getPullEndLocal());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getPullEndFor());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getPullEndLocal());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getPullYearDebitFor());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getPullYearDebitLocal());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getPullYearCreditFor());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getPullYearCreditLocal());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getCheckEndFor());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getCheckEndLocal());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getCheckEndFor());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getCheckEndLocal());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getCheckYearDebitFor());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getCheckYearDebitLocal());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getCheckYearCreditFor());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getCheckYearCreditLocal());
        param.add(logData.getDebitFor());
        param.add(logData.getDebitLocal());
        param.add(logData.getCreditFor());
        param.add(logData.getCreditLocal());
        return param;
    }

    @Override
    protected List<BigDecimal> getUpdatePuchAmtParam(long periodId, AcctPuchAmtLog logData, AcctPuchNoCheckData puchData, AcctPuchNoCheckData prePuchData, boolean reCal) {
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>(18);
        param.add(logData.getDebitFor());
        param.add(logData.getDebitLocal());
        param.add(logData.getCreditFor());
        param.add(logData.getCreditLocal());
        return param;
    }

    @Override
    protected void dealNext(long periodId, AcctPuchAmtLog logData, Iterator<AcctPuchNoCheckData> puchIt, AbstractCalculatorPuchAmt.Params params, AcctPuchNoCheckData prePuch) {
    }

    @Override
    protected void recalDealNext(long periodId, AcctPuchAmtLog logData, Iterator<AcctPuchNoCheckData> balIt, AbstractCalculatorPuchAmt.Params params, AcctPuchNoCheckData prePuchData) {
    }

    @Override
    protected boolean isPuchZero(AcctPuchNoCheckData checkAmtData, AcctPuchAmtLog logData, boolean reCal) {
        AcctPuchNoCheckData puchAmt = checkAmtData;
        return puchAmt.getPullCreditFor().compareTo(BigDecimal.ZERO) == 0 && puchAmt.getPullCreditLocal().compareTo(BigDecimal.ZERO) == 0 && puchAmt.getPullDebitFor().compareTo(BigDecimal.ZERO) == 0 && puchAmt.getPullDebitLocal().compareTo(BigDecimal.ZERO) == 0 && puchAmt.getCheckCreditFor().compareTo(BigDecimal.ZERO) == 0 && puchAmt.getCheckCreditLocal().compareTo(BigDecimal.ZERO) == 0 && puchAmt.getCheckDebitFor().compareTo(BigDecimal.ZERO) == 0 && puchAmt.getCheckDebitLocal().compareTo(BigDecimal.ZERO) == 0 && puchAmt.getCurcCreditFor().compareTo(BigDecimal.ZERO) == 0 && puchAmt.getCurcCreditLocal().compareTo(BigDecimal.ZERO) == 0 && puchAmt.getCurcDebitFor().compareTo(BigDecimal.ZERO) == 0 && puchAmt.getCurcDebitLocal().compareTo(BigDecimal.ZERO) == 0 && puchAmt.getCurnDebitfor().subtract(logData.getDebitFor()).compareTo(BigDecimal.ZERO) == 0 && puchAmt.getCurnDebitlocal().subtract(logData.getDebitLocal()).compareTo(BigDecimal.ZERO) == 0 && puchAmt.getCurnCreditfor().subtract(logData.getCreditFor()).compareTo(BigDecimal.ZERO) == 0 && puchAmt.getCurnCreditlocal().subtract(logData.getCreditLocal()).compareTo(BigDecimal.ZERO) == 0;
    }
}

