/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.pullcheck.acct;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.Row;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.pullcheck.AbstractCalculatorPuchAmt;
import kd.fi.ict.pullcheck.acct.AcctPuchAmtKey;
import kd.fi.ict.pullcheck.acct.AcctPuchAmtLog;
import kd.fi.ict.pullcheck.acct.AcctPuchNoCheckData;
import kd.fi.ict.pullcheck.acct.AcctPullAmtData;
import kd.fi.ict.util.PeriodUtil;

public class AcctCalculatorPullAmt
extends AbstractCalculatorPuchAmt<AcctPuchNoCheckData, AcctPuchAmtLog, AcctPuchAmtKey> {
    private static final String LOG_SQL = "SELECT FID, FSCHEMEID, FORGID, FBOOKTYPEID, FORIPERIODID, FPERIODID, FCURRENCYID, FASSGRPID, FOPERATION, FRELRECORDID, FPULLAMTCALED, FOPORGID, FCREATETIME, FACCOUNTTABLEID, FACCOUNTID, FDEBITFOR, FCREDITFOR, FDEBITLOCAL, FCREDITLOCAL FROM T_ICT_ACCTPUCHAMT_LOG WHERE FORGID = ? AND FBOOKTYPEID = ? AND FPULLAMTCALED = '0' AND FOPERATION IN ('PULLDATA','DELETE','IMPORTDATA')  ORDER BY FORIPERIODID,FACCOUNTTABLEID,FACCOUNTID,FCURRENCYID,FASSGRPID;";
    private static final String BILL_SQL = "SELECT A.FMASTERID FACCOUNTID,FASSGRPID,FAMTBAL,FAMTBALLOC,FAMT,FAMTLOC,FCURRENCYID,FCURRENCYLOCID,FPERIODID,FORIPERIODID,R.FORGID,FSCHEMEID,FBOOKTYPEID,R.FACCOUNTTABLEID,FOPORGID,R.FDC,FBALDC,R.FID FROM T_ICT_RELACCTRECORD R INNER JOIN T_BD_ACCOUNT A ON R.FACCOUNTID = A.FID WHERE R.FORGID = ? AND FBOOKTYPEID = ? AND FORIPERIODID = ?;";
    private static final String RECORD_SQL = "SELECT A.FMASTERID FACCOUNTID,FASSGRPID,FAMTBAL,FAMTBALLOC,FAMT,FAMTLOC,FCURRENCYID,FCURRENCYLOCID,FPERIODID,FORIPERIODID,R.FORGID,FSCHEMEID,FBOOKTYPEID,R.FACCOUNTTABLEID,FOPORGID,R.FDC,FBALDC,R.FID FROM T_ICT_RELACCTRECORD R INNER JOIN T_BD_ACCOUNT A ON R.FACCOUNTID = A.FID WHERE R.FORGID = ? AND FBOOKTYPEID = ? AND FPERIODID = ?;";
    private static final String INSERT_PUCH_SQL = "INSERT INTO T_ICT_ACCTPUCHAMT (FID,FORGID,FBOOKTYPEID ,FPERIODID,FENDPERIODID,FSCHEMEID,FACCOUNTTABLEID,FACCOUNTID,FCURRENCYID ,FASSGRPID,FOPORGID,FPBEGINFOR,FPBEGINLOCAL,FPDEBITFOR,FPDEBITLOCAL,FPCREDITFOR,FPCREDITLOCAL,FPYEARDEBITFOR,FPYEARDEBITLOCAL,FPYEARCREDITFOR,FPYEARCREDITLOCAL,FPENDFOR,FPENDLOCAL,FCURNDEBITFOR,FCURNDEBITLOCAL,FCURNCREDITFOR ,FCURNCREDITLOCAL, FCBEGINFOR, FCBEGINLOCAL, FCYEARDEBITFOR, FCYEARDEBITLOCAL, FCYEARCREDITFOR, FCYEARCREDITLOCAL, FCENDFOR, FCENDLOCAL) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
    private static final String RE_UPD_PUCH_AMT_SQL = "UPDATE T_ICT_ACCTPUCHAMT SET FPBEGINFOR = ?, FPBEGINLOCAL = ?, FPDEBITFOR = ?, FPDEBITLOCAL = ?,FPCREDITFOR = ?,FPCREDITLOCAL = ?,FPYEARDEBITFOR = ?, FPYEARDEBITLOCAL = ?, FPYEARCREDITFOR = ? , FPYEARCREDITLOCAL = ? ,FPENDFOR = ? , FPENDLOCAL = ?, FCURNDEBITFOR = ?, FCURNDEBITLOCAL = ?, FCURNCREDITFOR = ?, FCURNCREDITLOCAL = ? WHERE FID = ?;";
    private static final String UPD_PUCH_AMT_SQL = "UPDATE T_ICT_ACCTPUCHAMT SET FPDEBITFOR = FPDEBITFOR + ?, FPDEBITLOCAL = FPDEBITLOCAL + ?, FPCREDITFOR = FPCREDITFOR + ?, FPCREDITLOCAL = FPCREDITLOCAL + ?, FPYEARDEBITFOR = FPYEARDEBITFOR + ?, FPYEARDEBITLOCAL = FPYEARDEBITLOCAL + ?, FPYEARCREDITFOR = FPYEARCREDITFOR + ?, FPYEARCREDITLOCAL = FPYEARCREDITLOCAL + ?, FPENDFOR=FPENDFOR + ?, FPENDLOCAL=FPENDLOCAL + ?, FCURNDEBITFOR = FCURNDEBITFOR + ?, FCURNDEBITLOCAL = FCURNDEBITLOCAL + ?, FCURNCREDITFOR = FCURNCREDITFOR + ?, FCURNCREDITLOCAL = FCURNCREDITLOCAL + ? WHERE FID = ?;";
    private static final String UPD_CURR_Y_PUCH_SQL = "UPDATE T_ICT_ACCTPUCHAMT SET FPBEGINFOR = FPBEGINFOR+?,FPBEGINLOCAL = FPBEGINLOCAL+?,FCURNDEBITFOR = FCURNDEBITFOR + ?, FCURNDEBITLOCAL = FCURNDEBITLOCAL + ?, FCURNCREDITFOR = FCURNCREDITFOR + ?, FCURNCREDITLOCAL = FCURNCREDITLOCAL + ?,FPYEARDEBITFOR = FPYEARDEBITFOR+?,FPYEARDEBITLOCAL = FPYEARDEBITLOCAL+?,FPYEARCREDITFOR = FPYEARCREDITFOR+?,FPYEARCREDITLOCAL = FPYEARCREDITLOCAL+?,FPENDFOR = FPENDFOR+?,FPENDLOCAL = FPENDLOCAL+? WHERE FID = ?;";
    private static final String UPD_LATER_Y_PUCH_SQL = "UPDATE T_ICT_ACCTPUCHAMT SET  FPBEGINFOR = FPBEGINFOR+?,FPBEGINLOCAL = FPBEGINLOCAL+?,FCURNDEBITFOR = FCURNDEBITFOR + ?, FCURNDEBITLOCAL = FCURNDEBITLOCAL + ?, FCURNCREDITFOR = FCURNCREDITFOR + ?, FCURNCREDITLOCAL = FCURNCREDITLOCAL + ?,FPENDFOR = FPENDFOR+?,FPENDLOCAL = FPENDLOCAL+? WHERE FID = ?;";

    public AcctCalculatorPullAmt(OperationType operationType) {
        super(operationType);
    }

    @Override
    protected String getLogTable() {
        return "t_ict_acctpuchamt_log";
    }

    @Override
    protected String getLogSql() {
        return LOG_SQL;
    }

    @Override
    protected String getUpdateLogCaledSql() {
        return " UPDATE %S SET FPULLAMTCALED='1' WHERE FID ";
    }

    @Override
    protected AcctPuchAmtKey getPk(Row rs) {
        return new AcctPuchAmtKey(rs.getLong("fschemeid"), rs.getLong("faccounttableid"), rs.getLong("faccountid"), rs.getLong("fcurrencyid"), rs.getLong("fassgrpid"), rs.getLong("foporgid"));
    }

    @Override
    protected AcctPuchAmtLog getLogData(boolean reCal, Row rs) {
        AcctPuchAmtLog log = new AcctPuchAmtLog();
        log.setOriPeriodId(rs.getLong("foriperiodid"));
        log.setPeriodId(rs.getLong("fperiodid"));
        if (reCal) {
            BigDecimal amt = rs.getBigDecimal("famt");
            BigDecimal amtloc = rs.getBigDecimal("famtloc");
            if ("1".equals(rs.getString("fdc"))) {
                log.setDebitFor(amt);
                log.setDebitLocal(amtloc);
            } else {
                log.setCreditFor(amt);
                log.setCreditLocal(amtloc);
            }
        } else {
            log.setDebitFor(rs.getBigDecimal("fdebitfor"));
            log.setDebitLocal(rs.getBigDecimal("fdebitlocal"));
            log.setCreditFor(rs.getBigDecimal("fcreditfor"));
            log.setCreditLocal(rs.getBigDecimal("fcreditlocal"));
        }
        return log;
    }

    @Override
    protected String getBillSql() {
        return BILL_SQL;
    }

    @Override
    protected String getTab() {
        return "t_ict_acctpuchamt";
    }

    @Override
    protected String[] getKeyFields() {
        return new String[]{"fschemeid", "faccounttableid", "faccountid", "fcurrencyid", "fassgrpid", "foporgid"};
    }

    @Override
    protected String getPullAmtSelectFields(boolean reCal) {
        String select = "FPBEGINFOR,FPBEGINLOCAL,FPENDFOR,FPENDLOCAL,FPYEARDEBITFOR,FPYEARDEBITLOCAL,FPYEARCREDITFOR,FPYEARCREDITLOCAL,FPDEBITFOR,FPDEBITLOCAL,FPCREDITFOR,FPCREDITLOCAL,FCDEBITFOR,FCDEBITLOCAL,FCCREDITFOR,FCCREDITLOCAL,FCURCDEBITFOR,FCURCDEBITLOCAL,FCURCCREDITFOR,FCURCCREDITLOCAL,FCURNDEBITFOR,FCURNDEBITLOCAL,FCURNCREDITFOR,FCURNCREDITLOCAL,FCBEGINFOR, FCBEGINLOCAL, FCYEARDEBITFOR, FCYEARDEBITLOCAL, FCYEARCREDITFOR, FCYEARCREDITLOCAL, FCENDFOR, FCENDLOCAL";
        return select;
    }

    @Override
    protected String getCheckAmtSelectFields(boolean reCal) {
        String select = "FCBEGINFOR,FCBEGINLOCAL,FCENDFOR,FCENDLOCAL,FCYEARDEBITFOR,FCYEARDEBITLOCAL,FCYEARCREDITFOR,FCYEARCREDITLOCAL";
        return select;
    }

    @Override
    protected AcctPuchNoCheckData getPuchData(Row rs, boolean reCal) {
        AcctPuchNoCheckData data = new AcctPuchNoCheckData(rs.getLong("fid"));
        data.setPeriodId(rs.getLong("fperiodid"));
        data.setEndPeriodId(rs.getLong("fendperiodid"));
        data.setAccountTableId(rs.getLong("faccounttableid"));
        data.setAccountId(rs.getLong("faccountid"));
        data.setOrgId(rs.getLong("forgid"));
        data.setOpOrgId(rs.getLong("foporgid"));
        data.setBookTypeId(rs.getLong("fbooktypeid"));
        data.setPullBeginFor(rs.getBigDecimal("FPBEGINFOR"));
        data.setPullBeginLocal(rs.getBigDecimal("FPBEGINLOCAL"));
        data.setPullYearDebitFor(rs.getBigDecimal("FPYEARDEBITFOR"));
        data.setPullYearCreditFor(rs.getBigDecimal("FPYEARCREDITFOR"));
        data.setPullYearDebitLocal(rs.getBigDecimal("FPYEARDEBITLOCAL"));
        data.setPullYearCreditLocal(rs.getBigDecimal("FPYEARCREDITLOCAL"));
        data.setPullEndFor(rs.getBigDecimal("FPENDFOR"));
        data.setPullEndLocal(rs.getBigDecimal("FPENDLOCAL"));
        data.setPullDebitFor(rs.getBigDecimal("FPDEBITFOR"));
        data.setPullDebitLocal(rs.getBigDecimal("FPDEBITLOCAL"));
        data.setPullCreditFor(rs.getBigDecimal("FPCREDITFOR"));
        data.setPullCreditLocal(rs.getBigDecimal("FPCREDITLOCAL"));
        data.setCheckDebitFor(rs.getBigDecimal("FCDEBITFOR"));
        data.setCheckDebitLocal(rs.getBigDecimal("FCDEBITLOCAL"));
        data.setCheckCreditFor(rs.getBigDecimal("FCCREDITFOR"));
        data.setCheckCreditLocal(rs.getBigDecimal("FCCREDITLOCAL"));
        data.setCurcDebitFor(rs.getBigDecimal("FCURCDEBITFOR"));
        data.setCurcDebitLocal(rs.getBigDecimal("FCURCDEBITLOCAL"));
        data.setCurcCreditFor(rs.getBigDecimal("FCURCCREDITFOR"));
        data.setCurcCreditLocal(rs.getBigDecimal("FCURCCREDITLOCAL"));
        data.setCheckBeginFor(rs.getBigDecimal("FCBEGINFOR"));
        data.setCheckBeginLocal(rs.getBigDecimal("FCBEGINLOCAL"));
        data.setCheckYearDebitFor(rs.getBigDecimal("FCYEARDEBITFOR"));
        data.setCheckYearDebitLocal(rs.getBigDecimal("FCYEARDEBITLOCAL"));
        data.setCheckYearCreditFor(rs.getBigDecimal("FCYEARCREDITFOR"));
        data.setCheckYearCreditLocal(rs.getBigDecimal("FCYEARCREDITLOCAL"));
        data.setCheckEndFor(rs.getBigDecimal("FCENDFOR"));
        data.setCheckEndLocal(rs.getBigDecimal("FCENDLOCAL"));
        data.setCurnDebitfor(rs.getBigDecimal("FCURNDEBITFOR"));
        data.setCurnDebitlocal(rs.getBigDecimal("FCURNDEBITLOCAL"));
        data.setCurnCreditfor(rs.getBigDecimal("FCURNCREDITFOR"));
        data.setCurnCreditlocal(rs.getBigDecimal("FCURNCREDITLOCAL"));
        return data;
    }

    @Override
    protected List<BigDecimal> getNewPuchAmtParam(AcctPuchAmtKey pk, long periodId, AcctPuchAmtLog logData, AcctPuchNoCheckData prePuchAmt, boolean reCal) {
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>(18);
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getPullEndFor());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getPullEndLocal());
        param.add(logData.getDebitFor());
        param.add(logData.getDebitLocal());
        param.add(logData.getCreditFor());
        param.add(logData.getCreditLocal());
        if (prePuchAmt != null && periodId / PeriodUtil.YEAR_PERIOD_L == prePuchAmt.getPeriodId() / PeriodUtil.YEAR_PERIOD_L) {
            param.add(prePuchAmt.getPullYearDebitFor().add(logData.getDebitFor()));
            param.add(prePuchAmt.getPullYearDebitLocal().add(logData.getDebitLocal()));
            param.add(prePuchAmt.getPullYearCreditFor().add(logData.getCreditFor()));
            param.add(prePuchAmt.getPullYearCreditLocal().add(logData.getCreditLocal()));
        } else {
            param.add(logData.getDebitFor());
            param.add(logData.getDebitLocal());
            param.add(logData.getCreditFor());
            param.add(logData.getCreditLocal());
        }
        BigDecimal endfor = BigDecimal.ZERO;
        BigDecimal endlocal = BigDecimal.ZERO;
        if (prePuchAmt != null) {
            endfor = prePuchAmt.getPullEndFor();
            endlocal = prePuchAmt.getPullEndLocal();
        }
        param.add(endfor.add(logData.getDebitFor()).subtract(logData.getCreditFor()));
        param.add(endlocal.add(logData.getDebitLocal()).subtract(logData.getCreditLocal()));
        if (reCal) {
            param.add(logData.getCurnDebitFor());
            param.add(logData.getCurnDebitLocal());
            param.add(logData.getCurnCreditFor());
            param.add(logData.getCurnCreditLocal());
        } else if (logData.getPeriodId() == periodId) {
            param.add(logData.getDebitFor());
            param.add(logData.getDebitLocal());
            param.add(logData.getCreditFor());
            param.add(logData.getCreditLocal());
        } else {
            param.add(BigDecimal.ZERO);
            param.add(BigDecimal.ZERO);
            param.add(BigDecimal.ZERO);
            param.add(BigDecimal.ZERO);
        }
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getCheckEndFor());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getCheckEndLocal());
        if (prePuchAmt != null && periodId / PeriodUtil.YEAR_PERIOD_L == prePuchAmt.getPeriodId() / PeriodUtil.YEAR_PERIOD_L) {
            param.add(prePuchAmt.getCheckYearDebitFor());
            param.add(prePuchAmt.getCheckYearDebitLocal());
            param.add(prePuchAmt.getCheckYearCreditFor());
            param.add(prePuchAmt.getCheckYearCreditLocal());
        } else {
            param.add(BigDecimal.ZERO);
            param.add(BigDecimal.ZERO);
            param.add(BigDecimal.ZERO);
            param.add(BigDecimal.ZERO);
        }
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getCheckEndFor());
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getCheckEndLocal());
        return param;
    }

    @Override
    protected String getInsertPuchSql() {
        return INSERT_PUCH_SQL;
    }

    @Override
    protected String getUpdAmtSql(boolean reCal) {
        return reCal ? RE_UPD_PUCH_AMT_SQL : UPD_PUCH_AMT_SQL;
    }

    @Override
    protected List<BigDecimal> getUpdatePuchAmtParam(long periodId, AcctPuchAmtLog logData, AcctPuchNoCheckData puchData, AcctPuchNoCheckData prePuchData, boolean reCal) {
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>(18);
        if (reCal) {
            param.add(prePuchData == null ? puchData.getPullBeginFor() : prePuchData.getPullEndFor());
            param.add(prePuchData == null ? puchData.getPullBeginLocal() : prePuchData.getPullEndLocal());
        }
        BigDecimal debitFor = logData == null ? BigDecimal.ZERO : logData.getDebitFor();
        BigDecimal debitLocal = logData == null ? BigDecimal.ZERO : logData.getDebitLocal();
        BigDecimal creditFor = logData == null ? BigDecimal.ZERO : logData.getCreditFor();
        BigDecimal creditLocal = logData == null ? BigDecimal.ZERO : logData.getCreditLocal();
        BigDecimal curnDebitFor = logData == null ? BigDecimal.ZERO : logData.getCurnDebitFor();
        BigDecimal curnDebitLocal = logData == null ? BigDecimal.ZERO : logData.getCurnDebitLocal();
        BigDecimal curnCreditFor = logData == null ? BigDecimal.ZERO : logData.getCurnCreditFor();
        BigDecimal curnCreditLocal = logData == null ? BigDecimal.ZERO : logData.getCurnCreditLocal();
        param.add(debitFor);
        param.add(debitLocal);
        param.add(creditFor);
        param.add(creditLocal);
        if (reCal && (prePuchData == null || periodId / PeriodUtil.YEAR_PERIOD_L == prePuchData.getPeriodId() / PeriodUtil.YEAR_PERIOD_L)) {
            if (prePuchData == null) {
                param.add(debitFor);
                param.add(debitLocal);
                param.add(creditFor);
                param.add(creditLocal);
            } else {
                param.add(prePuchData.getPullYearDebitFor().add(debitFor));
                param.add(prePuchData.getPullYearDebitLocal().add(debitLocal));
                param.add(prePuchData.getPullYearCreditFor().add(creditFor));
                param.add(prePuchData.getPullYearCreditLocal().add(creditLocal));
            }
        } else {
            param.add(debitFor);
            param.add(debitLocal);
            param.add(creditFor);
            param.add(creditLocal);
        }
        if (reCal) {
            param.add(((BigDecimal)param.get(0)).add(debitFor).subtract(creditFor));
            param.add(((BigDecimal)param.get(1)).add(debitLocal.subtract(creditLocal)));
        } else {
            param.add(debitFor.subtract(creditFor));
            param.add(debitLocal.subtract(creditLocal));
        }
        if (reCal) {
            param.add(curnDebitFor);
            param.add(curnDebitLocal);
            param.add(curnCreditFor);
            param.add(curnCreditLocal);
        } else if (logData != null && logData.getPeriodId() == puchData.getPeriodId()) {
            param.add(debitFor);
            param.add(debitLocal);
            param.add(creditFor);
            param.add(creditLocal);
        } else {
            param.add(BigDecimal.ZERO);
            param.add(BigDecimal.ZERO);
            param.add(BigDecimal.ZERO);
            param.add(BigDecimal.ZERO);
        }
        return param;
    }

    @Override
    protected boolean equals(AcctPuchNoCheckData puchData, BigDecimal[] amount) {
        return false;
    }

    @Override
    protected String getUpdCurrYAmtSql() {
        return UPD_CURR_Y_PUCH_SQL;
    }

    @Override
    protected String getUpdLaterYAmtSql() {
        return UPD_LATER_Y_PUCH_SQL;
    }

    @Override
    protected void dealNext(long periodId, AcctPuchAmtLog logData, Iterator<AcctPuchNoCheckData> puchIt, AbstractCalculatorPuchAmt.Params params, AcctPuchNoCheckData prePuch) {
        BigDecimal difffor = logData.getDebitFor().subtract(logData.getCreditFor());
        BigDecimal difflocal = logData.getDebitLocal().subtract(logData.getCreditLocal());
        while (puchIt.hasNext()) {
            AcctPuchNoCheckData pullAmt = puchIt.next();
            long puchId = pullAmt.getId();
            ArrayList<Number> param = new ArrayList<Number>(6);
            param.add(difffor);
            param.add(difflocal);
            if (logData.getPeriodId() == pullAmt.getPeriodId()) {
                param.add(logData.getDebitFor());
                param.add(logData.getDebitLocal());
                param.add(logData.getCreditFor());
                param.add(logData.getCreditLocal());
            } else {
                param.add(BigDecimal.ZERO);
                param.add(BigDecimal.ZERO);
                param.add(BigDecimal.ZERO);
                param.add(BigDecimal.ZERO);
            }
            if (periodId / PeriodUtil.YEAR_PERIOD_L == pullAmt.getPeriodId() / PeriodUtil.YEAR_PERIOD_L) {
                param.add(logData.getDebitFor());
                param.add(logData.getDebitLocal());
                param.add(logData.getCreditFor());
                param.add(logData.getCreditLocal());
                param.add(difffor);
                param.add(difflocal);
                param.add(puchId);
                params.addUpdateCurrYAmtParam(param.toArray());
            } else {
                param.add(difffor);
                param.add(difflocal);
                param.add(puchId);
                params.addUpdateLaterYAmtParam(param.toArray());
            }
            prePuch = this.dealInvalidPeriod(pullAmt, prePuch, logData, params, false);
        }
    }

    @Override
    protected void recalDealNext(long periodId, AcctPuchAmtLog logData, Iterator<AcctPuchNoCheckData> balIt, AbstractCalculatorPuchAmt.Params params, AcctPuchNoCheckData prePuchData) {
        BigDecimal diffDebitfor = logData.getDebitFor().subtract(prePuchData.getPullDebitFor());
        BigDecimal diffDebitlocal = logData.getDebitLocal().subtract(prePuchData.getPullDebitLocal());
        BigDecimal diffCreditfor = logData.getCreditFor().subtract(prePuchData.getPullCreditFor());
        BigDecimal diffCreditlocal = logData.getCreditLocal().subtract(prePuchData.getPullCreditLocal());
        BigDecimal difffor = diffDebitfor.subtract(diffCreditfor);
        BigDecimal difflocal = diffDebitlocal.subtract(diffCreditlocal);
        while (balIt.hasNext()) {
            AcctPullAmtData bal = balIt.next();
            long balId = bal.getId();
            ArrayList<Number> param = new ArrayList<Number>();
            param.add(difffor);
            param.add(difflocal);
            param.add(BigDecimal.ZERO);
            param.add(BigDecimal.ZERO);
            param.add(BigDecimal.ZERO);
            param.add(BigDecimal.ZERO);
            if (periodId / PeriodUtil.YEAR_PERIOD_L == bal.getPeriodId() / PeriodUtil.YEAR_PERIOD_L) {
                param.add(diffDebitfor);
                param.add(diffDebitlocal);
                param.add(diffCreditfor);
                param.add(diffCreditlocal);
                param.add(difffor);
                param.add(difflocal);
                param.add(balId);
                params.addUpdateCurrYAmtParam(param.toArray());
                continue;
            }
            param.add(difffor);
            param.add(difflocal);
            param.add(balId);
            params.addUpdateLaterYAmtParam(param.toArray());
        }
    }

    @Override
    protected boolean isPuchZero(AcctPuchNoCheckData puchData, AcctPuchAmtLog logData, boolean reCal) {
        boolean isZero = false;
        if (reCal) {
            isZero = logData.getCreditFor().compareTo(BigDecimal.ZERO) == 0 && logData.getCreditLocal().compareTo(BigDecimal.ZERO) == 0 && logData.getDebitFor().compareTo(BigDecimal.ZERO) == 0 && logData.getDebitLocal().compareTo(BigDecimal.ZERO) == 0 && puchData.getCheckCreditFor().compareTo(BigDecimal.ZERO) == 0 && puchData.getCheckCreditLocal().compareTo(BigDecimal.ZERO) == 0 && puchData.getCheckDebitFor().compareTo(BigDecimal.ZERO) == 0 && puchData.getCheckDebitLocal().compareTo(BigDecimal.ZERO) == 0 && puchData.getCurcCreditFor().compareTo(BigDecimal.ZERO) == 0 && puchData.getCurcCreditLocal().compareTo(BigDecimal.ZERO) == 0 && puchData.getCurcDebitFor().compareTo(BigDecimal.ZERO) == 0 && puchData.getCurcDebitLocal().compareTo(BigDecimal.ZERO) == 0 && logData.getCurnCreditFor().compareTo(BigDecimal.ZERO) == 0 && logData.getCurnCreditLocal().compareTo(BigDecimal.ZERO) == 0 && logData.getCurnDebitFor().compareTo(BigDecimal.ZERO) == 0 && logData.getCurnDebitLocal().compareTo(BigDecimal.ZERO) == 0;
        } else {
            BigDecimal pullCreditFor = BigDecimal.ZERO;
            BigDecimal pullCreditLocal = BigDecimal.ZERO;
            BigDecimal pullDebitFor = BigDecimal.ZERO;
            BigDecimal pullDebitLocal = BigDecimal.ZERO;
            BigDecimal curnCreditFor = BigDecimal.ZERO;
            BigDecimal curnCreditLocal = BigDecimal.ZERO;
            BigDecimal curnDebitFor = BigDecimal.ZERO;
            BigDecimal curnDebitLocal = BigDecimal.ZERO;
            if (logData.getPeriodId() == puchData.getPeriodId()) {
                curnCreditFor = logData.getCreditFor();
                curnCreditLocal = logData.getCreditLocal();
                curnDebitFor = logData.getDebitFor();
                curnDebitLocal = logData.getDebitLocal();
            }
            if (logData.getOriPeriodId() == puchData.getPeriodId()) {
                pullCreditFor = logData.getCreditFor();
                pullCreditLocal = logData.getCreditLocal();
                pullDebitFor = logData.getDebitFor();
                pullDebitLocal = logData.getDebitLocal();
            }
            isZero = puchData.getPullCreditFor().add(pullCreditFor).compareTo(BigDecimal.ZERO) == 0 && puchData.getPullCreditLocal().add(pullCreditLocal).compareTo(BigDecimal.ZERO) == 0 && puchData.getPullDebitFor().add(pullDebitFor).compareTo(BigDecimal.ZERO) == 0 && puchData.getPullDebitLocal().add(pullDebitLocal).compareTo(BigDecimal.ZERO) == 0 && puchData.getCheckCreditFor().compareTo(BigDecimal.ZERO) == 0 && puchData.getCheckCreditLocal().compareTo(BigDecimal.ZERO) == 0 && puchData.getCheckDebitFor().compareTo(BigDecimal.ZERO) == 0 && puchData.getCheckDebitLocal().compareTo(BigDecimal.ZERO) == 0 && puchData.getCurcCreditFor().compareTo(BigDecimal.ZERO) == 0 && puchData.getCurcCreditLocal().compareTo(BigDecimal.ZERO) == 0 && puchData.getCurcDebitFor().compareTo(BigDecimal.ZERO) == 0 && puchData.getCurcDebitLocal().compareTo(BigDecimal.ZERO) == 0 && puchData.getCurnCreditfor().add(curnCreditFor).compareTo(BigDecimal.ZERO) == 0 && puchData.getCurnCreditlocal().add(curnCreditLocal).compareTo(BigDecimal.ZERO) == 0 && puchData.getCurnDebitfor().add(curnDebitFor).compareTo(BigDecimal.ZERO) == 0 && puchData.getCurnDebitlocal().add(curnDebitLocal).compareTo(BigDecimal.ZERO) == 0;
        }
        return isZero;
    }

    @Override
    protected String getRecordSql() {
        return RECORD_SQL;
    }

    @Override
    protected AcctPuchAmtLog getNoCheckData(Row rs) {
        AcctPuchAmtLog log = new AcctPuchAmtLog();
        log.setOriPeriodId(rs.getLong("foriperiodid"));
        log.setPeriodId(rs.getLong("fperiodid"));
        BigDecimal balamt = rs.getBigDecimal("famtbal");
        BigDecimal balamtloc = rs.getBigDecimal("famtballoc");
        if ("1".equals(rs.getString("fdc"))) {
            log.setCurnDebitFor(balamt);
            log.setCurnDebitLocal(balamtloc);
        } else {
            log.setCurnCreditFor(balamt);
            log.setCurnCreditLocal(balamtloc);
        }
        return log;
    }

    @Override
    protected String getPeriodField() {
        return "foriperiodid";
    }

    @Override
    protected String[] getOrderBy() {
        return new String[]{"faccountid", "fcurrencyid", "fassgrpid", "foporgid", "fschemeid"};
    }
}

