/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.pullcheck.cf;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.Row;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.pullcheck.AbstractCalculatorPuchAmt;
import kd.fi.ict.pullcheck.Data;
import kd.fi.ict.pullcheck.Key;
import kd.fi.ict.pullcheck.Log;
import kd.fi.ict.pullcheck.cf.CfCheckAmtData;
import kd.fi.ict.pullcheck.cf.CfPuchAmtKey;
import kd.fi.ict.pullcheck.cf.CfPuchAmtLog;
import kd.fi.ict.pullcheck.cf.CfPuchNoCheckData;
import kd.fi.ict.util.PeriodUtil;

public class CfCalculatorCheckAmt<D extends Data, L extends Log, K extends Key>
extends AbstractCalculatorPuchAmt<CfPuchNoCheckData, CfPuchAmtLog, CfPuchAmtKey> {
    private static final String LOG_SQL = "SELECT L.FID, L.FSCHEMEID, L.FORGID, L.FBOOKTYPEID, L.FORIPERIODID, L.FPERIODID,R.FPERIODID FCURPERIODID, L.FCURRENCYID, L.FASSGRPID, L.FOPERATION, L.FRELRECORDID, L.FCHECKAMTCALED, L.FOPORGID, L.FCREATETIME, L.FCFITEMID, L.FAMOUNT FROM T_ICT_CFPUCHAMT_LOG L INNER JOIN T_ICT_RELCFRECORD R ON R.FID = L.FRELRECORDID WHERE L.FORGID = ? AND L.FBOOKTYPEID = ? AND FCHECKAMTCALED = '0' AND FOPERATION IN ('MANUALCHECK','AUTOCHECK','CANCELCHECK') ORDER BY FPERIODID,FCFITEMID,FCURRENCYID,FASSGRPID;";
    private static final String BILL_SQL = "SELECT E.FORGID,E.FOPPORGID FOPORGID,E.FASSGRPID,E.FDC,E.FAMTVERIFY,I.FMASTERID FCFITEMID,R.FVERIFYSCHEMEID FSCHEMEID,E.FCURRENCYID,R.FPERIODID FPERIODID,T.FORIPERIODID,T.FPERIODID FCURPERIODID,E.FRELRECORDID,E.FENTRYID FROM T_ICT_CF_CROSS_ENTRY E INNER JOIN T_ICT_CF_CROSS_RECORD R ON E.FID = R.FID INNER JOIN T_GL_CASHFLOWITEM I ON E.FCASHFLOWITEMID = I.FID INNER JOIN T_ICT_RELCFRECORD T ON T.FID = E.FRELRECORDID WHERE E.FORGID = ? AND R.FPERIODID = ?;";
    private static final String INSERT_PUCH_SQL = "INSERT INTO T_ICT_CFPUCHAMT (FID,FORGID,FBOOKTYPEID,FPERIODID,FENDPERIODID,FSCHEMEID,FCFITEMID,FCURRENCYID,FASSGRPID,FOPORGID,FPYEARAMOUNT,FCAMOUNT,FCYEARAMOUNT,FCURAMOUNT,FCURNAMOUNT,FNOCHECKAMOUNT) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
    private static final String RE_UPD_PUCH_AMT_SQL = "UPDATE T_ICT_CFPUCHAMT SET FCAMOUNT = ?, FCYEARAMOUNT = ? , FCURAMOUNT = ? WHERE FID = ? ";
    private static final String UPD_PUCH_AMT_SQL = "UPDATE T_ICT_CFPUCHAMT SET  FCAMOUNT = FCAMOUNT + ?, FCYEARAMOUNT = FCYEARAMOUNT + ? , FCURAMOUNT = FCURAMOUNT + ? , FCURNAMOUNT = FCURNAMOUNT - ? , FNOCHECKAMOUNT = FNOCHECKAMOUNT - ? WHERE FID = ? ";
    private static final String UPD_CURR_Y_PUCH_SQL = "UPDATE T_ICT_CFPUCHAMT SET FCYEARAMOUNT = FCYEARAMOUNT + ? WHERE FID = ?;";
    private static final String UPD_PUCH_NoCheckAMT_ADD_SQL = "UPDATE T_ICT_CFPUCHAMT SET FNOCHECKAMOUNT = FNOCHECKAMOUNT - ? WHERE FID = ? ;";

    public CfCalculatorCheckAmt(OperationType operationType) {
        super(operationType);
    }

    @Override
    protected String getLogTable() {
        return "t_ict_cfpuchamt_log";
    }

    @Override
    protected String getUpdateLogCaledSql() {
        return " UPDATE %S SET FCHECKAMTCALED='1' WHERE FID ";
    }

    @Override
    protected String getLogSql() {
        return LOG_SQL;
    }

    @Override
    protected CfPuchAmtKey getPk(Row rs) {
        return new CfPuchAmtKey(rs.getLong("fschemeid"), rs.getLong("fcfitemid"), rs.getLong("fcurrencyid"), rs.getLong("fassgrpid"), rs.getLong("foporgid"));
    }

    @Override
    protected CfPuchAmtLog getLogData(boolean reCal, Row rs) {
        CfPuchAmtLog log = new CfPuchAmtLog();
        long oriperiod = rs.getLong("foriperiodid");
        long period = rs.getLong("fperiodid");
        log.setOriPeriodId(oriperiod);
        log.setPeriodId(period);
        log.setCurPeriodId(rs.getLong("fcurperiodid"));
        BigDecimal amt = BigDecimal.ZERO;
        amt = reCal ? rs.getBigDecimal("famtverify") : rs.getBigDecimal("famount");
        log.setAmount(amt);
        if (oriperiod == period) {
            log.setCurcAmt(amt);
        }
        return log;
    }

    @Override
    protected String getBillSql() {
        return BILL_SQL;
    }

    @Override
    protected String getTab() {
        return "t_ict_cfpuchamt";
    }

    @Override
    protected String[] getKeyFields() {
        return new String[]{"fschemeid", "fcfitemid", "fcurrencyid", "fassgrpid", "foporgid"};
    }

    @Override
    protected String getPullAmtSelectFields(boolean reCal) {
        String select = "fpamount,fpyearamount,fcuramount,fcurnamount,fnocheckamount";
        return select;
    }

    @Override
    protected String getCheckAmtSelectFields(boolean reCal) {
        String select = "fcamount,fcyearamount";
        return select;
    }

    @Override
    protected CfPuchNoCheckData getPuchData(Row rs, boolean reCal) {
        CfPuchNoCheckData data = new CfPuchNoCheckData(rs.getLong("fid"));
        data.setPeriodId(rs.getLong("fperiodid"));
        data.setEndPeriodId(rs.getLong("fendperiodid"));
        data.setCfitemId(rs.getLong("fcfitemid"));
        data.setOrgId(rs.getLong("forgid"));
        data.setOpOrgId(rs.getLong("foporgid"));
        data.setBookTypeId(rs.getLong("fbooktypeid"));
        data.setPullYearAmount(rs.getBigDecimal("fpyearamount"));
        data.setCheckAmount(rs.getBigDecimal("fcamount"));
        data.setCheckYearAmount(rs.getBigDecimal("fcyearamount"));
        data.setPullAmount(rs.getBigDecimal("fpamount"));
        data.setCheckAmount(rs.getBigDecimal("fcamount"));
        data.setCurAmount(rs.getBigDecimal("fcuramount"));
        data.setCurnAmount(rs.getBigDecimal("fcurnamount"));
        data.setNoCheckAmt(rs.getBigDecimal("fnocheckamount"));
        return data;
    }

    @Override
    protected List<BigDecimal> getNewPuchAmtParam(CfPuchAmtKey pk, long periodId, CfPuchAmtLog logData, CfPuchNoCheckData prePuchAmt, boolean reCal) {
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>(18);
        param.add(prePuchAmt == null ? BigDecimal.ZERO : prePuchAmt.getPullYearAmount());
        param.add(logData.getAmount());
        if (prePuchAmt != null && periodId / PeriodUtil.YEAR_PERIOD_L == prePuchAmt.getPeriodId() / PeriodUtil.YEAR_PERIOD_L) {
            param.add(prePuchAmt.getCheckYearAmount().add(logData.getAmount()));
        } else {
            param.add(logData.getAmount());
        }
        param.add(logData.getCurcAmt());
        param.add(BigDecimal.ZERO);
        param.add(BigDecimal.ZERO);
        return param;
    }

    @Override
    protected String getInsertPuchSql() {
        return INSERT_PUCH_SQL;
    }

    @Override
    protected String getUpdAmtSql(boolean reCal) {
        return reCal ? RE_UPD_PUCH_AMT_SQL : UPD_PUCH_AMT_SQL;
    }

    @Override
    protected List<BigDecimal> getUpdatePuchAmtParam(long periodId, CfPuchAmtLog logData, CfPuchNoCheckData puchData, CfPuchNoCheckData prePuchData, boolean reCal) {
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>(18);
        BigDecimal amount = logData == null ? BigDecimal.ZERO : logData.getAmount();
        BigDecimal curcAmt = logData == null ? BigDecimal.ZERO : logData.getCurcAmt();
        param.add(amount);
        if (reCal && (prePuchData == null || periodId / PeriodUtil.YEAR_PERIOD_L == prePuchData.getPeriodId() / PeriodUtil.YEAR_PERIOD_L)) {
            if (prePuchData == null) {
                param.add(amount);
            } else {
                param.add(prePuchData.getCheckYearAmount().add(amount));
            }
        } else {
            param.add(amount);
        }
        param.add(curcAmt);
        if (!reCal) {
            long curPeriodId;
            long l = curPeriodId = logData == null ? 0L : logData.getCurPeriodId();
            if (this.getOperationType() == OperationType.CANCELCHECK && curPeriodId != puchData.getPeriodId()) {
                param.add(BigDecimal.ZERO);
                param.add(BigDecimal.ZERO);
            } else {
                param.add(curcAmt);
                param.add(amount);
            }
        }
        return param;
    }

    @Override
    protected boolean equals(CfPuchNoCheckData puchData, BigDecimal[] amount) {
        return false;
    }

    @Override
    protected String getUpdCurrYAmtSql() {
        return UPD_CURR_Y_PUCH_SQL;
    }

    @Override
    protected String getUpdLaterYAmtSql() {
        return null;
    }

    @Override
    protected void dealNext(long periodId, CfPuchAmtLog logData, Iterator<CfPuchNoCheckData> puchIt, AbstractCalculatorPuchAmt.Params params, CfPuchNoCheckData prePuch) {
        long curPeriodId = 0L;
        if (this.getOperationType() == OperationType.CANCELCHECK) {
            curPeriodId = logData.getCurPeriodId();
        }
        while (puchIt.hasNext()) {
            CfCheckAmtData checkData = puchIt.next();
            long checkDataId = checkData.getId();
            ArrayList<Number> param = new ArrayList<Number>(3);
            if (periodId / PeriodUtil.YEAR_PERIOD_L == checkData.getPeriodId() / PeriodUtil.YEAR_PERIOD_L) {
                param.add(logData.getAmount());
                param.add(checkDataId);
                params.addUpdateCurrYAmtParam(param.toArray());
            }
            if (curPeriodId == 0L) continue;
            this.transAmtToCurPeriod(logData, checkData, params, curPeriodId);
        }
    }

    @Override
    protected void recalDealNext(long periodId, CfPuchAmtLog logData, Iterator<CfPuchNoCheckData> balIt, AbstractCalculatorPuchAmt.Params params, CfPuchNoCheckData prePuchAmt) {
        BigDecimal diffBal = logData.getAmount().subtract(prePuchAmt.getCheckAmount());
        while (balIt.hasNext()) {
            CfCheckAmtData bal = balIt.next();
            long balId = bal.getId();
            ArrayList<Number> param = new ArrayList<Number>();
            if (periodId / PeriodUtil.YEAR_PERIOD_L != bal.getPeriodId() / PeriodUtil.YEAR_PERIOD_L) continue;
            param.add(diffBal);
            param.add(balId);
            params.addUpdateCurrYAmtParam(param.toArray());
        }
    }

    @Override
    protected boolean isPuchZero(CfPuchNoCheckData checkAmtData, CfPuchAmtLog logData, boolean reCal) {
        boolean isZero = false;
        if (reCal) {
            isZero = checkAmtData.getPullAmount().compareTo(BigDecimal.ZERO) == 0 && logData.getAmount().compareTo(BigDecimal.ZERO) == 0 && logData.getCurcAmt().compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCurnAmount().compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getNoCheckAmt().compareTo(BigDecimal.ZERO) == 0;
        } else {
            BigDecimal curnAmt = logData.getCurcAmt();
            BigDecimal noCheckAmt = logData.getAmount();
            long curPeriodId = logData.getCurPeriodId();
            if (this.getOperationType() == OperationType.CANCELCHECK && curPeriodId != checkAmtData.getPeriodId()) {
                curnAmt = BigDecimal.ZERO;
                noCheckAmt = BigDecimal.ZERO;
            }
            isZero = checkAmtData.getPullAmount().compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCheckAmount().add(logData.getAmount()).compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCurAmount().add(logData.getCurcAmt()).compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getCurnAmount().subtract(curnAmt).compareTo(BigDecimal.ZERO) == 0 && checkAmtData.getNoCheckAmt().subtract(noCheckAmt).compareTo(BigDecimal.ZERO) == 0;
        }
        return isZero;
    }

    @Override
    protected String getUpdateNoCheckAddAmtSql() {
        return UPD_PUCH_NoCheckAMT_ADD_SQL;
    }

    private void transAmtToCurPeriod(CfPuchAmtLog logData, CfCheckAmtData puchData, AbstractCalculatorPuchAmt.Params params, long periodId) {
        ArrayList<Number> param = new ArrayList<Number>(3);
        if (periodId == puchData.getPeriodId()) {
            param.add(logData.getAmount());
            param.add(puchData.getId());
            params.addUpdateNoCheckAddParams(param.toArray());
        }
    }

    @Override
    protected String[] getOrderBy() {
        return new String[]{"fcfitemid", "fcurrencyid", "fassgrpid", "foporgid", "fschemeid"};
    }
}

