/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.pullcheck.cf;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.Row;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.pullcheck.AbstractCalculatorPuchAmt;
import kd.fi.ict.pullcheck.cf.CfCalculatorCheckAmt;
import kd.fi.ict.pullcheck.cf.CfPuchAmtKey;
import kd.fi.ict.pullcheck.cf.CfPuchAmtLog;
import kd.fi.ict.pullcheck.cf.CfPuchNoCheckData;

public class CfCalculatorNoCheckAmt
extends CfCalculatorCheckAmt<CfPuchNoCheckData, CfPuchAmtLog, CfPuchAmtKey> {
    private static final String LOG_SQL = "SELECT FID, FSCHEMEID, FORGID, FBOOKTYPEID, FORIPERIODID, FPERIODID,FPERIODID FCURPERIODID, FCURRENCYID, FASSGRPID, FOPERATION, FRELRECORDID, FCHECKAMTCALED, FOPORGID, FCREATETIME, FCFITEMID, FAMOUNT FROM T_ICT_CFPUCHAMT_LOG WHERE FORGID = ? AND FBOOKTYPEID = ? AND FCHECKAMTCALED = '0' AND FOPERATION IN ('CFRNEXTPERIOD','CANNEXTPERIOD') ORDER BY FPERIODID,FCFITEMID,FCURRENCYID,FASSGRPID;";
    private static final String UPD_PUCH_NoCheckAMT_SUB_SQL = "UPDATE T_ICT_CFPUCHAMT SET FNOCHECKAMOUNT = FNOCHECKAMOUNT - ?, FCURNAMOUNT = FCURNAMOUNT - ? WHERE FID = ? ;";
    private static final String INSERT_PUCH_NoCheckAMT_SQL = "INSERT INTO T_ICT_CFPUCHAMT (FID,FORGID,FBOOKTYPEID,FPERIODID,FENDPERIODID,FSCHEMEID,FCFITEMID,FCURRENCYID,FASSGRPID,FOPORGID,FPYEARAMOUNT,FCYEARAMOUNT,FNOCHECKAMOUNT) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?);";
    private static final String UPD_PUCH_NoCheckAMT_ADD_SQL = "UPDATE T_ICT_CFPUCHAMT SET FNOCHECKAMOUNT = FNOCHECKAMOUNT + ?, FCURNAMOUNT = FCURNAMOUNT + ? WHERE FID = ? ;";

    public CfCalculatorNoCheckAmt(OperationType operationType) {
        super(operationType);
    }

    @Override
    protected String getLogSql() {
        return LOG_SQL;
    }

    @Override
    protected String getUpdateLogCaledSql() {
        return " UPDATE %S SET FCHECKAMTCALED='1' WHERE (FOPERATION = 'CFRNEXTPERIOD' OR FOPERATION = 'CANNEXTPERIOD') AND FID ";
    }

    @Override
    protected String getInsertPuchSql() {
        return INSERT_PUCH_NoCheckAMT_SQL;
    }

    @Override
    protected String getUpdateNoCheckSubAmtSql() {
        return UPD_PUCH_NoCheckAMT_SUB_SQL;
    }

    @Override
    protected String getUpdateNoCheckAddAmtSql() {
        return UPD_PUCH_NoCheckAMT_ADD_SQL;
    }

    @Override
    protected String getCheckAmtSelectFields(boolean reCal) {
        return "FCAMOUNT,FCYEARAMOUNT,FCURNAMOUNT,FNOCHECKAMOUNT";
    }

    @Override
    protected CfPuchNoCheckData getPuchData(Row rs, boolean reCal) {
        CfPuchNoCheckData data = new CfPuchNoCheckData(rs.getLong("fid"));
        data.setPeriodId(rs.getLong("fperiodid"));
        data.setEndPeriodId(rs.getLong("fendperiodid"));
        data.setCfitemId(rs.getLong("fcfitemid"));
        data.setOrgId(rs.getLong("forgid"));
        data.setOpOrgId(rs.getLong("foporgid"));
        data.setBookTypeId(rs.getLong("fbooktypeid"));
        data.setPullYearAmount(rs.getBigDecimal("fpyearamount"));
        data.setCheckYearAmount(rs.getBigDecimal("fcyearamount"));
        data.setPullAmount(rs.getBigDecimal("fpamount"));
        data.setCheckAmount(rs.getBigDecimal("fcamount"));
        data.setCurAmount(rs.getBigDecimal("fcuramount"));
        data.setCurnAmount(rs.getBigDecimal("fcurnamount"));
        data.setNoCheckAmt(rs.getBigDecimal("fnocheckamount"));
        return data;
    }

    @Override
    protected List<BigDecimal> getNewPuchAmtParam(CfPuchAmtKey pk, long periodId, CfPuchAmtLog logData, CfPuchNoCheckData prePuchAmt, boolean reCal) {
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>(4);
        param.add(Objects.isNull(prePuchAmt.getPullYearAmount()) ? BigDecimal.ZERO : prePuchAmt.getPullYearAmount());
        param.add(Objects.isNull(prePuchAmt.getCheckYearAmount()) ? BigDecimal.ZERO : prePuchAmt.getCheckYearAmount());
        param.add(logData.getAmount());
        return param;
    }

    @Override
    protected List<BigDecimal> getUpdatePuchAmtParam(long periodId, CfPuchAmtLog logData, CfPuchNoCheckData puchData, CfPuchNoCheckData prePuchData, boolean reCal) {
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>(18);
        param.add(logData.getAmount());
        if (logData.getOriPeriodId() == puchData.getPeriodId()) {
            param.add(logData.getAmount());
        } else {
            param.add(BigDecimal.ZERO);
        }
        return param;
    }

    @Override
    protected void dealNext(long periodId, CfPuchAmtLog logData, Iterator<CfPuchNoCheckData> puchIt, AbstractCalculatorPuchAmt.Params params, CfPuchNoCheckData prePuch) {
    }

    @Override
    protected void recalDealNext(long periodId, CfPuchAmtLog logData, Iterator<CfPuchNoCheckData> balIt, AbstractCalculatorPuchAmt.Params params, CfPuchNoCheckData prePuchData) {
    }

    @Override
    protected boolean isPuchZero(CfPuchNoCheckData checkAmtData, CfPuchAmtLog logData, boolean reCal) {
        CfPuchNoCheckData puchAmt = checkAmtData;
        BigDecimal curnAmt = BigDecimal.ZERO;
        if (logData.getOriPeriodId() == puchAmt.getPeriodId()) {
            curnAmt = logData.getAmount();
        }
        return puchAmt.getPullAmount().compareTo(BigDecimal.ZERO) == 0 && puchAmt.getCheckAmount().compareTo(BigDecimal.ZERO) == 0 && puchAmt.getCurAmount().compareTo(BigDecimal.ZERO) == 0 && puchAmt.getCurnAmount().subtract(curnAmt).compareTo(BigDecimal.ZERO) == 0 && puchAmt.getNoCheckAmt().subtract(logData.getAmount()).compareTo(BigDecimal.ZERO) == 0;
    }
}

