/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.pullcheck.cf;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.Row;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.pullcheck.AbstractCalculatorPuchAmt;
import kd.fi.ict.pullcheck.cf.CfPuchAmtKey;
import kd.fi.ict.pullcheck.cf.CfPuchAmtLog;
import kd.fi.ict.pullcheck.cf.CfPuchNoCheckData;
import kd.fi.ict.util.PeriodUtil;

public class CfCalculatorPullAmt
extends AbstractCalculatorPuchAmt<CfPuchNoCheckData, CfPuchAmtLog, CfPuchAmtKey> {
    private static final String LOG_SQL = "SELECT FID, FSCHEMEID, FORGID, FBOOKTYPEID, FORIPERIODID, FPERIODID, FCURRENCYID, FASSGRPID, FOPERATION, FRELRECORDID, FPULLAMTCALED, FOPORGID, FCREATETIME, FCFITEMID, FAMOUNT FROM T_ICT_CFPUCHAMT_LOG WHERE FORGID = ? AND FBOOKTYPEID = ? AND FPULLAMTCALED = '0' AND FOPERATION IN ('PULLDATA','DELETE','IMPORTDATA') ORDER BY FPERIODID,FCFITEMID,FCURRENCYID,FASSGRPID;";
    private static final String BILL_SQL = "SELECT R.FID, FSCHEMEID, R.FORGID, FBOOKTYPEID, FORIPERIODID, FPERIODID, FCURRENCYID, FASSGRPID,FOPORGID,I.FMASTERID FCFITEMID,FAMTBAL,FAMT FROM T_ICT_RELCFRECORD R INNER JOIN T_GL_CASHFLOWITEM I ON R.FCASHFLOWITEMID = I.FID WHERE R.FORGID = ? AND FBOOKTYPEID = ? AND FORIPERIODID = ?;";
    private static final String RECORD_SQL = "SELECT R.FID, FSCHEMEID, R.FORGID, FBOOKTYPEID, FORIPERIODID, FPERIODID, FCURRENCYID, FASSGRPID,FOPORGID,I.FMASTERID FCFITEMID,FAMTBAL,FAMT FROM T_ICT_RELCFRECORD R INNER JOIN T_GL_CASHFLOWITEM I ON R.FCASHFLOWITEMID = I.FID WHERE R.FORGID = ? AND FBOOKTYPEID = ? AND FPERIODID = ?;";
    private static final String INSERT_PUCH_SQL = "INSERT INTO T_ICT_CFPUCHAMT (FID,FORGID,FBOOKTYPEID,FPERIODID,FENDPERIODID,FSCHEMEID,FCFITEMID,FCURRENCYID,FASSGRPID,FOPORGID,FPAMOUNT,FPYEARAMOUNT,FCYEARAMOUNT,FCURNAMOUNT,FNOCHECKAMOUNT) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
    private static final String RE_UPD_PUCH_AMT_SQL = "UPDATE T_ICT_CFPUCHAMT  SET FPAMOUNT = ?, FPYEARAMOUNT = ? , FCURNAMOUNT = ? , FNOCHECKAMOUNT = ?WHERE FID = ?;";
    private static final String UPD_PUCH_AMT_SQL = "UPDATE T_ICT_CFPUCHAMT SET  FPAMOUNT = FPAMOUNT + ?, FPYEARAMOUNT = FPYEARAMOUNT + ?, FCURNAMOUNT = FCURNAMOUNT + ?, FNOCHECKAMOUNT = FNOCHECKAMOUNT + ? WHERE FID = ?;";
    private static final String UPD_CURR_Y_PUCH_SQL = "UPDATE T_ICT_CFPUCHAMT SET FPYEARAMOUNT = FPYEARAMOUNT + ?, FNOCHECKAMOUNT = FNOCHECKAMOUNT + ? WHERE FID = ?;";

    public CfCalculatorPullAmt(OperationType operationType) {
        super(operationType);
    }

    @Override
    protected String getLogTable() {
        return "t_ict_cfpuchamt_log";
    }

    @Override
    protected String getUpdateLogCaledSql() {
        return " UPDATE %S SET FPULLAMTCALED='1' WHERE FID ";
    }

    @Override
    protected String getLogSql() {
        return LOG_SQL;
    }

    @Override
    protected CfPuchAmtKey getPk(Row rs) {
        return new CfPuchAmtKey(rs.getLong("fschemeid"), rs.getLong("fcfitemid"), rs.getLong("fcurrencyid"), rs.getLong("fassgrpid"), rs.getLong("foporgid"));
    }

    @Override
    protected CfPuchAmtLog getLogData(boolean reCal, Row rs) {
        CfPuchAmtLog log = new CfPuchAmtLog();
        log.setOriPeriodId(rs.getLong("foriperiodid"));
        log.setPeriodId(rs.getLong("fperiodid"));
        if (reCal) {
            log.setAmount(rs.getBigDecimal("famt"));
        } else {
            log.setAmount(rs.getBigDecimal("famount"));
        }
        return log;
    }

    @Override
    protected String getBillSql() {
        return BILL_SQL;
    }

    @Override
    protected String getTab() {
        return "t_ict_cfpuchamt";
    }

    @Override
    protected String[] getKeyFields() {
        return new String[]{"fschemeid", "fcfitemid", "fcurrencyid", "fassgrpid", "foporgid"};
    }

    @Override
    protected String getPullAmtSelectFields(boolean reCal) {
        String select = "fpamount,fpyearamount,fcamount,fcuramount,fcyearamount,fcurnamount,fnocheckamount";
        return select;
    }

    @Override
    protected String getCheckAmtSelectFields(boolean reCal) {
        String select = "fcamount,fcyearamount";
        return select;
    }

    @Override
    protected CfPuchNoCheckData getPuchData(Row rs, boolean reCal) {
        CfPuchNoCheckData data = new CfPuchNoCheckData(rs.getLong("fid"));
        data.setPeriodId(rs.getLong("fperiodid"));
        data.setEndPeriodId(rs.getLong("fendperiodid"));
        data.setCfitemId(rs.getLong("fcfitemid"));
        data.setOrgId(rs.getLong("forgid"));
        data.setOpOrgId(rs.getLong("foporgid"));
        data.setBookTypeId(rs.getLong("fbooktypeid"));
        data.setPullAmount(rs.getBigDecimal("fpamount"));
        data.setPullYearAmount(rs.getBigDecimal("fpyearamount"));
        data.setCheckAmount(rs.getBigDecimal("fcamount"));
        data.setCurAmount(rs.getBigDecimal("fcuramount"));
        data.setCurnAmount(rs.getBigDecimal("fcurnamount"));
        data.setNoCheckAmt(rs.getBigDecimal("fnocheckamount"));
        data.setCheckYearAmount(rs.getBigDecimal("fcyearamount"));
        return data;
    }

    @Override
    protected List<BigDecimal> getNewPuchAmtParam(CfPuchAmtKey pk, long periodId, CfPuchAmtLog logData, CfPuchNoCheckData prePuchAmt, boolean reCal) {
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>(18);
        param.add(logData.getAmount());
        if (prePuchAmt != null && periodId / PeriodUtil.YEAR_PERIOD_L == prePuchAmt.getPeriodId() / PeriodUtil.YEAR_PERIOD_L) {
            param.add(prePuchAmt.getPullYearAmount().add(logData.getAmount()));
            param.add(prePuchAmt.getCheckYearAmount());
        } else {
            param.add(logData.getAmount());
            param.add(BigDecimal.ZERO);
        }
        if (reCal) {
            param.add(logData.getCurnAmt());
            param.add(logData.getNoCheckAmt());
        } else {
            param.add(logData.getAmount());
            param.add(logData.getAmount());
        }
        return param;
    }

    @Override
    protected String getInsertPuchSql() {
        return INSERT_PUCH_SQL;
    }

    @Override
    protected String getUpdAmtSql(boolean reCal) {
        return reCal ? RE_UPD_PUCH_AMT_SQL : UPD_PUCH_AMT_SQL;
    }

    @Override
    protected List<BigDecimal> getUpdatePuchAmtParam(long periodId, CfPuchAmtLog logData, CfPuchNoCheckData puchData, CfPuchNoCheckData prePuchData, boolean reCal) {
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>(18);
        BigDecimal amount = logData == null ? BigDecimal.ZERO : logData.getAmount();
        BigDecimal curnAmt = logData == null ? BigDecimal.ZERO : logData.getCurnAmt();
        BigDecimal noCheckAmt = logData == null ? BigDecimal.ZERO : logData.getNoCheckAmt();
        param.add(amount);
        if (reCal && (prePuchData == null || periodId / PeriodUtil.YEAR_PERIOD_L == prePuchData.getPeriodId() / PeriodUtil.YEAR_PERIOD_L)) {
            if (prePuchData == null) {
                param.add(amount);
            } else {
                param.add(prePuchData.getPullYearAmount().add(amount));
            }
        } else {
            param.add(amount);
        }
        if (reCal) {
            param.add(curnAmt);
            param.add(noCheckAmt);
        } else {
            if (logData != null && logData.getPeriodId() == logData.getOriPeriodId()) {
                param.add(amount);
            } else {
                param.add(BigDecimal.ZERO);
            }
            if (logData != null && logData.getPeriodId() == puchData.getPeriodId()) {
                param.add(amount);
            } else {
                param.add(BigDecimal.ZERO);
            }
        }
        return param;
    }

    @Override
    protected boolean equals(CfPuchNoCheckData puchData, BigDecimal[] amount) {
        return false;
    }

    @Override
    protected String getUpdCurrYAmtSql() {
        return UPD_CURR_Y_PUCH_SQL;
    }

    @Override
    protected String getUpdLaterYAmtSql() {
        return null;
    }

    @Override
    protected void dealNext(long periodId, CfPuchAmtLog logData, Iterator<CfPuchNoCheckData> puchIt, AbstractCalculatorPuchAmt.Params params, CfPuchNoCheckData prePuch) {
        while (puchIt.hasNext()) {
            CfPuchNoCheckData pullAmtData = puchIt.next();
            long puchId = pullAmtData.getId();
            ArrayList<Number> param = new ArrayList<Number>(3);
            if (periodId / PeriodUtil.YEAR_PERIOD_L != pullAmtData.getPeriodId() / PeriodUtil.YEAR_PERIOD_L) continue;
            param.add(logData.getAmount());
            if (logData.getPeriodId() == pullAmtData.getPeriodId()) {
                param.add(logData.getAmount());
            } else {
                param.add(BigDecimal.ZERO);
            }
            param.add(puchId);
            params.addUpdateCurrYAmtParam(param.toArray());
            prePuch = this.dealInvalidPeriod(pullAmtData, prePuch, logData, params, false);
        }
    }

    @Override
    protected void recalDealNext(long periodId, CfPuchAmtLog logData, Iterator<CfPuchNoCheckData> balIt, AbstractCalculatorPuchAmt.Params params, CfPuchNoCheckData prePuchAmt) {
        BigDecimal diffBal = logData.getAmount().subtract(prePuchAmt.getPullAmount());
        while (balIt.hasNext()) {
            CfPuchNoCheckData bal = balIt.next();
            long balId = bal.getId();
            ArrayList<Number> param = new ArrayList<Number>();
            if (periodId / PeriodUtil.YEAR_PERIOD_L != bal.getPeriodId() / PeriodUtil.YEAR_PERIOD_L) continue;
            param.add(diffBal);
            param.add(BigDecimal.ZERO);
            param.add(balId);
            params.addUpdateCurrYAmtParam(param.toArray());
            if (this.isPuchZero(bal, logData, false)) {
                params.addRemovePuchId(balId);
                if (prePuchAmt == null) continue;
                params.addUpdateEndPeriodParam(new Object[]{bal.getEndPeriodId(), prePuchAmt.getId()});
                continue;
            }
            prePuchAmt = bal;
        }
    }

    @Override
    protected boolean isPuchZero(CfPuchNoCheckData pullAmtData, CfPuchAmtLog logData, boolean reCal) {
        boolean isZero = false;
        if (reCal) {
            isZero = logData.getAmount().compareTo(BigDecimal.ZERO) == 0 && pullAmtData.getCheckAmount().compareTo(BigDecimal.ZERO) == 0 && pullAmtData.getCurAmount().compareTo(BigDecimal.ZERO) == 0 && logData.getCurnAmt().compareTo(BigDecimal.ZERO) == 0 && logData.getNoCheckAmt().compareTo(BigDecimal.ZERO) == 0;
        } else {
            BigDecimal curnAmt = BigDecimal.ZERO;
            BigDecimal noCheckAmt = BigDecimal.ZERO;
            BigDecimal curPullAmt = BigDecimal.ZERO;
            long logPeriodId = logData.getPeriodId();
            long logOriPeriodId = logData.getOriPeriodId();
            long pullPeriodId = pullAmtData.getPeriodId();
            if (logPeriodId == pullPeriodId && logOriPeriodId == pullPeriodId) {
                curnAmt = logData.getAmount();
            }
            if (logOriPeriodId == pullPeriodId) {
                curPullAmt = logData.getAmount();
            }
            if (logPeriodId == pullPeriodId) {
                noCheckAmt = logData.getAmount();
            }
            isZero = pullAmtData.getPullAmount().add(curPullAmt).compareTo(BigDecimal.ZERO) == 0 && pullAmtData.getCheckAmount().compareTo(BigDecimal.ZERO) == 0 && pullAmtData.getCurAmount().compareTo(BigDecimal.ZERO) == 0 && pullAmtData.getCurnAmount().add(curnAmt).compareTo(BigDecimal.ZERO) == 0 && pullAmtData.getNoCheckAmt().add(noCheckAmt).compareTo(BigDecimal.ZERO) == 0;
        }
        return isZero;
    }

    @Override
    protected String getRecordSql() {
        return RECORD_SQL;
    }

    @Override
    protected CfPuchAmtLog getNoCheckData(Row rs) {
        CfPuchAmtLog log = new CfPuchAmtLog();
        long oriperiod = rs.getLong("foriperiodid");
        long period = rs.getLong("fperiodid");
        log.setOriPeriodId(oriperiod);
        log.setPeriodId(period);
        BigDecimal amtbal = rs.getBigDecimal("famtbal");
        log.setNoCheckAmt(amtbal);
        if (oriperiod == period) {
            log.setCurnAmt(amtbal);
        }
        return log;
    }

    @Override
    protected String getPeriodField() {
        return "foriperiodid";
    }

    @Override
    protected String[] getOrderBy() {
        return new String[]{"fcfitemid", "fcurrencyid", "fassgrpid", "foporgid", "fschemeid"};
    }
}

