/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.pullcheck.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ict.business.cancelcheck.bean.AuditRecordRow;
import kd.fi.ict.enums.LogCalculated;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.pullcheck.AbstractCalculatorPuchAmt;
import kd.fi.ict.pullcheck.BookKey;
import kd.fi.ict.pullcheck.IPuchAmtLog;
import kd.fi.ict.pullcheck.Key;
import kd.fi.ict.pullcheck.LogList;
import kd.fi.ict.pullcheck.cf.CfCalculatorCheckAmt;
import kd.fi.ict.pullcheck.cf.CfCalculatorNoCheckAmt;
import kd.fi.ict.pullcheck.cf.CfCalculatorPullAmt;
import kd.fi.ict.pullcheck.cf.CfPuchAmtLog;
import kd.fi.ict.pullcheck.cf.CfPuchAmtLogKey;

public class CfPuchLogImpl
implements IPuchAmtLog {
    private static final String CF_PUCH_LOG_BOOK = "CF_PUCH_LOG_BOOK";
    private static final String CF_RECORD_SELECT = "id,reconscheme,org,booktype,ori_period,period,oporg,cashflowitem.masterid,assgrp,amt,amtbal,currency,dc";
    private static final String INSERT_CF_PUCH_LOG_SQL = "INSERT INTO T_ICT_CFPUCHAMT_LOG (FID,FSCHEMEID,FRELRECORDID,FORGID,FBOOKTYPEID,FORIPERIODID,FPERIODID,FCFITEMID,FCURRENCYID,FASSGRPID,FOPORGID,FAMOUNT,FOPERATION,FPULLAMTCALED,FCHECKAMTCALED,FCREATETIME) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
    private static final String CF_CHECK_RECORD_SELECT = "entryentity.dc,entryentity.relrecordid,entryentity.amtverify,period checkperiod";

    @Override
    public void setDeductLog(DynamicObject[] relcord, OperationType operation) {
        LogList logList = new LogList();
        List ids = Arrays.stream(relcord).map(v -> v.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", ids);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ict_relcfrecord", (String)CF_RECORD_SELECT, (QFilter[])new QFilter[]{filter}, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                this.addCfPuchLog(-1, logList, row, null, operation);
            }
        }
        this.storeLog(logList, operation);
        this.updateAmt(operation);
    }

    @Override
    public void setAddLog(DynamicObject[] relcord, OperationType operation) {
        LogList logList = new LogList();
        List ids = Arrays.stream(relcord).map(v -> v.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", ids);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ict_relcfrecord", (String)CF_RECORD_SELECT, (QFilter[])new QFilter[]{filter}, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                this.addCfPuchLog(1, logList, row, null, operation);
            }
        }
        this.storeLog(logList, operation);
        this.updateAmt(operation);
    }

    @Override
    public void setDeductCheckLog(DynamicObject[] relcord, OperationType operation) {
        LogList logList = new LogList();
        List ids = Arrays.stream(relcord).map(v -> v.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", ids);
        try (DataSet dsCheck = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ict_check_cash_record", (String)CF_CHECK_RECORD_SELECT, (QFilter[])new QFilter[]{filter}, null);){
            HashMap<Long, Object[]> checkMap = new HashMap<Long, Object[]>(16);
            while (dsCheck.hasNext()) {
                Row rowCheck = dsCheck.next();
                checkMap.put(rowCheck.getLong("entryentity.relrecordid"), new Object[]{rowCheck.getString("entryentity.dc"), rowCheck.getBigDecimal("entryentity.amtverify"), rowCheck.getLong("checkperiod")});
                if (checkMap.size() != 999 && dsCheck.hasNext()) continue;
                filter = new QFilter("id", "in", checkMap.keySet());
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ict_relcfrecord", (String)CF_RECORD_SELECT, (QFilter[])new QFilter[]{filter}, null);){
                    while (ds.hasNext()) {
                        Row row = ds.next();
                        this.addCfPuchLog(-1, logList, row, checkMap, operation);
                    }
                }
                checkMap.clear();
            }
        }
        this.storeLog(logList, operation);
        this.updateAmt(operation);
    }

    @Override
    public void setDeductCheckLog(List<AuditRecordRow> records, OperationType operation) {
        LogList logList = new LogList();
        HashMap<Long, Object[]> checkMap = new HashMap<Long, Object[]>(16);
        for (int i = 0; i < records.size(); ++i) {
            AuditRecordRow dr = records.get(i);
            checkMap.put(dr.getRecordId(), new Object[]{dr.getDc(), dr.getAmt(), dr.getPeriodId()});
            if (checkMap.size() != 999 && i != records.size() - 1) continue;
            QFilter filter = new QFilter("id", "in", checkMap.keySet());
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ict_relcfrecord", (String)CF_RECORD_SELECT, (QFilter[])new QFilter[]{filter}, null);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    this.addCfPuchLog(-1, logList, row, checkMap, operation);
                }
            }
            checkMap.clear();
        }
        this.storeLog(logList, operation);
    }

    @Override
    public void setAddCheckLog(DynamicObject[] checkRecord, OperationType operation) {
        LogList logList = new LogList();
        List ids = Arrays.stream(checkRecord).map(v -> v.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", ids);
        try (DataSet dsCheck = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ict_check_cash_record", (String)CF_CHECK_RECORD_SELECT, (QFilter[])new QFilter[]{filter}, null);){
            HashMap<Long, Object[]> checkMap = new HashMap<Long, Object[]>(16);
            while (dsCheck.hasNext()) {
                Row rowCheck = dsCheck.next();
                checkMap.put(rowCheck.getLong("entryentity.relrecordid"), new Object[]{rowCheck.getString("entryentity.dc"), rowCheck.getBigDecimal("entryentity.amtverify"), rowCheck.getLong("checkperiod")});
                if (checkMap.size() != 999 && dsCheck.hasNext()) continue;
                filter = new QFilter("id", "in", checkMap.keySet());
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ict_relcfrecord", (String)CF_RECORD_SELECT, (QFilter[])new QFilter[]{filter}, null);){
                    while (ds.hasNext()) {
                        Row row = ds.next();
                        this.addCfPuchLog(1, logList, row, checkMap, operation);
                    }
                }
                checkMap.clear();
            }
        }
        this.storeLog(logList, operation);
        this.updateAmt(operation);
    }

    @Override
    public List<Object> setAddDisableCheckLog(List<AuditRecordRow> records, OperationType operation) {
        LogList logList = new LogList();
        HashMap<Long, Object[]> checkMap = new HashMap<Long, Object[]>(16);
        for (int i = 0; i < records.size(); ++i) {
            AuditRecordRow dr = records.get(i);
            checkMap.put(dr.getRecordId(), new Object[]{dr.getDc(), dr.getAmt(), dr.getPeriodId()});
            if (checkMap.size() != 999 && i != records.size() - 1) continue;
            QFilter filter = new QFilter("id", "in", checkMap.keySet());
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ict_relcfrecord", (String)CF_RECORD_SELECT, (QFilter[])new QFilter[]{filter}, null);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    this.addCfPuchLog(1, logList, row, checkMap, operation);
                }
            }
            checkMap.clear();
        }
        return this.storeLog(logList, operation, false);
    }

    @Override
    public void storeLog(LogList logList, OperationType operation) {
        this.storeCfLog(logList, operation, true);
    }

    private List<Object> storeLog(LogList logList, OperationType operation, boolean isEnable) {
        return this.storeCfLog(logList, operation, isEnable);
    }

    @Override
    public void updateAmt(OperationType operation) {
        AbstractCalculatorPuchAmt calculator = this.isUpdatePullAmt(operation) ? new CfCalculatorPullAmt(operation) : (this.isNextPeriod(operation) ? new CfCalculatorNoCheckAmt(operation) : new CfCalculatorCheckAmt(operation));
        Set bookSet = (Set)ThreadCache.get((Object)CF_PUCH_LOG_BOOK);
        if (Objects.nonNull(bookSet)) {
            bookSet.forEach(v -> calculator.calculate(v.getOrgId(), v.getBookTypeId()));
        }
    }

    @Override
    public void updateAmt(Set<BookKey> bookSet, OperationType operation) {
        AbstractCalculatorPuchAmt calculator = this.isUpdatePullAmt(operation) ? new CfCalculatorPullAmt(operation) : (this.isNextPeriod(operation) ? new CfCalculatorNoCheckAmt(operation) : new CfCalculatorCheckAmt(operation));
        if (Objects.nonNull(bookSet)) {
            bookSet.forEach(v -> calculator.calculate(v.getOrgId(), v.getBookTypeId()));
        }
    }

    private void addCfPuchLog(int negate, LogList logList, Row row, Map<Long, Object[]> checkMap, OperationType operation) {
        CfPuchAmtLogKey key = new CfPuchAmtLogKey(row);
        if (operation == OperationType.CANCELCHECK && Objects.nonNull(checkMap) && checkMap.get(key.getRelRecordId()).length > 2) {
            key = new CfPuchAmtLogKey(row, (Long)checkMap.get(key.getRelRecordId())[2]);
        }
        CfPuchAmtLog log = new CfPuchAmtLog();
        if (OperationType.CFRNEXTPERIOD == operation || OperationType.CANNEXTPERIOD == operation) {
            log.setAmount(row.getBigDecimal("amtbal"));
        } else {
            if (checkMap == null) {
                log.setAmount(row.getBigDecimal("amt"));
            } else {
                Object[] checkVal = checkMap.get(key.getRelRecordId());
                log.setAmount((BigDecimal)checkVal[1]);
            }
            if (negate == -1) {
                log.negate();
            }
        }
        logList.add(key, log);
    }

    private List<Object> storeCfLog(LogList logList, OperationType operation, boolean isEnable) {
        List<Object[]> params;
        if (logList != null && !logList.isEmpty() && !(params = this.getInsertParams(logList, operation.name(), isEnable)).isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)INSERT_CF_PUCH_LOG_SQL, params);
            return params.stream().map(x -> x[0]).collect(Collectors.toList());
        }
        return new ArrayList<Object>(1);
    }

    private List<Object[]> getInsertParams(LogList logList, String action, boolean isEnable) {
        ArrayList<Object[]> result = new ArrayList<Object[]>(logList.getData().size());
        HashSet<BookKey> bookSet = (HashSet<BookKey>)ThreadCache.get((Object)CF_PUCH_LOG_BOOK);
        if (bookSet == null) {
            bookSet = new HashSet<BookKey>(1);
            ThreadCache.put((Object)CF_PUCH_LOG_BOOK, bookSet);
        }
        Map puchMap = logList.getData();
        long[] puchLogIds = DB.genLongIds((String)"ict_cfpuchamt_log", (int)puchMap.size());
        int puchLogIdIndex = 0;
        for (Map.Entry entry : puchMap.entrySet()) {
            CfPuchAmtLog log = (CfPuchAmtLog)entry.getValue();
            if (log.isZero()) continue;
            bookSet.add(new BookKey((CfPuchAmtLogKey)entry.getKey()));
            long[] groupKey = ((Key)entry.getKey()).getKeyValues();
            int size = 9 + groupKey.length;
            ArrayList<Object> params = new ArrayList<Object>(size);
            params.add(puchLogIds[puchLogIdIndex++]);
            for (long filedValue : groupKey) {
                params.add(filedValue);
            }
            params.add(log.getAmount());
            params.add(action);
            if (isEnable) {
                params.add(LogCalculated.NOTCALCULATE.getValue());
                params.add(LogCalculated.NOTCALCULATE.getValue());
            } else {
                params.add(LogCalculated.NOTEFFECTIVE.getValue());
                params.add(LogCalculated.NOTEFFECTIVE.getValue());
            }
            params.add(new Date());
            result.add(params.toArray());
        }
        return result;
    }
}

