/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.opplugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.fi.lock.IShareLock;
import kd.fi.ict.business.cancelcheck.bean.OperatorLockKey;
import kd.fi.ict.cache.CacheHelper;
import kd.fi.ict.cache.CacheModule;
import kd.fi.ict.cache.DistributeCache;
import kd.fi.ict.enums.TransactionType;

public class AbstractRelRecordServicePlugin
extends AbstractOperationServicePlugIn {
    protected Map<String, IShareLock> shareLocks = new HashMap<String, IShareLock>(4);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("oporg");
        fieldKeys.add("reconscheme");
        fieldKeys.add("currency");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] entities = this.getDataEntities();
                if (entities.length > 0) {
                    String msg = ResManager.loadKDString((String)"%1$s\u6b63\u5728\u6267\u884c%2$s\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AbstractRelRecordServicePlugin_0", (String)"fi-ict-opplugin", (Object[])new Object[]{RequestContext.get().getUserName(), this.getOperationName()});
                    TransactionType transactionType = TransactionType.getTransactionTypeByDynamicObjectType((DynamicObject)entities[0].getDataEntity());
                    DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.getCacheModule((String)transactionType.getTransactionType()));
                    for (ExtendedDataEntity entity : entities) {
                        OperatorLockKey opLockKey = new OperatorLockKey(entity.getDataEntity());
                        String lockKey = opLockKey.getLockKey();
                        IShareLock shareLock = AbstractRelRecordServicePlugin.this.shareLocks.get(lockKey);
                        if (!Objects.isNull(shareLock)) continue;
                        cache.put(lockKey, msg);
                        shareLock = IShareLock.create();
                        if (shareLock.requireLock(lockKey, true, 0L)) {
                            AbstractRelRecordServicePlugin.this.shareLocks.put(lockKey, shareLock);
                            continue;
                        }
                        this.addMessage(entity, cache.get(lockKey));
                    }
                }
            }
        });
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        if (this.shareLocks.size() > 0) {
            String transactionType = null;
            DistributeCache cache = null;
            for (Map.Entry<String, IShareLock> entry : this.shareLocks.entrySet()) {
                String key = entry.getKey();
                if (Objects.isNull(transactionType)) {
                    transactionType = key.split("-")[0];
                    cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.getCacheModule((String)transactionType));
                }
                entry.getValue().release();
                if (!Objects.nonNull(cache) || !Objects.nonNull(key)) continue;
                cache.remove(key);
            }
        }
    }
}

