/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.opplugin.autoReconciliation;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ict.business.autoreconcil.AutoReconciliationFactory;
import kd.fi.ict.business.autoreconcil.IAutoReconciliation;
import kd.fi.ict.business.bean.AutoCondition;
import kd.fi.ict.lock.CrossCheckLockKey;
import kd.fi.ict.lock.LockKey;

public class AutoReconciliationOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(AutoReconciliationOp.class);
    private DynamicObject dataEntity;

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dynamicObjects = e.getDataEntities();
        this.dataEntity = dynamicObjects[0];
        String autoScheme = this.operateOption.getVariableValue("autoScheme");
        List paramList = (List)SerializationUtils.fromJsonString((String)autoScheme, List.class);
        this.operationResult.setSuccess(true);
        for (String reconScheme : paramList) {
            try {
                this.autoReconProcess(reconScheme);
            }
            catch (KDException ex) {
                this.operationResult.setSuccess(false);
                this.operationResult.setMessage(ex.getMessage());
                logger.error((Throwable)ex);
            }
        }
        logger.info("\u6240\u6709\u65b9\u6848\u6267\u884c\u5b8c\u6bd5!");
    }

    private void autoReconProcess(String reconScheme) {
        logger.info("\u5f00\u59cb\u6267\u884c\u5bf9\u8d26\u4efb\u52a1:\u65b9\u6848:{}", (Object)reconScheme);
        ArrayList<Long> orgList = new ArrayList<Long>();
        ArrayList<Long> oppOrgList = new ArrayList<Long>();
        String[] reconStr = reconScheme.split(",");
        String orgId = reconStr[0];
        String oppOrgId = reconStr[1];
        String schemeId = reconStr[2];
        String currencyId = reconStr[3];
        String transactionType = reconStr[4];
        orgList.add(Long.valueOf(orgId));
        oppOrgList.add(Long.valueOf(oppOrgId));
        long period_id = this.dataEntity.getLong("period_id");
        CrossCheckLockKey checkLockKey = new CrossCheckLockKey(LockKey.getLockKeyByTransactionType((String)transactionType), Long.parseLong(orgId), Long.parseLong(oppOrgId), Long.parseLong(schemeId), Long.parseLong(currencyId));
        try (DLock dLock = DLock.create((String)checkLockKey.getKey()).fastMode();){
            if (dLock.tryLock()) {
                AutoCondition autoCondition = new AutoCondition(orgList, oppOrgList, Long.valueOf(period_id), Long.valueOf(schemeId), Long.valueOf(currencyId));
                IAutoReconciliation reconciliation = AutoReconciliationFactory.getReconciliation((String)transactionType);
                long now = System.currentTimeMillis();
                reconciliation.autoProcess(autoCondition);
                logger.info("==AutoReconciliationOp==\u5bf9\u8d26\u603b\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - now));
            } else {
                logger.info("\u3010\u5bf9\u8d26\u65b9\u6848\u3011:{}\u6709\u5176\u4ed6\u65b9\u6848\u6b63\u5728\u5bf9\u8d26\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (Object)reconScheme);
            }
        }
    }
}

