/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.opplugin.cancelcheck;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.fi.ict.business.cancelcheck.service.AbstractCancelCheckService;
import kd.fi.ict.business.cancelcheck.service.CancelCheckServieFactory;
import kd.fi.ict.enums.VerifyType;
import kd.fi.ict.opplugin.AbstractRelRecordServicePlugin;

public class CancelCheckOpService
extends AbstractRelRecordServicePlugin {
    private VerifyType getVerifyType() {
        String billEntityTypeName = this.billEntityType.getName();
        if ("ict_check_record".equals(billEntityTypeName)) {
            return VerifyType.ACCT;
        }
        return VerifyType.CF;
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("entryentity.relrecordid");
        fieldKeys.add("entryentity.amtverify");
        fieldKeys.add("entryentity.amtbal");
        if (VerifyType.ACCT == this.getVerifyType()) {
            fieldKeys.add("entryentity.amtverifyloc");
            fieldKeys.add("entryentity.amtballoc");
            fieldKeys.add("entryentity.loccur");
        }
        if (VerifyType.CF == this.getVerifyType()) {
            fieldKeys.add("entryentity.concurrency");
            fieldKeys.add("entryentity.convertamt");
            fieldKeys.add("entryentity.convertamtbal");
            fieldKeys.add("entryentity.convertamtverify");
        }
        fieldKeys.add("entryentity.org");
        fieldKeys.add("entryentity.opporg");
        fieldKeys.add("entryentity.currency");
        fieldKeys.add("entryentity.relrecordid");
        fieldKeys.add("entryentity.dc");
        fieldKeys.add("entryentity.voucherid");
        fieldKeys.add("verifyscheme");
        fieldKeys.add("checktype");
        fieldKeys.add("period");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String billEntityName;
        AbstractCancelCheckService cancelCheckService;
        String voucherParams = this.getOption().getVariableValue("voucherids", "");
        ArrayList voucherids = new ArrayList(10);
        if (StringUtils.isNotBlank((CharSequence)voucherParams)) {
            voucherids.addAll((Collection)SerializationUtils.fromJsonString((String)voucherParams, List.class));
        }
        if (null != (cancelCheckService = CancelCheckServieFactory.getService((String)(billEntityName = this.billEntityType.getName())))) {
            Map pkToError = cancelCheckService.cancelCheck(billEntityName, e.getDataEntities(), voucherids);
            if (!pkToError.isEmpty()) {
                OperationResult delResult = this.getOperationResult();
                for (Map.Entry errorInfo : pkToError.entrySet()) {
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo("ICT_CANCEL_CHECK", ErrorLevel.FatalError, errorInfo.getKey());
                    operateErrorInfo.setMessage((String)errorInfo.getValue());
                    operateErrorInfo.setTitle(ResManager.loadKDString((String)"\u53d6\u6d88\u52fe\u7a3d", (String)"CancelCheckOpService_1", (String)"fi-ict-opplugin", (Object[])new Object[0]));
                    delResult.addErrorInfo(operateErrorInfo);
                }
                delResult.setSuccess(false);
                Set failPkValueSet = pkToError.keySet();
                DynamicObject[] successDataEntities = (DynamicObject[])Arrays.stream(e.getDataEntities()).filter(x -> !failPkValueSet.contains(x.getPkValue())).toArray(DynamicObject[]::new);
                e.setDataEntities(successDataEntities);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u53cd\u52fe\u7a3d\u64cd\u4f5c\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u3002", (String)"CancelCheckOpService_2", (String)"fi-ict-opplugin", (Object[])new Object[0]));
        }
    }
}

