/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.opplugin.manualrelverigy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.lock.IShareLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ict.business.cancelcheck.bean.OperatorLockKey;
import kd.fi.ict.business.opservice.manualrelverigy.IManualReconciliationLogService;
import kd.fi.ict.business.opservice.manualrelverigy.converttomanual.ManualReconciliationConvertToManualReconciliation;
import kd.fi.ict.business.opservice.manualrelverigy.factory.GetManualReconciliationLogServiceFactory;
import kd.fi.ict.business.opservice.manualrelverigy.factory.GetVchDataHandleFactory;
import kd.fi.ict.cache.CacheHelper;
import kd.fi.ict.cache.CacheModule;
import kd.fi.ict.cache.DistributeCache;
import kd.fi.ict.common.manualrelverigy.ManualReconciliationInfo;
import kd.fi.ict.entity.RecordManualVo;
import kd.fi.ict.enums.TransactionType;
import kd.fi.ict.lock.LockKey;
import kd.fi.ict.util.IctDataMutexUtil;

public class ManualReconciliationOp
extends AbstractOperationServicePlugIn {
    protected Map<String, IShareLock> shareLocks = new HashMap<String, IShareLock>(4);
    protected Log LOGGER = LogFactory.getLog(ManualReconciliationOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] entities = this.getDataEntities();
                if (entities.length > 0) {
                    String msg = ResManager.loadKDString((String)"%1$s\u6b63\u5728\u6267\u884c%2$s\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ManualReconciliationOp_1", (String)"fi-ict-opplugin", (Object[])new Object[]{RequestContext.get().getUserName(), this.getOperationName()});
                    DynamicObject entity = entities[0].getDataEntity();
                    TransactionType transactionType = "acct_type".equals(entity.getString("showtype")) ? TransactionType.CASH_FLOW : TransactionType.BOND_DEBT;
                    OperatorLockKey opLockKey = new OperatorLockKey(LockKey.getLockKeyByTransactionType((String)transactionType.name()), Long.valueOf(entity.getLong("org_id")), Long.valueOf(entity.getLong("oppoorg_id")), Long.valueOf(entity.getLong("currency_id")), Long.valueOf(entity.getLong("verifyscheme_id")));
                    DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.getCacheModule((String)transactionType.name()));
                    String lockKey = opLockKey.getLockKey();
                    IShareLock shareLock = ManualReconciliationOp.this.shareLocks.get(lockKey);
                    if (Objects.isNull(shareLock)) {
                        cache.put(lockKey, msg);
                        shareLock = IShareLock.create();
                        if (shareLock.requireLock(lockKey, true, 0L)) {
                            ManualReconciliationOp.this.shareLocks.put(lockKey, shareLock);
                        } else {
                            this.addMessage(entities[0], cache.get(opLockKey.getLockKey()));
                        }
                    } else {
                        this.addMessage(entities[0], cache.get(opLockKey.getLockKey()));
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ManualReconciliationConvertToManualReconciliation manualReconciliationConvert = new ManualReconciliationConvertToManualReconciliation();
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        List bselList = (List)SerializationUtils.fromJsonString((String)this.operateOption.getVariableValue("select_b_entryentity"), List.class);
        List dselList = (List)SerializationUtils.fromJsonString((String)this.operateOption.getVariableValue("select_d_entryentity"), List.class);
        List<RecordManualVo> bselectList = this.changeMethod(bselList);
        List<RecordManualVo> dselectList = this.changeMethod(dselList);
        String showType = this.operateOption.getVariableValue("showtype");
        String remark = this.operateOption.getVariableValue("remark");
        String currentTime = this.operateOption.getVariableValue("current_time");
        List bentryList = GetVchDataHandleFactory.getHandle((String)showType).compileSelectRows(bselectList);
        if (bentryList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u52fe\u9009\u7684\u672c\u65b9\u5173\u8054\u4ea4\u6613\u51ed\u8bc1\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u518d\u91cd\u8bd5\u3002", (String)"ManualReconciliationOp_0", (String)"fi-ict-opplugin", (Object[])new Object[0]));
        }
        List dentryList = GetVchDataHandleFactory.getHandle((String)showType).compileSelectRows(dselectList);
        manualReconciliationConvert.init(new Object[]{dataEntity, bselList, dselList, showType, remark, currentTime});
        ManualReconciliationInfo manualReconciliationInfo = manualReconciliationConvert.convert(bentryList, dentryList);
        IManualReconciliationLogService service = GetManualReconciliationLogServiceFactory.getService((String)manualReconciliationInfo.getShowType());
        Set recordIds = bselectList.stream().map(RecordManualVo::getRecordId).collect(Collectors.toSet());
        recordIds.addAll(dselectList.stream().map(RecordManualVo::getRecordId).collect(Collectors.toSet()));
        Map requireMutex = IctDataMutexUtil.requireMutex((String)dataEntity.getDataEntityType().getName(), recordIds);
        if (requireMutex.size() > 0) {
            IctDataMutexUtil.batchRelease((String)dataEntity.getDataEntityType().getName(), recordIds);
        } else {
            Map validateResult = service.validate(manualReconciliationConvert);
            if (this.checkIsSuccess(e, validateResult)) {
                IctDataMutexUtil.batchRelease((String)dataEntity.getDataEntityType().getName(), recordIds);
                return;
            }
            Map processResult = service.process(manualReconciliationInfo);
            if (this.checkIsSuccess(e, processResult)) {
                IctDataMutexUtil.batchRelease((String)dataEntity.getDataEntityType().getName(), recordIds);
                return;
            }
            IctDataMutexUtil.batchRelease((String)dataEntity.getDataEntityType().getName(), recordIds);
        }
        this.LOGGER.info("- bselList:{}", (Object)SerializationUtils.toJsonString(bselectList));
        this.LOGGER.info("- dselList:{}", (Object)SerializationUtils.toJsonString(dselectList));
    }

    private List<RecordManualVo> changeMethod(List<LinkedHashMap> bselList) {
        ArrayList<RecordManualVo> bselectList = new ArrayList<RecordManualVo>(10);
        for (LinkedHashMap linkedHashMap : bselList) {
            RecordManualVo vo = new RecordManualVo();
            vo.setRecordId((Long)linkedHashMap.get("recordId"));
            vo.setTaoriamount((BigDecimal)linkedHashMap.get("taoriamount"));
            vo.setTlocalcur((BigDecimal)linkedHashMap.get("tlocalcur"));
            vo.setIndex((Integer)linkedHashMap.get("index"));
            bselectList.add(vo);
        }
        return bselectList;
    }

    private boolean checkIsSuccess(BeginOperationTransactionArgs e, Map<String, Object> validateResult) {
        if (!((Boolean)validateResult.get("success")).booleanValue()) {
            this.operationResult.setSuccess(false);
            this.operationResult.setMessage((String)validateResult.get("message"));
            e.setCancelOperation(true);
            return true;
        }
        return false;
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        if (this.shareLocks.size() > 0) {
            String transactionType = null;
            DistributeCache cache = null;
            for (Map.Entry<String, IShareLock> entry : this.shareLocks.entrySet()) {
                String key = entry.getKey();
                if (Objects.isNull(transactionType)) {
                    transactionType = key.split("-")[0];
                    cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.getCacheModule((String)transactionType));
                }
                entry.getValue().release();
                if (!Objects.nonNull(cache) || !Objects.nonNull(key)) continue;
                cache.remove(key);
            }
        }
    }
}

