/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.opplugin.recontolerance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ict.constant.ReconToleranceField;
import kd.fi.ict.util.AccountServiceHelper;

public class ReconToleranceSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("useorg");
        fieldKeys.add("accounttable");
        fieldKeys.add("account");
        fieldKeys.add("currency");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                this.setAddBillNoForContent(false);
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    Object value2;
                    DynamicObject dyn = dataEntity.getDataEntity();
                    long useOrgId = dyn.getLong(ReconToleranceField.id((String)"useorg"));
                    long acctTableId = dyn.getLong(ReconToleranceField.id((String)"accounttable"));
                    DynamicObjectCollection dynAccountCol = dyn.getDynamicObjectCollection("account");
                    ArrayList accountLst = new ArrayList(dynAccountCol.size());
                    dynAccountCol.forEach(value -> accountLst.add(value.getLong("fbasedataid.id")));
                    long currencyID = dyn.getLong(ReconToleranceField.id((String)"currency"));
                    QFilter filterCommon = new QFilter("id", "!=", dyn.getPkValue()).and(new QFilter("accounttable", "=", (Object)acctTableId)).and(new QFilter("currency", "=", (Object)currencyID)).and(BaseDataServiceHelper.getBaseDataFilter((String)"ict_recontolerance", (Long)useOrgId));
                    QFilter filter = new QFilter("account.fbasedataid.id", "in", accountLst);
                    boolean exists = QueryServiceHelper.exists((String)"ict_recontolerance", (QFilter[])new QFilter[]{filterCommon, filter});
                    if (exists) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u76f8\u540c\u7ec4\u7ec7\uff0c\u76f8\u540c\u79d1\u76ee\u8868\uff0c\u76f8\u540c\u79d1\u76ee\uff0c\u76f8\u540c\u5e01\u79cd\u4e0b\u53ea\u80fd\u6709\u4e00\u4e2a\u5bb9\u5dee\u3002", (String)"ReconToleranceSaveOp_0", (String)"fi-ict-opplugin", (Object[])new Object[0]));
                    }
                    if ("2".equals(dyn.getString("tolerancetype")) && (((BigDecimal)(value2 = dyn.getBigDecimal("tolerancevalue"))).compareTo(BigDecimal.ONE) >= 0 || ((BigDecimal)value2).compareTo(BigDecimal.ZERO) <= 0)) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5bb9\u5dee\u65b9\u5f0f\u662f\u767e\u5206\u6bd4\u65f6\uff0c\u5bb9\u5dee\u503c\u57280~1\u4e4b\u95f4\u3002", (String)"ReconToleranceSaveOp_1", (String)"fi-ict-opplugin", (Object[])new Object[0]));
                    }
                    value2 = accountLst.iterator();
                    while (value2.hasNext()) {
                        Long acctId = (Long)value2.next();
                        Set parentIdsByAcctId = AccountServiceHelper.getParentIdsByAcctId((long)useOrgId, (long)acctId, (boolean)false);
                        filter = new QFilter("account.fbasedataid.id", "in", (Object)parentIdsByAcctId).and(new QFilter("tolerancevalue", "<=", (Object)dyn.getBigDecimal("tolerancevalue")));
                        exists = QueryServiceHelper.exists((String)"ict_recontolerance", (QFilter[])new QFilter[]{filterCommon, filter});
                        if (exists) {
                            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u5bb9\u5dee\u503c\u5fc5\u987b\u5c0f\u4e8e\u4e0a\u7ea7\u79d1\u76ee\u8bbe\u5b9a\u7684\u5bb9\u5dee\u503c\u3002", (String)"ReconToleranceSaveOp_2", (String)"fi-ict-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        Set childrenIdsByAcctId = AccountServiceHelper.getChildrenIdsByAcctId((long)useOrgId, (long)acctId, (boolean)false, (boolean)true);
                        filter = new QFilter("account.fbasedataid.id", "in", (Object)childrenIdsByAcctId).and(new QFilter("tolerancevalue", ">=", (Object)dyn.getBigDecimal("tolerancevalue")));
                        exists = QueryServiceHelper.exists((String)"ict_recontolerance", (QFilter[])new QFilter[]{filterCommon, filter});
                        if (!exists) continue;
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u5bb9\u5dee\u503c\u5fc5\u987b\u5927\u4e8e\u4e0b\u7ea7\u79d1\u76ee\u8bbe\u5b9a\u7684\u5bb9\u5dee\u503c\u3002", (String)"ReconToleranceSaveOp_3", (String)"fi-ict-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    QFilter filter1 = new QFilter("id", "=", (Object)dyn.getLong("masterid"));
                    DynamicObject dynDs = QueryServiceHelper.queryOne((String)"ict_recontolerance", (String)"tolerancevalue", (QFilter[])filter1.toArray());
                    if (!Objects.nonNull(dynDs) || dyn.getBigDecimal("tolerancevalue").compareTo(dynDs.getBigDecimal("tolerancevalue")) <= 0) continue;
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u5bb9\u5dee\u503c\u4e0d\u80fd\u5927\u4e8e\u539f\u59cb\u5bb9\u5dee\u503c\u3002", (String)"ReconToleranceSaveOp_4", (String)"fi-ict-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        String[] numbers = DB.genStringIds((String)"ict_recontolerance", (int)dataEntities.length);
        String[] names = DB.genStringIds((String)"ict_recontolerance", (int)dataEntities.length);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dyn = dataEntities[i];
            if (dyn.getString("number").length() != 0) continue;
            dyn.set("number", (Object)numbers[i]);
            dyn.set("name", (Object)names[i]);
        }
    }
}

