/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.opplugin.syndata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ict.accsys.AccSysUtil;
import kd.fi.ict.business.handle.impl.DataHandleExecuter;
import kd.fi.ict.business.intertrans.syndata.FilterParam;
import kd.fi.ict.util.ICTUtils;

public class AutoPullVchEntryOp
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String intellexecschema = this.operateOption.getVariableValue("gl_intellexecschema");
        if (Objects.nonNull(intellexecschema)) {
            this.intellSchemeSynData(e);
        }
    }

    private void intellSchemeSynData(BeforeOperationArgs e) {
        FilterParam filterParam;
        String taskId = DBServiceHelper.genStringId();
        String operationKey = e.getOperationKey();
        if (Arrays.asList("pullacct", "pullcf").contains(operationKey) && Objects.nonNull(filterParam = this.getFilterValue(e.getDataEntities()))) {
            DataHandleExecuter executer = new DataHandleExecuter(taskId, filterParam, operationKey);
            executer.run();
        }
    }

    protected FilterParam getFilterValue(DynamicObject[] dataEntities) {
        FilterParam param = new FilterParam();
        HashSet<Long> orgIds = new HashSet<Long>(10);
        for (DynamicObject dataEntity : dataEntities) {
            orgIds.add(dataEntity.getLong("org.id"));
        }
        HasPermOrgResult permOrgResult = AccSysUtil.getAllPermOrgs((String)"ict_autopulldata", (String)"1Q7MJDFAAHQK");
        if (!permOrgResult.hasAllOrgPerm()) {
            orgIds.retainAll(permOrgResult.getHasPermOrgs());
            if (orgIds.isEmpty()) {
                return null;
            }
        }
        param.setOrgIdLst(new ArrayList(orgIds));
        QFilter qFilter = new QFilter("accounttype", "=", (Object)"1");
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id", (QFilter[])qFilter.toArray());
        ArrayList<Long> bookTypes = new ArrayList<Long>(0);
        bookTypes.add(dyn.getLong("id"));
        param.setBooktypeIdLst(bookTypes);
        String schemaIdStr = this.getOption().getVariableValue("gl_intellexecschema");
        QFilter filter = new QFilter("intelschemaid", "=", (Object)Long.valueOf(schemaIdStr));
        filter.and(new QFilter("execstatus", "=", (Object)"2"));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_intelschemasumlog", (String)"execenddate", (QFilter[])filter.toArray(), (String)"id desc");){
            if (Objects.nonNull(ds) && ds.hasNext()) {
                Row next = ds.next();
                param.setBeginBookDate(next.getDate("execenddate"));
                param.setEndBookDate(ICTUtils.getEndCurTime());
            } else {
                param.setBeginBookDate(ICTUtils.getBeforeCurTimeByDays((int)2));
                param.setEndBookDate(ICTUtils.getEndCurTime());
            }
        }
        param.setIntellSchema(Boolean.TRUE.booleanValue());
        return param;
    }
}

