/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.opplugin.syndata;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ict.accsys.AccSysUtil;
import kd.fi.ict.accsys.AccountBookInfo;
import kd.fi.ict.opplugin.AbstractRelRecordServicePlugin;
import kd.fi.ict.util.ICTUtils;

public class ConvertOperation
extends AbstractRelRecordServicePlugin {
    private static BigDecimal ownExchangeRate = new BigDecimal(0);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("concurrency");
        fieldKeys.add("convertamt");
        fieldKeys.add("convertamtbal");
        fieldKeys.add("isconvert");
        fieldKeys.add("amt");
        fieldKeys.add("amtbal");
        fieldKeys.add("lastupdatetime");
        fieldKeys.add("org");
        fieldKeys.add("oporg");
        fieldKeys.add("period");
        fieldKeys.add("status");
        fieldKeys.add("billno");
        fieldKeys.add("booktype");
        fieldKeys.add("bookeddate");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                Long exratetable = Long.valueOf(this.getOption().getVariableValue("exratetable"));
                Long concurrency = Long.valueOf(this.getOption().getVariableValue("concurrency"));
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    long oppBaseCurrencyId;
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    long orgid = dynamicObject.getLong("org.id");
                    String orgName = dynamicObject.getString("org.name");
                    long opporgid = dynamicObject.getLong("oporg.id");
                    String opporgName = dynamicObject.getString("oporg.name");
                    long booktypeid = dynamicObject.getLong("booktype.id");
                    AccountBookInfo ownAccSys = AccSysUtil.getBookFromAccSys((long)orgid, (long)booktypeid);
                    AccountBookInfo oppFromAccSys = AccSysUtil.getBookFromAccSys((long)opporgid, (long)booktypeid);
                    if (ownAccSys == null || oppFromAccSys == null) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6839\u636e\u7ec4\u7ec7\u53ca\u8d26\u7c3f\u7c7b\u578b\u83b7\u53d6\u8d26\u7c3f\u4e0d\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u6298\u7b97\u3002", (String)"ConvertOperation_3", (String)"fi-ict-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    long ownBaseCurrencyId = ownAccSys.getBaseCurrencyId();
                    if (ownBaseCurrencyId == (oppBaseCurrencyId = oppFromAccSys.getBaseCurrencyId())) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u672c\u65b9\u7ec4\u7ec7\u3010%1$s\u3011\u3001\u5bf9\u65b9\u7ec4\u7ec7\u3010%2$s\u3011\u7684\u672c\u4f4d\u5e01\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u6298\u7b97\u3002", (String)"ConvertOperation_0", (String)"fi-ict-opplugin", (Object[])new Object[0]), orgName, opporgName));
                        continue;
                    }
                    String status = dynamicObject.getString("status");
                    if (!status.equals("0")) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u672c\u65b9\u7ec4\u7ec7\u3010%1$s\u3011\u3001\u5bf9\u65b9\u7ec4\u7ec7\u3010%2$s\u3011\u4e0d\u662f\u672a\u52fe\u7a3d\uff0c\u4e0d\u5141\u8bb8\u6298\u7b97\u3002", (String)"ConvertOperation_1", (String)"fi-ict-opplugin", (Object[])new Object[0]), orgName, opporgName));
                        continue;
                    }
                    if (ownBaseCurrencyId == concurrency) {
                        ownExchangeRate = BigDecimal.ONE;
                        continue;
                    }
                    Date periodEnddate = dynamicObject.getDate("period.enddate");
                    ownExchangeRate = ICTUtils.getExchangeRate((Long)exratetable, (Long)ownBaseCurrencyId, (Long)concurrency, (Date)periodEnddate);
                    if (ownExchangeRate != null) continue;
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6c47\u7387\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u6298\u7b97\u3002", (String)"ConvertOperation_2", (String)"fi-ict-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        Long concurrency = Long.valueOf(this.getOption().getVariableValue("concurrency"));
        for (DynamicObject dyn : dataEntities = e.getDataEntities()) {
            dyn.set("concurrency", (Object)concurrency);
            dyn.set("isconvert", (Object)true);
            int currencyScale = ICTUtils.getCurrencyScale((Long)concurrency);
            BigDecimal amt = dyn.getBigDecimal("amt");
            BigDecimal amtBal = dyn.getBigDecimal("amtbal");
            BigDecimal convertAmt = ownExchangeRate.multiply(amt);
            BigDecimal convertAmtBal = ownExchangeRate.multiply(amtBal);
            dyn.set("convertamt", (Object)amt.multiply(convertAmt).divide(amt, currencyScale, 4));
            dyn.set("convertamtbal", (Object)amtBal.multiply(convertAmtBal).divide(amtBal, currencyScale, 4));
            dyn.set("lastupdatetime", (Object)TimeServiceHelper.getTimeStamp());
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }
}

