/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.opplugin.syndata;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.ict.constant.RelAcctRecordField;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.opplugin.AbstractRelRecordServicePlugin;
import kd.fi.ict.pullcheck.PuchLogFactory;

public class PullVchEntryDeleteOp
extends AbstractRelRecordServicePlugin {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("booktype");
        fieldKeys.add("period");
        fieldKeys.add("status");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity ext : dataEntities = this.getDataEntities()) {
                    DynamicObject dyn = ext.getDataEntity();
                    String status = dyn.getString("status");
                    if ("0".equals(status)) continue;
                    this.addMessage(ext, ResManager.loadKDString((String)"\u5df2\u52fe\u7a3d\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PullVchEntryDeleteOp_0", (String)"fi-ict-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<String> deleteKeySet = new HashSet<String>(16);
        for (DynamicObject dyn : dataEntities) {
            long orgId = dyn.getLong(RelAcctRecordField.id_((String)"org"));
            long bookTypeId = dyn.getLong(RelAcctRecordField.id_((String)"booktype"));
            long periodId = dyn.getLong(RelAcctRecordField.id_((String)"period"));
            String deleteKey = String.format("%s_%s_%s", orgId, bookTypeId, periodId);
            if (!deleteKeySet.add(deleteKey)) continue;
            QFilter fOrgId = new QFilter("org", "=", (Object)orgId);
            QFilter fBookTypeId = new QFilter("booktype", "=", (Object)bookTypeId);
            QFilter fPeriodId = new QFilter("period", "=", (Object)periodId);
            DeleteServiceHelper.delete((String)"ict_pulldatalog", (QFilter[])new QFilter[]{fOrgId, fBookTypeId, fPeriodId});
        }
        if (dataEntities.length > 0) {
            String formName = dataEntities[0].getDataEntityType().getName();
            PuchLogFactory.getPuchLog((String)formName).setDeductLog(dataEntities, OperationType.DELETE);
        }
    }
}

