/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.opplugin.syndata;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ict.constant.RelRecordField;
import kd.fi.ict.enums.CheckStatus;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.opplugin.AbstractRelRecordServicePlugin;
import kd.fi.ict.pullcheck.IPuchAmtLog;
import kd.fi.ict.pullcheck.PuchLogFactory;
import kd.fi.ict.util.PeriodUtil;

public class RelRecoedCanacelNextPeriodOp
extends AbstractRelRecordServicePlugin {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("lastupdatetime");
        fieldKeys.add("ori_period");
        fieldKeys.add("period");
        fieldKeys.add("isnextperiod");
        fieldKeys.add("status");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity data : dataEntities = this.getDataEntities()) {
                    DynamicObject dyn = data.getDataEntity();
                    if (dyn.getLong(RelRecordField.id((String)"period")) <= dyn.getLong(RelRecordField.id((String)"ori_period"))) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u5bf9\u8d26\u65e5\u671f\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u8bb0\u8d26\u65e5\u671f\u3002", (String)"RelRecoedCanacelNextPeriodOp_0", (String)"fi-ict-opplugin", (Object[])new Object[0]));
                    }
                    if (!CheckStatus.ALL_CHECK.getValue().equals(dyn.getString("status"))) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u5df2\u7ecf\u52fe\u7a3d\u7684\u6570\u636e\u4e0d\u80fd\u53d6\u6d88\u8f6c\u5165\u4e0b\u671f\u3002", (String)"RelRecoedCanacelNextPeriodOp_1", (String)"fi-ict-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dyn : dataEntities = e.getDataEntities()) {
            dyn.set("billstatus", (Object)"A");
            long prePeriodId = PeriodUtil.getPreviousPeriod((Object)dyn.getLong(RelRecordField.id((String)"period"))).getLong("id");
            dyn.set("period", (Object)prePeriodId);
            dyn.set("lastupdatetime", (Object)TimeServiceHelper.getTimeStamp());
            if (dyn.getLong(RelRecordField.id((String)"ori_period")) != prePeriodId) continue;
            dyn.set("isnextperiod", (Object)Boolean.FALSE);
        }
        if (dataEntities.length > 0) {
            SaveServiceHelper.update((DynamicObject[])dataEntities);
            IPuchAmtLog checkBalLog = PuchLogFactory.getPuchLog((String)dataEntities[0].getDynamicObjectType().getName());
            checkBalLog.setAddLog(dataEntities, OperationType.CANNEXTPERIOD);
        }
    }
}

