/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.opplugin.syndata;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ict.constant.RelRecordField;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.opplugin.AbstractRelRecordServicePlugin;
import kd.fi.ict.pullcheck.IPuchAmtLog;
import kd.fi.ict.pullcheck.PuchLogFactory;
import kd.fi.ict.util.PeriodUtil;

public class RelRecordConfirmNextPeriodOp
extends AbstractRelRecordServicePlugin {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("lastupdatetime");
        fieldKeys.add("isnextperiod");
        fieldKeys.add("period");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity data : dataEntities = this.getDataEntities()) {
                    DynamicObject dyn = data.getDataEntity();
                    if (dyn.getString("billstatus").equals("B")) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u8fd8\u6ca1\u63d0\u4ea4\u8f6c\u4e0b\u671f\uff0c\u4e0d\u80fd\u8fdb\u884c\u5ba1\u6838\u8f6c\u4e0b\u671f\u64cd\u4f5c\u3002", (String)"RelRecordConfirmNextPeriodOp_0", (String)"fi-ict-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dyn : dataEntities = e.getDataEntities()) {
            dyn.set("billstatus", (Object)"A");
            dyn.set("isnextperiod", (Object)Boolean.TRUE);
            long nextPeriodId = PeriodUtil.getNextPeriod((Object)dyn.getLong(RelRecordField.id((String)"period"))).getLong("id");
            dyn.set("period", (Object)nextPeriodId);
            dyn.set("lastupdatetime", (Object)TimeServiceHelper.getTimeStamp());
        }
        if (dataEntities.length > 0) {
            SaveServiceHelper.update((DynamicObject[])dataEntities);
            IPuchAmtLog checkBalLog = PuchLogFactory.getPuchLog((String)dataEntities[0].getDynamicObjectType().getName());
            checkBalLog.setAddLog(dataEntities, OperationType.CFRNEXTPERIOD);
        }
    }
}

