/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.opplugin.verfischeme;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.ict.constant.VerifySchemeField;
import kd.fi.ict.enums.TransactionType;
import kd.fi.ict.opplugin.verfischeme.VerfySchemeDeleteValidator;

public class VerfySchemeDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("entryentity");
        fieldKeys.add("transactiontype");
        fieldKeys.add("account.id");
        fieldKeys.add("cashflowitem");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new VerfySchemeDeleteValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.endOperationTransaction(e);
        for (DynamicObject dyn : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection entryEntiry = dyn.getDynamicObjectCollection("entryentity");
            QFilter forg = new QFilter("org", "=", (Object)dyn.getLong(VerifySchemeField.id((String)"org")));
            QFilter fstatus = new QFilter("status", "!=", (Object)"0");
            try (TXHandle handler = TX.requiresNew();){
                try {
                    if (TransactionType.CASH_FLOW.getTransactionType().equals(dyn.getString("transactiontype"))) {
                        List acctCfIdlst = entryEntiry.stream().mapToLong(value -> value.getLong(VerifySchemeField.id((String)"cashflowitem"))).boxed().collect(Collectors.toList());
                        QFilter fcf = new QFilter("cashflowitem", "in", acctCfIdlst);
                        DeleteServiceHelper.delete((String)"ict_relcfrecord", (QFilter[])new QFilter[]{forg, fcf, fstatus});
                        fcf = new QFilter("itemclassify", "in", acctCfIdlst);
                        DeleteServiceHelper.delete((String)"ict_pulldatalog", (QFilter[])new QFilter[]{forg, fcf});
                        continue;
                    }
                    List acctOrgIdlst = entryEntiry.stream().mapToLong(value -> value.getLong("account.id")).boxed().collect(Collectors.toList());
                    QFilter facct = new QFilter("account", "in", acctOrgIdlst);
                    DeleteServiceHelper.delete((String)"ict_relacctrecord", (QFilter[])new QFilter[]{forg, facct, fstatus});
                    facct = new QFilter("itemclassify", "in", acctOrgIdlst);
                    DeleteServiceHelper.delete((String)"ict_pulldatalog", (QFilter[])new QFilter[]{forg, facct});
                }
                catch (Exception ex) {
                    handler.markRollback();
                    throw ex;
                }
            }
        }
    }
}

