/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.opplugin.verfischeme;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.ict.constant.VerifySchemeField;
import kd.fi.ict.enums.TransactionType;
import kd.fi.ict.enums.VerifyType;

public class VerfySchemeDeleteValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] extEntities;
        for (ExtendedDataEntity entity : extEntities = this.getDataEntities()) {
            DynamicObject dataEntity = entity.getDataEntity();
            Set<String> checkData = TransactionType.CASH_FLOW.getTransactionType().equals(dataEntity.getString("transactiontype")) ? this.getCheckData(dataEntity, VerifyType.CF) : this.getCheckData(dataEntity, VerifyType.ACCT);
            if (checkData.isEmpty()) continue;
            String itemsStr = String.join((CharSequence)",", checkData);
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5206\u5f55\u9879\u76ee[%s]\u5df2\u5b58\u5728\u52fe\u7a3d\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"VerfySchemeDeleteValidator_0", (String)"fi-ict-opplugin", (Object[])new Object[]{itemsStr}));
        }
    }

    private Set<String> getCheckData(DynamicObject dataEntity, VerifyType type) {
        Row next2;
        Throwable throwable;
        DataSet dataSet;
        HashSet<String> itemName = new HashSet<String>(10);
        DynamicObject orgDyn = dataEntity.getDynamicObject("org");
        DynamicObjectCollection entryEntiry = dataEntity.getDynamicObjectCollection("entryentity");
        QFilter forg = new QFilter("org", "=", orgDyn.getPkValue());
        QFilter fstatus = new QFilter("status", "!=", (Object)"0");
        if (VerifyType.ACCT == type) {
            List acctOrgIdlst = entryEntiry.stream().mapToLong(value -> value.getLong("account.id")).boxed().collect(Collectors.toList());
            QFilter facct = new QFilter("account", "in", acctOrgIdlst);
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ict_relacctrecord", (String)"account.name accountname", (QFilter[])new QFilter[]{forg, facct, fstatus}, null);
            throwable = null;
            try {
                String accountname;
                if (dataSet.hasNext() && StringUtils.isNotEmpty((String)(accountname = (next2 = dataSet.next()).getString("accountname")))) {
                    itemName.add(accountname);
                }
            }
            catch (Throwable next2) {
                throwable = next2;
                throw next2;
            }
            finally {
                if (dataSet != null) {
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable next2) {
                            throwable.addSuppressed(next2);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        if (VerifyType.CF == type) {
            List acctCfIdlst = entryEntiry.stream().mapToLong(value -> value.getLong(VerifySchemeField.id((String)"cashflowitem"))).boxed().collect(Collectors.toList());
            QFilter fcf = new QFilter("cashflowitem", "in", acctCfIdlst);
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ict_relcfrecord", (String)"cashflowitem.name cashflowitemname", (QFilter[])new QFilter[]{forg, fcf, fstatus}, null);
            throwable = null;
            try {
                String cashflowitemname;
                if (dataSet.hasNext() && StringUtils.isNotEmpty((String)(cashflowitemname = (next2 = dataSet.next()).getString("cashflowitemname")))) {
                    itemName.add(cashflowitemname);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet != null) {
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        return itemName;
    }
}

