/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.opplugin.verfischeme;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ict.constant.VerifySchemeField;
import kd.fi.ict.enums.TransactionType;
import kd.fi.ict.enums.VerifyType;
import kd.fi.ict.util.AccountServiceHelper;
import kd.fi.ict.util.VerifySchemaUtils;

public class VerifySchemeSaveOp
extends AbstractOperationServicePlugIn {
    private Log LOGGER = LogFactory.getLog((String)VerifySchemeSaveOp.class.getName());

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("transactiontype");
        fieldKeys.add("e_accounttable");
        fieldKeys.add("account");
        fieldKeys.add("accountnumber".concat(".longnumber"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] datas;
                for (ExtendedDataEntity data : datas = this.getDataEntities()) {
                    VerifyType verifyType;
                    Map.Entry<Object, Long> entry2;
                    DynamicObject dyn = data.getDataEntity();
                    DynamicObjectCollection entryEntiry = dyn.getDynamicObjectCollection("entryentity");
                    if (entryEntiry.size() == 0) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u5206\u5f55\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VerifySchemaSaveOp_3", (String)"fi-ict-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        return;
                    }
                    dyn.set("accounttable", (Object)((DynamicObject)entryEntiry.get(0)).getDynamicObject("e_accounttable"));
                    boolean isCashFlow = dyn.getString("transactiontype").equals(TransactionType.CASH_FLOW.getTransactionType());
                    String item = isCashFlow ? "cashflowitem" : "account";
                    Map<Object, Long> collect = entryEntiry.stream().collect(Collectors.groupingBy(v -> v.getLong(VerifySchemeField.id((String)item)), Collectors.counting()));
                    for (Map.Entry<Object, Long> entry2 : collect.entrySet()) {
                        if (entry2.getValue() <= 1L) continue;
                        if (item.equals("account")) {
                            this.addMessage(data, ResManager.loadKDString((String)"\u5206\u5f55\u5b58\u5728\u91cd\u590d\u7684\u79d1\u76ee\u3002", (String)"VerifySchemaSaveOp_0", (String)"fi-ict-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        }
                        if (item.equals("cashflowitem")) {
                            this.addMessage(data, ResManager.loadKDString((String)"\u5206\u5f55\u5b58\u5728\u91cd\u590d\u7684\u73b0\u91d1\u6d41\u91cf\u3002", (String)"VerifySchemaSaveOp_1", (String)"fi-ict-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        }
                        return;
                    }
                    if (this.repeatNumber(data, entryEntiry, item)) {
                        return;
                    }
                    HashSet<String> commonassgrpSet = new HashSet<String>(0);
                    entry2 = entryEntiry.iterator();
                    while (entry2.hasNext()) {
                        DynamicObject edyn = (DynamicObject)entry2.next();
                        String commonassgrpStr = "";
                        DynamicObjectCollection dynColl = edyn.getDynamicObjectCollection("commonassgrp");
                        if (dynColl.size() == 0) {
                            commonassgrpSet.add("");
                            continue;
                        }
                        ArrayList<String> lst = new ArrayList<String>(dynColl.size());
                        for (DynamicObject adyn : dynColl) {
                            String number = "";
                            number = "1".equals(adyn.get("fbasedataid.valuetype")) ? adyn.getString("fbasedataid.valuesource.number") : adyn.getString("fbasedataid.number");
                            if (!Objects.nonNull(number)) continue;
                            lst.add(number);
                        }
                        if (lst.size() > 0) {
                            Collections.sort(lst, Collator.getInstance(Locale.CHINA));
                            commonassgrpStr = String.join((CharSequence)",", lst);
                        }
                        commonassgrpSet.add(commonassgrpStr);
                    }
                    if (commonassgrpSet.size() != 1) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u5171\u540c\u6838\u7b97\u7ef4\u5ea6\u503c\u6765\u6e90\u5fc5\u987b\u76f8\u540c\u3002", (String)"VerifySchemaSaveOp_5", (String)"fi-ict-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                    VerifyType verifyType2 = verifyType = isCashFlow ? VerifyType.CF : VerifyType.ACCT;
                    if (!this.checkSupOrSubLevel(data, verifyType, item)) continue;
                    return;
                }
            }

            private boolean checkSupOrSubLevel(ExtendedDataEntity data, VerifyType verifyType, String item) {
                DynamicObject curVsDynObject = data.getDataEntity();
                long orgId = curVsDynObject.getLong(VerifySchemeField.id((String)"org"));
                DynamicObject[] dbVsDynObjects = VerifySchemaUtils.getVerifySchemaByOrg((Long)orgId, (VerifyType)verifyType);
                HashMap<Long, Set> acctTableToLongNumbers = new HashMap<Long, Set>(dbVsDynObjects.length);
                HashMap<Long, Set> acctTableToNumbers = new HashMap<Long, Set>(dbVsDynObjects.length);
                String delimiter = verifyType == VerifyType.ACCT ? "_" : "@";
                for (DynamicObject dbVsDyn : dbVsDynObjects) {
                    if (curVsDynObject.getLong("id") == dbVsDyn.getLong("id")) continue;
                    DynamicObjectCollection dynColl = dbVsDyn.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : dynColl) {
                        String[] split;
                        long acctTableId2 = 0L;
                        if (verifyType == VerifyType.ACCT) {
                            acctTableId2 = entry.getLong(VerifySchemeField.id((String)"e_accounttable"));
                        }
                        String number = entry.getString(VerifySchemeField.join((String[])new String[]{item, "number"}));
                        acctTableToNumbers.computeIfAbsent(acctTableId2, x -> new HashSet(8)).add(number);
                        String longNumber = entry.getString(VerifySchemeField.join((String[])new String[]{item, "longnumber"}));
                        acctTableToLongNumbers.computeIfAbsent(acctTableId2, x -> new HashSet(8)).add(longNumber);
                        for (String parentNumber : split = longNumber.split(delimiter)) {
                            acctTableToNumbers.computeIfAbsent(acctTableId2, x -> new HashSet(8)).add(parentNumber);
                        }
                    }
                }
                acctTableToLongNumbers.forEach((acctTableId, longNUmbers) -> {
                    Set allChildNumbers = verifyType == VerifyType.ACCT ? AccountServiceHelper.getAcctAllChildNumbersByLongNumbers((long)orgId, (long)acctTableId, (Set)longNUmbers) : AccountServiceHelper.getCfAllChildNumbersByLongNumbers((long)orgId, (Set)longNUmbers);
                    acctTableToNumbers.computeIfAbsent((Long)acctTableId, x -> new HashSet(8)).addAll(allChildNumbers);
                });
                StringBuilder itemName = new StringBuilder();
                DynamicObjectCollection entryEntiry = curVsDynObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynEntry : entryEntiry) {
                    long acctTableId3 = dynEntry.getLong(VerifySchemeField.id((String)"e_accounttable"));
                    Set numbers = (Set)acctTableToNumbers.get(acctTableId3);
                    if (!Objects.nonNull(numbers) || !numbers.contains(dynEntry.getString(VerifySchemeField.join((String[])new String[]{item, "number"})))) continue;
                    itemName.append(dynEntry.getDynamicObject(item).getString("name")).append(',');
                }
                if (itemName.length() > 0) {
                    itemName.deleteCharAt(itemName.length() - 1);
                    this.addMessage(data, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u540c\u7ec4\u7ec7\u4e0b\u7684[%s]\u3002", (String)"VerifySchemaSaveOp_2", (String)"fi-ict-opplugin", (Object[])new Object[]{itemName}), ErrorLevel.Error);
                    return true;
                }
                return false;
            }

            private boolean repeatNumber(ExtendedDataEntity data, DynamicObjectCollection entryEntiry, String item) {
                String separatortem = Objects.equals(item, "cashflowitem") ? "@" : "_";
                HashMap<Long, Map> fullNumber = new HashMap<Long, Map>(entryEntiry.size());
                for (DynamicObject entiryDyn : entryEntiry) {
                    long acctTableID = entiryDyn.getLong(VerifySchemeField.id((String)"e_accounttable"));
                    String longnumber = entiryDyn.getString(item.concat(".longnumber"));
                    if (!Objects.nonNull(longnumber)) continue;
                    String[] split = longnumber.split(separatortem);
                    String number = split[split.length - 1];
                    for (String s : split) {
                        Map acctMap = (Map)fullNumber.get(acctTableID);
                        if (Objects.nonNull(acctMap) && (acctMap.get(s) == Boolean.TRUE || acctMap.containsKey(number))) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7f16\u7801[%1$s]\u7684\u4e0a\u4e0b\u7ea7\u3002", (String)"VerifySchemaSaveOp_4", (String)"fi-ict-opplugin", (Object[])new Object[0]), number), ErrorLevel.Error);
                            return true;
                        }
                        if (s.equals(number)) {
                            fullNumber.computeIfAbsent(acctTableID, x -> new HashMap()).put(s, Boolean.TRUE);
                            continue;
                        }
                        fullNumber.computeIfAbsent(acctTableID, x -> new HashMap()).put(s, Boolean.FALSE);
                    }
                }
                return false;
            }
        });
    }
}

