/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bd.service.balance.AppHelper;
import kd.fi.ict.exception.BOSException;
import kd.fi.ict.mservice.AcctAmtQueryParam;
import kd.fi.ict.mservice.util.AcctAndAssistHelper;
import kd.fi.ict.mservice.util.ICTServiceUtils;
import kd.fi.ict.puchamt.AcctPuchAmtQueryExecutor;
import kd.fi.ict.service.AcctAmtService;

public class AcctAmtServiceImpl
implements AcctAmtService {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    public HashSet<String> balanceFields = new HashSet<String>(){
        {
            this.add("org");
            this.add("oporg");
            this.add("booktype");
            this.add("period");
            this.add("endperiod");
            this.add("accounttable");
            this.add("account");
            this.add("assgrp");
            this.add("currency");
            this.add("pbeginfor");
            this.add("pbeginlocal");
            this.add("pdebitfor");
            this.add("pdebitlocal");
            this.add("pcreditfor");
            this.add("pcreditlocal");
            this.add("pyeardebitfor");
            this.add("pyeardebitlocal");
            this.add("pyearcreditfor");
            this.add("pyearcreditlocal");
            this.add("pendfor");
            this.add("pendlocal");
            this.add("cbeginfor");
            this.add("cbeginlocal");
            this.add("cdebitfor");
            this.add("cdebitlocal");
            this.add("ccreditfor");
            this.add("ccreditlocal");
            this.add("cyeardebitfor");
            this.add("cyeardebitlocal");
            this.add("cyearcreditfor");
            this.add("cyearcreditlocal");
            this.add("cendfor");
            this.add("cendlocal");
            this.add("curcdebitfor");
            this.add("curcdebitlocal");
            this.add("curccreditfor");
            this.add("curccreditlocal");
            this.add("curndebitfor");
            this.add("curndebitlocal");
            this.add("curncreditfor");
            this.add("curncreditlocal");
        }
    };
    public HashSet<String> dcFields = new HashSet<String>(){
        {
            this.add("pbeginfor");
            this.add("pbeginlocal");
            this.add("pendfor");
            this.add("pendlocal");
            this.add("cbeginfor");
            this.add("cbeginlocal");
            this.add("cendfor");
            this.add("cendlocal");
        }
    };
    public HashSet<String> amtFields = new HashSet<String>(){
        {
            this.add("pbeginfor");
            this.add("pbeginlocal");
            this.add("pdebitfor");
            this.add("pdebitlocal");
            this.add("pcreditfor");
            this.add("pcreditlocal");
            this.add("pyeardebitfor");
            this.add("pyeardebitlocal");
            this.add("pyearcreditfor");
            this.add("pyearcreditlocal");
            this.add("pendfor");
            this.add("pendlocal");
            this.add("cbeginfor");
            this.add("cbeginlocal");
            this.add("cdebitfor");
            this.add("cdebitlocal");
            this.add("ccreditfor");
            this.add("ccreditlocal");
            this.add("cyeardebitfor");
            this.add("cyeardebitlocal");
            this.add("cyearcreditfor");
            this.add("cyearcreditlocal");
            this.add("cendfor");
            this.add("cendlocal");
            this.add("curcdebitfor");
            this.add("curcdebitlocal");
            this.add("curccreditfor");
            this.add("curccreditlocal");
            this.add("curndebitfor");
            this.add("curndebitlocal");
            this.add("curncreditfor");
            this.add("curncreditlocal");
        }
    };

    public String getAcctAmt(String param) {
        try {
            this.log.info("\u4f59\u989d\u8868\u53d6\u6570\u63a5\u6536\u53c2\u6570\uff1a" + param);
            if (param == null || StringUtils.isBlank((CharSequence)param)) {
                return null;
            }
            AcctAmtQueryParam queryParam = (AcctAmtQueryParam)JSONUtils.cast((String)param, AcctAmtQueryParam.class);
            List<Map<String, Object>> data = this.getAcctAmtData(queryParam);
            this.log.info("\u4f59\u989d\u8868\u53d6\u6570\u8fd4\u56de\u6570\u636e\uff1a" + data);
            return JSONUtils.toString(data);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public List<Map<String, Object>> getAcctAmtData(AcctAmtQueryParam param) {
        HashMap<String, Object> deriveMap = new HashMap<String, Object>();
        deriveMap.put("aliasDc", "dc");
        deriveMap.put("aliasAssgrp", "ass_id");
        deriveMap.put("aliasAcct", "acct_id");
        deriveMap.put("flagDc", false);
        deriveMap.put("flagAss", false);
        deriveMap.put("flagAcct", false);
        if (param.getSelector() == null || param.getSelector().isEmpty()) {
            return null;
        }
        long accounttableId = param.getAccountTableId() == 0L ? this.getAccountTableId(param.getOrgId(), param.getBookTypeId()) : param.getAccountTableId();
        if (accounttableId == 0L) {
            return null;
        }
        param.setAccountTableId(accounttableId);
        Map<Long, List<Map<String, Long>>> accountAssgrp = param.getAccountAssgrp();
        HashMap<String, String> selFiledMap = new HashMap<String, String>();
        HashMap<String, String> selAssMap = new HashMap<String, String>();
        HashSet selAmtAlias = Sets.newHashSetWithExpectedSize((int)10);
        String sels = this.getSelector(param.getSelector(), param.getGroupBy(), selFiledMap, selAssMap, deriveMap, selAmtAlias);
        try (DataSet ds = null;){
            if (!accountAssgrp.isEmpty()) {
                AcctAndAssistHelper acctAssistHelper = new AcctAndAssistHelper();
                ds = acctAssistHelper.getAssFilterAndAssDs(sels, param, accountAssgrp, deriveMap);
            } else {
                ds = AcctPuchAmtQueryExecutor.getInstance().getPuchAmt(param.toQueryParam(sels));
            }
            ds = this.dealAssgrpAlias(ds, selAssMap);
            HashSet<String> balGroupFields = new HashSet<String>();
            HashSet<String> assGroupFields = new HashSet<String>();
            this.splitGroupFields(param.getGroupBy(), balGroupFields, assGroupFields);
            Set<String> selAlias = this.getMapValue(selFiledMap);
            Set<String> assAlias = this.getMapValue(selAssMap);
            this.log.info("\u4f59\u989d\u8868\u53d6\u6570sum\u524d\u53c2\u6570\uff1a" + balGroupFields + ";" + assGroupFields + ";" + assAlias + ";" + deriveMap);
            ds = this.sum(ds, balGroupFields, assGroupFields, selFiledMap, assAlias, deriveMap);
            if (!((Boolean)deriveMap.get("flagDc")).booleanValue()) {
                selAlias.remove(deriveMap.get("aliasDc"));
            }
            if (!((Boolean)deriveMap.get("flagAss")).booleanValue()) {
                selAlias.remove(deriveMap.get("aliasAssgrp"));
            }
            if (!((Boolean)deriveMap.get("flagAcct")).booleanValue()) {
                selAlias.remove(deriveMap.get("aliasAcct"));
            }
            selAlias.addAll(assAlias);
            List<Map<String, Object>> rs = this.trans2List(selAlias, deriveMap, ds, selAmtAlias, param.isReturnZeroResult());
            this.log.info("\u4f59\u989d\u8868\u53d6\u6570\u8fd4\u56de\u7ed3\u679c\uff1a" + rs);
            List<Map<String, Object>> list = rs;
            return list;
        }
    }

    private DataSet dealAssgrpAlias(DataSet dataSet, Map<String, String> assAliasMap) {
        List<String> allFields = ICTServiceUtils.getFieldsByDs(dataSet);
        for (Map.Entry<String, String> assAliasMapEntry : assAliasMap.entrySet()) {
            String assField = assAliasMapEntry.getKey();
            if (!allFields.contains(assField)) continue;
            allFields.remove(assField);
            allFields.add(assField + " " + assAliasMapEntry.getValue());
        }
        dataSet = dataSet.select(allFields.toArray(new String[0]));
        return dataSet;
    }

    public Long[] toLongArray(long[] values) {
        Long[] value = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            value[i] = values[i];
        }
        return value;
    }

    private Set<String> getMapValue(Map<String, String> selMap) {
        HashSet<String> aliasList = new HashSet<String>();
        aliasList.addAll(selMap.values());
        return aliasList;
    }

    private long getAccountTableId(long orgId, long bookTypeId) {
        QFilter orgFilter = new QFilter("org.id", "=", (Object)orgId);
        QFilter bookFilter = new QFilter("bookstype.id", "=", (Object)bookTypeId);
        long accounttableId = 0L;
        try (DataSet set = QueryServiceHelper.queryDataSet((String)"BalanceService", (String)"gl_accountbook", (String)"accounttable.id accounttableId", (QFilter[])new QFilter[]{orgFilter, bookFilter}, null);){
            Iterator it = set.iterator();
            if (it.hasNext()) {
                Row row = (Row)it.next();
                accounttableId = row.getLong("accounttableId");
            }
        }
        return accounttableId;
    }

    private List<Map<String, Object>> trans2List(Set<String> selector, Map<String, Object> deriveMap, DataSet ds, Set<String> selAmtAlias, boolean isZeroResult) {
        ArrayList<Map<String, Object>> rs = new ArrayList<Map<String, Object>>();
        int selSize = selector.size();
        Iterator rowIt = ds.iterator();
        String balanceLimit = AppHelper.getSystemProperty((String)"fi.ict.service.balance.limit", (String)"100000");
        int limit = Integer.parseInt(balanceLimit);
        boolean isZero = true;
        while (rowIt.hasNext()) {
            Row row = (Row)rowIt.next();
            HashMap<String, Object> rowData = new HashMap<String, Object>(selSize);
            for (String sel : selector) {
                Object value = row.get(sel);
                rowData.put(sel, value);
                if (!isZero || !selAmtAlias.contains(sel) || BigDecimal.ZERO.compareTo((BigDecimal)value) == 0) continue;
                isZero = false;
            }
            if (!isZero || isZeroResult) {
                rs.add(rowData);
            }
            if (rs.size() != limit) continue;
            return rs;
        }
        return rs;
    }

    private DataSet sum(DataSet ds, Set<String> balGroupFields, Set<String> assGroupFields, Map<String, String> selFiledMap, Set<String> assFields, Map<String, Object> deriveMap) {
        Set<String> fieldSet;
        LinkedList<String> allFields = new LinkedList<String>();
        HashSet<String> compareFields = new HashSet<String>(8);
        ArrayList<String> amountFields = new ArrayList<String>(8);
        for (Map.Entry<String, String> entry : selFiledMap.entrySet()) {
            String name = entry.getKey();
            String alias = entry.getValue();
            if (name.endsWith("for") || name.endsWith("local")) {
                allFields.add(this.replaceFieldByDc(alias, deriveMap));
                amountFields.add(alias);
                compareFields.add(alias);
                continue;
            }
            allFields.add(alias);
            compareFields.add(alias);
        }
        allFields.addAll(assFields);
        compareFields.addAll(assFields);
        if (!((Boolean)deriveMap.get("flagDc")).booleanValue()) {
            allFields.remove(deriveMap.get("aliasDc"));
            compareFields.remove(deriveMap.get("aliasDc"));
        }
        if (!((Boolean)deriveMap.get("flagAss")).booleanValue()) {
            allFields.remove(deriveMap.get("aliasAssgrp"));
            compareFields.remove(deriveMap.get("aliasAssgrp"));
        }
        if (!((Boolean)deriveMap.get("flagAcct")).booleanValue()) {
            allFields.remove(deriveMap.get("aliasAcct"));
            compareFields.remove(deriveMap.get("aliasAcct"));
        }
        if (!(fieldSet = this.dataSetFields(ds)).containsAll(compareFields)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fc7\u6ee4\u5b57\u6bb5\u8ddf\u67e5\u8be2\u5b57\u6bb5\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u8fc7\u6ee4\u5b57\u6bb5\uff1a%1$s\uff1b\u548c\u67e5\u8be2\u5b57\u6bb5%2$s\u3002", (String)"AcctAmtQueryParamApi_8", (String)"fi-ict-webapi", (Object[])new Object[0]), fieldSet, compareFields));
        }
        ds = ds.select(allFields.toArray(new String[0]));
        if (assGroupFields != null) {
            balGroupFields.addAll(assGroupFields);
        }
        if (balGroupFields != null && !balGroupFields.isEmpty()) {
            GroupbyDataSet gpRs = ds.groupBy(balGroupFields.toArray(new String[0]));
            for (String str : amountFields) {
                gpRs.sum(str);
            }
            ds = gpRs.finish();
        }
        return ds;
    }

    private Set<String> dataSetFields(DataSet ds) {
        Field[] fields;
        HashSet<String> fieldList = new HashSet<String>(8);
        for (Field field : fields = ds.getRowMeta().getFields()) {
            String alias = field.getAlias();
            fieldList.add(alias);
        }
        return fieldList;
    }

    private String replaceFieldByDc(String amountField, Map<String, Object> deriveMap) {
        if (this.dcFields.contains(amountField)) {
            String exp = "case when " + deriveMap.get("aliasDc") + "='1' then " + amountField + " else -1*" + amountField + " end as " + amountField;
            return exp;
        }
        return amountField;
    }

    public String[] splitStr(String str, String name, String alias) {
        String[] strs = str.trim().split("\\s+");
        alias = strs.length == 2 ? strs[1].trim() : strs[0].trim();
        name = strs[0].trim();
        return new String[]{name, alias};
    }

    private String getSelector(List<String> selector, List<String> groupBy, Map<String, String> selAliasMap, Map<String, String> selAssFields, Map<String, Object> deriveMap, Set<String> selAmtAlias) {
        StringBuilder sels = new StringBuilder();
        HashSet<String> fs = new HashSet<String>();
        if (groupBy != null && !groupBy.isEmpty()) {
            fs.addAll(groupBy);
        }
        fs.addAll(selector);
        boolean flagSplit = false;
        for (String f : fs) {
            String fieldName;
            String name = "";
            String alias = "";
            String[] nameAndAlias = this.splitStr(f, name, alias);
            name = nameAndAlias[0];
            alias = nameAndAlias[1];
            String[] nameArray = name.split("\\.");
            String string = fieldName = nameArray.length == 0 ? name : name.split("\\.")[0];
            if (this.balanceFields.contains(fieldName)) {
                if ("account.dc".equalsIgnoreCase(name)) {
                    deriveMap.put("aliasDc", alias);
                    deriveMap.put("flagDc", true);
                } else if ("assgrp.id".equalsIgnoreCase(name) || "assgrp".equalsIgnoreCase(name)) {
                    deriveMap.put("aliasAssgrp", alias);
                    deriveMap.put("flagAss", true);
                } else if ("account.id".equalsIgnoreCase(name) || "account".equalsIgnoreCase(name)) {
                    deriveMap.put("aliasAcct", alias);
                    deriveMap.put("flagAcct", true);
                } else if (this.dcFields.contains(name)) {
                    deriveMap.put(name + "_bal", alias);
                }
                if (flagSplit) {
                    sels.append(",").append(f);
                } else {
                    sels.append(f);
                    flagSplit = true;
                }
                selAliasMap.put(name, alias);
                if (!this.amtFields.contains(fieldName)) continue;
                selAmtAlias.add(alias);
                continue;
            }
            selAssFields.put(name, alias);
        }
        if (fs.size() > 0) {
            if (!((Boolean)deriveMap.get("flagDc")).booleanValue()) {
                sels.append(",account.dc ").append(deriveMap.get("aliasDc"));
                selAliasMap.put("account.dc", (String)deriveMap.get("aliasDc"));
            }
            if (!((Boolean)deriveMap.get("flagAss")).booleanValue()) {
                sels.append(",assgrp.id ").append(deriveMap.get("aliasAssgrp"));
                selAliasMap.put("assgrp.id", (String)deriveMap.get("aliasAssgrp"));
            }
            if (!((Boolean)deriveMap.get("flagAcct")).booleanValue()) {
                sels.append(",account.id ").append(deriveMap.get("aliasAcct"));
                selAliasMap.put("aliasAcct.id", (String)deriveMap.get("aliasAcct"));
            }
        }
        return sels.toString();
    }

    private void splitGroupFields(List<String> groupFields, Set<String> bals, Set<String> ass) {
        for (String fields : groupFields) {
            String fieldName;
            String name = "";
            String alias = "";
            String[] nameAndAlias = this.splitStr(fields, name, alias);
            name = nameAndAlias[0];
            alias = nameAndAlias[1];
            String[] nameArray = name.split("\\.");
            String string = fieldName = nameArray.length == 0 ? name : name.split("\\.")[0];
            if (this.balanceFields.contains(fieldName)) {
                bals.add(alias);
                continue;
            }
            ass.add(alias);
        }
    }
}

