/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.ict.exception.BOSException;
import kd.fi.ict.mservice.CfAmtQueryParam;
import kd.fi.ict.mservice.util.ICTServiceUtils;
import kd.fi.ict.puchamt.CfPuchAmtQueryExecutor;
import kd.fi.ict.puchamt.cf.CfPuchAmtQueryParam;
import kd.fi.ict.service.CfAmtService;

public class CfAmtServiceImpl
implements CfAmtService {
    private static final Log LOG = LogFactory.getLog(CfAmtServiceImpl.class);
    private static final String CFITEM = "cfitem";
    private static final String CURRENCY = "currency";
    public static final String[] AMOUNTFIELDS = new String[]{"pamount", "camount", "nocheckamount", "curamount", "curnamount"};
    public static final String[] YEARAMOUNTFIELDS = new String[]{"pyearamount", "cyearamount"};
    private CfAmtQueryParam queryParam;

    public String getCashFlowAmount(String param) {
        try {
            LOG.info("\u5185\u90e8\u4ea4\u6613\u73b0\u91d1\u6d41\u91cf\u63a5\u53e3\u53c2\u6570\uff1a" + param);
            this.queryParam = (CfAmtQueryParam)JSONUtils.cast((String)param, CfAmtQueryParam.class);
            List<Map<String, Object>> data = this.getCashFlowAmountData(this.queryParam);
            LOG.info("\u5185\u90e8\u4ea4\u6613\u73b0\u91d1\u6d41\u91cf\u63a5\u53e3\u7ed3\u679c\uff1a" + data);
            return JSONUtils.toString(data);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public List<Map<String, Object>> getCashFlowAmount(long orgId, long bookTypeId, long periodId, long[] cfitemIds, long[] opOrgIds) {
        return this.getCashFlow(orgId, bookTypeId, periodId, cfitemIds, opOrgIds, this.queryParam.getAssgrp());
    }

    public List<Map<String, Object>> getCashFlowAmountData(CfAmtQueryParam param) {
        this.queryParam = param;
        LOG.info("\u6267\u884c\u672c\u671f\u73b0\u91d1\u6d41\u91cf\u63a5\u53e3");
        return this.getCashFlowAmount(param.getOrgId(), param.getBookTypeId(), param.getPeriodId(), param.getCfitemIds(), param.getOpOrgIds());
    }

    private List<Map<String, Object>> getCashFlow(long orgId, long bookTypeId, long periodId, long[] cfitemIds, long[] opOrgIds, Map<String, Object> assgrpMap) {
        LOG.info("\u5185\u90e8\u4ea4\u6613\u73b0\u91d1\u6d41\u91cf\u63a5\u53e3\u53c2\u6570\uff1aorgid:" + orgId + "bookTypeId:" + bookTypeId + "periodId:" + periodId + "cfitemIds:" + cfitemIds + "assgrpMap:" + assgrpMap + "opOrgIds:" + opOrgIds);
        HashSet<String> selectors = new HashSet<String>(16);
        HashSet<String> groupByFieldSet = new HashSet<String>(8);
        HashSet<String> amountFieldSet = new HashSet<String>(4);
        this.initQueryFields(selectors, amountFieldSet);
        groupByFieldSet.addAll(this.queryParam.getGroupBy());
        Set<Long> cfitemIdSet = this.getCfitemIds(cfitemIds);
        Map<Long, Long> cfitemMasterIdToIdMap = ICTServiceUtils.masterToIDMap(cfitemIdSet, "gl_cashflowitem");
        if (cfitemMasterIdToIdMap.isEmpty()) {
            return null;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        HashSet<String> flexEmptyValFields = new HashSet<String>(8);
        HashMap<String, Set<Object>> flexToValsMap = new HashMap<String, Set<Object>>(8);
        ICTServiceUtils.getFlexAndVals(assgrpMap, flexEmptyValFields, flexToValsMap);
        HashSet<String> allFlexSet = new HashSet<String>(8);
        allFlexSet.addAll(flexEmptyValFields);
        allFlexSet.addAll(flexToValsMap.keySet());
        selectors.removeAll(allFlexSet);
        filters.addAll(this.getAssistMetaQfilter(flexEmptyValFields, flexToValsMap));
        filters.add(new QFilter(CFITEM, "in", cfitemIdSet));
        String selectStr = ((Object)selectors).toString().substring(1, ((Object)selectors).toString().length() - 1);
        String flexMetaFieldSet = this.getFlexMetaField(allFlexSet);
        selectStr = selectStr + flexMetaFieldSet;
        MainEntityType cashflowEntity = ICTServiceUtils.getCashflowMainEntityType(allFlexSet);
        DataSet cashflowData = CfPuchAmtQueryExecutor.getInstance().getCfPuchAmtEntity(this.toQueryParam(selectStr, orgId, bookTypeId, periodId, opOrgIds, filters), cashflowEntity);
        List<Map<String, Object>> resultList = this.getCashflowResultList(cashflowData, groupByFieldSet, amountFieldSet, cfitemMasterIdToIdMap, this.queryParam.isReturnZeroResult());
        LOG.info("\u5185\u90e8\u4ea4\u6613\u73b0\u91d1\u6d41\u91cf\u63a5\u53e3\u7ed3\u679c\uff1alist:" + resultList.toString());
        return resultList;
    }

    private CfPuchAmtQueryParam toQueryParam(String selectStr, long orgId, long bookTypeId, long periodId, long[] opOrgIds, List<QFilter> filters) {
        CfPuchAmtQueryParam param = new CfPuchAmtQueryParam();
        param.setSelector(selectStr);
        param.setOrgIds(new long[]{orgId});
        param.setBookTypeId(bookTypeId);
        param.setOpOrgIds(opOrgIds);
        param.setBeginPeriodId(periodId);
        param.setEndPeriodId(periodId);
        param.setFilters(filters.toArray(new QFilter[0]));
        return param;
    }

    private Set<Long> getCfitemIds(long[] cfitemIds) {
        HashSet<Long> cfitemSet = new HashSet(8);
        if (cfitemIds != null && cfitemIds.length > 0) {
            cfitemSet.addAll(CollectionUtils.arrayToList((Object)cfitemIds));
        } else {
            cfitemSet = this.queryParam.getCfitemAssgrp().keySet();
        }
        return cfitemSet;
    }

    private List<QFilter> getAssistMetaQfilter(Set<String> flexEmptyValFields, Map<String, Set<Object>> flexToValsMap) {
        String assgrpPrefix = "assgrp_";
        ArrayList<QFilter> customFilters = new ArrayList<QFilter>(8);
        for (String string : flexEmptyValFields) {
            customFilters.add(QFilter.join((String)(assgrpPrefix + string), (String)(assgrpPrefix + string + ".hg"), (QFilter)new QFilter(assgrpPrefix + string + ".asstype", "=", (Object)string), (ORMHint.JoinHint)(this.queryParam.isQueryAll() ? ORMHint.JoinHint.LEFT : ORMHint.JoinHint.INNER), (boolean)false));
        }
        for (Map.Entry entry : flexToValsMap.entrySet()) {
            String flex = (String)entry.getKey();
            Set valSet = (Set)entry.getValue();
            QFilter fflex = new QFilter(assgrpPrefix + flex + ".asstype", "=", (Object)flex);
            QFilter fvalue = new QFilter(assgrpPrefix + flex + ".assval", "in", (Object)valSet);
            customFilters.add(fflex);
            customFilters.add(fvalue);
        }
        return customFilters;
    }

    private String getFlexMetaField(Set<String> flexSet) {
        StringBuilder flexBuilder = new StringBuilder();
        for (String flex : flexSet) {
            flexBuilder.append(",");
            flexBuilder.append(" assgrp_");
            flexBuilder.append(flex);
            flexBuilder.append(".assval ");
            flexBuilder.append(flex);
        }
        return flexBuilder.toString();
    }

    private void initQueryFields(Set<String> selectors, Set<String> amountVals) {
        selectors.addAll(this.queryParam.getSelector());
        selectors.addAll(this.queryParam.getSelector());
        selectors.add(CFITEM);
        selectors.add(CURRENCY);
        for (String amountField : AMOUNTFIELDS) {
            if (!selectors.contains(amountField)) continue;
            amountVals.add(amountField);
        }
        for (String amountField : YEARAMOUNTFIELDS) {
            if (!selectors.contains(amountField)) continue;
            amountVals.add(amountField);
        }
        if (amountVals.isEmpty()) {
            amountVals.addAll(Arrays.asList(AMOUNTFIELDS));
            amountVals.addAll(Arrays.asList(YEARAMOUNTFIELDS));
            selectors.addAll(amountVals);
        }
    }

    private List<Map<String, Object>> getCashflowResultList(DataSet cashflowData, Set<String> groupBySet, Set<String> amountSet, Map<Long, Long> cfitemMasteridToIdMap, boolean isZeroResult) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(1024);
        if (cashflowData != null) {
            ArrayList<String> aliasList = new ArrayList<String>(groupBySet.size());
            for (String string : groupBySet) {
                String[] groupBys = string.split(" ");
                String aliasField = groupBys.length == 2 ? groupBys[1] : groupBys[0];
                aliasList.add(aliasField);
            }
            GroupbyDataSet gds = cashflowData.groupBy(aliasList.toArray(new String[0]));
            for (String amountVal : amountSet) {
                gds = gds.sum(amountVal);
            }
            cashflowData = gds.finish();
            List<String> list = ICTServiceUtils.getFieldsByDs(cashflowData);
            boolean isZero = true;
            for (Row row : cashflowData) {
                HashMap<String, Object> map = new HashMap<String, Object>(list.size());
                for (String field : groupBySet) {
                    Object val = row.get(field);
                    map.put(field, val);
                }
                for (String field : amountSet) {
                    BigDecimal value = row.getBigDecimal(field);
                    map.put(field, value);
                    if (!isZero || BigDecimal.ZERO.compareTo(value) == 0) continue;
                    isZero = false;
                }
                if (isZero && !isZeroResult) continue;
                resultList.add(map);
            }
        }
        return resultList;
    }
}

