/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.fetch.acct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ict.mservice.fetch.acct.AcctPuchQueryParam;
import kd.fi.ict.puchamt.acct.AcctPuchAmtQueryParam;

public class AcctPuchAssgrpHelper {
    public static DataSet getAssgrpData(String sels, AcctPuchQueryParam param, AcctPuchAmtQueryParam queryParam, Map<String, Object> deriveMap) {
        Map<Long, List<Map<String, Long>>> accountAssgrp = param.getAccountAssgrp();
        Map<String, Set<Long>> flexToIdsMap = AcctPuchAssgrpHelper.collectFlexsAndVal(accountAssgrp);
        Map<Map<String, Long>, Set<Long>> flexsAcctIdsMap = AcctPuchAssgrpHelper.putFlexsToDsMap(accountAssgrp);
        Map<Set<String>, Set<Long>> allFlexsToLeafAcctMap = AcctPuchAssgrpHelper.getLeafAcctByFlexs(flexsAcctIdsMap, param);
        DataSet resultds = AcctPuchAssgrpHelper.joinAssistSet(param, queryParam, sels, allFlexsToLeafAcctMap, flexsAcctIdsMap, deriveMap);
        return resultds;
    }

    private static DataSet joinAssistSet(AcctPuchQueryParam param, AcctPuchAmtQueryParam queryParam, String sels, Map<Set<String>, Set<Long>> allFlexsToLeafAcctMap, Map<Map<String, Long>, Set<Long>> flexsAcctIdsMap, Map<String, Object> deriveMap) {
        return null;
    }

    private static Map<Set<String>, Set<Long>> getLeafAcctByFlexs(Map<Map<String, Long>, Set<Long>> flexsAcctIdsMap, AcctPuchQueryParam param) {
        if (flexsAcctIdsMap.isEmpty()) {
            return new HashMap<Set<String>, Set<Long>>();
        }
        Long orgId = param.getOrgIds().length > 0 ? param.getOrgIds()[0] : 0L;
        Map<Set<String>, Set<Long>> flexsToAcctMap = AcctPuchAssgrpHelper.flexsToAcct(flexsAcctIdsMap);
        HashSet allFlexs = new HashSet();
        HashSet<Long> allAcctIds = new HashSet<Long>();
        for (Map.Entry<Set<String>, Set<Long>> entry : flexsToAcctMap.entrySet()) {
            allFlexs.addAll(entry.getKey());
            allAcctIds.addAll((Collection)entry.getValue());
        }
        DynamicObjectCollection acttypeColl = QueryServiceHelper.query((String)"bd_asstacttype", (String)"id,flexfield", (QFilter[])new QFilter("flexfield", "in", allFlexs).toArray());
        HashMap<String, Long> typeMap = new HashMap<String, Long>();
        for (DynamicObject acttype : acttypeColl) {
            typeMap.put(acttype.getString("flexfield"), acttype.getLong("id"));
        }
        HashMap<Long, Set<Long>> idToLeafMap = new HashMap<Long, Set<Long>>();
        AcctPuchAssgrpHelper.getAcctLeaf(allAcctIds, idToLeafMap, orgId);
        Map<Set<String>, Set<Long>> flexsToLeafAcctMap = AcctPuchAssgrpHelper.dbFlexs(flexsToAcctMap, idToLeafMap, typeMap);
        return flexsToLeafAcctMap;
    }

    private static Map<Set<String>, Set<Long>> dbFlexs(Map<Set<String>, Set<Long>> flexsToAcctMap, Map<Long, Set<Long>> idToLeafMap, Map<String, Long> typeMap) {
        HashMap<Set<String>, Set<Long>> flexsToLeafAcctMap = new HashMap<Set<String>, Set<Long>>(flexsToAcctMap.size());
        for (Map.Entry<Set<String>, Set<Long>> entry : flexsToAcctMap.entrySet()) {
            HashSet leafAcctIds = new HashSet();
            Set<Long> acctIds = entry.getValue();
            for (Long acctId : acctIds) {
                leafAcctIds.addAll(idToLeafMap.get(acctId));
            }
            Set<String> flexs = entry.getKey();
            StringBuilder sql = new StringBuilder();
            sql.append("select a.fid from T_BD_Account a ");
            StringBuffer where = new StringBuffer();
            ArrayList<Long> sp = new ArrayList<Long>(32);
            where.append(" WHERE a.fid in (");
            for (Long acctId : leafAcctIds) {
                where.append("?,");
                sp.add(acctId);
            }
            where = where.deleteCharAt(where.length() - 1);
            where.append(')');
            HashSet<Long> flexAcctIds = new HashSet<Long>(32);
            int i = 1;
            for (String s : flexs) {
                sql.append(" INNER JOIN T_BD_AccountAsstActItem a").append(i).append(" ON a.fid=a").append(i).append(".fid");
                where.append(" and a").append(i).append(".fasstactitemid = ? ");
                sp.add(typeMap.get(s));
                ++i;
            }
            try (DataSet dataSet = AcctPuchAssgrpHelper.queryDataSetMethod("", DBRoute.of((String)"gl"), sql.append(where).toString(), sp.toArray());){
                while (dataSet.hasNext()) {
                    flexAcctIds.add(dataSet.next().getLong("fid"));
                }
            }
            flexsToLeafAcctMap.put(flexs, flexAcctIds);
        }
        return flexsToLeafAcctMap;
    }

    private static DataSet queryDataSetMethod(String name, DBRoute gl, String toString, Object[] toArray) {
        return DB.queryDataSet((String)name, (DBRoute)gl, (String)toString, (Object[])toArray);
    }

    private static void getAcctLeaf(Set<Long> acctIds, Map<Long, Set<Long>> idToLeafMap, Long orgId) {
        HashSet<Long> allAcctIds = new HashSet<Long>();
        allAcctIds.addAll(acctIds);
        HashMap<String, Long> numberToIdMap = new HashMap<String, Long>();
        AcctPuchAssgrpHelper.getMidAndNumByAcctId(allAcctIds, numberToIdMap);
        HashMap<Long, Set<Long>> pIdToIdMap = new HashMap<Long, Set<Long>>(allAcctIds.size());
        Iterator iterator = allAcctIds.iterator();
        while (iterator.hasNext()) {
            long acctId = (Long)iterator.next();
            HashSet<Long> idSet = new HashSet<Long>();
            idSet.add(acctId);
            pIdToIdMap.put(acctId, idSet);
        }
        AcctPuchAssgrpHelper.queryAcctAllLeaf(allAcctIds, pIdToIdMap, idToLeafMap, 0);
        QFilter fbasedata = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        AcctPuchAssgrpHelper.uLeafAcctIdAndMid(idToLeafMap, fbasedata, numberToIdMap);
        for (long acctId : acctIds) {
            Set allLeafAcctIds = idToLeafMap.computeIfAbsent(acctId, x -> new HashSet());
            if (!allLeafAcctIds.isEmpty()) continue;
            allLeafAcctIds.add(acctId);
        }
    }

    private static void uLeafAcctIdAndMid(Map<Long, Set<Long>> idToLeafMap, QFilter fbasedata, Map<String, Long> numberToIdMap) {
        Object number;
        Set<Long> idSet = idToLeafMap.keySet();
        DataSet acctSet = AcctPuchAssgrpHelper.queryDataSet("", "bd_accountview", "id, number, masterid, parent", new QFilter[]{new QFilter("id", "in", idSet)});
        HashMap<Long, String> idToNumberMap = new HashMap<Long, String>(16);
        for (Object row : acctSet) {
            idToNumberMap.put(row.getLong("id"), row.getString("number"));
        }
        HashMap<String, Set> numberToLeafMap = new HashMap<String, Set>();
        for (Map.Entry entry : idToLeafMap.entrySet()) {
            number = (String)idToNumberMap.get(entry.getKey());
            Set set = numberToLeafMap.computeIfAbsent((String)number, x -> new HashSet());
            set.addAll((Collection)entry.getValue());
        }
        for (Map.Entry entry : numberToLeafMap.entrySet()) {
            number = (String)entry.getKey();
            long l = numberToIdMap.get(number);
            idToLeafMap.put(l, (Set<Long>)entry.getValue());
        }
        HashSet allLeafSet = new HashSet();
        Collection<Set<Long>> collection = idToLeafMap.values();
        for (Set set : collection) {
            allLeafSet.addAll(set);
        }
        DataSet leafAcctDS = AcctPuchAssgrpHelper.queryDataSet("", "bd_accountview", "id, number, masterid, parent", new QFilter[]{new QFilter("id", "in", allLeafSet), fbasedata});
        HashSet<Long> hashSet = new HashSet<Long>();
        for (Row row : leafAcctDS) {
            hashSet.add(row.getLong("id"));
        }
        HashMap<Long, Set<Long>> resultMap = new HashMap<Long, Set<Long>>(idToLeafMap.size());
        for (Map.Entry<Long, Set<Long>> entry : idToLeafMap.entrySet()) {
            Set<Long> leafSet = entry.getValue();
            leafSet.retainAll(hashSet);
            resultMap.put(entry.getKey(), leafSet);
        }
        idToLeafMap.clear();
        idToLeafMap.putAll(resultMap);
    }

    private static void queryAcctAllLeaf(Set<Long> acctIds, Map<Long, Set<Long>> leafIdsToAcctIdsMap, Map<Long, Set<Long>> idToAllLeafMap, int isRepeatIndex) {
        try (DataSet acctSet = AcctPuchAssgrpHelper.queryDataSet("", "bd_accountview", "id,number, masterid, parent, isleaf", new QFilter[]{new QFilter("parent", "in", acctIds)});){
            acctIds.clear();
            for (Row row : acctSet) {
                long pid = row.getLong("parent");
                long id = row.getLong("id");
                long masterId = row.getLong("masterid");
                Set<Long> acctIdSet = leafIdsToAcctIdsMap.get(pid);
                boolean isLeaf = row.getBoolean("isleaf");
                if (isLeaf) {
                    for (Long acctId : acctIdSet) {
                        Set<Object> allLeaf = idToAllLeafMap.get(acctId) == null ? new HashSet() : idToAllLeafMap.get(acctId);
                        allLeaf.add(id);
                        allLeaf.add(masterId);
                        idToAllLeafMap.put(acctId, allLeaf);
                    }
                    continue;
                }
                acctIds.add(id);
                acctIds.add(masterId);
                HashSet<Long> idSet = leafIdsToAcctIdsMap.get(id) == null ? new HashSet<Long>() : leafIdsToAcctIdsMap.get(id);
                idSet.addAll(acctIdSet);
                leafIdsToAcctIdsMap.put(id, idSet);
                leafIdsToAcctIdsMap.put(masterId, idSet);
            }
            if (!acctIds.isEmpty()) {
                if (isRepeatIndex > 1000) {
                    return;
                }
                AcctPuchAssgrpHelper.queryAcctAllLeaf(acctIds, leafIdsToAcctIdsMap, idToAllLeafMap, ++isRepeatIndex);
            }
        }
    }

    private static void getMidAndNumByAcctId(Set<Long> acctIds, Map<String, Long> numberToIdMap) {
        DataSet acctSet = AcctPuchAssgrpHelper.queryDataSet("getMidAndNumByAcctId", "bd_accountview", "id, masterid, number", new QFilter[]{new QFilter("id", "in", acctIds)});
        for (Row row : acctSet) {
            long masterId = row.getLong("masterid");
            numberToIdMap.put(row.getString("number"), row.getLong("id"));
            acctIds.add(masterId);
        }
        DataSet numebrAcctSet = AcctPuchAssgrpHelper.queryDataSet("getMidAndNumByAcctId", "bd_accountview", "id,number,masterid", new QFilter[]{new QFilter("masterid", "in", acctIds)});
        for (Row row : numebrAcctSet) {
            numberToIdMap.putIfAbsent(row.getString("number"), row.getLong("id"));
            acctIds.add(row.getLong("id"));
        }
    }

    private static DataSet queryDataSet(String algoKey, String entityId, String sel, QFilter[] filters) {
        DataSet assistSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityId, (String)sel, (QFilter[])filters, null);
        return assistSet;
    }

    private static Map<Set<String>, Set<Long>> flexsToAcct(Map<Map<String, Long>, Set<Long>> flexsAcctIdsMap) {
        HashMap<Set<String>, Set<Long>> flexsToAcctMap = new HashMap<Set<String>, Set<Long>>();
        for (Map.Entry<Map<String, Long>, Set<Long>> entry : flexsAcctIdsMap.entrySet()) {
            Set<String> flexs = entry.getKey().keySet();
            Set acctIds = flexsToAcctMap.computeIfAbsent(flexs, x -> new HashSet());
            acctIds.addAll((Collection)entry.getValue());
        }
        return flexsToAcctMap;
    }

    private static Map<String, Set<Long>> collectFlexsAndVal(Map<Long, List<Map<String, Long>>> accountAssgrp) {
        HashMap<String, Set<Long>> flexToIdsMap = new HashMap<String, Set<Long>>();
        Collection<List<Map<String, Long>>> values = accountAssgrp.values();
        for (List<Map<String, Long>> value : values) {
            value.forEach(map -> map.forEach((k, v) -> flexToIdsMap.computeIfAbsent((String)k, x -> new HashSet()).add(v)));
        }
        return flexToIdsMap;
    }

    private static Map<Map<String, Long>, Set<Long>> putFlexsToDsMap(Map<Long, List<Map<String, Long>>> accountAssgrp) {
        HashMap<Map<String, Long>, Set<Long>> flexsAcctIdsMap = new HashMap<Map<String, Long>, Set<Long>>();
        HashMap flexMap = new HashMap();
        for (Map.Entry<Long, List<Map<String, Long>>> entry : accountAssgrp.entrySet()) {
            Long acctId = entry.getKey();
            List<Map<String, Long>> mapList = entry.getValue();
            if (mapList == null || mapList.isEmpty()) {
                flexsAcctIdsMap.computeIfAbsent(flexMap, x -> new HashSet()).add(acctId);
                continue;
            }
            mapList.forEach(v -> {
                if (v == null || v.isEmpty()) {
                    flexsAcctIdsMap.computeIfAbsent(flexMap, x -> new HashSet()).add(acctId);
                } else {
                    flexsAcctIdsMap.computeIfAbsent((Map<String, Long>)v, x -> new HashSet()).add(acctId);
                }
            });
        }
        return flexsAcctIdsMap;
    }
}

