/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.fetch.acct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.fi.ict.mservice.fetch.acct.AcctPuchAssgrpHelper;
import kd.fi.ict.mservice.fetch.acct.AcctPuchQueryParam;
import kd.fi.ict.puchamt.AcctPuchAmtQueryExecutor;
import kd.fi.ict.puchamt.acct.AcctPuchAmtQueryParam;
import kd.fi.ict.service.fetch.AcctPuchService;
import kd.fi.ict.util.DataSetHelper;

public class AcctPuchServiceImpl
implements AcctPuchService {
    private static final Log LOGGER = LogFactory.getLog(AcctPuchServiceImpl.class);
    public Set<String> puchAmtFields = new HashSet<String>(){
        {
            this.add("org");
            this.add("booktype");
            this.add("accounttable");
            this.add("oporg");
            this.add("period");
            this.add("endperiod");
            this.add("account");
            this.add("assgrp");
            this.add("currency");
            this.add("pbeginfor");
            this.add("pbeginlocal");
            this.add("pdebitfor");
            this.add("pdebitlocal");
            this.add("pcreditfor");
            this.add("pcreditlocal");
            this.add("pyeardebitfor");
            this.add("pyeardebitlocal");
            this.add("pyearcreditfor");
            this.add("pyearcreditlocal");
            this.add("pendfor");
            this.add("pendlocal");
            this.add("cbeginfor");
            this.add("cbeginlocal");
            this.add("cdebitfor");
            this.add("cdebitlocal");
            this.add("ccreditfor");
            this.add("ccreditlocal");
            this.add("cyeardebitfor");
            this.add("cyeardebitlocal");
            this.add("cyearcreditfor");
            this.add("cyearcreditlocal");
            this.add("cendfor");
            this.add("cendlocal");
        }
    };
    public Set<String> dcFields = new HashSet<String>(){
        {
            this.add("pbeginfor");
            this.add("pbeginlocal");
            this.add("pendfor");
            this.add("pendlocal");
            this.add("cbeginfor");
            this.add("cbeginlocal");
            this.add("cendfor");
            this.add("cendlocal");
        }
    };

    public String getPuchData(String param) {
        try {
            LOGGER.info("-ict-PuchServiceImpl \u53d6\u6570\u53c2\u6570:{}", (Object)param);
            List<Object> data = new ArrayList();
            if (StringUtils.isNotEmpty((String)param)) {
                AcctPuchQueryParam queryParam = (AcctPuchQueryParam)JSONUtils.cast((String)param, AcctPuchQueryParam.class);
                data = this.getPuchData(queryParam);
            }
            LOGGER.info("-ict-PuchServiceImpl \u53d6\u6570\u7ed3\u679c:{}", data);
            return JSONUtils.toString(data);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("ict", "fetch error"), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getPuchData(AcctPuchQueryParam queryParam) {
        Long[] longArray;
        if (queryParam.getSelectors() == null || queryParam.getSelectors().isEmpty()) {
            return null;
        }
        if (queryParam.getAccountTableId() == 0L) {
            return null;
        }
        HashMap<String, Object> deriveMap = new HashMap<String, Object>();
        deriveMap.put("aliasDc", "dc");
        deriveMap.put("aliasAssgrp", "ass_id");
        deriveMap.put("aliasAcct", "acct_id");
        deriveMap.put("flagDc", false);
        deriveMap.put("flagAss", false);
        deriveMap.put("flagAcct", false);
        HashMap<String, String> selFiledMap = new HashMap<String, String>();
        HashMap<String, String> selAssMap = new HashMap<String, String>();
        String sels = this.getSelector(queryParam.getSelectors(), queryParam.getGroupBys(), selFiledMap, selAssMap, deriveMap);
        Map<Long, List<Map<String, Long>>> accountAssgrp = queryParam.getAccountAssgrp();
        AcctPuchAmtQueryParam param = new AcctPuchAmtQueryParam();
        param.setOrgIds(queryParam.getOrgIds());
        param.setAccountTableId(Long.valueOf(queryParam.getAccountTableId()));
        param.setBookTypeId(Long.valueOf(queryParam.getBookTypeId()));
        param.setBeginPeriodId(Long.valueOf(queryParam.getPeriodId()));
        param.setEndPeriodID(Long.valueOf(queryParam.getPeriodId()));
        param.setSelector(sels);
        AcctPuchAmtQueryParam.AcctParam acctParam = param.getAcctParam();
        acctParam.setSumAssgrp(true);
        if (!queryParam.getAccountIds().isEmpty()) {
            acctParam.setAccountFilter(new QFilter("id", "in", queryParam.getAccountIds()));
        }
        acctParam.setSpecialAccount(queryParam.isSpecialAccount());
        if (queryParam.getCurrencyId() == 0L) {
            longArray = null;
        } else {
            Long[] longArray2 = new Long[1];
            longArray = longArray2;
            longArray2[0] = queryParam.getCurrencyId();
        }
        acctParam.setCurrencyIds(longArray);
        List<Map<String, Object>> result = null;
        try (DataSet puchAmtDs = null;){
            puchAmtDs = accountAssgrp.isEmpty() ? AcctPuchAmtQueryExecutor.getInstance().getPuchAmt(param) : AcctPuchAssgrpHelper.getAssgrpData(sels, queryParam, param, deriveMap);
            puchAmtDs = this.dealAssgrpAlias(puchAmtDs, selAssMap);
            Tuple<Set<String>, Set<String>> tuple = this.splitGroupFields(queryParam.getGroupBys());
            HashSet<String> selAlias = new HashSet<String>(selFiledMap.values());
            HashSet<String> assAlias = new HashSet<String>(selAssMap.values());
            puchAmtDs = this.sum(puchAmtDs, (Set)tuple.item1, (Set)tuple.item2, selFiledMap, assAlias, deriveMap);
            if (!((Boolean)deriveMap.get("flagDc")).booleanValue()) {
                selAlias.remove(deriveMap.get("aliasDc"));
            }
            if (!((Boolean)deriveMap.get("flagAss")).booleanValue()) {
                selAlias.remove(deriveMap.get("aliasAssgrp"));
            }
            if (!((Boolean)deriveMap.get("flagAcct")).booleanValue()) {
                selAlias.remove(deriveMap.get("aliasAcct"));
            }
            selAlias.addAll(assAlias);
            result = this.trans2List(selAlias, puchAmtDs);
        }
        return result;
    }

    private DataSet sum(DataSet ds, Set<String> balGroupFields, Set<String> assGroupField, Map<String, String> selFieldMap, Set<String> assFields, Map<String, Object> deriveMap) {
        List fieldSet;
        LinkedList<String> allFields = new LinkedList<String>();
        HashSet<String> compareFields = new HashSet<String>(8);
        ArrayList amountFields = new ArrayList(8);
        selFieldMap.forEach((k, v) -> {
            if (k.endsWith("for") || k.endsWith("local")) {
                allFields.add(this.replaceFieldByDc((String)v, deriveMap));
                amountFields.add(v);
                compareFields.add((String)v);
            } else {
                allFields.add((String)v);
                compareFields.add((String)v);
            }
        });
        allFields.addAll(assFields);
        compareFields.addAll(assFields);
        if (!((Boolean)deriveMap.get("flagDc")).booleanValue()) {
            allFields.remove(deriveMap.get("aliasDc"));
            compareFields.remove(deriveMap.get("aliasDc"));
        }
        if (!((Boolean)deriveMap.get("flagAss")).booleanValue()) {
            allFields.remove(deriveMap.get("aliasAssgrp"));
            compareFields.remove(deriveMap.get("aliasAssgrp"));
        }
        if (!((Boolean)deriveMap.get("flagAcct")).booleanValue()) {
            allFields.remove(deriveMap.get("aliasAcct"));
            compareFields.remove(deriveMap.get("aliasAcct"));
        }
        if (!(fieldSet = DataSetHelper.getDataSetFileds((DataSet)ds)).containsAll(compareFields)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fc7\u6ee4\u5b57\u6bb5\u8ddf\u67e5\u8be2\u5b57\u6bb5\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u8fc7\u6ee4\u5b57\u6bb5\uff1a%1$s\uff1b\u548c\u67e5\u8be2\u5b57\u6bb5%2$s", (String)"BalanceQueryParamApi_0", (String)"fi-gl-webapi", (Object[])new Object[0]), fieldSet, compareFields));
        }
        ds = ds.select(allFields.toArray(new String[0]));
        if (assGroupField != null) {
            balGroupFields.addAll(assGroupField);
        }
        if (balGroupFields != null && !balGroupFields.isEmpty()) {
            GroupbyDataSet gpRs = ds.groupBy(balGroupFields.toArray(new String[0]));
            for (String str : amountFields) {
                gpRs.sum(str);
            }
            ds = gpRs.finish();
        }
        return ds;
    }

    private String replaceFieldByDc(String amountField, Map<String, Object> deriveMap) {
        if (this.dcFields.contains(amountField)) {
            return "case when " + deriveMap.get("aliasDc") + "='1' then " + amountField + " else -1*" + amountField + " end as " + amountField;
        }
        return amountField;
    }

    private String getSelector(List<String> selector, List<String> groupBy, Map<String, String> selAliasMap, Map<String, String> selAssFields, Map<String, Object> deriveMap) {
        StringBuilder sels = new StringBuilder();
        HashSet<String> fs = new HashSet<String>();
        if (groupBy != null && !groupBy.isEmpty()) {
            fs.addAll(groupBy);
        }
        fs.addAll(selector);
        for (String f : fs) {
            String filedName;
            String[] filedOrAlias = this.splitStr(f);
            String name = filedOrAlias[0];
            String alias = filedOrAlias[1];
            String[] nameArray = name.split("\\.");
            String string = filedName = nameArray.length == 0 ? name : nameArray[0];
            if (this.puchAmtFields.contains(filedName)) {
                if ("account.dc".equalsIgnoreCase(name)) {
                    deriveMap.put("aliasDc", alias);
                    deriveMap.put("flagDc", true);
                } else if ("assgrp.id".equalsIgnoreCase(name) || "assgrp".equalsIgnoreCase(name)) {
                    deriveMap.put("aliasAssgrp", alias);
                    deriveMap.put("flagAss", true);
                } else if ("account.id".equalsIgnoreCase(name) || "account".equalsIgnoreCase(name)) {
                    deriveMap.put("aliasAcct", alias);
                    deriveMap.put("flagAss", true);
                } else if (this.dcFields.contains(name)) {
                    deriveMap.put(name + "_bal", alias);
                }
                sels.append(f).append(",");
                selAliasMap.put(name, alias);
                continue;
            }
            selAssFields.put(name, alias);
        }
        if (fs.size() > 0) {
            if (!((Boolean)deriveMap.get("flagDc")).booleanValue()) {
                sels.append("account.dc ").append(deriveMap.get("aliasDc")).append(",");
                selAliasMap.put("account.dc", (String)deriveMap.get("aliasDc"));
            }
            if (!((Boolean)deriveMap.get("flagAss")).booleanValue()) {
                sels.append("assgrp.id ").append(deriveMap.get("aliasAssgrp")).append(",");
                selAliasMap.put("assgrp.id", (String)deriveMap.get("aliasAssgrp"));
            }
            if (!((Boolean)deriveMap.get("flagAcct")).booleanValue()) {
                sels.append("account.id ").append(deriveMap.get("aliasAcct")).append(",");
                selAliasMap.put("account.id", (String)deriveMap.get("aliasAcct"));
            }
        }
        if (sels.length() > 0) {
            return sels.substring(0, sels.length() - 1);
        }
        return sels.toString();
    }

    public String[] splitStr(String filed) {
        String[] strs = filed.trim().split("\\s+");
        String alias = strs.length == 2 ? strs[1].trim() : strs[0].trim();
        String name = strs[0].trim();
        return new String[]{alias, name};
    }

    private DataSet dealAssgrpAlias(DataSet dataSet, Map<String, String> assAliasMap) {
        List allFields = DataSetHelper.getDataSetFileds((DataSet)dataSet);
        assAliasMap.forEach((k, v) -> {
            if (allFields.contains(k)) {
                allFields.remove(k);
                allFields.add(k + " " + v);
            }
        });
        return dataSet.select(allFields.toArray(new String[0]));
    }

    private Tuple<Set<String>, Set<String>> splitGroupFields(List<String> groupFields) {
        Tuple tuple = Tuple.create(new HashSet(0), new HashSet(0));
        for (String fields : groupFields) {
            String filedName;
            String[] filedOrAlias = this.splitStr(fields);
            String name = filedOrAlias[0];
            String alias = filedOrAlias[1];
            String[] nameArray = name.split("\\.");
            String string = filedName = nameArray.length == 0 ? name : nameArray[0];
            if (this.puchAmtFields.contains(filedName)) {
                ((Set)tuple.item1).add(alias);
                continue;
            }
            ((Set)tuple.item2).add(alias);
        }
        return tuple;
    }

    private List<Map<String, Object>> trans2List(Set<String> selector, DataSet ds) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        int selSize = selector.size();
        Iterator rowIt = ds.iterator();
        if (rowIt.hasNext()) {
            Row row = (Row)rowIt.next();
            HashMap<String, Object> rowData = new HashMap<String, Object>(selSize);
            for (String sel : selector) {
                rowData.put(sel, row.get(sel));
            }
            result.add(rowData);
        }
        return result;
    }
}

