/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.fetch.cf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.JSONUtils;
import kd.fi.ict.mservice.fetch.cf.CfPuchQueryParam;
import kd.fi.ict.mservice.fetch.util.AssServiceUtils;
import kd.fi.ict.puchamt.CfPuchAmtQueryExecutor;
import kd.fi.ict.puchamt.cf.CfPuchAmtQueryExecutorImpl;
import kd.fi.ict.puchamt.cf.CfPuchAmtQueryParam;
import kd.fi.ict.service.fetch.CfPuchService;

public class CfPuchServiceImpl
implements CfPuchService {
    private static final String org = "org";
    private static final String cfitem = "cfitem";
    private static final String assgrp = "assgrp";
    private static final String currency = "currency";
    public static final String amount = "pamount";
    public static final String yearAmount = "pyearamount";
    private static final Log LOGGER = LogFactory.getLog(CfPuchServiceImpl.class);

    public String getPuchData(String param) {
        try {
            LOGGER.info("-ict-\u73b0\u91d1\u6d41\u91cf\u63a5\u53e3\u53c2\u6570:{}", (Object)param);
            CfPuchQueryParam queryParam = (CfPuchQueryParam)JSONUtils.cast((String)param, CfPuchQueryParam.class);
            List<Map<String, Object>> data = null;
            CfPuchQueryParamWarp paramWarp = new CfPuchQueryParamWarp(queryParam);
            if (paramWarp.getOriSelectors().contains(amount)) {
                data = this.getCfAmountData(paramWarp);
            } else if (paramWarp.getOriSelectors().contains(yearAmount)) {
                data = this.getCfYearAmountData(paramWarp);
            }
            LOGGER.info("-ict-\u73b0\u91d1\u6d41\u91cf\u53d6\u6570\u7ed3\u679c\uff1a{}", data);
            return JSONUtils.toString(data);
        }
        catch (IOException e) {
            LOGGER.info("-ict-\u73b0\u91d1\u6d41\u91cf\u53d6\u6570\u7ed3\u679c\uff1a{}", (Object)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public List<Map<String, Object>> getCfAmountData(CfPuchQueryParamWarp paramWarp) {
        return this.getCashFlow(paramWarp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getCashFlow(CfPuchQueryParamWarp paramWarp) {
        LOGGER.info("\u73b0\u91d1\u6d41\u91cf\u63a5\u53e3\u53c2\u6570\uff1aorgid:{},bookTypeId:{},periodId:{},cfitemIds:{},cfitemIds:{}", new Object[]{paramWarp.getOrgId(), paramWarp.getBookTypeId(), paramWarp.getPeriodId(), paramWarp.cfitemIds, paramWarp.assgrps});
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DataSet assgrpDs = null;
        List flexFields = null;
        Map<Object, Object> cfitemIdToMasterIdMap = null;
        Map<Long, Map<String, List<Long>>> cfitemAssgrpMap = paramWarp.getCfitemAssgrp();
        if (!cfitemAssgrpMap.isEmpty()) {
            Map<String, Object> assgrpIdSetMap = AssServiceUtils.getAssFilterAndAssDs(cfitemAssgrpMap, "gl_cashflowitem");
            Set allAssIds = (Set)assgrpIdSetMap.get("assIds");
            flexFields = (List)assgrpIdSetMap.get("flexFields");
            assgrpDs = (DataSet)assgrpIdSetMap.get("assDs");
            cfitemIdToMasterIdMap = (HashMap)assgrpIdSetMap.get("acctIdToMasterId");
            if (allAssIds != null && !allAssIds.isEmpty() && allAssIds.size() < 1000) {
                QFilter fassgrp = new QFilter(assgrp, "in", (Object)allAssIds);
                filters.add(fassgrp);
            }
        }
        if (cfitemIdToMasterIdMap == null) {
            if (paramWarp.cfitemIds == null || paramWarp.cfitemIds.size() == 0) {
                return null;
            }
            QFilter fcfitem = new QFilter(cfitem, "in", (Object)paramWarp.cfitemIds);
            ArrayList<Long> idList = new ArrayList<Long>(paramWarp.cfitemIds.size());
            for (Long id : paramWarp.cfitemIds) {
                idList.add(id);
            }
            cfitemIdToMasterIdMap = AssServiceUtils.idToMasterIDMap(idList, "gl_cashflowitem");
            filters.add(fcfitem);
        } else {
            Set<Long> cfitemIdSet = cfitemAssgrpMap.keySet();
            QFilter fcfitem = new QFilter(cfitem, "in", cfitemIdSet);
            filters.add(fcfitem);
        }
        flexFields = flexFields == null ? new ArrayList() : flexFields;
        try (DataSet ds = null;){
            List<String> dsFields;
            CfPuchAmtQueryExecutorImpl cashFlowQueryExecutor = (CfPuchAmtQueryExecutorImpl)CfPuchAmtQueryExecutor.getInstance();
            paramWarp.selFields.removeAll(flexFields);
            CfPuchAmtQueryParam param = new CfPuchAmtQueryParam();
            param.setSelector(paramWarp.getSelFieldsStr());
            param.setOrgIds(new long[]{paramWarp.getOrgId()});
            param.setBookTypeId(paramWarp.getBookTypeId());
            param.setBeginPeriodId(paramWarp.getPeriodId());
            param.setEndPeriodId(paramWarp.getPeriodId());
            param.setFilters(filters.toArray(new QFilter[0]));
            ds = cashFlowQueryExecutor.getCfPuchAmt(param);
            if (assgrpDs != null && !flexFields.isEmpty()) {
                dsFields = AssServiceUtils.getFieldsByDs(ds);
                ds = ds.join(assgrpDs, JoinType.INNER).on(cfitem, "masterid").on(assgrp, "id").select(dsFields.toArray(new String[0]), flexFields.toArray(new String[0])).finish();
            }
            if (Objects.isNull(ds)) {
                dsFields = null;
                return dsFields;
            }
            List<String> groupByList = paramWarp.getOriGroupBys();
            ArrayList<Object> aliasList = new ArrayList<Object>(groupByList.size());
            for (String groupField : groupByList) {
                String[] gStrs = groupField.split(" ");
                String nameField = gStrs[0];
                if (gStrs.length == 2) {
                    nameField = gStrs[1];
                }
                aliasList.add(nameField);
            }
            if (aliasList.isEmpty()) {
                for (Object selector : paramWarp.selFields) {
                    if (paramWarp.sumFields.contains(selector)) continue;
                    aliasList.add(selector);
                }
            }
            GroupbyDataSet gds = ds.groupBy(aliasList.toArray(new String[0]));
            for (String amountVal : paramWarp.sumFields) {
                ds = gds.sum(amountVal).finish();
            }
            List<String> dsFields2 = AssServiceUtils.getFieldsByDs(ds);
            ArrayList list = new ArrayList();
            for (Row row : ds) {
                HashMap<String, Object> map = new HashMap<String, Object>(dsFields2.size() + 2);
                for (String field : dsFields2) {
                    long masterId;
                    Object val = row.get(field);
                    if (cfitem.equals(field) && (masterId = row.getLong(field).longValue()) != 0L) {
                        for (Map.Entry<Object, Object> entry : cfitemIdToMasterIdMap.entrySet()) {
                            if (masterId != (Long)entry.getValue()) continue;
                            masterId = (Long)entry.getKey();
                            val = masterId;
                        }
                    }
                    map.put(field, val);
                }
                map.put(org, paramWarp.getOrgId());
                for (String amountVal : paramWarp.sumFields) {
                    map.put(amountVal, row.getBigDecimal(amountVal));
                }
                list.add(map);
            }
            LOGGER.info("\u73b0\u91d1\u6d41\u91cf\u63a5\u53e3\u7ed3\u679c\uff1alist: {}", list);
            ArrayList arrayList = list;
            return arrayList;
        }
    }

    private List<Map<String, Object>> getCfYearAmountData(CfPuchQueryParamWarp queryParam) {
        return this.getCashFlow(queryParam);
    }

    static class CfPuchQueryParamWarp
    extends CfPuchQueryParam {
        private final List<String> selFields = new LinkedList<String>();
        private final List<String> sumFields = new LinkedList<String>();
        private Set<Long> cfitemIds = new HashSet<Long>(16);
        private Map<String, Object> assgrps = new HashMap<String, Object>(16);

        public CfPuchQueryParamWarp(CfPuchQueryParam queryParam) {
            super(queryParam);
            this.setCfItemAndAssgrpValue(queryParam);
            this.setSelectors();
        }

        private void setCfItemAndAssgrpValue(CfPuchQueryParam queryParam) {
            Map<Long, Map<String, List<Long>>> cfitemAssgrp = queryParam.getCfitemAssgrp();
            cfitemAssgrp.forEach((k, v) -> {
                this.cfitemIds.add((Long)k);
                v.forEach((k1, v1) -> v1.forEach(x -> this.assgrps.put((String)k1, x)));
            });
        }

        private void setSelectors() {
            this.selFields.addAll(this.getOriSelectors());
            this.selFields.addAll(this.getOriGroupBys());
            if (!this.selFields.contains(CfPuchServiceImpl.cfitem)) {
                this.selFields.add(CfPuchServiceImpl.cfitem);
            }
            if (!this.selFields.contains(CfPuchServiceImpl.currency)) {
                this.selFields.add(CfPuchServiceImpl.currency);
            }
            if (this.selFields.contains(CfPuchServiceImpl.amount)) {
                this.sumFields.add(CfPuchServiceImpl.amount);
            }
            if (this.selFields.contains(CfPuchServiceImpl.yearAmount)) {
                this.sumFields.add(CfPuchServiceImpl.yearAmount);
            }
            if (this.sumFields.isEmpty()) {
                this.sumFields.add(CfPuchServiceImpl.amount);
            }
            if (!this.getCfitemAssgrp().isEmpty() && !this.selFields.contains(CfPuchServiceImpl.assgrp)) {
                this.selFields.add(CfPuchServiceImpl.assgrp);
            }
        }

        public String getSelFieldsStr() {
            return String.join((CharSequence)",", this.selFields);
        }
    }
}

