/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.fetch.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class AssServiceUtils {
    public static Map<String, Object> getAssFilterAndAssDs(Map<Long, Map<String, List<Long>>> itemAssgrp, String entityId) {
        HashMap<String, Object> resultMap;
        if (itemAssgrp == null) {
            itemAssgrp = new HashMap<Long, Map<String, List<Long>>>();
        }
        HashSet allAssIds = new HashSet();
        DataSet resultDs = null;
        ArrayList<Long> acctIds = new ArrayList<Long>(itemAssgrp.size());
        HashSet<String> flexSet = new HashSet<String>();
        HashMap<Long, DataSet> acctDsMap = new HashMap<Long, DataSet>(itemAssgrp.size());
        for (Map.Entry<Long, Map<String, List<Long>>> entry : itemAssgrp.entrySet()) {
            resultMap = AssServiceUtils.parseAccountFlexField(entry.getValue());
            DataSet dataSet = (DataSet)resultMap.get("resultDs");
            flexSet.addAll(AssServiceUtils.getFieldsByDs(dataSet));
            acctDsMap.put(entry.getKey(), dataSet);
            acctIds.add(entry.getKey());
            allAssIds.addAll((Set)resultMap.get("resultAssIds"));
        }
        ArrayList<String> flexFields = new ArrayList<String>(flexSet);
        Map<Object, Object> acctIdToMasterIdMap = new HashMap();
        acctIdToMasterIdMap = AssServiceUtils.idToMasterIDMap(acctIds, entityId);
        if (!flexFields.isEmpty()) {
            for (Map.Entry entry : acctDsMap.entrySet()) {
                Long accountId = (Long)entry.getKey();
                DataSet acctDs = (DataSet)entry.getValue();
                List<String> acctFields = AssServiceUtils.getFieldsByDs(acctDs);
                ArrayList acctFlexFields = new ArrayList(flexFields);
                acctFlexFields.removeAll(acctFields);
                if (acctDs == null) continue;
                acctDs = acctDs.addNullField(acctFlexFields.toArray(new String[0])).select(flexFields.toArray(new String[0])).addField(accountId + "L", "aliasAcct").addField((acctIdToMasterIdMap.get(accountId) == null ? accountId : (Long)acctIdToMasterIdMap.get(accountId)) + "L", "masterid");
                resultDs = resultDs == null ? acctDs : resultDs.union(acctDs);
            }
            flexFields.removeIf(x -> x.equalsIgnoreCase("id"));
        }
        resultMap = new HashMap<String, Object>();
        resultMap.put("assIds", allAssIds);
        resultMap.put("assDs", resultDs);
        resultMap.put("flexFields", flexFields);
        resultMap.put("acctIdToMasterId", acctIdToMasterIdMap);
        return resultMap;
    }

    private static Map<String, Object> parseAccountFlexField(Map<String, List<Long>> flexField2ValMap) {
        HashSet<Long> assIds = new HashSet<Long>();
        Map<String, DataSet> mapDs = AssServiceUtils.queryFlexfieldToAssist(flexField2ValMap);
        DataSet result = null;
        for (Map.Entry<String, List<Long>> map : flexField2ValMap.entrySet()) {
            String flexField = map.getKey();
            DataSet assValDs = mapDs.get(flexField).select(new String[]{"id", "assval " + flexField});
            List<String> resultFields = AssServiceUtils.getFieldsByDs(result);
            result = result == null ? assValDs : result.join(assValDs, JoinType.INNER).on("id", "id").select(resultFields.toArray(new String[0]), new String[]{flexField}).finish();
        }
        if (result != null) {
            DataSet it = result.copy();
            for (Row row : it) {
                assIds.add(row.getLong("id"));
            }
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("resultDs", result);
        resultMap.put("resultAssIds", assIds);
        return resultMap;
    }

    public static List<String> getFieldsByDs(DataSet dataSet) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (dataSet != null) {
            Field[] fields;
            RowMeta rowMeta = dataSet.getRowMeta();
            for (Field field : fields = rowMeta.getFields()) {
                String fieldAlias = field.getAlias();
                fieldNames.add(fieldAlias);
            }
        }
        return fieldNames;
    }

    public static Map<Long, Long> idToMasterIDMap(List<Long> acctIds, String entityId) {
        HashMap<Long, Long> acctToMasterMap = new HashMap<Long, Long>();
        QFilter fid = new QFilter("id", "in", acctIds);
        DataSet acctSet = QueryServiceHelper.queryDataSet((String)"acctIdToMasterIDMap", (String)entityId, (String)"id,masterid", (QFilter[])new QFilter[]{fid}, null);
        for (Row row : acctSet) {
            long masterId = row.getLong("masterid");
            long id = row.getLong("id");
            acctToMasterMap.put(id, masterId);
        }
        return acctToMasterMap;
    }

    private static Map<String, DataSet> queryFlexfieldToAssist(Map<String, List<Long>> flexField2ValMap) {
        ThreeTuple threeTuple = new ThreeTuple(new HashSet(), new HashSet(), new HashSet());
        flexField2ValMap.forEach((k, v) -> {
            if (Objects.nonNull(v)) {
                ((Set)threeTuple.item1).add(k);
                ((Set)threeTuple.item2).addAll(v);
            } else {
                ((Set)threeTuple.item3).add(k);
            }
        });
        HashMap<String, DataSet> mapDs = new HashMap<String, DataSet>();
        QFilter filters = new QFilter("asstype", "in", threeTuple.item1);
        filters.and(new QFilter("assval", "in", threeTuple.item2));
        filters.or(new QFilter("asstype", "in", threeTuple.item3));
        String selectFields = "hg id, asstype, assval";
        DataSet assValDs = QueryServiceHelper.queryDataSet((String)"GLServiceUtils.queryFlexfieldToAssist", (String)"gl_assist_bd", (String)selectFields, (QFilter[])filters.toArray(), null);
        flexField2ValMap.forEach((k, v) -> {
            if (Objects.nonNull(v)) {
                mapDs.put((String)k, assValDs.filter("asstype='" + k + "'").filter(" assval in (" + StringUtils.join((Iterable)v, (char)',') + ")"));
            } else {
                mapDs.put((String)k, assValDs.filter("asstype='" + k + "'"));
            }
        });
        return mapDs;
    }
}

