/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.fi.ict.mservice.formula.ICalculatorService;
import kd.fi.ict.mservice.formula.Ict4BcmRptFormulaFactory;
import kd.fi.ict.service.formula.Ict4BcmRptFormualService;
import org.apache.commons.io.IOUtils;

public class Ict4BcmRptFormualServiceImpl
implements Ict4BcmRptFormualService {
    private static final Log LOG = LogFactory.getLog(Ict4BcmRptFormualServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormulaDef() throws IOException {
        String formula_def;
        InputStream formula_def_list;
        block10: {
            formula_def_list = null;
            formula_def = "";
            try {
                formula_def_list = Lang.en_US.equals((Object)Lang.get()) ? Thread.currentThread().getContextClassLoader().getResourceAsStream("resources/ictformula/ict_formulas_list.en_US.json") : Thread.currentThread().getContextClassLoader().getResourceAsStream("resources/ictformula/ict_formulas_list.json");
                if (!Objects.nonNull(formula_def_list)) break block10;
                formula_def = IOUtils.toString((InputStream)formula_def_list);
            }
            catch (Throwable throwable) {
                if (Objects.nonNull(formula_def_list)) {
                    Ict4BcmRptFormualServiceImpl.formulaClose(formula_def_list);
                }
                throw throwable;
            }
        }
        if (Objects.nonNull(formula_def_list)) {
            Ict4BcmRptFormualServiceImpl.formulaClose(formula_def_list);
        }
        InputStream formula_catalog_list = null;
        String formula_catalog = "";
        try {
            formula_catalog_list = Thread.currentThread().getContextClassLoader().getResourceAsStream("resources/ictformula/ict_formulas_catalog_list.json");
            if (Objects.nonNull(formula_catalog_list)) {
                formula_catalog = IOUtils.toString((InputStream)formula_catalog_list);
            }
        }
        finally {
            if (Objects.nonNull(formula_catalog_list)) {
                Ict4BcmRptFormualServiceImpl.formulaClose(formula_catalog_list);
            }
        }
        HashMap<String, String> configMap = new HashMap<String, String>(2);
        if (StringUtils.isNotEmpty((String)formula_def) && StringUtils.isNotEmpty((String)formula_catalog)) {
            configMap.put("formula_catalog_list", formula_catalog);
            configMap.put("formula_def_list", formula_def);
        }
        return JSONUtils.toString(configMap);
    }

    public static void formulaClose(InputStream formula_catalog_list) {
        if (formula_catalog_list != null) {
            try {
                formula_catalog_list.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public String dipatchCal(String formulaName, String param) throws IOException {
        ICalculatorService puchAmtService = Ict4BcmRptFormulaFactory.getCalculatorService(formulaName);
        if (Objects.isNull(puchAmtService)) {
            return String.format(ResManager.loadKDString((String)"\u975e\u5185\u90e8\u4ea4\u6613\u6807\u51c6\u53d6\u6570\u516c\u5f0f\uff0c\u53d6\u6570\u516c\u5f0f\u4e3a%s", (String)"Ict4BcmRptFormualServiceImpl_0", (String)"fi-ict-mservice", (Object[])new Object[0]), formulaName);
        }
        return puchAmtService.getCalculatorResult(param);
    }

    public String dispatchBatchCal(String formulaName, String param) throws IOException {
        ICalculatorService batchBalanceService = Ict4BcmRptFormulaFactory.getBatchCalculatorService(formulaName);
        if (Objects.isNull(batchBalanceService)) {
            return String.format(ResManager.loadKDString((String)"\u975e\u5185\u90e8\u4ea4\u6613\u6807\u51c6\u53d6\u6570\u516c\u5f0f\uff0c\u53d6\u6570\u516c\u5f0f\u4e3a%s", (String)"Ict4BcmRptFormualServiceImpl_0", (String)"fi-ict-mservice", (Object[])new Object[0]), formulaName);
        }
        return batchBalanceService.getCalculatorResult(param);
    }
}

