/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.batchquery.account;

import com.google.common.collect.Table;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.ict.mservice.formula.ICalculatorService;
import kd.fi.ict.mservice.formula.batchquery.account.AcctBatchQueryContext;
import kd.fi.ict.mservice.formula.batchquery.account.AcctFloatFormula;
import kd.fi.ict.mservice.formula.batchquery.account.AcctFloatFormulaParse;
import kd.fi.ict.mservice.formula.batchquery.param.FormulaFloatKey;
import kd.fi.ict.mservice.formula.common.facct.AcctFetchType;
import kd.fi.ict.mservice.formula.common.utils.AcctUtil;
import kd.fi.ict.puchamt.AcctPuchAmtQueryExecutor;
import kd.fi.ict.puchamt.acct.AcctPuchAmtQueryParam;

public class AcctBatchCalculatorServiceImpl
implements ICalculatorService {
    private static final Log LOGGER = LogFactory.getLog(AcctBatchCalculatorServiceImpl.class);

    @Override
    public String getCalculatorResult(String param) {
        String resultStr = null;
        try {
            LOGGER.info("ictacct \u53d6\u6570\u53c2\u6570:{}", (Object)param);
            long beforeTime = System.currentTimeMillis();
            AcctFloatFormulaParse parser = new AcctFloatFormulaParse(param);
            ArrayList<AcctFloatFormula> legalFormulaList = new ArrayList<AcctFloatFormula>(8);
            parser.getBookFormulasMap().values().forEach(legalFormulaList::addAll);
            AcctBatchQueryContext context = new AcctBatchQueryContext(parser.getfCommon(), (List<AcctFloatFormula>)legalFormulaList);
            for (AcctFloatFormula formula : legalFormulaList) {
                formula.setErrorMsg(this.checkFormula(context, formula));
                if (StringUtils.isNotBlank((CharSequence)formula.getErrorMsg())) continue;
                HashMap<Long, Integer> acctToAssistStyleMap = new HashMap<Long, Integer>();
                HashMap<Long, Set<Long>> acctToReClassAcctIdsMap = new HashMap<Long, Set<Long>>();
                this.dealReClassAccount(context, formula, acctToAssistStyleMap, acctToReClassAcctIdsMap);
                DataSet balance = this.getBalanceByAssist(context, formula, acctToReClassAcctIdsMap);
                this.reClassBalance(context, formula, balance, acctToReClassAcctIdsMap, acctToAssistStyleMap);
            }
            resultStr = this.getResult(parser, legalFormulaList);
            LOGGER.info("ictacct \u53d6\u6570\u7ed3\u679c\uff1a {}\uff0c \u8017\u65f6\uff1a{}" + resultStr, (Object)(System.currentTimeMillis() - beforeTime));
        }
        catch (Exception e) {
            LOGGER.error("ictacct get balance exception : " + e.getMessage(), (Throwable)e);
        }
        return resultStr;
    }

    private String checkFormula(AcctBatchQueryContext ctx, AcctFloatFormula formula) {
        String errorMsg = this.checkOrg(ctx.getOrgNumberToIdMap(), formula.getOrgNumber());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkOpOrg(ctx.getOrgNumberToIdMap(), formula.getOpOrgNumberSet());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkBookType(ctx.getBookTypeNumberToIdMap(), formula.getBootTypeNumber());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkAccountBook(ctx.getAccountBookMap(), formula.getOrgNumber(), formula.getBootTypeNumber());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkPeriod(ctx.getPeriodMap(), formula.getfKey());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkAccount(formula.getAccountNumberToDynMap());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkAssist(formula, ctx.getAssistMap());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkAmtCalculatorField(formula, ctx.getCurrencyNumberToIdMap());
        return errorMsg;
    }

    private String checkOrg(Map<String, Long> orgNumberToIdMap, String orgNumber) {
        if (!orgNumberToIdMap.containsKey(orgNumber)) {
            return String.format(ResManager.loadKDString((String)"\u672c\u65b9\u7ec4\u7ec7\u7f16\u7801:%s\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"AcctBatchCalculatorServiceImpl_0", (String)"fi-ict-mservice", (Object[])new Object[0]), orgNumber);
        }
        return "";
    }

    private String checkOpOrg(Map<String, Long> orgNumberToIdMap, Set<String> opOrgNumberSet) {
        for (String opOrgNumber : opOrgNumberSet) {
            if (!orgNumberToIdMap.containsKey(opOrgNumber)) continue;
            return "";
        }
        return String.format(ResManager.loadKDString((String)"\u5bf9\u65b9\u7ec4\u7ec7\u7f16\u7801:%s\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"AcctBatchCalculatorServiceImpl_6", (String)"fi-ict-mservice", (Object[])new Object[0]), String.join((CharSequence)",", opOrgNumberSet));
    }

    private String checkBookType(Map<String, Long> bookTypeNumberToIdMap, String bookTypeNumber) {
        if (!bookTypeNumberToIdMap.containsKey(bookTypeNumber)) {
            return String.format(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801:%s\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u8d26\u7c3f\u7c7b\u578b\u4fe1\u606f\u3002", (String)"AcctBatchCalculatorServiceImpl_1", (String)"fi-ict-mservice", (Object[])new Object[0]), bookTypeNumber);
        }
        return "";
    }

    private String checkAccountBook(Map<String, DynamicObject> accountBookMap, String orgNumber, String bookTypeNumber) {
        DynamicObject accountBookInfo = accountBookMap.get(orgNumber + "*" + bookTypeNumber);
        if (accountBookInfo == null) {
            return String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7ec4\u7ec7\u7f16\u7801\uff1a%1$s\uff0c\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801\uff1a%2$s\uff0c\u5bf9\u5e94\u7684\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"AcctBatchCalculatorServiceImpl_2", (String)"fi-ict-mservice", (Object[])new Object[0]), orgNumber, bookTypeNumber);
        }
        return "";
    }

    private String checkPeriod(Map<String, DynamicObject> periodMap, String formulaKey) {
        if (periodMap.isEmpty() || periodMap.get(formulaKey) == null) {
            return ResManager.loadKDString((String)"\u53d6\u4e0d\u5230\u671f\u95f4\uff0c\u8bf7\u67e5\u770b\u516c\u5f0f\u671f\u95f4\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"AcctBatchCalculatorServiceImpl_3", (String)"fi-ict-mservice", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkAccount(Map<String, DynamicObject> accountNumberToDynMap) {
        accountNumberToDynMap.entrySet().removeIf(accountNumberToDynEntry -> accountNumberToDynEntry.getValue() == null);
        if (accountNumberToDynMap.isEmpty()) {
            return ResManager.loadKDString((String)"\u516c\u5f0f\u8bbe\u7f6e\u7684\u79d1\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AcctBatchCalculatorServiceImpl_4", (String)"fi-ict-mservice", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkAssist(AcctFloatFormula formula, Map<String, DynamicObject> assistMap) {
        Set<String> allAssistNumber = formula.getAllAssistNumber();
        for (String assistNumber : allAssistNumber) {
            if (assistMap.get(assistNumber) != null) continue;
            return String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u7f16\u7801\u4e3a\uff1a%s\u7684\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AcctBatchCalculatorServiceImpl_5", (String)"fi-ict-mservice", (Object[])new Object[0]), assistNumber);
        }
        return "";
    }

    private String checkAmtCalculatorField(AcctFloatFormula formula, Map<String, Long> currencyNumberToIdMap) {
        AcctFetchType.AmtCaluatorField amtCalculatorField;
        boolean baseCurrency = true;
        String currencyNumber = formula.getCurrencyNumber();
        if (StringUtils.isNotBlank((CharSequence)currencyNumber) && currencyNumberToIdMap.get(currencyNumber) != null) {
            baseCurrency = false;
        }
        if (Objects.isNull(amtCalculatorField = AcctFetchType.getAmtFieldByType(formula.getPuchType(), formula.getFetchType(), baseCurrency))) {
            return ResManager.loadKDString((String)"\u5bf9\u8d26\u7c7b\u578b\u548c\u53d6\u6570\u7c7b\u578b\u4e3a\u9519\u8bef\u7ec4\u5408\u3002", (String)"AcctBatchCalculatorServiceImpl_8", (String)"fi-ict-mservice", (Object[])new Object[0]);
        }
        return "";
    }

    private void dealReClassAccount(AcctBatchQueryContext ctx, AcctFloatFormula formula, Map<Long, Integer> acctToAssistStyleMap, Map<Long, Set<Long>> acctToReClassAcctIdsMap) {
        int reClassType = formula.getReClassType();
        Map<String, DynamicObject> accountNumberMap = formula.getAccountNumberToDynMap();
        HashSet<Long> accountIdSet = new HashSet<Long>(accountNumberMap.size());
        for (Map.Entry<String, DynamicObject> accountDynEntry : accountNumberMap.entrySet()) {
            DynamicObject accountDyn = accountDynEntry.getValue();
            if (accountDyn == null) continue;
            accountIdSet.add(accountDyn.getLong("id"));
        }
        if (!AcctFetchType.getFetchTypeReclass().contains(formula.getFetchType())) {
            Map<Long, Set<Long>> allDetailedAccountMap = ctx.getAllDetailedAccountMap();
            for (Long accountId : accountIdSet) {
                acctToAssistStyleMap.put(accountId, 2);
                acctToReClassAcctIdsMap.put(accountId, allDetailedAccountMap.get(accountId));
            }
        } else {
            this.acctReClassDeal(reClassType, accountIdSet, acctToAssistStyleMap, acctToReClassAcctIdsMap, ctx, formula.getAllAssistNumber());
        }
        LOGGER.info("AcctBatchCalculatorServiceImpl_dealReClassAccount acctToReClassAcctIdsMap\uff1a" + acctToReClassAcctIdsMap);
        LOGGER.info("AcctBatchCalculatorServiceImpl_dealReClassAccount acctToAssistStyleMap\uff1a" + acctToAssistStyleMap);
    }

    private void acctReClassDeal(int reClassType, Set<Long> accountIdSet, Map<Long, Integer> acctToAssistStyleMap, Map<Long, Set<Long>> acctToReClassAcctIdsMap, AcctBatchQueryContext ctx, Set<String> assistNumberSet) {
        Map<Long, Set<Long>> directChildAccountMap = ctx.getDirectChildAccountMap();
        Map<Long, Set<Long>> allDetailedAccountMap = ctx.getAllDetailedAccountMap();
        Map<Long, Set<String>> accountToAssistMap = ctx.getAccountIdToFlexFieldMap();
        boolean isSelectAssist = !assistNumberSet.isEmpty();
        switch (reClassType) {
            case 1: {
                for (Long accountId : accountIdSet) {
                    boolean isContainAssist = this.acctIsContainAssistMap(accountToAssistMap, accountId);
                    if (isSelectAssist) {
                        HashSet<Long> acctIds = new HashSet<Long>();
                        acctIds.add(accountId);
                        acctToReClassAcctIdsMap.put(accountId, acctIds);
                        acctToAssistStyleMap.put(accountId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        Set<Long> directLeafIds = directChildAccountMap.get(accountId);
                        acctToReClassAcctIdsMap.put(accountId, directLeafIds);
                        acctToAssistStyleMap.put(accountId, 1);
                        continue;
                    }
                    Set<Long> allLeafIds = allDetailedAccountMap.get(accountId);
                    acctToReClassAcctIdsMap.put(accountId, allLeafIds);
                    acctToAssistStyleMap.put(accountId, 3);
                }
                break;
            }
            case 2: {
                for (Long accountId : accountIdSet) {
                    Set<Long> allLeafIds;
                    boolean isContainAssist = this.acctIsContainAssistMap(accountToAssistMap, accountId);
                    if (isSelectAssist) {
                        allLeafIds = allDetailedAccountMap.get(accountId);
                        acctToReClassAcctIdsMap.put(accountId, allLeafIds);
                        acctToAssistStyleMap.put(accountId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        allLeafIds = allDetailedAccountMap.get(accountId);
                        acctToReClassAcctIdsMap.put(accountId, allLeafIds);
                        acctToAssistStyleMap.put(accountId, 3);
                        continue;
                    }
                    allLeafIds = allDetailedAccountMap.get(accountId);
                    acctToReClassAcctIdsMap.put(accountId, allLeafIds);
                    acctToAssistStyleMap.put(accountId, 3);
                }
                break;
            }
            case 3: {
                for (Long accountId : accountIdSet) {
                    boolean isContainAssist = this.acctIsContainAssistMap(accountToAssistMap, accountId);
                    Set<Long> directLeafIds = directChildAccountMap.get(accountId);
                    if (isSelectAssist) {
                        acctToReClassAcctIdsMap.put(accountId, directLeafIds);
                        acctToAssistStyleMap.put(accountId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToReClassAcctIdsMap.put(accountId, directLeafIds);
                        acctToAssistStyleMap.put(accountId, 1);
                        continue;
                    }
                    acctToReClassAcctIdsMap.put(accountId, directLeafIds);
                    acctToAssistStyleMap.put(accountId, 3);
                }
                break;
            }
            case 4: {
                for (Long accountId : accountIdSet) {
                    boolean isContainAssist = this.acctIsContainAssistMap(accountToAssistMap, accountId);
                    Set<Long> allLeafIds = allDetailedAccountMap.get(accountId);
                    acctToReClassAcctIdsMap.put(accountId, allLeafIds);
                    if (isSelectAssist) {
                        acctToAssistStyleMap.put(accountId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToAssistStyleMap.put(accountId, 1);
                        continue;
                    }
                    acctToAssistStyleMap.put(accountId, 1);
                }
                break;
            }
            case 5: {
                for (Long accountId : accountIdSet) {
                    boolean isContainAssist = this.acctIsContainAssistMap(accountToAssistMap, accountId);
                    Set<Long> directLeafIds = directChildAccountMap.get(accountId);
                    if (isSelectAssist) {
                        acctToReClassAcctIdsMap.put(accountId, directLeafIds);
                        acctToAssistStyleMap.put(accountId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToReClassAcctIdsMap.put(accountId, directLeafIds);
                        acctToAssistStyleMap.put(accountId, 1);
                        continue;
                    }
                    acctToReClassAcctIdsMap.put(accountId, directLeafIds);
                    acctToAssistStyleMap.put(accountId, 1);
                }
                break;
            }
            case 6: {
                for (Long accountId : accountIdSet) {
                    HashSet<Long> acctIds;
                    boolean isContainAssist = this.acctIsContainAssistMap(accountToAssistMap, accountId);
                    if (isSelectAssist) {
                        Set<Long> allLeafIds = allDetailedAccountMap.get(accountId);
                        acctToReClassAcctIdsMap.put(accountId, allLeafIds);
                        acctToAssistStyleMap.put(accountId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctIds = new HashSet<Long>();
                        acctIds.add(accountId);
                        acctToReClassAcctIdsMap.put(accountId, acctIds);
                        acctToAssistStyleMap.put(accountId, 1);
                        continue;
                    }
                    acctIds = new HashSet();
                    acctIds.add(accountId);
                    acctToReClassAcctIdsMap.put(accountId, acctIds);
                    acctToAssistStyleMap.put(accountId, 1);
                }
                break;
            }
        }
    }

    private boolean acctIsContainAssistMap(Map<Long, Set<String>> accountToAssistMap, long accountId) {
        boolean isContainAssist = true;
        Set<String> flexFields = accountToAssistMap.get(accountId);
        if (flexFields == null || flexFields.isEmpty()) {
            isContainAssist = false;
        }
        return isContainAssist;
    }

    private DataSet getBalanceByAssist(AcctBatchQueryContext ctx, AcctFloatFormula formula, Map<Long, Set<Long>> acctToReClassAcctIdsMap) {
        long startTime = System.currentTimeMillis();
        int assistSize = formula.getAllAssistNumber().size();
        DataSet balance = assistSize > 2 ? this.queryBalanceByORM(ctx, formula, acctToReClassAcctIdsMap) : this.queryBalanceJoinAssist(ctx, formula, acctToReClassAcctIdsMap);
        long endTime = System.currentTimeMillis();
        LOGGER.info("get balance cost time\uff1a" + (endTime - startTime));
        return balance;
    }

    private DataSet queryBalanceByORM(AcctBatchQueryContext ctx, AcctFloatFormula formula, Map<Long, Set<Long>> acctToReClassAcctIdsMap) {
        List<String> fieldList;
        boolean isBaseCurrency = true;
        String currencyNumber = formula.getCurrencyNumber();
        if (StringUtils.isNotBlank((CharSequence)currencyNumber) && ctx.getCurrencyNumberToIdMap().get(currencyNumber) != null) {
            isBaseCurrency = false;
        }
        HashSet<String> sumFields = new HashSet<String>();
        String fetchType = formula.getFetchType();
        AcctFetchType.AmtCaluatorField fetchTypeField = AcctFetchType.getAmtFieldByType(formula.getPuchType(), fetchType, isBaseCurrency);
        if (fetchTypeField != null && (fieldList = fetchTypeField.getCalFields()) != null) {
            sumFields.addAll(fieldList);
        }
        boolean isReClass = AcctFetchType.getFetchTypeReclass().contains(fetchType);
        String selector = this.buildSelectFields(formula, isBaseCurrency, sumFields, isReClass);
        HashSet<String> allAssistNumberSet = new HashSet<String>(formula.getAssistToValueNumberMap().keySet());
        allAssistNumberSet.addAll(formula.getAssistToRangeValueMap().keySet());
        if (isReClass) {
            allAssistNumberSet.addAll(formula.getAllValueAssistNumberSet());
        }
        Map<String, DynamicObject> assistMap = ctx.getAssistMap();
        StringBuilder assgrpStr = new StringBuilder();
        for (String assistNumber : allAssistNumberSet) {
            DynamicObject assistDyn = assistMap.get(assistNumber);
            if (assistDyn == null) continue;
            assgrpStr.append(",");
            assgrpStr.append(" assgrp_");
            assgrpStr.append(assistDyn.getString("flexfield"));
            assgrpStr.append(".assval ");
            assgrpStr.append(assistDyn.getString("flexfield"));
        }
        selector = selector + assgrpStr;
        AcctPuchAmtQueryParam param = this.buildGetBalanceParamByORM(ctx, formula, acctToReClassAcctIdsMap, isReClass, allAssistNumberSet, selector);
        LOGGER.info("AcctBatchCalculatorServiceImpl_queryBalance getBalance param\uff1a" + param);
        DataSet balance = AcctPuchAmtQueryExecutor.getInstance().getPuchAmt(param);
        balance = this.filterBalanceByAcctNumber(balance, acctToReClassAcctIdsMap, ctx.getAccountIdToNumberMap());
        return balance;
    }

    private AcctPuchAmtQueryParam buildGetBalanceParamByORM(AcctBatchQueryContext ctx, AcctFloatFormula formula, Map<Long, Set<Long>> acctToReClassAcctIdsMap, boolean isReClass, Set<String> allAssistNumberSet, String selector) {
        AcctPuchAmtQueryParam.AcctParam acctParam;
        AcctPuchAmtQueryParam queryParam = this.buildGetBalanceParam(ctx, formula, acctToReClassAcctIdsMap, selector);
        MainEntityType balanceMainEntityType = this.getBalMainEntityType(allAssistNumberSet, ctx.getAssistMap());
        if (balanceMainEntityType != null) {
            queryParam.setPuchEntityType(balanceMainEntityType);
        }
        ArrayList<QFilter> customFilters = (acctParam = queryParam.getAcctParam()).getCustomFilter() == null ? new ArrayList() : acctParam.getCustomFilter();
        this.setAssistFilter(formula.getOrgNumber(), customFilters, formula.getAssistToValueNumberMap(), formula.getAssistToRangeValueMap(), formula.getAllValueAssistNumberSet(), ctx.getAssistMap(), ctx.getAssistValueNumberToIdTable(), ctx.getAssistRangeValToIdTable(), isReClass);
        acctParam.setCustomFilter(customFilters);
        return queryParam;
    }

    private MainEntityType getBalMainEntityType(Set<String> allAssistNumberSet, Map<String, DynamicObject> assistMap) {
        try {
            MainEntityType balEntity = (MainEntityType)EntityMetadataCache.getDataEntityType((String)"ict_acctpuchamt").clone();
            this.registerProperty(balEntity, allAssistNumberSet, assistMap);
            return balEntity;
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private void registerProperty(MainEntityType balEntity, Set<String> allAssistNumberSet, Map<String, DynamicObject> assistMap) {
        for (String assistNumber : allAssistNumberSet) {
            DynamicObject assistDyn = assistMap.get(assistNumber);
            if (assistDyn == null) continue;
            String valueSource = assistDyn.getString("valuesource");
            String flexField = assistDyn.getString("flexfield");
            DynamicObjectType type = this.getFlexDataType(valueSource);
            BasedataProp prop = new BasedataProp();
            prop.setAlias("fassgrpid");
            prop.setName("assgrp_" + flexField);
            prop.setComplexType((IDataEntityType)type);
            ((LongProp)type.getProperties().get((Object)"id")).setAlias("fid");
            balEntity.addProperty((DynamicProperty)prop);
        }
    }

    private DynamicObjectType getFlexDataType(String valueSource) {
        String tableName = StringUtils.isBlank((CharSequence)valueSource) ? "gl_assist_txt" : "gl_assist_bd";
        try {
            return (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)tableName).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private void setAssistFilter(String orgNumber, List<QFilter> customFilters, Map<String, List<String>> assistToValueNumberMap, Map<String, List<String>> assistToRangeValueMap, Set<String> allValueAssistNumberSet, Map<String, DynamicObject> assistMap, Table<String, String, Map<String, Set<Object>>> assistValueNumberToIdTable, Table<String, String, Map<String, Set<Object>>> assistRangeValToIdTable, boolean isReClass) {
        QFilter valueFilter;
        QFilter flexFilter;
        String flexField;
        DynamicObject assistDyn;
        String assistNumber;
        String assgrpPrefix = "assgrp_";
        for (Map.Entry<String, List<String>> assistToValueNumberEntry : assistToValueNumberMap.entrySet()) {
            assistNumber = assistToValueNumberEntry.getKey();
            List<String> assistValueNumberList = assistToValueNumberEntry.getValue();
            assistDyn = assistMap.get(assistNumber);
            if (assistDyn == null) continue;
            flexField = assistDyn.getString("flexfield");
            HashSet<Integer> assistValueIdSet = new HashSet<Integer>(assistValueNumberList.size());
            for (String assistValueNumber : assistValueNumberList) {
                Set assistValueId = (Set)((Map)assistValueNumberToIdTable.get((Object)orgNumber, (Object)assistNumber)).get(assistValueNumber);
                if (CollectionUtils.isNotEmpty((Collection)assistValueId)) {
                    assistValueIdSet.addAll(assistValueId);
                    continue;
                }
                assistValueIdSet.add(0);
            }
            if (!assistValueIdSet.isEmpty()) {
                flexFilter = new QFilter(assgrpPrefix + flexField + ".asstype", "=", (Object)flexField);
                valueFilter = new QFilter(assgrpPrefix + flexField + ".assval", "in", assistValueIdSet);
                customFilters.add(flexFilter);
                customFilters.add(valueFilter);
                continue;
            }
            customFilters.add(QFilter.join((String)(assgrpPrefix + flexField), (String)(assgrpPrefix + flexField + ".hg"), (QFilter)new QFilter(assgrpPrefix + flexField + ".asstype", "=", (Object)flexField), (ORMHint.JoinHint)ORMHint.JoinHint.LEFT, (boolean)false));
        }
        for (Map.Entry<String, List<String>> assistToRangeValueEntry : assistToRangeValueMap.entrySet()) {
            assistNumber = assistToRangeValueEntry.getKey();
            List<String> rangeValueList = assistToRangeValueEntry.getValue();
            assistDyn = assistMap.get(assistNumber);
            if (assistDyn == null) continue;
            flexField = assistDyn.getString("flexfield");
            HashSet<Integer> allRangeValueIdSet = new HashSet<Integer>(rangeValueList.size());
            for (String rangeValue : rangeValueList) {
                Set rangeValueIdSet = (Set)((Map)assistRangeValToIdTable.get((Object)orgNumber, (Object)assistNumber)).get(rangeValue);
                if (CollectionUtils.isNotEmpty((Collection)rangeValueIdSet)) {
                    allRangeValueIdSet.addAll(rangeValueIdSet);
                    continue;
                }
                allRangeValueIdSet.add(0);
            }
            if (!allRangeValueIdSet.isEmpty()) {
                flexFilter = new QFilter(assgrpPrefix + flexField + ".asstype", "=", (Object)flexField);
                valueFilter = new QFilter(assgrpPrefix + flexField + ".assval", "in", allRangeValueIdSet);
                customFilters.add(flexFilter);
                customFilters.add(valueFilter);
                continue;
            }
            customFilters.add(QFilter.join((String)(assgrpPrefix + flexField), (String)(assgrpPrefix + flexField + ".hg"), (QFilter)new QFilter(assgrpPrefix + flexField + ".asstype", "=", (Object)flexField), (ORMHint.JoinHint)ORMHint.JoinHint.LEFT, (boolean)false));
        }
        if (isReClass) {
            for (String assistNumber2 : allValueAssistNumberSet) {
                DynamicObject assistDyn2 = assistMap.get(assistNumber2);
                if (assistDyn2 == null) continue;
                String flexField2 = assistDyn2.getString("flexfield");
                String valueType = assistDyn2.getString("valuetype");
                QFilter flexFilter2 = new QFilter(assgrpPrefix + flexField2 + ".asstype", "=", (Object)flexField2);
                QFilter valueFilter2 = null;
                if ("3".equals(valueType)) {
                    flexFilter2 = new QFilter(assgrpPrefix + flexField2 + ".assval", "!=", null);
                } else {
                    valueFilter2 = new QFilter(assgrpPrefix + flexField2 + ".assval", "!=", (Object)0L);
                }
                customFilters.add(flexFilter2);
                customFilters.add(valueFilter2);
            }
        }
    }

    private DataSet queryBalanceJoinAssist(AcctBatchQueryContext ctx, AcctFloatFormula formula, Map<Long, Set<Long>> acctToReClassAcctIdsMap) {
        List<String> fieldList;
        boolean isBaseCurrency = true;
        String currencyNumber = formula.getCurrencyNumber();
        if (StringUtils.isNotBlank((CharSequence)currencyNumber) && ctx.getCurrencyNumberToIdMap().get(currencyNumber) != null) {
            isBaseCurrency = false;
        }
        HashSet<String> sumFields = new HashSet<String>();
        String fetchType = formula.getFetchType();
        AcctFetchType.AmtCaluatorField fetchTypeField = AcctFetchType.getAmtFieldByType(formula.getPuchType(), fetchType, isBaseCurrency);
        if (fetchTypeField != null && (fieldList = fetchTypeField.getCalFields()) != null) {
            sumFields.addAll(fieldList);
        }
        boolean isReClass = AcctFetchType.getFetchTypeReclass().contains(fetchType);
        String selector = this.buildSelectFields(formula, isBaseCurrency, sumFields, isReClass);
        AcctPuchAmtQueryParam param = this.buildGetBalanceParam(ctx, formula, acctToReClassAcctIdsMap, selector);
        LOGGER.info("AcctBatchCalculatorServiceImpl_queryBalance getBalance param\uff1a" + param);
        DataSet balance = AcctPuchAmtQueryExecutor.getInstance().getPuchAmt(param);
        balance = this.balanceJoinAssist(balance, ctx, formula, isReClass, sumFields);
        balance = this.filterBalanceByAcctNumber(balance, acctToReClassAcctIdsMap, ctx.getAccountIdToNumberMap());
        Set<String> allAssistNumberSet = formula.getAllAssistNumber();
        balance = AcctUtil.filterBalanceByAssist(balance, allAssistNumberSet, ctx.getAssistMap());
        return balance;
    }

    private String buildSelectFields(AcctFloatFormula formula, boolean isBaseCurrency, Set<String> sumFields, boolean isReClass) {
        HashSet<String> balFields = new HashSet<String>();
        balFields.add("org");
        balFields.add("oporg");
        if (!isBaseCurrency) {
            balFields.add("currency");
        }
        balFields.add("account.number account");
        if (isReClass || formula.getAllAssistNumber().size() > 0) {
            balFields.add("assgrp hg");
        }
        balFields.addAll(sumFields);
        String selFields = ((Object)balFields).toString();
        selFields = selFields.substring(1, selFields.length() - 1);
        return selFields;
    }

    private AcctPuchAmtQueryParam buildGetBalanceParam(AcctBatchQueryContext ctx, AcctFloatFormula formula, Map<Long, Set<Long>> acctToReClassAcctIdsMap, String selector) {
        AcctPuchAmtQueryParam queryParam = new AcctPuchAmtQueryParam();
        queryParam.setSelector(selector);
        Map<String, Long> orgNumberToIdMap = ctx.getOrgNumberToIdMap();
        Long[] orgIds = new Long[]{orgNumberToIdMap.get(formula.getOrgNumber())};
        queryParam.setOrgIds(orgIds);
        HashSet<Long> opOrgIdSet = new HashSet<Long>(8);
        for (String opOrgNumber : formula.getOpOrgNumberSet()) {
            opOrgIdSet.add(orgNumberToIdMap.getOrDefault(opOrgNumber, 0L));
        }
        queryParam.setOpOrgIds(opOrgIdSet.toArray(new Long[0]));
        DynamicObject accountBookInfo = ctx.getAccountBookMap().get(formula.getOrgNumber() + "*" + formula.getBootTypeNumber());
        queryParam.setBookTypeId(Long.valueOf(accountBookInfo.getLong("bookstype.id")));
        queryParam.setAccountTableId(ctx.getAccountTableIdMap().get(formula.getfKey()));
        queryParam.setBeginPeriodId(formula.getStartPeriodId());
        queryParam.setEndPeriodID(formula.getEndPeriodId());
        AcctPuchAmtQueryParam.AcctParam acctParam = new AcctPuchAmtQueryParam.AcctParam();
        queryParam.setAcctParam(acctParam);
        acctParam.setSpecialAccount(false);
        Set<String> accountNumberSet = formula.getAccountNumberToDynMap().keySet();
        if (!accountNumberSet.isEmpty()) {
            Set<String> allAccountNumberSet = this.dealLeafAcctNumbers(formula.getAssistToValueNumberMap().keySet(), ctx.getAssistMap(), formula.getAccountNumberToDynMap(), acctToReClassAcctIdsMap, ctx.getAccountIdToFlexFieldMap(), ctx.getAccountIdToNumberMap(), ctx.getAllDetailedAccountMap());
            acctParam.setOnlyLeafAcctAmt(false);
            acctParam.setAccountFilter(new QFilter("number", "in", allAccountNumberSet));
        }
        boolean isBaseCurrency = true;
        String currencyNumber = formula.getCurrencyNumber();
        if (StringUtils.isNotBlank((CharSequence)currencyNumber) && ctx.getCurrencyNumberToIdMap().get(currencyNumber) != null) {
            isBaseCurrency = false;
        }
        if (!isBaseCurrency) {
            acctParam.setCurrencyIds(new Long[]{ctx.getCurrencyNumberToIdMap().get(currencyNumber)});
        }
        return queryParam;
    }

    private Set<String> dealLeafAcctNumbers(Set<String> assistNumberSet, Map<String, DynamicObject> assistMap, Map<String, DynamicObject> accountNumberMap, Map<Long, Set<Long>> acctToReClassAcctIdsMap, Map<Long, Set<String>> accountIdToFlexFieldMap, Map<Long, String> accountIdToNumberMap, Map<Long, Set<Long>> detailAccountIdMap) {
        if (!assistNumberSet.isEmpty()) {
            HashSet<String> flexFieldSet = new HashSet<String>(assistNumberSet.size());
            for (String string : assistNumberSet) {
                DynamicObject dynamicObject = assistMap.get(string);
                String string2 = dynamicObject.getString("flexfield");
                flexFieldSet.add(string2);
            }
            HashSet<Long> allReClassAccountIdSet = new HashSet<Long>(8);
            for (Map.Entry<String, DynamicObject> entry : accountNumberMap.entrySet()) {
                DynamicObject dynamicObject = entry.getValue();
                if (dynamicObject == null) continue;
                Set<Long> reClassAccountIdSet = acctToReClassAcctIdsMap.get(dynamicObject.getLong("id"));
                allReClassAccountIdSet.addAll(reClassAccountIdSet);
            }
            HashSet hashSet = new HashSet(8);
            for (Long l : allReClassAccountIdSet) {
                hashSet.addAll(detailAccountIdMap.get(l));
            }
            HashSet<Long> hashSet2 = new HashSet<Long>(hashSet.size());
            for (Long detailAccountId : hashSet) {
                Set<String> accountToFlexFieldSet = accountIdToFlexFieldMap.get(detailAccountId);
                if (accountToFlexFieldSet == null || !accountToFlexFieldSet.containsAll(flexFieldSet)) continue;
                hashSet2.add(detailAccountId);
            }
            HashSet<String> hashSet3 = new HashSet<String>(hashSet2.size());
            for (Long accountId : hashSet2) {
                hashSet3.add(accountIdToNumberMap.get(accountId));
            }
            return hashSet3;
        }
        return accountNumberMap.keySet();
    }

    private DataSet balanceJoinAssist(DataSet balance, AcctBatchQueryContext ctx, AcctFloatFormula formula, boolean isReClass, Set<String> sumFiledSet) {
        Map<String, DataSet> flexFieldToHgMap = this.getHgByFlexField(ctx, formula);
        HashSet<String> flexFields = new HashSet<String>();
        for (Map.Entry<String, DataSet> flexFieldToHgEntry : flexFieldToHgMap.entrySet()) {
            String flexField = flexFieldToHgEntry.getKey();
            DataSet assistDataSet = flexFieldToHgEntry.getValue();
            if (assistDataSet != null) {
                assistDataSet = assistDataSet.copy();
                List<String> balFields = AcctUtil.getDataSetCols(balance);
                flexFields.add(flexField);
                List<String> assistList = AcctUtil.getDataSetCols(assistDataSet);
                assistList.remove("hg");
                balance = balance.join(assistDataSet, JoinType.LEFT).on("hg", "hg").select(balFields.toArray(new String[0]), assistList.toArray(new String[0])).finish();
                continue;
            }
            balance = balance.addNullField(flexField);
        }
        if (isReClass && !flexFields.isEmpty()) {
            List<String> balFields = AcctUtil.getDataSetCols(balance);
            balFields.removeAll(sumFiledSet);
            balFields.remove("hg");
            GroupbyDataSet gDataSet = balance.groupBy(balFields.toArray(new String[0]));
            for (String sumField : sumFiledSet) {
                gDataSet.sum(sumField);
            }
            balance = gDataSet.finish();
        }
        return balance;
    }

    private Map<String, DataSet> getHgByFlexField(AcctBatchQueryContext ctx, AcctFloatFormula formula) {
        String flexField;
        DynamicObject assistDyn;
        Map<String, DynamicObject> assistMap = ctx.getAssistMap();
        Table<String, String, Map<String, Set<Object>>> assistValueNumberToIdTable = ctx.getAssistValueNumberToIdTable();
        Table<String, String, Map<String, Set<Object>>> assistRangeValToIdTable = ctx.getAssistRangeValToIdTable();
        Map<String, DataSet> allFlexFieldToHgMap = ctx.getFlexFieldToHgMap();
        HashMap<String, DataSet> flexFieldToHgMap = new HashMap<String, DataSet>(8);
        String orgNumber = formula.getOrgNumber();
        Map<String, List<String>> assistToValueNumberMap = formula.getAssistToValueNumberMap();
        for (Map.Entry<String, List<String>> entry : assistToValueNumberMap.entrySet()) {
            String string = entry.getKey();
            List<String> valueNumberList = entry.getValue();
            assistDyn = assistMap.get(string);
            if (assistDyn == null || !CollectionUtils.isNotEmpty(valueNumberList)) continue;
            flexField = assistDyn.getString("flexfield");
            HashSet assistValueIdSet = new HashSet(valueNumberList.size());
            for (String valueNumber : valueNumberList) {
                if (((Map)assistValueNumberToIdTable.get((Object)orgNumber, (Object)string)).get(valueNumber) == null) continue;
                assistValueIdSet.addAll((Collection)((Map)assistValueNumberToIdTable.get((Object)orgNumber, (Object)string)).get(valueNumber));
            }
            DataSet dataSet = allFlexFieldToHgMap.get(flexField);
            if (dataSet != null) {
                DataSet copyDataSet = dataSet.copy();
                HashMap flexValsMap = new HashMap(8);
                flexValsMap.put("var1", assistValueIdSet);
                flexFieldToHgMap.put(flexField, copyDataSet.filter(flexField + " in var1 ", flexValsMap));
                continue;
            }
            flexFieldToHgMap.put(flexField, null);
        }
        Map<String, List<String>> assistToRangeValueMap = formula.getAssistToRangeValueMap();
        for (Map.Entry<String, List<String>> entry : assistToRangeValueMap.entrySet()) {
            String assistNumber = entry.getKey();
            List<String> rangeValueList = entry.getValue();
            DynamicObject assistDyn2 = assistMap.get(assistNumber);
            if (assistDyn2 == null || !CollectionUtils.isNotEmpty(rangeValueList)) continue;
            String flexField2 = assistDyn2.getString("flexfield");
            HashSet rangeValueIdSet = new HashSet(rangeValueList.size());
            for (String rangeValue : rangeValueList) {
                if (((Map)assistRangeValToIdTable.get((Object)orgNumber, (Object)assistNumber)).get(rangeValue) == null) continue;
                rangeValueIdSet.addAll((Collection)((Map)assistRangeValToIdTable.get((Object)orgNumber, (Object)assistNumber)).get(rangeValue));
            }
            DataSet dataSet = allFlexFieldToHgMap.get(flexField2);
            if (dataSet != null) {
                DataSet copyDataSet = dataSet.copy();
                HashMap flexValsMap = new HashMap(8);
                flexValsMap.put("var1", rangeValueIdSet);
                flexFieldToHgMap.put(flexField2, copyDataSet.filter(flexField2 + " in var1 ", flexValsMap));
                continue;
            }
            flexFieldToHgMap.put(flexField2, null);
        }
        Set<String> set = formula.getAllValueAssistNumberSet();
        for (String assistNumber : set) {
            assistDyn = assistMap.get(assistNumber);
            if (assistDyn == null) continue;
            flexField = assistDyn.getString("flexfield");
            DataSet dataSet = allFlexFieldToHgMap.get(flexField);
            DataSet copyDataSet = null;
            if (dataSet != null) {
                copyDataSet = dataSet.copy();
            }
            flexFieldToHgMap.put(flexField, copyDataSet);
        }
        return flexFieldToHgMap;
    }

    private DataSet filterBalanceByAcctNumber(DataSet balance, Map<Long, Set<Long>> acctToReClassAcctIdsMap, Map<Long, String> accountIdToNumberMap) {
        Set<String> accountNumberSet = this.getAccountNumber(acctToReClassAcctIdsMap, accountIdToNumberMap);
        if (!accountNumberSet.isEmpty()) {
            StringBuilder accountNumberFilter = new StringBuilder();
            accountNumberFilter.append("account in (");
            accountNumberSet.forEach(number -> accountNumberFilter.append("\"").append((String)number).append("\"").append(","));
            if (accountNumberFilter.length() > 0) {
                accountNumberFilter.delete(accountNumberFilter.length() - 1, accountNumberFilter.length()).append(")");
            }
            return balance.filter(accountNumberFilter.toString());
        }
        return balance;
    }

    private Set<String> getAccountNumber(Map<Long, Set<Long>> acctToReClassAcctIdsMap, Map<Long, String> accountIdToNumberMap) {
        HashSet<String> accountNumberSet = new HashSet<String>(8);
        for (Set<Long> accountSet : acctToReClassAcctIdsMap.values()) {
            accountSet.forEach(id -> accountNumberSet.add((String)accountIdToNumberMap.get(id)));
        }
        return accountNumberSet;
    }

    private void reClassBalance(AcctBatchQueryContext ctx, AcctFloatFormula formula, DataSet balance, Map<Long, Set<Long>> acctToReClassAcctIdsMap, Map<Long, Integer> acctToAssistStyleMap) {
        long startTime = System.currentTimeMillis();
        Table<String, String, Map<Object, Set<String>>> assistValIdToNumTable = ctx.getAssistValIdToNumTable();
        Map assistValIdToNumMap = assistValIdToNumTable.row((Object)formula.getOrgNumber());
        AcctFetchType.AmtCaluatorField amtCalculatorField = this.getAmtCalculatorField(formula, ctx.getCurrencyNumberToIdMap());
        HashMap<Long, String> orgIdToNumberMap = new HashMap<Long, String>(8);
        for (Map.Entry<String, Long> orgNumberToIdEntry : ctx.getOrgNumberToIdMap().entrySet()) {
            orgIdToNumberMap.put(orgNumberToIdEntry.getValue(), orgNumberToIdEntry.getKey());
        }
        this.sumBalanceByAssist(balance, formula, ctx.getAssistMap(), amtCalculatorField, assistValIdToNumMap, acctToAssistStyleMap, acctToReClassAcctIdsMap, ctx.getAccountIdToNumberMap(), orgIdToNumberMap);
        long endTime = System.currentTimeMillis();
        LOGGER.info("sum balance cost all time\uff1a" + (endTime - startTime));
    }

    private AcctFetchType.AmtCaluatorField getAmtCalculatorField(AcctFloatFormula formula, Map<String, Long> currencyNumberToIdMap) {
        boolean isBaseCurrency = true;
        String currencyNumber = formula.getCurrencyNumber();
        if (StringUtils.isNotBlank((CharSequence)currencyNumber) && currencyNumberToIdMap.get(currencyNumber) != null) {
            isBaseCurrency = false;
        }
        String fetchType = formula.getFetchType();
        AcctFetchType.AmtCaluatorField amtCaluatorField = AcctFetchType.getAmtFieldByType(formula.getPuchType(), fetchType, isBaseCurrency);
        if (amtCaluatorField == null && StringUtils.isBlank((CharSequence)formula.getErrorMsg())) {
            formula.setErrorMsg(String.format(ResManager.loadKDString((String)"%s\u53d6\u6570\u7c7b\u578b\u4e0d\u652f\u6301\u3002", (String)"AcctBatchCalculatorServiceImpl_7", (String)"fi-gl-mservice", (Object[])new Object[0]), fetchType));
        }
        return amtCaluatorField;
    }

    private void sumBalanceByAssist(DataSet balance, AcctFloatFormula formula, Map<String, DynamicObject> assistMap, AcctFetchType.AmtCaluatorField amtCalculatorField, Map<String, Map<Object, Set<String>>> assistValIdToNumMap, Map<Long, Integer> acctToAssistStyleMap, Map<Long, Set<Long>> acctToReClassAcctIdsMap, Map<Long, String> accountIdToNumberMap, Map<Long, String> orgIdToNumberMap) {
        long startTime = System.currentTimeMillis();
        List<String> floatTypeNumberList = formula.getFloatTypeNumberList();
        boolean isReClass = AcctFetchType.getFetchTypeReclass().contains(formula.getFetchType());
        Map<FormulaFloatKey, BigDecimal> resultMap = formula.getResultMap();
        if (!isReClass) {
            this.sumBalanceNoReClass(balance, resultMap, floatTypeNumberList, amtCalculatorField, assistMap, assistValIdToNumMap, orgIdToNumberMap);
        } else {
            this.sumBalanceReClass(balance, floatTypeNumberList, amtCalculatorField, assistMap, assistValIdToNumMap, formula, acctToAssistStyleMap, acctToReClassAcctIdsMap, accountIdToNumberMap, orgIdToNumberMap);
        }
        long endTime = System.currentTimeMillis();
        LOGGER.info("sum balance cost time\uff1a" + (endTime - startTime));
    }

    private void sumBalanceNoReClass(DataSet balance, Map<FormulaFloatKey, BigDecimal> resultMap, List<String> floatTypeNumberList, AcctFetchType.AmtCaluatorField amtCalculatorField, Map<String, DynamicObject> assistMap, Map<String, Map<Object, Set<String>>> assistValIdToNumMap, Map<Long, String> orgIdToNumberMap) {
        long startTime = System.currentTimeMillis();
        long executeTime = 0L;
        for (Row row : balance) {
            Set<Map<String, Object>> assistValueKeys = AcctUtil.buildAssistValueKeys(floatTypeNumberList, assistMap, row, assistValIdToNumMap);
            BigDecimal amtRow = AcctFetchType.rowCountByFetchType(row, amtCalculatorField);
            String opOrgNumber = orgIdToNumberMap.get(row.getLong("oporg"));
            Set<FormulaFloatKey> formulaFloatKeySet = AcctUtil.buildFormulaFloatKey(opOrgNumber, assistValueKeys);
            for (FormulaFloatKey formulaFloatKey : formulaFloatKeySet) {
                BigDecimal amount = resultMap.computeIfAbsent(formulaFloatKey, key -> new BigDecimal("0"));
                amount = amount.add(amtRow);
                resultMap.put(formulaFloatKey, amount);
                ++executeTime;
            }
        }
        long endTime = System.currentTimeMillis();
        LOGGER.info("sum balance by no reclass execute time\uff1a" + executeTime);
        LOGGER.info("sum balance by no reclass cost time\uff1a" + (endTime - startTime));
    }

    private void sumBalanceReClass(DataSet balance, List<String> floatTypeNumberList, AcctFetchType.AmtCaluatorField amtCalculatorField, Map<String, DynamicObject> assistMap, Map<String, Map<Object, Set<String>>> assistValIdToNumMap, AcctFloatFormula formula, Map<Long, Integer> acctToAssistStyleMap, Map<Long, Set<Long>> acctToReClassAcctIdsMap, Map<Long, String> accountIdToNumberMap, Map<Long, String> orgIdToNumberMap) {
        long startTime = System.currentTimeMillis();
        Map<String, Integer> acctNumToAssistStyleMap = this.getAssistStyleMap(formula, acctToReClassAcctIdsMap, acctToAssistStyleMap, accountIdToNumberMap);
        long executeTime = 0L;
        for (Row row : balance) {
            Set<Map<String, Object>> assistValueKeys = AcctUtil.buildAssistValueKeys(floatTypeNumberList, assistMap, row, assistValIdToNumMap);
            BigDecimal amtRow = AcctFetchType.rowCountByFetchType(row, amtCalculatorField);
            String opOrgNumber = orgIdToNumberMap.get(row.getLong("oporg"));
            Set<FormulaFloatKey> formulaFloatKeySet = AcctUtil.buildFormulaFloatKey(opOrgNumber, assistValueKeys);
            for (FormulaFloatKey formulaFloatKey : formulaFloatKeySet) {
                Map accountToAmountMap = formula.getCombinationToAmountByAccountMap().computeIfAbsent(formulaFloatKey, key -> new HashMap(8));
                this.reClassAmount(formulaFloatKey, row, amtRow, acctNumToAssistStyleMap, accountToAmountMap, formula);
                ++executeTime;
            }
        }
        long endTime = System.currentTimeMillis();
        LOGGER.info("sum balance by reclass execute time\uff1a" + executeTime);
        LOGGER.info("sum balance by reclass cost time\uff1a" + (endTime - startTime));
    }

    private Map<String, Integer> getAssistStyleMap(AcctFloatFormula formula, Map<Long, Set<Long>> acctToReClassAcctIdsMap, Map<Long, Integer> acctToAssistStyleMap, Map<Long, String> accountIdToNumberMap) {
        HashMap<String, Integer> acctNumToAssistStyleMap = new HashMap<String, Integer>(8);
        for (Map.Entry<String, DynamicObject> accountEntry : formula.getAccountNumberToDynMap().entrySet()) {
            DynamicObject accountDyn = accountEntry.getValue();
            if (accountDyn == null) continue;
            long accountId = accountDyn.getLong("id");
            Set<Long> reClassAccountIdSet = acctToReClassAcctIdsMap.get(accountId);
            Integer assistStyle = acctToAssistStyleMap.get(accountId);
            if (reClassAccountIdSet.isEmpty()) continue;
            reClassAccountIdSet.forEach(id -> acctNumToAssistStyleMap.put((String)accountIdToNumberMap.get(id), assistStyle));
        }
        return acctNumToAssistStyleMap;
    }

    private void reClassAmount(FormulaFloatKey floatValueKey, Row rowData, BigDecimal amtRow, Map<String, Integer> acctNumToAssistStyleMap, Map<String, BigDecimal> accountToAmountMap, AcctFloatFormula formula) {
        Map<FormulaFloatKey, BigDecimal> resultMap = formula.getResultMap();
        BigDecimal resultAmount = resultMap.computeIfAbsent(floatValueKey, key -> new BigDecimal(0));
        String accountId = rowData.getString("account");
        int reClassType = formula.getReClassType();
        boolean isJBal = !AcctFetchType.getFetchTypeD().contains(formula.getFetchType());
        int assistStyle = acctNumToAssistStyleMap.get(accountId);
        if (assistStyle == 1) {
            BigDecimal amtAcct = accountToAmountMap.computeIfAbsent(accountId, x -> new BigDecimal("0"));
            amtAcct = amtAcct.add(amtRow);
            accountToAmountMap.put(accountId, amtAcct);
        } else if (assistStyle == 2) {
            if (reClassType == 4 || reClassType == 5) {
                BigDecimal amtAcct = accountToAmountMap.computeIfAbsent(accountId, x -> new BigDecimal("0"));
                amtAcct = amtAcct.add(amtRow);
                accountToAmountMap.put(accountId, amtAcct);
            } else if (isJBal) {
                if (amtRow.compareTo(BigDecimal.ZERO) > 0) {
                    resultAmount = resultAmount.add(amtRow);
                }
            } else if (amtRow.compareTo(BigDecimal.ZERO) < 0) {
                resultAmount = resultAmount.add(amtRow);
            }
        } else if (assistStyle == 3) {
            if (isJBal) {
                if (amtRow.compareTo(BigDecimal.ZERO) > 0) {
                    resultAmount = resultAmount.add(amtRow);
                }
            } else if (amtRow.compareTo(BigDecimal.ZERO) < 0) {
                resultAmount = resultAmount.add(amtRow);
            }
        }
        resultMap.put(floatValueKey, resultAmount);
    }

    private String getResult(AcctFloatFormulaParse parser, List<AcctFloatFormula> formulas) {
        try {
            Map<String, Map<String, Object>> resultMap = parser.getResultMap();
            for (AcctFloatFormula formula : formulas) {
                HashMap<String, Object> acctValueMap = new HashMap<String, Object>(8);
                if (StringUtils.isBlank((CharSequence)formula.getErrorMsg())) {
                    acctValueMap.put("v", this.getAmountResult(formula));
                    acctValueMap.put("success", true);
                    acctValueMap.put("failmsg", null);
                    acctValueMap.put("index", formula.getFloatTypeNumberList().contains("oporg") ? 0 : -1);
                } else {
                    acctValueMap.put("v", null);
                    acctValueMap.put("success", false);
                    acctValueMap.put("failmsg", formula.getErrorMsg());
                }
                resultMap.put(formula.getfKey(), acctValueMap);
            }
            return JSONUtils.toString(resultMap);
        }
        catch (IOException e) {
            LOGGER.error("ICTACCT float getResult:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private Map<String, BigDecimal> getAmountResult(AcctFloatFormula formula) {
        Map<FormulaFloatKey, BigDecimal> resultMap = formula.getResultMap();
        Map<FormulaFloatKey, Map<String, BigDecimal>> combinationToAmountByAccountMap = formula.getCombinationToAmountByAccountMap();
        HashMap<String, BigDecimal> assistToResultMap = new HashMap<String, BigDecimal>(resultMap.size());
        String balanceDc = this.getBalanceDc(formula);
        List<String> floatTypeNumberList = formula.getFloatTypeNumberList();
        for (Map.Entry<FormulaFloatKey, BigDecimal> resultEntry : resultMap.entrySet()) {
            FormulaFloatKey floatValueKey = resultEntry.getKey();
            BigDecimal resultAmount = resultEntry.getValue();
            Map<String, BigDecimal> leafAcctToAmtMap = combinationToAmountByAccountMap.get(floatValueKey);
            if (resultAmount == null) {
                if (leafAcctToAmtMap.isEmpty()) {
                    return null;
                }
                resultAmount = new BigDecimal("0");
                resultEntry.setValue(resultAmount);
            }
            resultAmount = this.reClassSum(leafAcctToAmtMap, formula, resultAmount, balanceDc);
            StringBuilder assistKey = new StringBuilder();
            for (String floatTypeNumber : floatTypeNumberList) {
                if ("oporg".equals(floatTypeNumber)) {
                    assistKey.append(floatValueKey.getOpOrgNumber()).append("|");
                    continue;
                }
                assistKey.append(floatValueKey.getAssistKey().get(floatTypeNumber)).append("|");
            }
            assistKey.delete(assistKey.length() - 1, assistKey.length());
            assistToResultMap.put(assistKey.toString(), assistToResultMap.containsKey(assistKey.toString()) ? ((BigDecimal)assistToResultMap.get(assistKey.toString())).add(resultAmount) : resultAmount);
        }
        return assistToResultMap;
    }

    private String getBalanceDc(AcctFloatFormula formula) {
        Collection<DynamicObject> accounts = formula.getAccountNumberToDynMap().values();
        HashSet<String> balanceDcSet = new HashSet<String>(8);
        for (DynamicObject account : accounts) {
            String balanceDc = account.getString("dc");
            balanceDcSet.add(balanceDc);
        }
        if (balanceDcSet.size() == 1) {
            return (String)balanceDcSet.iterator().next();
        }
        return "1";
    }

    private BigDecimal reClassSum(Map<String, BigDecimal> leafAcctToAmtMap, AcctFloatFormula formula, BigDecimal resultAmount, String balanceDc) {
        String fetchType = formula.getFetchType();
        boolean isReClass = AcctFetchType.getFetchTypeReclass().contains(fetchType);
        boolean isJBal = !AcctFetchType.getFetchTypeD().contains(fetchType);
        boolean isBalDc = AcctFetchType.getFetchType_y().contains(fetchType);
        ArrayList<BigDecimal> amountList = new ArrayList<BigDecimal>(8);
        if (leafAcctToAmtMap != null) {
            amountList.addAll(leafAcctToAmtMap.values());
        }
        for (BigDecimal amount : amountList) {
            if ((!isJBal || amount.compareTo(BigDecimal.ZERO) <= 0) && (isJBal || amount.compareTo(BigDecimal.ZERO) >= 0)) continue;
            resultAmount = resultAmount.add(amount);
        }
        if (isReClass && !isJBal) {
            resultAmount = resultAmount.negate();
        }
        if (isBalDc) {
            resultAmount = resultAmount.multiply(new BigDecimal(balanceDc));
        }
        return resultAmount;
    }
}

