/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.batchquery.account;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ict.accsys.AccSysUtil;
import kd.fi.ict.mservice.formula.batchquery.account.AcctFloatFormula;
import kd.fi.ict.mservice.formula.batchquery.param.FloatQueryContext;
import kd.fi.ict.mservice.formula.common.FormulaCommon;
import kd.fi.ict.mservice.formula.common.utils.AcctUtil;
import kd.fi.ict.mservice.formula.common.utils.MakeBaseDateDetailHelper;

public class AcctBatchQueryContext
extends FloatQueryContext {
    private static final String AUXILIARY_DATA_TYPE = "2";
    private static final String MANUAL_DIMENSION = "3";
    private static final String CTRL_STRATEGY_GLOBAL_SHARE = "5";
    private static final String ACCOUNT_TABLE_ID = "accounttable.id";
    private static final String[] selectFields = new String[]{"id", "org.id", "accounttable.id", "number", "startdate", "enddate", "parent", "longnumber", "level", "isleaf", "dc"};
    private final Log log = LogFactory.getLog((String)AcctBatchQueryContext.class.getName());
    private Map<String, Map<String, DynamicObject>> formulaToAccountsMap;
    private Map<String, Long> accountTableIdMap;
    private Map<Long, Long> accountIdToMasterIdMap;
    private Map<Long, Set<Long>> directChildAccountMap;
    private Map<Long, Set<Long>> allDetailedAccountMap;
    private Map<String, DynamicObject> assistMap;
    private Map<Long, Set<String>> accountIdToFlexFieldMap;
    private Map<String, String> flexFieldToAssistEntityMap;
    private Table<String, String, Map<String, Set<Object>>> assistValueNumberToIdTable;
    private Table<String, String, Map<String, Set<Object>>> assistRangeValToIdTable;
    private Map<Long, String> accountIdToNumberMap;
    private Map<String, DataSet> flexFieldToHgMap;
    private Table<String, String, Map<Object, Set<String>>> assistValIdToNumTable;
    private Map<String, Long> standardMap;
    private Map<String, DataSet> groupMap;

    public AcctBatchQueryContext(FormulaCommon acctFormulaCommon, List<AcctFloatFormula> formulas) {
        super(acctFormulaCommon, formulas);
        this.initAccountTable(formulas);
        this.initAccountMap(formulas);
        this.initAssistMap(formulas);
        this.initAssistValueId(formulas);
        this.initHgByFlexField(formulas);
    }

    private static SqlBuilder getSqlBuilder(Collection<Long> orgIds, Collection<Long> accountTableIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT c.fid id, u.fuseorgid useorgid, c.faccounttableid accounttableid, c.fctrlstrategy ctrlstrategy FROM T_BD_ACCOUNT AS c LEFT JOIN T_BD_ACCOUNT_U AS u ON u.fdataid = c.fid WHERE", new Object[0]).append("c.fstatus='C'", new Object[0]);
        if (CollectionUtils.isNotEmpty(accountTableIds)) {
            sql.appendIn("AND c.faccounttableid", accountTableIds.toArray());
        }
        sql.append("AND", new Object[0]).appendIn("u.fuseorgid", orgIds.toArray());
        sql.append("UNION ", new Object[0]).append("SELECT c.fid id, 0 as fuseorgid, c.faccounttableid accounttableid, c.fctrlstrategy ctrlstrategy  FROM T_BD_ACCOUNT as c where c.fctrlstrategy = '5'", new Object[0]);
        if (CollectionUtils.isNotEmpty(accountTableIds)) {
            sql.appendIn("AND c.faccounttableid", accountTableIds.toArray());
        }
        return sql;
    }

    private void initAccountTable(List<AcctFloatFormula> formulas) {
        this.accountTableIdMap = new HashMap<String, Long>(8);
        for (AcctFloatFormula formula : formulas) {
            DynamicObject bookInfo;
            String orgNumber = formula.getOrgNumber();
            String bookTypeNumber = formula.getBootTypeNumber();
            Long orgId = this.getOrgNumberToIdMap().getOrDefault(orgNumber, 0L);
            Long bookTypeId = this.getBookTypeNumberToIdMap().getOrDefault(bookTypeNumber, 0L);
            DynamicObject period = this.getPeriodMap().get(formula.getfKey());
            if (period == null || orgId == 0L || bookTypeId == 0L) continue;
            long periodId = period.getLong("id");
            long acctTableId = AccSysUtil.getCurPeriodAccountTableId((long)orgId, (long)bookTypeId, (long)periodId);
            if (acctTableId == 0L && (bookInfo = this.getAccountBookMap().get(orgNumber + "*" + bookTypeNumber)) != null) {
                acctTableId = bookInfo.getLong(ACCOUNT_TABLE_ID);
            }
            this.accountTableIdMap.put(formula.getfKey(), acctTableId);
        }
        this.log.info("AcctBatchQueryContext_initAccountTable accountTableIdMap:" + this.accountTableIdMap);
    }

    private void initAccountMap(List<AcctFloatFormula> formulas) {
        long startTime = System.currentTimeMillis();
        Table<Long, Long, List<DynamicObject>> accountDynTable = this.getAccountDynTable(this.getOrgNumberToIdMap().values(), this.accountTableIdMap.values(), selectFields);
        this.initAccountIdToNumber(accountDynTable);
        ArrayList<DynamicObject> accountDynList = new ArrayList<DynamicObject>(8);
        this.initCurrentAccount(formulas, accountDynTable, accountDynList);
        this.initDirectChildAccount(formulas, accountDynTable, accountDynList);
        this.initDetailedAccount(formulas, accountDynTable, accountDynList);
        this.dealDetailAccount(accountDynList);
        this.initAllAcctFlexFields();
        long endTime = System.currentTimeMillis();
        this.log.info("init accounts cost time\uff1a" + (endTime - startTime));
    }

    private void initAssistValueId(List<AcctFloatFormula> formulas) {
        long startTime = System.currentTimeMillis();
        this.assistValueNumberToIdTable = HashBasedTable.create();
        this.assistRangeValToIdTable = HashBasedTable.create();
        HashBasedTable allAssistToValueNumberTable = HashBasedTable.create();
        HashBasedTable allAssistToRangeValueTable = HashBasedTable.create();
        for (AcctFloatFormula formula : formulas) {
            String orgNumber = formula.getOrgNumber();
            Map<String, List<String>> assistToValueNumberMap = formula.getAssistToValueNumberMap();
            for (Map.Entry<String, List<String>> assistToValueNumberEntry : assistToValueNumberMap.entrySet()) {
                Set<String> allValueNumSet;
                String assistNumber = assistToValueNumberEntry.getKey();
                List<String> valueNumberList = assistToValueNumberEntry.getValue();
                if (!CollectionUtils.isNotEmpty(valueNumberList)) continue;
                if (allAssistToValueNumberTable.contains((Object)orgNumber, (Object)assistNumber)) {
                    allValueNumSet = (Set)allAssistToValueNumberTable.get((Object)orgNumber, (Object)assistNumber);
                    allValueNumSet.addAll(valueNumberList);
                    continue;
                }
                allValueNumSet = new HashSet<String>(valueNumberList);
                allAssistToValueNumberTable.put((Object)orgNumber, (Object)assistNumber, allValueNumSet);
            }
            Map<String, List<String>> assistToRangeValueMap = formula.getAssistToRangeValueMap();
            for (Map.Entry<String, List<String>> assistToRangeValueEntry : assistToRangeValueMap.entrySet()) {
                String assistNumber = assistToRangeValueEntry.getKey();
                List<String> rangeValueList = assistToRangeValueEntry.getValue();
                if (!CollectionUtils.isNotEmpty(rangeValueList)) continue;
                if (allAssistToRangeValueTable.contains((Object)orgNumber, (Object)assistNumber)) {
                    Set allValueNumSet = (Set)allAssistToRangeValueTable.get((Object)orgNumber, (Object)assistNumber);
                    allValueNumSet.addAll(rangeValueList);
                    continue;
                }
                HashSet<String> allRangeValueSet = new HashSet<String>(rangeValueList);
                allAssistToRangeValueTable.put((Object)orgNumber, (Object)assistNumber, allRangeValueSet);
            }
        }
        this.queryAssistValueId((Table<String, String, Set<String>>)allAssistToValueNumberTable);
        this.queryAssistRangeValueId((Table<String, String, Set<String>>)allAssistToRangeValueTable);
        long endTime = System.currentTimeMillis();
        this.log.info("init assistValueId cost time\uff1a" + (endTime - startTime));
    }

    private void initAssistMap(List<AcctFloatFormula> formulas) {
        long startTime = System.currentTimeMillis();
        HashSet<String> allAssistNumberSet = new HashSet<String>();
        for (AcctFloatFormula formula : formulas) {
            allAssistNumberSet.addAll(formula.getAllAssistNumber());
        }
        this.assistMap = new HashMap<String, DynamicObject>(allAssistNumberSet.size());
        QFilter numberQF = new QFilter("number", "in", allAssistNumberSet);
        QFilter flexIdQF = new QFilter("flexid", "=", (Object)2L);
        DynamicObjectCollection assistDyns = QueryServiceHelper.query((String)"bd_asstacttype", (String)"number, valuetype, assistanttype, valuesource, flexfield", (QFilter[])new QFilter[]{numberQF, flexIdQF});
        for (DynamicObject assistDyn : assistDyns) {
            this.assistMap.put(assistDyn.getString("number"), assistDyn);
        }
        this.log.info("AcctBatchQueryContext_initAssistMap assistMap\uff1a" + this.assistMap);
        long endTime = System.currentTimeMillis();
        this.log.info("init assist cost time\uff1a" + (endTime - startTime));
    }

    private void queryAssistValueId(Table<String, String, Set<String>> allAssistToValueNumberTable) {
        this.assistValIdToNumTable = HashBasedTable.create();
        for (Table.Cell allAssistToValueNumberCell : allAssistToValueNumberTable.cellSet()) {
            QFilter orgFilter;
            String orgNumber = (String)allAssistToValueNumberCell.getRowKey();
            long orgId = this.getOrgNumberToIdMap().getOrDefault(orgNumber, 0L);
            if (orgId == 0L) continue;
            String assistNumber = (String)allAssistToValueNumberCell.getColumnKey();
            DynamicObject assistDyn = this.assistMap.get(assistNumber);
            Set valueNumberSet = (Set)allAssistToValueNumberCell.getValue();
            if (assistDyn == null) continue;
            if (MANUAL_DIMENSION.equals(assistDyn.getString("valuetype"))) {
                Map<String, HashSet<String>> valueNumToIdMap = new HashMap(valueNumberSet.size());
                if (this.assistValueNumberToIdTable.contains((Object)orgNumber, (Object)assistNumber)) {
                    valueNumToIdMap = (Map)this.assistValueNumberToIdTable.get((Object)orgNumber, (Object)assistNumber);
                }
                Map<String, HashSet<String>> valueIdToNumsMap = new HashMap(8);
                if (this.assistValIdToNumTable.contains((Object)orgNumber, (Object)assistNumber)) {
                    valueIdToNumsMap = (Map)this.assistValIdToNumTable.get((Object)orgNumber, (Object)assistNumber);
                }
                for (String valueNumber : valueNumberSet) {
                    valueNumToIdMap.put(valueNumber, new HashSet<String>(Collections.singleton(valueNumber)));
                    valueIdToNumsMap.put(valueNumber, new HashSet<String>(Collections.singleton(valueNumber)));
                }
                this.assistValueNumberToIdTable.put((Object)orgNumber, (Object)assistNumber, valueNumToIdMap);
                this.assistValIdToNumTable.put((Object)orgNumber, (Object)assistNumber, valueIdToNumsMap);
                continue;
            }
            String entityId = assistDyn.getString("valuesource");
            ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
            if (entityId != null && (orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)orgId)) != null) {
                filters.add(orgFilter);
            }
            if (AUXILIARY_DATA_TYPE.equals(assistDyn.get("valuetype"))) {
                QFilter groupFilter = new QFilter("group", "=", (Object)assistDyn.getLong("assistanttype"));
                filters.add(groupFilter);
            }
            MakeBaseDateDetailHelper detailHelper = new MakeBaseDateDetailHelper();
            Map<String, Set<Long>> valueNumToIdsMap = detailHelper.getDetailAssists(entityId, valueNumberSet, filters);
            Map valNumToIdMap = new HashMap(8);
            if (this.assistValueNumberToIdTable.contains((Object)orgNumber, (Object)assistNumber)) {
                valNumToIdMap = (Map)this.assistValueNumberToIdTable.get((Object)orgNumber, (Object)assistNumber);
            }
            for (Map.Entry<String, Set<Long>> valueNumToIdsEntry : valueNumToIdsMap.entrySet()) {
                valNumToIdMap.put(valueNumToIdsEntry.getKey(), new HashSet(valueNumToIdsEntry.getValue()));
            }
            this.assistValueNumberToIdTable.put((Object)orgNumber, (Object)assistNumber, valNumToIdMap);
            Map<String, Object> floatValueNumberMap = this.getBatchQueryParam().getRefParamMap();
            List assistValueNumList = (List)floatValueNumberMap.get(assistNumber);
            if (CollectionUtils.isEmpty((Collection)assistValueNumList)) continue;
            for (String assistValueNumber : assistValueNumList) {
                Set<Long> valueIdSet = valueNumToIdsMap.get(assistValueNumber);
                if (CollectionUtils.isEmpty(valueIdSet)) continue;
                Map<Object, Set> valueIdToNumsMap = new HashMap(8);
                if (this.assistValIdToNumTable.contains((Object)orgNumber, (Object)assistNumber)) {
                    valueIdToNumsMap = (Map)this.assistValIdToNumTable.get((Object)orgNumber, (Object)assistNumber);
                }
                for (Long valueId : valueIdSet) {
                    Set idToValueNumberSet = valueIdToNumsMap.computeIfAbsent(valueId, key -> new HashSet(8));
                    idToValueNumberSet.add(assistValueNumber);
                }
                this.assistValIdToNumTable.put((Object)orgNumber, (Object)assistNumber, valueIdToNumsMap);
            }
        }
        this.log.info("AcctBatchQueryContext_queryAssistValueId assistValueNumberToIdTable\uff1a" + this.assistValueNumberToIdTable);
        this.log.info("AcctBatchQueryContext_queryAssistValueId assistValIdToNumTable\uff1a" + this.assistValIdToNumTable);
    }

    private void queryAssistRangeValueId(Table<String, String, Set<String>> allAssistToRangeValueTable) {
        this.standardMap = new HashMap<String, Long>(8);
        this.groupMap = new HashMap<String, DataSet>(8);
        MakeBaseDateDetailHelper detailHelper = new MakeBaseDateDetailHelper();
        for (Table.Cell allAssistToRangeValueCell : allAssistToRangeValueTable.cellSet()) {
            QFilter orgFilter;
            String orgNumber = (String)allAssistToRangeValueCell.getRowKey();
            long orgId = this.getOrgNumberToIdMap().getOrDefault(orgNumber, 0L);
            String assistNumber = (String)allAssistToRangeValueCell.getColumnKey();
            DynamicObject assistDyn = this.assistMap.get(assistNumber);
            Set assistRangeValueSet = (Set)allAssistToRangeValueCell.getValue();
            if (assistDyn == null) continue;
            String entityId = assistDyn.getString("valuesource");
            if (StringUtils.isBlank((CharSequence)entityId)) {
                Map<String, Set> rangeValueIdMap = new HashMap(8);
                if (this.assistRangeValToIdTable.contains((Object)orgNumber, (Object)assistNumber)) {
                    rangeValueIdMap = (Map)this.assistRangeValToIdTable.get((Object)orgNumber, (Object)assistNumber);
                }
                for (String rangeValueNum : assistRangeValueSet) {
                    String rangeValue = rangeValueNum.substring(1, rangeValueNum.length() - 1);
                    Set rangeValueIdSet = rangeValueIdMap.computeIfAbsent(rangeValueNum, key -> new HashSet());
                    rangeValueIdSet.addAll(Arrays.asList(rangeValue.split(",")));
                }
                this.assistRangeValToIdTable.put((Object)orgNumber, (Object)assistNumber, rangeValueIdMap);
                continue;
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
            if (orgId != 0L && (orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)orgId)) != null) {
                filters.add(orgFilter);
            }
            if (AUXILIARY_DATA_TYPE.equals(assistDyn.get("valuetype"))) {
                QFilter groupFilter = new QFilter("group", "=", (Object)assistDyn.getLong("assistanttype"));
                filters.add(groupFilter);
            }
            Map rangeValNumToIdMap = new HashMap(8);
            if (this.assistRangeValToIdTable.contains((Object)orgNumber, (Object)assistNumber)) {
                rangeValNumToIdMap = (Map)this.assistRangeValToIdTable.get((Object)orgNumber, (Object)assistNumber);
            }
            for (String rangeValueNum : assistRangeValueSet) {
                boolean isClassify = rangeValueNum.contains("#");
                DataSet assistDataSet = null;
                if (isClassify) {
                    assistDataSet = AcctUtil.queryAssistValByGroup(rangeValueNum, entityId, this.standardMap, this.groupMap);
                } else {
                    String rangeValue = rangeValueNum.substring(1, rangeValueNum.length() - 1);
                    String[] continueValNum = rangeValue.split(",");
                    assistDataSet = AcctUtil.queryContinueNumber(Arrays.asList(continueValNum), filters, "masterid", entityId);
                }
                HashSet<Object> rangeValueIdSet = new HashSet<Object>(8);
                if (assistDataSet != null) {
                    for (Row assist : assistDataSet) {
                        rangeValueIdSet.add(assist.getLong("masterid"));
                    }
                }
                HashSet<Object> allRangeValIdSet = new HashSet<Object>(8);
                if (CollectionUtils.isNotEmpty(rangeValueIdSet)) {
                    allRangeValIdSet.addAll(rangeValueIdSet);
                }
                if (detailHelper.hasParent(entityId)) {
                    Set<Object> detailAssistIdSet = detailHelper.getDetailAssisttContinueNumbers(entityId, rangeValueIdSet, filters);
                    allRangeValIdSet.addAll(detailAssistIdSet);
                }
                rangeValNumToIdMap.put(rangeValueNum, allRangeValIdSet);
            }
            this.assistRangeValToIdTable.put((Object)orgNumber, (Object)assistNumber, rangeValNumToIdMap);
        }
    }

    private void dealDetailAccount(List<DynamicObject> accountDynList) {
        HashSet allAccountIdSet = new HashSet(8);
        accountDynList.forEach(accountDyn -> {
            if (accountDyn != null) {
                allAccountIdSet.add(accountDyn.getLong("id"));
            }
        });
        Iterator iterator = allAccountIdSet.iterator();
        while (iterator.hasNext()) {
            Set detailedAccountIdSet;
            long accountId = (Long)iterator.next();
            Set directChildAccountIdSet = this.directChildAccountMap.computeIfAbsent(accountId, key -> new HashSet());
            if (directChildAccountIdSet.isEmpty()) {
                directChildAccountIdSet.add(accountId);
            }
            if (!(detailedAccountIdSet = this.allDetailedAccountMap.computeIfAbsent(accountId, key -> new HashSet())).isEmpty()) continue;
            detailedAccountIdSet.add(accountId);
        }
        this.log.info("AcctBatchQueryContext_dealDetailAccount directChildAccountMap\uff1a" + this.directChildAccountMap);
        this.log.info("AcctBatchQueryContext_dealDetailAccount allDetailedAccountMap\uff1a" + this.allDetailedAccountMap);
    }

    private void initAllAcctFlexFields() {
        this.accountIdToMasterIdMap = new HashMap<Long, Long>(8);
        this.accountIdToFlexFieldMap = new HashMap<Long, Set<String>>(8);
        this.flexFieldToAssistEntityMap = new HashMap<String, String>(8);
        HashSet<Object> allAccountIdSet = new HashSet<Object>(8);
        for (Map.Entry<String, Map<String, DynamicObject>> entry : this.formulaToAccountsMap.entrySet()) {
            Map<String, DynamicObject> accountMap = entry.getValue();
            Collection<DynamicObject> accounts = accountMap.values();
            for (DynamicObject account : accounts) {
                if (account == null) continue;
                allAccountIdSet.add(account.getLong("id"));
            }
        }
        for (Map.Entry<Object, Object> entry : this.directChildAccountMap.entrySet()) {
            allAccountIdSet.add(entry.getKey());
            allAccountIdSet.addAll((Collection)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.allDetailedAccountMap.entrySet()) {
            allAccountIdSet.add(entry.getKey());
            allAccountIdSet.addAll((Collection)entry.getValue());
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)"id, number, masterid, checkitementry.asstactitem.flexfield flexfield, checkitementry.asstactitem.valuetype valuetype", (QFilter[])new QFilter[]{new QFilter("id", "in", allAccountIdSet)}, null);
        for (Row row : dataSet) {
            long accountId = row.getLong("id");
            long masterId = row.getLong("masterid");
            this.accountIdToMasterIdMap.put(accountId, masterId);
            String flexField = row.getString("flexfield");
            Set flexFieldSet = this.accountIdToFlexFieldMap.computeIfAbsent(accountId, key -> new HashSet());
            flexFieldSet.add(flexField);
            String valueType = row.getString("valuetype");
            if (MANUAL_DIMENSION.equals(valueType)) {
                this.flexFieldToAssistEntityMap.put(flexField, "gl_assist_txt");
                continue;
            }
            this.flexFieldToAssistEntityMap.put(flexField, "gl_assist_bd");
        }
        this.log.info("AcctBatchQueryContext_initAllAcctFlexFields accountIdToMasterIdMap\uff1a" + this.accountIdToMasterIdMap);
        this.log.info("AcctBatchQueryContext_initAllAcctFlexFields accountIdToFlexFieldMap\uff1a" + this.accountIdToFlexFieldMap);
        this.log.info("AcctBatchQueryContext_initAllAcctFlexFields flexFieldToAssistEntityMap\uff1a" + this.flexFieldToAssistEntityMap);
    }

    private Table<Long, Long, List<DynamicObject>> getAccountDynTable(Collection<Long> orgIds, Collection<Long> accountTableIds, String[] selectFields) {
        HashBasedTable accountDynTable = HashBasedTable.create();
        if (CollectionUtils.isNotEmpty(orgIds) && CollectionUtils.isNotEmpty(accountTableIds)) {
            SqlBuilder sqlBuilder = AcctBatchQueryContext.getSqlBuilder(orgIds, accountTableIds);
            HashSet<Long> allAccountIdSet = new HashSet<Long>(8);
            HashBasedTable orgAndAcctTableToAcctIDTable = HashBasedTable.create();
            try (DataSet dataSet = DB.queryDataSet((String)"AcctBatchQueryContext.queryAccounts", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
                for (Row row : dataSet) {
                    Long accountId = row.getLong("id");
                    Long useOrgId = row.getLong("useorgid");
                    Long accountTableId = row.getLong("accounttableid");
                    String ctrlStrategy = row.getString("ctrlstrategy");
                    if (CTRL_STRATEGY_GLOBAL_SHARE.equals(ctrlStrategy)) {
                        for (Long orgId : orgIds) {
                            if (!orgAndAcctTableToAcctIDTable.contains((Object)orgId, (Object)accountTableId)) {
                                orgAndAcctTableToAcctIDTable.put((Object)orgId, (Object)accountTableId, new HashSet(8));
                            }
                            ((Set)orgAndAcctTableToAcctIDTable.get((Object)orgId, (Object)accountTableId)).add(accountId);
                        }
                    } else {
                        if (!orgAndAcctTableToAcctIDTable.contains((Object)useOrgId, (Object)accountTableId)) {
                            orgAndAcctTableToAcctIDTable.put((Object)useOrgId, (Object)accountTableId, new HashSet(8));
                        }
                        ((Set)orgAndAcctTableToAcctIDTable.get((Object)useOrgId, (Object)accountTableId)).add(accountId);
                    }
                    allAccountIdSet.add(accountId);
                }
            }
            String fieldsString = StringUtils.join((Object[])selectFields, (String)",");
            Map accountDynCol = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)fieldsString, (QFilter[])new QFilter[]{new QFilter("id", "in", allAccountIdSet)});
            for (Table.Cell accountIdCell : orgAndAcctTableToAcctIDTable.cellSet()) {
                Set accountIdSet = (Set)accountIdCell.getValue();
                long orgId = (Long)accountIdCell.getRowKey();
                long accountTableId = (Long)accountIdCell.getColumnKey();
                accountDynTable.put((Object)orgId, (Object)accountTableId, accountIdSet.stream().map(x -> (DynamicObject)accountDynCol.get(x)).collect(Collectors.toList()));
            }
        }
        this.log.info("AcctBatchQueryContext_getAccountDynTable accountDynTable\uff1a" + accountDynTable);
        return accountDynTable;
    }

    private List<DynamicObject> getAccountListFromTable(String orgNumber, String formulaKey, Table<Long, Long, List<DynamicObject>> accountDynTable) {
        Long orgId = this.getOrgNumberToIdMap().get(orgNumber);
        Long accountTableId = this.accountTableIdMap.get(formulaKey);
        return (List)accountDynTable.get((Object)orgId, (Object)accountTableId);
    }

    private void initAccountIdToNumber(Table<Long, Long, List<DynamicObject>> accountDynTable) {
        this.accountIdToNumberMap = new HashMap<Long, String>(8);
        for (List accDys : accountDynTable.values()) {
            for (DynamicObject acc : accDys) {
                this.accountIdToNumberMap.computeIfAbsent(acc.getLong("id"), key -> acc.getString("number"));
            }
        }
        this.log.info("AcctBatchQueryContext_initAccountIdToNumber accountIdToNumberMap\uff1a" + this.accountIdToNumberMap);
    }

    private void initCurrentAccount(List<AcctFloatFormula> formulas, Table<Long, Long, List<DynamicObject>> accountDynTable, List<DynamicObject> accountList) {
        this.formulaToAccountsMap = new HashMap<String, Map<String, DynamicObject>>(formulas.size());
        for (AcctFloatFormula formula : formulas) {
            Set<String> accountContinueNumberSet;
            DynamicObject periodDyn = this.getPeriodMap().get(formula.getfKey());
            if (periodDyn == null) continue;
            Date periodEndDate = periodDyn.getDate("enddate");
            List<DynamicObject> accountDynList = this.getAccountListFromTable(formula.getOrgNumber(), formula.getfKey(), accountDynTable);
            Set<String> allAccountNumberSet = formula.getAccountNumberToDynMap().keySet();
            if (!allAccountNumberSet.isEmpty() && !accountDynList.isEmpty()) {
                for (DynamicObject accountDyn : accountDynList) {
                    String accountNumber = accountDyn.getString("number");
                    Date accountStartDate = accountDyn.getDate("startdate");
                    Date accountEndDate = accountDyn.getDate("enddate");
                    if (!allAccountNumberSet.contains(accountNumber) || !this.isCurPeriod(accountStartDate, accountEndDate, periodEndDate)) continue;
                    formula.getAccountNumberToDynMap().put(accountNumber, accountDyn);
                    Map accountNumberToDynMap = this.formulaToAccountsMap.computeIfAbsent(formula.getfKey(), key -> new HashMap(8));
                    accountNumberToDynMap.put(accountNumber, accountDyn);
                    accountList.add(accountDyn);
                }
            }
            if ((accountContinueNumberSet = formula.getAccountContinueNumberSet()).isEmpty() || accountDynList.isEmpty()) continue;
            for (DynamicObject accountDyn : accountDynList) {
                for (String continueNum : accountContinueNumberSet) {
                    String accountNumber = accountDyn.getString("number");
                    Date accountStartDate = accountDyn.getDate("startdate");
                    Date accountEndDate = accountDyn.getDate("enddate");
                    if (!this.isRangeAccountNum(accountNumber, continueNum) || !this.isCurPeriod(accountStartDate, accountEndDate, periodEndDate)) continue;
                    formula.getAccountNumberToDynMap().put(accountNumber, accountDyn);
                    Map accountNumberToDynMap = this.formulaToAccountsMap.computeIfAbsent(formula.getfKey(), key -> new HashMap(8));
                    accountNumberToDynMap.put(accountNumber, accountDyn);
                    accountList.add(accountDyn);
                }
            }
        }
        this.log.info("AcctBatchQueryContext_initCurrentAccount formulaToAccountsMap\uff1a" + this.formulaToAccountsMap);
    }

    private void initDirectChildAccount(List<AcctFloatFormula> formulas, Table<Long, Long, List<DynamicObject>> accountDynTable, List<DynamicObject> accountList) {
        this.directChildAccountMap = new HashMap<Long, Set<Long>>(8);
        for (AcctFloatFormula formula : formulas) {
            HashSet<DynamicObject> allCurAccountSet = new HashSet<DynamicObject>(formula.getAccountNumberToDynMap().values());
            DynamicObject periodDyn = this.getPeriodMap().get(formula.getfKey());
            List<DynamicObject> accountDynList = this.getAccountListFromTable(formula.getOrgNumber(), formula.getfKey(), accountDynTable);
            if (!CollectionUtils.isNotEmpty(allCurAccountSet) || periodDyn == null || !CollectionUtils.isNotEmpty(accountDynList)) continue;
            Date periodEndDate = periodDyn.getDate("enddate");
            block1: for (DynamicObject accountDyn : accountDynList) {
                if (accountDyn == null) continue;
                Date accountStartDate = accountDyn.getDate("startdate");
                Date accountEndDate = accountDyn.getDate("enddate");
                for (DynamicObject curAccount : allCurAccountSet) {
                    int level;
                    int curAcctLevel;
                    String longNumber;
                    String curAcctLongNumber;
                    if (curAccount == null || !this.isDirectChildAccount(curAcctLongNumber = curAccount.getString("longnumber"), longNumber = accountDyn.getString("longnumber"), curAcctLevel = curAccount.getInt("level"), level = accountDyn.getInt("level")) || !this.isCurPeriod(accountStartDate, accountEndDate, periodEndDate)) continue;
                    Long directChildAccountId = accountDyn.getLong("id");
                    Long accountId = curAccount.getLong("id");
                    Set directChildAccountIdSet = this.directChildAccountMap.computeIfAbsent(accountId, key -> new HashSet());
                    directChildAccountIdSet.add(directChildAccountId);
                    accountList.add(accountDyn);
                    continue block1;
                }
            }
        }
        this.log.info("AcctBatchQueryContext_initDirectChildAccount directChildAccountMap\uff1a" + this.directChildAccountMap);
    }

    private void initDetailedAccount(List<AcctFloatFormula> formulas, Table<Long, Long, List<DynamicObject>> accountDynTable, List<DynamicObject> accountList) {
        this.allDetailedAccountMap = new HashMap<Long, Set<Long>>(8);
        HashSet<DynamicObject> accountSet = new HashSet<DynamicObject>(8);
        for (AcctFloatFormula formula : formulas) {
            DynamicObject periodDyn = this.getPeriodMap().get(formula.getfKey());
            if (formula.getAccountNumberToDynMap().isEmpty() || periodDyn == null) continue;
            Date periodEndDate = periodDyn.getDate("enddate");
            List<DynamicObject> accountDynList = this.getAccountListFromTable(formula.getOrgNumber(), formula.getfKey(), accountDynTable);
            for (DynamicObject accountDyn : accountDynList) {
                String longNumber = accountDyn.getString("longnumber");
                Date accountStartDate = accountDyn.getDate("startdate");
                Date accountEndDate = accountDyn.getDate("enddate");
                boolean isLeaf = accountDyn.getBoolean("isleaf");
                for (DynamicObject curAccountDyn : accountList) {
                    if (curAccountDyn == null) continue;
                    String curLongNumber = curAccountDyn.getString("longnumber");
                    Long curAccountId = curAccountDyn.getLong("id");
                    boolean isLeafAndMatchPeriod = isLeaf && longNumber.startsWith(curLongNumber) && this.isCurPeriod(accountStartDate, accountEndDate, periodEndDate);
                    if (!isLeafAndMatchPeriod) continue;
                    Set accountIdSet = this.allDetailedAccountMap.computeIfAbsent(curAccountId, key -> new HashSet(8));
                    accountIdSet.add(accountDyn.getLong("id"));
                    accountSet.add(accountDyn);
                }
            }
        }
        accountList.addAll(accountSet);
        this.log.info("AcctBatchQueryContext_initDetailedAccount allDetailedAccountMap\uff1a" + this.allDetailedAccountMap);
    }

    private boolean isDirectChildAccount(String curAcctLongNumber, String longNumber, int curAcctLevel, int level) {
        return longNumber.startsWith(curAcctLongNumber) && level == curAcctLevel + 1;
    }

    private boolean isCurPeriod(Date startDate, Date endDate, Date checkDate) {
        return startDate.compareTo(checkDate) <= 0 && endDate.compareTo(checkDate) >= 0;
    }

    private void initHgByFlexField(List<AcctFloatFormula> formulas) {
        long startTime = System.currentTimeMillis();
        this.flexFieldToHgMap = new HashMap<String, DataSet>(8);
        HashMap<String, Set> allFlexFieldToValueMap = new HashMap<String, Set>(8);
        for (AcctFloatFormula acctFloatFormula : formulas) {
            String assistNumber;
            Object assistToRangeValueEntry2;
            String flexField;
            DynamicObject assistDyn;
            String orgNumber = acctFloatFormula.getOrgNumber();
            Map<String, List<String>> assistToValueNumberMap = acctFloatFormula.getAssistToValueNumberMap();
            for (Map.Entry<String, List<String>> entry : assistToValueNumberMap.entrySet()) {
                String assistNumber2 = entry.getKey();
                List<String> valueNumberList = entry.getValue();
                assistDyn = this.assistMap.get(assistNumber2);
                if (assistDyn == null || !CollectionUtils.isNotEmpty(valueNumberList)) continue;
                flexField = assistDyn.getString("flexfield");
                HashSet assistValueIdSet = new HashSet(valueNumberList.size());
                for (Object valueNumber : valueNumberList) {
                    if (this.assistValueNumberToIdTable.get((Object)orgNumber, (Object)assistNumber2) == null || !CollectionUtils.isNotEmpty((Collection)((Collection)((Map)this.assistValueNumberToIdTable.get((Object)orgNumber, (Object)assistNumber2)).get(valueNumber)))) continue;
                    assistValueIdSet.addAll((Collection)((Map)this.assistValueNumberToIdTable.get((Object)orgNumber, (Object)assistNumber2)).get(valueNumber));
                }
                if (allFlexFieldToValueMap.containsKey(flexField) && !Objects.isNull(allFlexFieldToValueMap.get(flexField)) && ((Set)allFlexFieldToValueMap.get(flexField)).isEmpty()) continue;
                Set allAssistValueIdSet = allFlexFieldToValueMap.computeIfAbsent(flexField, key -> new HashSet());
                allAssistValueIdSet.addAll(assistValueIdSet);
            }
            Map<String, List<String>> assistToRangeValueMap = acctFloatFormula.getAssistToRangeValueMap();
            for (Object assistToRangeValueEntry2 : assistToRangeValueMap.entrySet()) {
                Object valueNumber;
                assistNumber = assistToRangeValueEntry2.getKey();
                List rangeValueList = (List)assistToRangeValueEntry2.getValue();
                DynamicObject assistDyn2 = this.assistMap.get(assistNumber);
                if (assistDyn2 == null || !CollectionUtils.isNotEmpty((Collection)rangeValueList)) continue;
                String flexField2 = assistDyn2.getString("flexfield");
                HashSet assistValueIdSet = new HashSet(rangeValueList.size());
                valueNumber = rangeValueList.iterator();
                while (valueNumber.hasNext()) {
                    String rangeValue = (String)valueNumber.next();
                    assistValueIdSet.addAll((Collection)((Map)this.assistRangeValToIdTable.get((Object)orgNumber, (Object)assistNumber)).get(rangeValue));
                }
                if (allFlexFieldToValueMap.containsKey(flexField2) && !Objects.isNull(allFlexFieldToValueMap.get(flexField2)) && ((Set)allFlexFieldToValueMap.get(flexField2)).isEmpty()) continue;
                Set allAssistValueIdSet = allFlexFieldToValueMap.computeIfAbsent(flexField2, key -> new HashSet());
                allAssistValueIdSet.addAll(assistValueIdSet);
            }
            Set<String> set = acctFloatFormula.getAllValueAssistNumberSet();
            assistToRangeValueEntry2 = set.iterator();
            while (assistToRangeValueEntry2.hasNext()) {
                assistNumber = (String)assistToRangeValueEntry2.next();
                assistDyn = this.assistMap.get(assistNumber);
                if (assistDyn == null) continue;
                flexField = assistDyn.getString("flexfield");
                allFlexFieldToValueMap.put(flexField, new HashSet());
            }
        }
        for (Map.Entry entry : allFlexFieldToValueMap.entrySet()) {
            String flexField = (String)entry.getKey();
            Set allAssistValueIdSet = (Set)entry.getValue();
            String entityId = this.flexFieldToAssistEntityMap.get(flexField);
            if (!StringUtils.isNotEmpty((CharSequence)entityId)) continue;
            ArrayList<QFilter> arrayList = new ArrayList<QFilter>(8);
            arrayList.add(new QFilter("asstype", "=", (Object)flexField));
            if (CollectionUtils.isNotEmpty((Collection)allAssistValueIdSet)) {
                arrayList.add(new QFilter("assval", "in", (Object)allAssistValueIdSet));
            }
            String selectFields = "hg, assval " + flexField;
            DataSet hg = this.queryHgByFlexField(entityId, selectFields, arrayList, null);
            this.flexFieldToHgMap.put(flexField, hg);
        }
        long endTime = System.currentTimeMillis();
        this.log.info("init hg cost time\uff1a" + (endTime - startTime));
    }

    public DataSet queryHgByFlexField(String entityId, String selectFields, List<QFilter> filters, String orderBys) {
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityId, (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), (String)orderBys);
    }

    private boolean isRangeAccountNum(String accountNum, String rangeNum) {
        String[] rangeNums = rangeNum.substring(1, rangeNum.length() - 1).split(",");
        return rangeNums.length == 2 && accountNum.compareTo(rangeNums[0]) >= 0 && accountNum.compareTo(rangeNums[1]) <= 0 && accountNum.length() == rangeNums[0].length();
    }

    public Map<String, Map<String, DynamicObject>> getFormulaToAccountsMap() {
        return this.formulaToAccountsMap;
    }

    public void setFormulaToAccountsMap(Map<String, Map<String, DynamicObject>> formulaToAccountsMap) {
        this.formulaToAccountsMap = formulaToAccountsMap;
    }

    public Map<String, Long> getAccountTableIdMap() {
        return this.accountTableIdMap;
    }

    public void setAccountTableIdMap(Map<String, Long> accountTableIdMap) {
        this.accountTableIdMap = accountTableIdMap;
    }

    public Map<Long, Long> getAccountIdToMasterIdMap() {
        return this.accountIdToMasterIdMap;
    }

    public void setAccountIdToMasterIdMap(Map<Long, Long> accountIdToMasterIdMap) {
        this.accountIdToMasterIdMap = accountIdToMasterIdMap;
    }

    public Map<Long, Set<Long>> getDirectChildAccountMap() {
        return this.directChildAccountMap;
    }

    public void setDirectChildAccountMap(Map<Long, Set<Long>> directChildAccountMap) {
        this.directChildAccountMap = directChildAccountMap;
    }

    public Map<Long, Set<Long>> getAllDetailedAccountMap() {
        return this.allDetailedAccountMap;
    }

    public void setAllDetailedAccountMap(Map<Long, Set<Long>> allDetailedAccountMap) {
        this.allDetailedAccountMap = allDetailedAccountMap;
    }

    public Map<String, DynamicObject> getAssistMap() {
        return this.assistMap;
    }

    public void setAssistMap(Map<String, DynamicObject> assistMap) {
        this.assistMap = assistMap;
    }

    public Map<Long, Set<String>> getAccountIdToFlexFieldMap() {
        return this.accountIdToFlexFieldMap;
    }

    public void setAccountIdToFlexFieldMap(Map<Long, Set<String>> accountIdToFlexFieldMap) {
        this.accountIdToFlexFieldMap = accountIdToFlexFieldMap;
    }

    public Map<String, String> getFlexFieldToAssistEntityMap() {
        return this.flexFieldToAssistEntityMap;
    }

    public void setFlexFieldToAssistEntityMap(Map<String, String> flexFieldToAssistEntityMap) {
        this.flexFieldToAssistEntityMap = flexFieldToAssistEntityMap;
    }

    public Table<String, String, Map<String, Set<Object>>> getAssistValueNumberToIdTable() {
        return this.assistValueNumberToIdTable;
    }

    public void setAssistValueNumberToIdTable(Table<String, String, Map<String, Set<Object>>> assistValueNumberToIdTable) {
        this.assistValueNumberToIdTable = assistValueNumberToIdTable;
    }

    public Table<String, String, Map<String, Set<Object>>> getAssistRangeValToIdTable() {
        return this.assistRangeValToIdTable;
    }

    public void setAssistRangeValToIdTable(Table<String, String, Map<String, Set<Object>>> assistRangeValToIdTable) {
        this.assistRangeValToIdTable = assistRangeValToIdTable;
    }

    public Map<Long, String> getAccountIdToNumberMap() {
        return this.accountIdToNumberMap;
    }

    public void setAccountIdToNumberMap(Map<Long, String> accountIdToNumberMap) {
        this.accountIdToNumberMap = accountIdToNumberMap;
    }

    public Map<String, DataSet> getFlexFieldToHgMap() {
        return this.flexFieldToHgMap;
    }

    public void setFlexFieldToHgMap(Map<String, DataSet> flexFieldToHgMap) {
        this.flexFieldToHgMap = flexFieldToHgMap;
    }

    public Table<String, String, Map<Object, Set<String>>> getAssistValIdToNumTable() {
        return this.assistValIdToNumTable;
    }

    public void setAssistValIdToNumTable(Table<String, String, Map<Object, Set<String>>> assistValIdToNumTable) {
        this.assistValIdToNumTable = assistValIdToNumTable;
    }
}

