/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.batchquery.account;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.ict.mservice.formula.batchquery.param.FloatBaseFormula;
import kd.fi.ict.mservice.formula.batchquery.param.FormulaFloatKey;
import kd.fi.ict.mservice.formula.common.FormulaCommon;
import kd.fi.ict.mservice.formula.common.FormulaParamIndex;
import kd.fi.ict.mservice.formula.common.utils.AcctUtil;

public class AcctFloatFormula
extends FloatBaseFormula {
    private Map<String, DynamicObject> accountNumberToDynMap;
    private Set<String> accountContinueNumberSet;
    private Map<String, List<String>> assistToValueNumberMap;
    private Map<String, List<String>> assistToRangeValueMap;
    private Set<String> allValueAssistNumberSet;
    private int reClassType;
    private Map<FormulaFloatKey, Map<String, BigDecimal>> combinationToAmountByAccountMap;

    public AcctFloatFormula(FormulaCommon floatFormulaCommon, String fKey, List<String> fParams) {
        super(floatFormulaCommon, fKey, fParams);
        this.initAcctFloatFormula(floatFormulaCommon, fParams);
    }

    private void initAcctFloatFormula(FormulaCommon fCommon, List<String> fParams) {
        this.parseAccountAndAssist(fParams.get(FormulaParamIndex.ACCTANDASSGRP.getValue()), fCommon.getRefParamMap());
        this.reClassType = StringUtils.isNotBlank((CharSequence)fParams.get(FormulaParamIndex.RECLASSTYPE.getValue())) ? Integer.parseInt(fParams.get(FormulaParamIndex.RECLASSTYPE.getValue())) : fCommon.getAccountReClass();
        this.combinationToAmountByAccountMap = new HashMap<FormulaFloatKey, Map<String, BigDecimal>>(8);
    }

    private void parseAccountAndAssist(String accountAndAssistStr, Map<String, Object> floatParam) {
        this.accountContinueNumberSet = new HashSet<String>(8);
        this.accountNumberToDynMap = new HashMap<String, DynamicObject>(8);
        this.assistToValueNumberMap = new HashMap<String, List<String>>(8);
        this.assistToRangeValueMap = new HashMap<String, List<String>>(8);
        this.allValueAssistNumberSet = new HashSet<String>(8);
        AcctUtil.parseItemAndAssist(accountAndAssistStr, floatParam, this.accountContinueNumberSet, this.accountNumberToDynMap, this.assistToValueNumberMap, this.assistToRangeValueMap, this.allValueAssistNumberSet, this.getFloatTypeNumberList());
    }

    public Map<String, DynamicObject> getAccountNumberToDynMap() {
        return this.accountNumberToDynMap;
    }

    public void setAccountNumberToDynMap(Map<String, DynamicObject> accountNumberToDynMap) {
        this.accountNumberToDynMap = accountNumberToDynMap;
    }

    public Set<String> getAccountContinueNumberSet() {
        return this.accountContinueNumberSet;
    }

    public void setAccountContinueNumberSet(Set<String> accountContinueNumberSet) {
        this.accountContinueNumberSet = accountContinueNumberSet;
    }

    public Map<String, List<String>> getAssistToValueNumberMap() {
        return this.assistToValueNumberMap;
    }

    public void setAssistToValueNumberMap(Map<String, List<String>> assistToValueNumberMap) {
        this.assistToValueNumberMap = assistToValueNumberMap;
    }

    public Map<String, List<String>> getAssistToRangeValueMap() {
        return this.assistToRangeValueMap;
    }

    public void setAssistToRangeValueMap(Map<String, List<String>> assistToRangeValueMap) {
        this.assistToRangeValueMap = assistToRangeValueMap;
    }

    public Set<String> getAllValueAssistNumberSet() {
        return this.allValueAssistNumberSet;
    }

    public void setAllValueAssistNumberSet(Set<String> allValueAssistNumberSet) {
        this.allValueAssistNumberSet = allValueAssistNumberSet;
    }

    public int getReClassType() {
        return this.reClassType;
    }

    public void setReClassType(int reClassType) {
        this.reClassType = reClassType;
    }

    public Map<FormulaFloatKey, Map<String, BigDecimal>> getCombinationToAmountByAccountMap() {
        return this.combinationToAmountByAccountMap;
    }

    public void setCombinationToAmountByAccountMap(Map<FormulaFloatKey, Map<String, BigDecimal>> combinationToAmountByAccountMap) {
        this.combinationToAmountByAccountMap = combinationToAmountByAccountMap;
    }

    public Set<String> getAllAssistNumber() {
        HashSet<String> allAssistNumSet = new HashSet<String>(8);
        allAssistNumSet.addAll(this.assistToValueNumberMap.keySet());
        allAssistNumSet.addAll(this.assistToRangeValueMap.keySet());
        allAssistNumSet.addAll(this.allValueAssistNumberSet);
        return allAssistNumSet;
    }
}

