/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.batchquery.cashflow;

import com.google.common.collect.Table;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.ict.enums.PuchType;
import kd.fi.ict.mservice.formula.ICalculatorService;
import kd.fi.ict.mservice.formula.batchquery.cashflow.CfBatchQueryContext;
import kd.fi.ict.mservice.formula.batchquery.cashflow.CfFloatFormula;
import kd.fi.ict.mservice.formula.batchquery.cashflow.CfFloatFormulaParse;
import kd.fi.ict.mservice.formula.batchquery.param.FormulaFloatKey;
import kd.fi.ict.mservice.formula.common.fcf.CfFetchType;
import kd.fi.ict.mservice.formula.common.utils.AcctUtil;
import kd.fi.ict.puchamt.CfPuchAmtQueryExecutor;
import kd.fi.ict.puchamt.cf.CfPuchAmtQueryParam;

public class CfBatchCalculatorServiceImpl
implements ICalculatorService {
    private static final Log LOGGER = LogFactory.getLog(CfBatchCalculatorServiceImpl.class);

    @Override
    public String getCalculatorResult(String param) {
        String resultStr = null;
        try {
            LOGGER.info("ictcf \u53d6\u6570\u53c2\u6570:{}", (Object)param);
            long beforeTime = System.currentTimeMillis();
            CfFloatFormulaParse parser = new CfFloatFormulaParse(param);
            ArrayList<CfFloatFormula> legalFormulaList = new ArrayList<CfFloatFormula>(8);
            parser.getBookFormulasMap().values().forEach(legalFormulaList::addAll);
            CfBatchQueryContext context = new CfBatchQueryContext(parser.getfCommon(), (List<CfFloatFormula>)legalFormulaList);
            for (CfFloatFormula formula : legalFormulaList) {
                formula.setErrorMsg(this.checkFormula(context, formula));
                if (StringUtils.isNotBlank((CharSequence)formula.getErrorMsg())) continue;
                DataSet balance = this.getCashFlowBalance(context, formula);
                this.sumBalance(context, formula, balance);
            }
            resultStr = this.getResult(parser, legalFormulaList);
            LOGGER.info("ictcf \u53d6\u6570\u7ed3\u679c\uff1a {}\uff0c \u8017\u65f6\uff1a{}" + resultStr, (Object)(System.currentTimeMillis() - beforeTime));
        }
        catch (Exception e) {
            LOGGER.error("ictcf get balance exception : " + e.getMessage(), (Throwable)e);
        }
        return resultStr;
    }

    private String checkFormula(CfBatchQueryContext ctx, CfFloatFormula formula) {
        String errorMsg = this.checkOrg(ctx.getOrgNumberToIdMap(), formula.getOrgNumber());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkOpOrg(ctx.getOrgNumberToIdMap(), formula.getOpOrgNumberSet());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkBookType(ctx.getBookTypeNumberToIdMap(), formula.getBootTypeNumber());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkAccountBook(ctx.getAccountBookMap(), formula.getOrgNumber(), formula.getBootTypeNumber());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkPeriod(ctx.getPeriodMap(), formula.getfKey());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkCashFlowItem(formula.getCashFlowNumberToDynMap());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        Set<String> allAssistNumberSet = formula.getAllAssistNumber();
        errorMsg = this.checkAssist(allAssistNumberSet, ctx.getAssistMap());
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.checkAmtCalculatorField(formula.getPuchType(), formula.getFetchType());
        return errorMsg;
    }

    private String checkOrg(Map<String, Long> orgNumberToIdMap, String orgNumber) {
        if (!orgNumberToIdMap.containsKey(orgNumber)) {
            return String.format(ResManager.loadKDString((String)"\u672c\u65b9\u7ec4\u7ec7\u7f16\u7801:%s\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"CfBatchCalculatorServiceImpl_0", (String)"fi-ict-mservice", (Object[])new Object[0]), orgNumber);
        }
        return "";
    }

    private String checkOpOrg(Map<String, Long> orgNumberToIdMap, Set<String> opOrgNumberSet) {
        for (String opOrgNumber : opOrgNumberSet) {
            if (!orgNumberToIdMap.containsKey(opOrgNumber)) continue;
            return "";
        }
        return String.format(ResManager.loadKDString((String)"\u5bf9\u65b9\u7ec4\u7ec7\u7f16\u7801:%s\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"CfBatchCalculatorServiceImpl_1", (String)"fi-ict-mservice", (Object[])new Object[0]), String.join((CharSequence)",", opOrgNumberSet));
    }

    private String checkBookType(Map<String, Long> bookTypeNumberToIdMap, String bookTypeNumber) {
        if (!bookTypeNumberToIdMap.containsKey(bookTypeNumber)) {
            return String.format(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801:%s\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u8d26\u7c3f\u7c7b\u578b\u4fe1\u606f\u3002", (String)"CfBatchCalculatorServiceImpl_2", (String)"fi-ict-mservice", (Object[])new Object[0]), bookTypeNumber);
        }
        return "";
    }

    private String checkAccountBook(Map<String, DynamicObject> accountBookMap, String orgNumber, String bookTypeNumber) {
        DynamicObject accountBookInfo = accountBookMap.get(orgNumber + "*" + bookTypeNumber);
        if (accountBookInfo == null) {
            return String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7ec4\u7ec7\u7f16\u7801\uff1a%1$s\uff0c\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801\uff1a%2$s\uff0c\u5bf9\u5e94\u7684\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"CfBatchCalculatorServiceImpl_3", (String)"fi-ict-mservice", (Object[])new Object[0]), orgNumber, bookTypeNumber);
        }
        return "";
    }

    private String checkPeriod(Map<String, DynamicObject> periodMap, String formulaKey) {
        if (periodMap.isEmpty() || periodMap.get(formulaKey) == null) {
            return ResManager.loadKDString((String)"\u53d6\u4e0d\u5230\u671f\u95f4\uff0c\u8bf7\u67e5\u770b\u516c\u5f0f\u671f\u95f4\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"CfBatchCalculatorServiceImpl_4", (String)"fi-ict-mservice", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkCashFlowItem(Map<String, DynamicObject> cashNumberToDynMap) {
        cashNumberToDynMap.entrySet().removeIf(accountNumberToDynEntry -> accountNumberToDynEntry.getValue() == null);
        if (cashNumberToDynMap.isEmpty()) {
            return ResManager.loadKDString((String)"\u516c\u5f0f\u8bbe\u7f6e\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"CfBatchCalculatorServiceImpl_5", (String)"fi-ict-mservice", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkAssist(Set<String> assistNumberSet, Map<String, DynamicObject> assistMap) {
        for (String assistNumber : assistNumberSet) {
            if (assistMap.get(assistNumber) != null) continue;
            return String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u7f16\u7801\u4e3a\uff1a%s\u7684\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"CfBatchCalculatorServiceImpl_6", (String)"fi-ict-mservice", (Object[])new Object[0]), assistNumber);
        }
        return "";
    }

    private String checkAmtCalculatorField(PuchType puchType, String fetchType) {
        CfFetchType.AmtCaluatorField amtCalculatorField = CfFetchType.getAmtFieldByType(puchType, fetchType);
        if (Objects.isNull(amtCalculatorField)) {
            return ResManager.loadKDString((String)"\u5bf9\u8d26\u7c7b\u578b\u548c\u53d6\u6570\u7c7b\u578b\u4e3a\u9519\u8bef\u7ec4\u5408\u3002", (String)"CfBatchCalculatorServiceImpl_7", (String)"fi-ict-mservice", (Object[])new Object[0]);
        }
        return "";
    }

    private DataSet getCashFlowBalance(CfBatchQueryContext ctx, CfFloatFormula formula) {
        long startTime = System.currentTimeMillis();
        DataSet balance = this.queryBalanceJoinAssist(ctx, formula);
        long endTime = System.currentTimeMillis();
        LOGGER.info("get cashflow balance cost time\uff1a" + (endTime - startTime));
        return balance;
    }

    private DataSet queryBalanceJoinAssist(CfBatchQueryContext ctx, CfFloatFormula formula) {
        CfPuchAmtQueryParam cfParam = new CfPuchAmtQueryParam();
        StringBuilder selectFields = new StringBuilder("cfitem, oporg, assgrp");
        CfFetchType.AmtCaluatorField amtCalculatorField = CfFetchType.getAmtFieldByType(formula.getPuchType(), formula.getFetchType());
        if (amtCalculatorField != null) {
            for (String calField : amtCalculatorField.getCalFields()) {
                selectFields.append(",").append(calField);
            }
        }
        cfParam.setSelector(selectFields.toString());
        Map<String, Long> orgNumberToIdMap = ctx.getOrgNumberToIdMap();
        Long orgId = orgNumberToIdMap.getOrDefault(formula.getOrgNumber(), 0L);
        cfParam.setOrgIds(new long[]{orgId});
        HashSet<Long> opOrgIdSet = new HashSet<Long>(formula.getOpOrgNumberSet().size());
        for (String opOrgNumber : formula.getOpOrgNumberSet()) {
            opOrgIdSet.add(orgNumberToIdMap.getOrDefault(opOrgNumber, 0L));
        }
        if (cfParam.getFilters() == null) {
            cfParam.setFilters(new QFilter[]{new QFilter("oporg", "in", opOrgIdSet)});
        } else {
            List<QFilter> filterList = Arrays.asList(cfParam.getFilters());
            filterList.add(new QFilter("oporg", "in", opOrgIdSet));
            cfParam.setFilters(filterList.toArray(new QFilter[0]));
        }
        DynamicObject accountBookInfo = ctx.getAccountBookMap().get(formula.getOrgNumber() + "*" + formula.getBootTypeNumber());
        cfParam.setBookTypeId(accountBookInfo.getLong("bookstype.id"));
        cfParam.setBeginPeriodId(formula.getStartPeriodId().longValue());
        cfParam.setEndPeriodId(formula.getEndPeriodId().longValue());
        Set cashFlowIdSet = formula.getCashFlowNumberToDynMap().values().stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(Arrays.asList(cfParam.getFilters()));
        filterList.add(new QFilter("cfitem", "in", cashFlowIdSet));
        cfParam.setFilters(filterList.toArray(new QFilter[0]));
        DataSet balance = CfPuchAmtQueryExecutor.getInstance().getCfPuchAmt(cfParam);
        balance = this.balanceJoinAssist(balance, ctx, formula);
        Set<String> allAssistNumberSet = formula.getAllAssistNumber();
        balance = AcctUtil.filterBalanceByAssist(balance, allAssistNumberSet, ctx.getAssistMap());
        return balance;
    }

    private DataSet balanceJoinAssist(DataSet balance, CfBatchQueryContext ctx, CfFloatFormula formula) {
        Map<String, DataSet> flexFieldToHgMap = this.getHgByFlexField(ctx, formula);
        for (Map.Entry<String, DataSet> flexFieldToHgEntry : flexFieldToHgMap.entrySet()) {
            String flexField = flexFieldToHgEntry.getKey();
            DataSet assistDataSet = flexFieldToHgEntry.getValue();
            if (assistDataSet != null) {
                assistDataSet = assistDataSet.copy();
                List<String> balFields = AcctUtil.getDataSetCols(balance);
                List<String> assistList = AcctUtil.getDataSetCols(assistDataSet);
                assistList.remove("hg");
                balance = balance.join(assistDataSet, JoinType.LEFT).on("assgrp", "hg").select(balFields.toArray(new String[0]), assistList.toArray(new String[0])).finish();
                continue;
            }
            balance = balance.addNullField(flexField);
        }
        return balance;
    }

    private Map<String, DataSet> getHgByFlexField(CfBatchQueryContext ctx, CfFloatFormula formula) {
        String flexField;
        DynamicObject assistDyn;
        Map<String, DynamicObject> assistMap = ctx.getAssistMap();
        Table<String, String, Map<String, Set<Object>>> assistValueNumberToIdTable = ctx.getAssistValueNumberToIdTable();
        Table<String, String, Map<String, Set<Object>>> assistRangeValToIdTable = ctx.getAssistRangeValToIdTable();
        Map<String, DataSet> allFlexFieldToHgMap = ctx.getFlexFieldToHgMap();
        HashMap<String, DataSet> flexFieldToHgMap = new HashMap<String, DataSet>(8);
        String orgNumber = formula.getOrgNumber();
        Map<String, List<String>> assistToValueNumberMap = formula.getAssistToValueNumberMap();
        for (Map.Entry<String, List<String>> entry : assistToValueNumberMap.entrySet()) {
            String string = entry.getKey();
            List<String> valueNumberList = entry.getValue();
            assistDyn = assistMap.get(string);
            if (assistDyn == null || !CollectionUtils.isNotEmpty(valueNumberList)) continue;
            flexField = assistDyn.getString("flexfield");
            HashSet assistValueIdSet = new HashSet(valueNumberList.size());
            for (String valueNumber : valueNumberList) {
                if (((Map)assistValueNumberToIdTable.get((Object)orgNumber, (Object)string)).get(valueNumber) == null) continue;
                assistValueIdSet.addAll((Collection)((Map)assistValueNumberToIdTable.get((Object)orgNumber, (Object)string)).get(valueNumber));
            }
            DataSet dataSet = allFlexFieldToHgMap.get(flexField);
            if (dataSet != null) {
                DataSet copyDataSet = dataSet.copy();
                HashMap flexValsMap = new HashMap(8);
                flexValsMap.put("var1", assistValueIdSet);
                flexFieldToHgMap.put(flexField, copyDataSet.filter(flexField + " in var1 ", flexValsMap));
                continue;
            }
            flexFieldToHgMap.put(flexField, null);
        }
        Map<String, List<String>> assistToRangeValueMap = formula.getAssistToRangeValueMap();
        for (Map.Entry<String, List<String>> entry : assistToRangeValueMap.entrySet()) {
            String assistNumber = entry.getKey();
            List<String> rangeValueList = entry.getValue();
            DynamicObject assistDyn2 = assistMap.get(assistNumber);
            if (assistDyn2 == null || !CollectionUtils.isNotEmpty(rangeValueList)) continue;
            String flexField2 = assistDyn2.getString("flexfield");
            HashSet rangeValueIdSet = new HashSet(rangeValueList.size());
            for (String rangeValue : rangeValueList) {
                if (((Map)assistRangeValToIdTable.get((Object)orgNumber, (Object)assistNumber)).get(rangeValue) == null) continue;
                rangeValueIdSet.addAll((Collection)((Map)assistRangeValToIdTable.get((Object)orgNumber, (Object)assistNumber)).get(rangeValue));
            }
            DataSet dataSet = allFlexFieldToHgMap.get(flexField2);
            if (dataSet != null) {
                DataSet copyDataSet = dataSet.copy();
                HashMap flexValsMap = new HashMap(8);
                flexValsMap.put("var1", rangeValueIdSet);
                flexFieldToHgMap.put(flexField2, copyDataSet.filter(flexField2 + " in var1 ", flexValsMap));
                continue;
            }
            flexFieldToHgMap.put(flexField2, null);
        }
        Set<String> set = formula.getAllValueAssistNumberSet();
        for (String assistNumber : set) {
            assistDyn = assistMap.get(assistNumber);
            if (assistDyn == null) continue;
            flexField = assistDyn.getString("flexfield");
            DataSet dataSet = allFlexFieldToHgMap.get(flexField);
            DataSet copyDataSet = null;
            if (dataSet != null) {
                copyDataSet = dataSet.copy();
            }
            flexFieldToHgMap.put(flexField, copyDataSet);
        }
        return flexFieldToHgMap;
    }

    private void sumBalance(CfBatchQueryContext ctx, CfFloatFormula formula, DataSet balance) {
        long startTime = System.currentTimeMillis();
        Table<String, String, Map<Object, Set<String>>> assistValIdToNumTable = ctx.getAssistValIdToNumTable();
        Map assistValIdToNumMap = assistValIdToNumTable.row((Object)formula.getOrgNumber());
        HashMap<Long, String> orgIdToNumberMap = new HashMap<Long, String>(8);
        for (Map.Entry<String, Long> orgNumberToIdEntry : ctx.getOrgNumberToIdMap().entrySet()) {
            orgIdToNumberMap.put(orgNumberToIdEntry.getValue(), orgNumberToIdEntry.getKey());
        }
        CfFetchType.AmtCaluatorField amtCalculatorField = CfFetchType.getAmtFieldByType(formula.getPuchType(), formula.getFetchType());
        Map<FormulaFloatKey, BigDecimal> resultMap = formula.getResultMap();
        for (Row row : balance) {
            Set<Map<String, Object>> assistValueKeys = AcctUtil.buildAssistValueKeys(formula.getFloatTypeNumberList(), ctx.getAssistMap(), row, assistValIdToNumMap);
            BigDecimal amtRow = CfFetchType.rowCountByFetchType(row, amtCalculatorField);
            String opOrgNumber = (String)orgIdToNumberMap.get(row.getLong("oporg"));
            Set<FormulaFloatKey> formulaFloatKeySet = AcctUtil.buildFormulaFloatKey(opOrgNumber, assistValueKeys);
            for (FormulaFloatKey formulaFloatKey : formulaFloatKeySet) {
                BigDecimal amount = resultMap.computeIfAbsent(formulaFloatKey, key -> new BigDecimal("0"));
                amount = amount.add(amtRow);
                resultMap.put(formulaFloatKey, amount);
            }
        }
        long endTime = System.currentTimeMillis();
        LOGGER.info("sum balance cost all time\uff1a" + (endTime - startTime));
    }

    private String getResult(CfFloatFormulaParse parser, List<CfFloatFormula> formulas) {
        try {
            Map<String, Map<String, Object>> resultMap = parser.getResultMap();
            for (CfFloatFormula formula : formulas) {
                HashMap<String, Object> acctValueMap = new HashMap<String, Object>(8);
                if (StringUtils.isBlank((CharSequence)formula.getErrorMsg())) {
                    acctValueMap.put("v", this.getAmountResult(formula));
                    acctValueMap.put("success", true);
                    acctValueMap.put("failmsg", null);
                    acctValueMap.put("index", formula.getFloatTypeNumberList().contains("oporg") ? 0 : -1);
                } else {
                    acctValueMap.put("v", null);
                    acctValueMap.put("success", false);
                    acctValueMap.put("failmsg", formula.getErrorMsg());
                }
                resultMap.put(formula.getfKey(), acctValueMap);
            }
            return JSONUtils.toString(resultMap);
        }
        catch (IOException e) {
            LOGGER.error("ICTCF float getResult:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private Map<String, BigDecimal> getAmountResult(CfFloatFormula formula) {
        Map<FormulaFloatKey, BigDecimal> resultMap = formula.getResultMap();
        HashMap<String, BigDecimal> assistToResultMap = new HashMap<String, BigDecimal>(resultMap.size());
        List<String> floatTypeNumberList = formula.getFloatTypeNumberList();
        for (Map.Entry<FormulaFloatKey, BigDecimal> resultEntry : resultMap.entrySet()) {
            FormulaFloatKey floatValueKey = resultEntry.getKey();
            BigDecimal resultAmount = resultEntry.getValue();
            StringBuilder floatKey = new StringBuilder();
            for (String floatTypeNumber : floatTypeNumberList) {
                if ("oporg".equals(floatTypeNumber)) {
                    floatKey.append(floatValueKey.getOpOrgNumber()).append("|");
                    continue;
                }
                floatKey.append(floatValueKey.getAssistKey().get(floatTypeNumber)).append("|");
            }
            floatKey.delete(floatKey.length() - 1, floatKey.length());
            assistToResultMap.put(floatKey.toString(), assistToResultMap.containsKey(floatKey.toString()) ? ((BigDecimal)assistToResultMap.get(floatKey.toString())).add(resultAmount) : resultAmount);
        }
        return assistToResultMap;
    }
}

