/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.batchquery.cashflow;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ict.mservice.formula.batchquery.cashflow.CfFloatFormula;
import kd.fi.ict.mservice.formula.batchquery.param.FloatQueryContext;
import kd.fi.ict.mservice.formula.common.FormulaCommon;
import kd.fi.ict.mservice.formula.common.utils.AcctUtil;
import kd.fi.ict.mservice.formula.common.utils.MakeBaseDateDetailHelper;

public class CfBatchQueryContext
extends FloatQueryContext {
    private static final String AUXILIARY_DATA_TYPE = "2";
    private static final String MANUAL_DIMENSION = "3";
    private final Log log = LogFactory.getLog((String)CfBatchQueryContext.class.getName());
    private Map<String, DynamicObject> assistMap;
    private Map<String, String> flexFieldToAssistEntityMap;
    private Table<String, String, Map<String, Set<Object>>> assistValueNumberToIdTable;
    private Table<String, String, Map<String, Set<Object>>> assistRangeValToIdTable;
    private Map<String, DataSet> flexFieldToHgMap;
    private Table<String, String, Map<Object, Set<String>>> assistValIdToNumTable;
    private Map<String, Long> standardMap;
    private Map<String, DataSet> groupMap;

    public CfBatchQueryContext(FormulaCommon cfBatchQueryParam, List<CfFloatFormula> formulas) {
        super(cfBatchQueryParam, formulas);
        this.initCashFlowTable(formulas);
        this.initAssistMap(formulas);
        this.initAssistValueId(formulas);
        this.initHgByFlexField(formulas);
    }

    private void initCashFlowTable(List<CfFloatFormula> formulas) {
        HashMap<String, Set<String>> orgNumToCashNumsMap = new HashMap<String, Set<String>>(8);
        formulas.forEach(formula -> {
            Set cashNumSet = orgNumToCashNumsMap.computeIfAbsent(formula.getOrgNumber(), k -> new HashSet(8));
            cashNumSet.addAll(formula.getCashFlowNumberToDynMap().keySet());
        });
        Table<String, String, DynamicObject> orgCashNumToDynTable = this.getOrgCashNumToIdsTable(orgNumToCashNumsMap);
        formulas.forEach(formula -> {
            String orgNumber = formula.getOrgNumber();
            Map<String, DynamicObject> cashFlowNumberToDynMap = formula.getCashFlowNumberToDynMap();
            cashFlowNumberToDynMap.replaceAll((k, v) -> (DynamicObject)orgCashNumToDynTable.get((Object)orgNumber, k));
        });
    }

    private Table<String, String, DynamicObject> getOrgCashNumToIdsTable(Map<String, Set<String>> orgNumToCashNumsMap) {
        HashBasedTable orgCashNumToDynTable = HashBasedTable.create();
        for (Map.Entry<String, Set<String>> entry : orgNumToCashNumsMap.entrySet()) {
            String orgNum = entry.getKey();
            Long orgId = this.getOrgNumberToIdMap().getOrDefault(orgNum, 0L);
            if (orgId == 0L) continue;
            QFilter qids = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
            QFilter[] qfs = new QFilter[]{qids, new QFilter("number", "in", entry.getValue())};
            DynamicObjectCollection cashFlowDyns = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"id, number", (QFilter[])qfs);
            for (DynamicObject cashFlowDyn : cashFlowDyns) {
                String cashNum = cashFlowDyn.getString("number");
                orgCashNumToDynTable.put((Object)orgNum, (Object)cashNum, (Object)cashFlowDyn);
            }
        }
        return orgCashNumToDynTable;
    }

    private void initAssistMap(List<CfFloatFormula> formulas) {
        long startTime = System.currentTimeMillis();
        HashSet<String> allAssistNumberSet = new HashSet<String>();
        for (CfFloatFormula formula : formulas) {
            allAssistNumberSet.addAll(formula.getAllAssistNumber());
        }
        this.assistMap = new HashMap<String, DynamicObject>(allAssistNumberSet.size());
        this.flexFieldToAssistEntityMap = new HashMap<String, String>(allAssistNumberSet.size());
        QFilter numberQF = new QFilter("number", "in", allAssistNumberSet);
        QFilter flexIdQF = new QFilter("flexid", "=", (Object)2L);
        DynamicObjectCollection assistDyns = QueryServiceHelper.query((String)"bd_asstacttype", (String)"number, valuetype, assistanttype, valuesource, flexfield", (QFilter[])new QFilter[]{numberQF, flexIdQF});
        for (DynamicObject assistDyn : assistDyns) {
            this.assistMap.put(assistDyn.getString("number"), assistDyn);
            String flexField = assistDyn.getString("flexfield");
            String valueType = assistDyn.getString("valuetype");
            if (MANUAL_DIMENSION.equals(valueType)) {
                this.flexFieldToAssistEntityMap.put(flexField, "gl_assist_txt");
                continue;
            }
            this.flexFieldToAssistEntityMap.put(flexField, "gl_assist_bd");
        }
        this.log.info("CfBatchQueryContext_initAssistMap assistMap\uff1a" + this.assistMap);
        long endTime = System.currentTimeMillis();
        this.log.info("init assist cost time\uff1a" + (endTime - startTime));
    }

    private void initAssistValueId(List<CfFloatFormula> formulas) {
        long startTime = System.currentTimeMillis();
        this.assistValueNumberToIdTable = HashBasedTable.create();
        this.assistRangeValToIdTable = HashBasedTable.create();
        HashBasedTable allAssistToValueNumberTable = HashBasedTable.create();
        HashBasedTable allAssistToRangeValueTable = HashBasedTable.create();
        for (CfFloatFormula formula : formulas) {
            String orgNumber = formula.getOrgNumber();
            Map<String, List<String>> assistToValueNumberMap = formula.getAssistToValueNumberMap();
            for (Map.Entry<String, List<String>> assistToValueNumberEntry : assistToValueNumberMap.entrySet()) {
                Set<String> allValueNumSet;
                String assistNumber = assistToValueNumberEntry.getKey();
                List<String> valueNumberList = assistToValueNumberEntry.getValue();
                if (!CollectionUtils.isNotEmpty(valueNumberList)) continue;
                if (allAssistToValueNumberTable.contains((Object)orgNumber, (Object)assistNumber)) {
                    allValueNumSet = (Set)allAssistToValueNumberTable.get((Object)orgNumber, (Object)assistNumber);
                    allValueNumSet.addAll(valueNumberList);
                    continue;
                }
                allValueNumSet = new HashSet<String>(valueNumberList);
                allAssistToValueNumberTable.put((Object)orgNumber, (Object)assistNumber, allValueNumSet);
            }
            Map<String, List<String>> assistToRangeValueMap = formula.getAssistToRangeValueMap();
            for (Map.Entry<String, List<String>> assistToRangeValueEntry : assistToRangeValueMap.entrySet()) {
                String assistNumber = assistToRangeValueEntry.getKey();
                List<String> rangeValueList = assistToRangeValueEntry.getValue();
                if (!CollectionUtils.isNotEmpty(rangeValueList)) continue;
                if (allAssistToRangeValueTable.contains((Object)orgNumber, (Object)assistNumber)) {
                    Set allValueNumSet = (Set)allAssistToRangeValueTable.get((Object)orgNumber, (Object)assistNumber);
                    allValueNumSet.addAll(rangeValueList);
                    continue;
                }
                HashSet<String> allRangeValueSet = new HashSet<String>(rangeValueList);
                allAssistToRangeValueTable.put((Object)orgNumber, (Object)assistNumber, allRangeValueSet);
            }
        }
        this.queryAssistValueId((Table<String, String, Set<String>>)allAssistToValueNumberTable);
        this.queryAssistRangeValueId((Table<String, String, Set<String>>)allAssistToRangeValueTable);
        long endTime = System.currentTimeMillis();
        this.log.info("init assistValueId cost time\uff1a" + (endTime - startTime));
    }

    private void queryAssistValueId(Table<String, String, Set<String>> allAssistToValueNumberTable) {
        this.assistValIdToNumTable = HashBasedTable.create();
        for (Table.Cell allAssistToValueNumberCell : allAssistToValueNumberTable.cellSet()) {
            QFilter orgFilter;
            String orgNumber = (String)allAssistToValueNumberCell.getRowKey();
            long orgId = this.getOrgNumberToIdMap().getOrDefault(orgNumber, 0L);
            if (orgId == 0L) continue;
            String assistNumber = (String)allAssistToValueNumberCell.getColumnKey();
            DynamicObject assistDyn = this.assistMap.get(assistNumber);
            Set valueNumberSet = (Set)allAssistToValueNumberCell.getValue();
            if (assistDyn == null) continue;
            if (MANUAL_DIMENSION.equals(assistDyn.getString("valuetype"))) {
                Map<String, HashSet<String>> valueNumToIdMap = new HashMap(valueNumberSet.size());
                if (this.assistValueNumberToIdTable.contains((Object)orgNumber, (Object)assistNumber)) {
                    valueNumToIdMap = (Map)this.assistValueNumberToIdTable.get((Object)orgNumber, (Object)assistNumber);
                }
                Map<String, HashSet<String>> valueIdToNumsMap = new HashMap(8);
                if (this.assistValIdToNumTable.contains((Object)orgNumber, (Object)assistNumber)) {
                    valueIdToNumsMap = (Map)this.assistValIdToNumTable.get((Object)orgNumber, (Object)assistNumber);
                }
                for (String valueNumber : valueNumberSet) {
                    valueNumToIdMap.put(valueNumber, new HashSet<String>(Collections.singleton(valueNumber)));
                    valueIdToNumsMap.put(valueNumber, new HashSet<String>(Collections.singleton(valueNumber)));
                }
                this.assistValueNumberToIdTable.put((Object)orgNumber, (Object)assistNumber, valueNumToIdMap);
                this.assistValIdToNumTable.put((Object)orgNumber, (Object)assistNumber, valueIdToNumsMap);
                continue;
            }
            String entityId = assistDyn.getString("valuesource");
            ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
            if (entityId != null && (orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)orgId)) != null) {
                filters.add(orgFilter);
            }
            if (AUXILIARY_DATA_TYPE.equals(assistDyn.get("valuetype"))) {
                QFilter groupFilter = new QFilter("group", "=", (Object)assistDyn.getLong("assistanttype"));
                filters.add(groupFilter);
            }
            MakeBaseDateDetailHelper detailHelper = new MakeBaseDateDetailHelper();
            Map<String, Set<Long>> valueNumToIdsMap = detailHelper.getDetailAssists(entityId, valueNumberSet, filters);
            Map valNumToIdMap = new HashMap(8);
            if (this.assistValueNumberToIdTable.contains((Object)orgNumber, (Object)assistNumber)) {
                valNumToIdMap = (Map)this.assistValueNumberToIdTable.get((Object)orgNumber, (Object)assistNumber);
            }
            for (Map.Entry<String, Set<Long>> valueNumToIdsEntry : valueNumToIdsMap.entrySet()) {
                valNumToIdMap.put(valueNumToIdsEntry.getKey(), new HashSet(valueNumToIdsEntry.getValue()));
            }
            this.assistValueNumberToIdTable.put((Object)orgNumber, (Object)assistNumber, valNumToIdMap);
            Map<String, Object> floatValueNumberMap = this.getBatchQueryParam().getRefParamMap();
            List assistValueNumList = (List)floatValueNumberMap.get(assistNumber);
            if (CollectionUtils.isEmpty((Collection)assistValueNumList)) continue;
            for (String assistValueNumber : assistValueNumList) {
                Set<Long> valueIdSet = valueNumToIdsMap.get(assistValueNumber);
                if (CollectionUtils.isEmpty(valueIdSet)) continue;
                Map<Object, Set> valueIdToNumsMap = new HashMap(8);
                if (this.assistValIdToNumTable.contains((Object)orgNumber, (Object)assistNumber)) {
                    valueIdToNumsMap = (Map)this.assistValIdToNumTable.get((Object)orgNumber, (Object)assistNumber);
                }
                for (Long valueId : valueIdSet) {
                    Set idToValueNumberSet = valueIdToNumsMap.computeIfAbsent(valueId, key -> new HashSet(8));
                    idToValueNumberSet.add(assistValueNumber);
                }
                this.assistValIdToNumTable.put((Object)orgNumber, (Object)assistNumber, valueIdToNumsMap);
            }
        }
        this.log.info("CfBatchQueryContext_queryAssistValueId assistValueNumberToIdTable\uff1a" + this.assistValueNumberToIdTable);
        this.log.info("CfBatchQueryContext_queryAssistValueId assistValIdToNumTable\uff1a" + this.assistValIdToNumTable);
    }

    private void queryAssistRangeValueId(Table<String, String, Set<String>> allAssistToRangeValueTable) {
        this.standardMap = new HashMap<String, Long>(8);
        this.groupMap = new HashMap<String, DataSet>(8);
        MakeBaseDateDetailHelper detailHelper = new MakeBaseDateDetailHelper();
        for (Table.Cell allAssistToRangeValueCell : allAssistToRangeValueTable.cellSet()) {
            QFilter orgFilter;
            String orgNumber = (String)allAssistToRangeValueCell.getRowKey();
            long orgId = this.getOrgNumberToIdMap().getOrDefault(orgNumber, 0L);
            String assistNumber = (String)allAssistToRangeValueCell.getColumnKey();
            DynamicObject assistDyn = this.assistMap.get(assistNumber);
            Set assistRangeValueSet = (Set)allAssistToRangeValueCell.getValue();
            if (assistDyn == null) continue;
            String entityId = assistDyn.getString("valuesource");
            if (StringUtils.isBlank((CharSequence)entityId)) {
                Map<String, Set> rangeValueIdMap = new HashMap(8);
                if (this.assistRangeValToIdTable.contains((Object)orgNumber, (Object)assistNumber)) {
                    rangeValueIdMap = (Map)this.assistRangeValToIdTable.get((Object)orgNumber, (Object)assistNumber);
                }
                for (String rangeValueNum : assistRangeValueSet) {
                    String rangeValue = rangeValueNum.substring(1, rangeValueNum.length() - 1);
                    Set rangeValueIdSet = rangeValueIdMap.computeIfAbsent(rangeValueNum, key -> new HashSet());
                    rangeValueIdSet.addAll(Arrays.asList(rangeValue.split(",")));
                }
                this.assistRangeValToIdTable.put((Object)orgNumber, (Object)assistNumber, rangeValueIdMap);
                continue;
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
            if (orgId != 0L && (orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)orgId)) != null) {
                filters.add(orgFilter);
            }
            if (AUXILIARY_DATA_TYPE.equals(assistDyn.get("valuetype"))) {
                QFilter groupFilter = new QFilter("group", "=", (Object)assistDyn.getLong("assistanttype"));
                filters.add(groupFilter);
            }
            Map rangeValNumToIdMap = new HashMap(8);
            if (this.assistRangeValToIdTable.contains((Object)orgNumber, (Object)assistNumber)) {
                rangeValNumToIdMap = (Map)this.assistRangeValToIdTable.get((Object)orgNumber, (Object)assistNumber);
            }
            for (String rangeValueNum : assistRangeValueSet) {
                boolean isClassify = rangeValueNum.contains("#");
                DataSet assistDataSet = null;
                if (isClassify) {
                    assistDataSet = AcctUtil.queryAssistValByGroup(rangeValueNum, entityId, this.standardMap, this.groupMap);
                } else {
                    String rangeValue = rangeValueNum.substring(1, rangeValueNum.length() - 1);
                    String[] continueValNum = rangeValue.split(",");
                    assistDataSet = AcctUtil.queryContinueNumber(Arrays.asList(continueValNum), filters, "masterid", entityId);
                }
                HashSet<Object> rangeValueIdSet = new HashSet<Object>(8);
                if (assistDataSet != null) {
                    for (Row assist : assistDataSet) {
                        rangeValueIdSet.add(assist.getLong("masterid"));
                    }
                }
                HashSet<Object> allRangeValIdSet = new HashSet<Object>(8);
                if (CollectionUtils.isNotEmpty(rangeValueIdSet)) {
                    allRangeValIdSet.addAll(rangeValueIdSet);
                }
                if (detailHelper.hasParent(entityId)) {
                    Set<Object> detailAssistIdSet = detailHelper.getDetailAssisttContinueNumbers(entityId, rangeValueIdSet, filters);
                    allRangeValIdSet.addAll(detailAssistIdSet);
                }
                rangeValNumToIdMap.put(rangeValueNum, allRangeValIdSet);
            }
            this.assistRangeValToIdTable.put((Object)orgNumber, (Object)assistNumber, rangeValNumToIdMap);
        }
    }

    private void initHgByFlexField(List<CfFloatFormula> formulas) {
        long startTime = System.currentTimeMillis();
        this.flexFieldToHgMap = new HashMap<String, DataSet>(8);
        HashMap<String, Set> allFlexFieldToValueMap = new HashMap<String, Set>(8);
        for (CfFloatFormula cfFloatFormula : formulas) {
            String assistNumber;
            Object assistToRangeValueEntry2;
            String flexField;
            DynamicObject assistDyn;
            String orgNumber = cfFloatFormula.getOrgNumber();
            Map<String, List<String>> assistToValueNumberMap = cfFloatFormula.getAssistToValueNumberMap();
            for (Map.Entry<String, List<String>> entry : assistToValueNumberMap.entrySet()) {
                String assistNumber2 = entry.getKey();
                List<String> valueNumberList = entry.getValue();
                assistDyn = this.assistMap.get(assistNumber2);
                if (assistDyn == null || !CollectionUtils.isNotEmpty(valueNumberList)) continue;
                flexField = assistDyn.getString("flexfield");
                HashSet assistValueIdSet = new HashSet(valueNumberList.size());
                for (Object valueNumber : valueNumberList) {
                    if (this.assistValueNumberToIdTable.get((Object)orgNumber, (Object)assistNumber2) == null || !CollectionUtils.isNotEmpty((Collection)((Collection)((Map)this.assistValueNumberToIdTable.get((Object)orgNumber, (Object)assistNumber2)).get(valueNumber)))) continue;
                    assistValueIdSet.addAll((Collection)((Map)this.assistValueNumberToIdTable.get((Object)orgNumber, (Object)assistNumber2)).get(valueNumber));
                }
                if (allFlexFieldToValueMap.containsKey(flexField) && !Objects.isNull(allFlexFieldToValueMap.get(flexField)) && ((Set)allFlexFieldToValueMap.get(flexField)).isEmpty()) continue;
                Set allAssistValueIdSet = allFlexFieldToValueMap.computeIfAbsent(flexField, key -> new HashSet());
                allAssistValueIdSet.addAll(assistValueIdSet);
            }
            Map<String, List<String>> assistToRangeValueMap = cfFloatFormula.getAssistToRangeValueMap();
            for (Object assistToRangeValueEntry2 : assistToRangeValueMap.entrySet()) {
                Object valueNumber;
                assistNumber = assistToRangeValueEntry2.getKey();
                List rangeValueList = (List)assistToRangeValueEntry2.getValue();
                DynamicObject assistDyn2 = this.assistMap.get(assistNumber);
                if (assistDyn2 == null || !CollectionUtils.isNotEmpty((Collection)rangeValueList)) continue;
                String flexField2 = assistDyn2.getString("flexfield");
                HashSet assistValueIdSet = new HashSet(rangeValueList.size());
                valueNumber = rangeValueList.iterator();
                while (valueNumber.hasNext()) {
                    String rangeValue = (String)valueNumber.next();
                    assistValueIdSet.addAll((Collection)((Map)this.assistRangeValToIdTable.get((Object)orgNumber, (Object)assistNumber)).get(rangeValue));
                }
                if (allFlexFieldToValueMap.containsKey(flexField2) && !Objects.isNull(allFlexFieldToValueMap.get(flexField2)) && ((Set)allFlexFieldToValueMap.get(flexField2)).isEmpty()) continue;
                Set allAssistValueIdSet = allFlexFieldToValueMap.computeIfAbsent(flexField2, key -> new HashSet());
                allAssistValueIdSet.addAll(assistValueIdSet);
            }
            Set<String> set = cfFloatFormula.getAllValueAssistNumberSet();
            assistToRangeValueEntry2 = set.iterator();
            while (assistToRangeValueEntry2.hasNext()) {
                assistNumber = (String)assistToRangeValueEntry2.next();
                assistDyn = this.assistMap.get(assistNumber);
                if (assistDyn == null) continue;
                flexField = assistDyn.getString("flexfield");
                allFlexFieldToValueMap.put(flexField, new HashSet());
            }
        }
        for (Map.Entry entry : allFlexFieldToValueMap.entrySet()) {
            String flexField = (String)entry.getKey();
            Set allAssistValueIdSet = (Set)entry.getValue();
            String entityId = this.flexFieldToAssistEntityMap.get(flexField);
            if (!StringUtils.isNotEmpty((CharSequence)entityId)) continue;
            ArrayList<QFilter> arrayList = new ArrayList<QFilter>(8);
            arrayList.add(new QFilter("asstype", "=", (Object)flexField));
            if (CollectionUtils.isNotEmpty((Collection)allAssistValueIdSet)) {
                arrayList.add(new QFilter("assval", "in", (Object)allAssistValueIdSet));
            }
            String selectFields = "hg, assval " + flexField;
            DataSet hg = this.queryHgByFlexField(entityId, selectFields, arrayList, null);
            this.flexFieldToHgMap.put(flexField, hg);
        }
        long endTime = System.currentTimeMillis();
        this.log.info("init hg cost time\uff1a" + (endTime - startTime));
    }

    public DataSet queryHgByFlexField(String entityId, String selectFields, List<QFilter> filters, String orderBys) {
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityId, (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), (String)orderBys);
    }

    public Map<String, DynamicObject> getAssistMap() {
        return this.assistMap;
    }

    public void setAssistMap(Map<String, DynamicObject> assistMap) {
        this.assistMap = assistMap;
    }

    public Map<String, String> getFlexFieldToAssistEntityMap() {
        return this.flexFieldToAssistEntityMap;
    }

    public void setFlexFieldToAssistEntityMap(Map<String, String> flexFieldToAssistEntityMap) {
        this.flexFieldToAssistEntityMap = flexFieldToAssistEntityMap;
    }

    public Table<String, String, Map<String, Set<Object>>> getAssistValueNumberToIdTable() {
        return this.assistValueNumberToIdTable;
    }

    public void setAssistValueNumberToIdTable(Table<String, String, Map<String, Set<Object>>> assistValueNumberToIdTable) {
        this.assistValueNumberToIdTable = assistValueNumberToIdTable;
    }

    public Table<String, String, Map<String, Set<Object>>> getAssistRangeValToIdTable() {
        return this.assistRangeValToIdTable;
    }

    public void setAssistRangeValToIdTable(Table<String, String, Map<String, Set<Object>>> assistRangeValToIdTable) {
        this.assistRangeValToIdTable = assistRangeValToIdTable;
    }

    public Map<String, DataSet> getFlexFieldToHgMap() {
        return this.flexFieldToHgMap;
    }

    public void setFlexFieldToHgMap(Map<String, DataSet> flexFieldToHgMap) {
        this.flexFieldToHgMap = flexFieldToHgMap;
    }

    public Table<String, String, Map<Object, Set<String>>> getAssistValIdToNumTable() {
        return this.assistValIdToNumTable;
    }

    public void setAssistValIdToNumTable(Table<String, String, Map<Object, Set<String>>> assistValIdToNumTable) {
        this.assistValIdToNumTable = assistValIdToNumTable;
    }

    public Map<String, Long> getStandardMap() {
        return this.standardMap;
    }

    public void setStandardMap(Map<String, Long> standardMap) {
        this.standardMap = standardMap;
    }

    public Map<String, DataSet> getGroupMap() {
        return this.groupMap;
    }

    public void setGroupMap(Map<String, DataSet> groupMap) {
        this.groupMap = groupMap;
    }
}

