/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.batchquery.param;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ict.mservice.formula.batchquery.param.FloatBaseFormula;
import kd.fi.ict.mservice.formula.common.BaseFormula;
import kd.fi.ict.mservice.formula.common.FormulaCommon;
import kd.fi.ict.mservice.formula.common.utils.AcctPeriodUtil;
import kd.fi.ict.mservice.formula.common.utils.AcctUtil;

public class FloatQueryContext {
    private final Log log = LogFactory.getLog((String)FloatQueryContext.class.getName());
    private FormulaCommon batchQueryParam;
    private Map<String, Long> orgNumberToIdMap;
    private Map<String, Long> bookTypeNumberToIdMap;
    private Map<String, Long> currencyNumberToIdMap;
    private Map<String, DynamicObject> accountBookMap;
    private Map<String, DynamicObject> periodMap;

    public FloatQueryContext(FormulaCommon batchQueryParam, List<? extends FloatBaseFormula> formulas) {
        this.batchQueryParam = batchQueryParam;
        Set<String> allOrgNumberSet = formulas.stream().map(BaseFormula::getOrgNumber).collect(Collectors.toSet());
        formulas.forEach(formula -> allOrgNumberSet.addAll(formula.getOpOrgNumberSet()));
        this.orgNumberToIdMap = AcctUtil.numbersToIds("bos_org", allOrgNumberSet, null);
        this.bookTypeNumberToIdMap = AcctUtil.numbersToIds("bd_accountbookstype", formulas.stream().map(BaseFormula::getBootTypeNumber).collect(Collectors.toSet()), null);
        this.currencyNumberToIdMap = AcctUtil.numbersToIds("bd_currency", formulas.stream().map(BaseFormula::getCurrencyNumber).collect(Collectors.toSet()), null);
        this.initBookInfos(formulas);
        this.initPeriodMap(batchQueryParam.getFy(), batchQueryParam.getPeriod(), batchQueryParam.getAdjustPeriod(), formulas);
    }

    private void initBookInfos(List<? extends FloatBaseFormula> formulas) {
        this.accountBookMap = new HashMap<String, DynamicObject>(formulas.size());
        HashSet<Long> orgIdSet = new HashSet<Long>(8);
        HashSet<Long> bookTypeIdSet = new HashSet<Long>(8);
        for (FloatBaseFormula floatBaseFormula : formulas) {
            orgIdSet.add(this.orgNumberToIdMap.get(floatBaseFormula.getOrgNumber()));
            bookTypeIdSet.add(this.bookTypeNumberToIdMap.get(floatBaseFormula.getBootTypeNumber()));
        }
        Collection accountBookInfos = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)"org.number, bookstype.number, bookstype.id, accounttable.id, periodtype_id", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIdSet), new QFilter("bookstype", "in", bookTypeIdSet)}).values();
        HashBasedTable hashBasedTable = HashBasedTable.create();
        for (DynamicObject dynamicObject : accountBookInfos) {
            hashBasedTable.put((Object)dynamicObject.getString("org.number"), (Object)dynamicObject.getString("bookstype.number"), (Object)dynamicObject);
        }
        for (FloatBaseFormula floatBaseFormula : formulas) {
            String orgNumber = floatBaseFormula.getOrgNumber();
            String bookTypeNumber = floatBaseFormula.getBootTypeNumber();
            this.accountBookMap.put(orgNumber + "*" + bookTypeNumber, (DynamicObject)hashBasedTable.get((Object)orgNumber, (Object)bookTypeNumber));
        }
    }

    private void initPeriodMap(int comYear, int comPeriod, String comAdjustPeriod, List<? extends FloatBaseFormula> formulas) {
        this.periodMap = new HashMap<String, DynamicObject>(formulas.size());
        HashMap<String, Long> periodTypeIdMap = new HashMap<String, Long>(formulas.size());
        for (FloatBaseFormula floatBaseFormula : formulas) {
            Long periodTypeId = this.getPeriodTypeId(floatBaseFormula.getOrgNumber(), floatBaseFormula.getBootTypeNumber(), this.accountBookMap);
            if (periodTypeId == null) continue;
            periodTypeIdMap.put(floatBaseFormula.getfKey(), periodTypeId);
        }
        String selectFields = StringUtils.join((Object[])new String[]{"periodyear", "periodnumber", "id", "begindate", "enddate", "periodtype", "isadjustperiod"}, (String)",");
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bd_period", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("periodtype", "in", periodTypeIdMap.values())}, (String)"id");
        HashMap<Long, Table> periodTypeToPeriodMap = new HashMap<Long, Table>(periodTypeIdMap.size());
        for (DynamicObject period : dynamicObjectCollection) {
            Table table = periodTypeToPeriodMap.computeIfAbsent(period.getLong("periodtype"), key -> HashBasedTable.create());
            int periodYear = period.getInt("periodyear");
            int periodNum = period.getInt("periodnumber");
            if (periodNum >= 13) {
                table.put((Object)periodYear, (Object)String.valueOf(periodNum), (Object)period);
                table.put((Object)periodYear, (Object)(periodNum + "T"), (Object)period);
                continue;
            }
            if (period.getBoolean("isadjustperiod")) {
                table.put((Object)periodYear, (Object)(periodNum + "T"), (Object)period);
                continue;
            }
            table.put((Object)periodYear, (Object)String.valueOf(periodNum), (Object)period);
        }
        HashMap periodTypeToPeriodNumberMap = new HashMap(8);
        for (Map.Entry entry : periodTypeToPeriodMap.entrySet()) {
            Long periodTypeId = (Long)entry.getKey();
            Table periodTable = (Table)entry.getValue();
            Map periodFromYearMap = new HashMap(8);
            if (periodTypeToPeriodNumberMap.containsKey(periodTypeId)) {
                periodFromYearMap = (Map)periodTypeToPeriodNumberMap.get(periodTypeId);
            } else {
                periodTypeToPeriodNumberMap.put(periodTypeId, periodFromYearMap);
            }
            for (Table.Cell periodCell : periodTable.cellSet()) {
                String year = String.valueOf(periodCell.getRowKey());
                String periodNumber = (String)periodCell.getColumnKey();
                if (periodFromYearMap.containsKey(year)) {
                    if (Objects.isNull(periodNumber) || periodNumber.endsWith("T") && Integer.parseInt(periodNumber.substring(0, periodNumber.length() - 1)) > 12) continue;
                    ((List)periodFromYearMap.get(year)).add(periodNumber);
                    continue;
                }
                ArrayList<String> periodNumberList = new ArrayList<String>(8);
                periodNumberList.add(periodNumber);
                periodFromYearMap.put(year, periodNumberList);
            }
        }
        this.log.info("BatchQueryContext_initPeriodMap periodTypeToPeriodNumberMap:" + periodTypeToPeriodNumberMap);
        for (FloatBaseFormula floatBaseFormula : formulas) {
            Long periodTypeId = (Long)periodTypeIdMap.get(floatBaseFormula.getfKey());
            Table periodTable = (Table)periodTypeToPeriodMap.get(periodTypeId);
            if (floatBaseFormula.isMonthRpt()) {
                int year = -1;
                String periodStr = StringUtils.isNotBlank((CharSequence)comAdjustPeriod) ? comAdjustPeriod : String.valueOf(comPeriod);
                if (!AcctPeriodUtil.checkPeriodFormat(periodStr)) continue;
                String yearAndPeriodKey = AcctPeriodUtil.dealYearAndPeriod(floatBaseFormula.getPeriod(), comPeriod, comAdjustPeriod, String.valueOf(floatBaseFormula.getFy()), comYear, (Map)periodTypeToPeriodNumberMap.get(periodTypeId));
                String[] yearAndPeriod = yearAndPeriodKey.split("-");
                if (yearAndPeriod.length == 2) {
                    year = Integer.parseInt(yearAndPeriod[0]);
                    periodStr = yearAndPeriod[1];
                }
                if (periodTable == null) continue;
                Collection<DynamicObject> periodDyns = periodTable.row((Object)year).values();
                int maxPeriod = this.getMaxPeriod(periodDyns);
                if (!periodStr.endsWith("T") && Integer.parseInt(periodStr) > -maxPeriod && Integer.parseInt(periodStr) <= 0) {
                    periodStr = String.valueOf(Integer.parseInt(periodStr) + maxPeriod);
                }
                this.periodMap.put(floatBaseFormula.getfKey(), (DynamicObject)periodTable.get((Object)year, (Object)periodStr));
                long periodId = Objects.nonNull(periodTable.get((Object)year, (Object)periodStr)) ? ((DynamicObject)periodTable.get((Object)year, (Object)periodStr)).getLong("id") : 0L;
                floatBaseFormula.setStartPeriodId(periodId);
                floatBaseFormula.setEndPeriodId(periodId);
                continue;
            }
            DynamicObject startPeriodDyn = (DynamicObject)periodTable.get((Object)floatBaseFormula.getFy(), (Object)floatBaseFormula.getfCommon().getScopePeriods().get(0));
            DynamicObject endPeriodDyn = (DynamicObject)periodTable.get((Object)floatBaseFormula.getFy(), (Object)floatBaseFormula.getfCommon().getScopePeriods().get(1));
            this.periodMap.put(floatBaseFormula.getfKey(), endPeriodDyn);
            floatBaseFormula.setStartPeriodId(Objects.nonNull(startPeriodDyn) ? startPeriodDyn.getLong("id") : 0L);
            floatBaseFormula.setEndPeriodId(Objects.nonNull(endPeriodDyn) ? endPeriodDyn.getLong("id") : 0L);
        }
        this.log.info("BatchQueryContext_initPeriodMap periodMap:" + this.periodMap);
    }

    private int getMaxPeriod(Collection<DynamicObject> periodDyns) {
        int maxPeriod = 0;
        for (DynamicObject periodDyn : periodDyns) {
            if (periodDyn.getInt("periodnumber") <= maxPeriod) continue;
            maxPeriod = periodDyn.getInt("periodnumber");
        }
        return maxPeriod;
    }

    public FormulaCommon getBatchQueryParam() {
        return this.batchQueryParam;
    }

    public void setBatchQueryParam(FormulaCommon batchQueryParam) {
        this.batchQueryParam = batchQueryParam;
    }

    public Map<String, Long> getOrgNumberToIdMap() {
        return this.orgNumberToIdMap;
    }

    public void setOrgNumberToIdMap(Map<String, Long> orgNumberToIdMap) {
        this.orgNumberToIdMap = orgNumberToIdMap;
    }

    public Map<String, Long> getBookTypeNumberToIdMap() {
        return this.bookTypeNumberToIdMap;
    }

    public void setBookTypeNumberToIdMap(Map<String, Long> bookTypeNumberToIdMap) {
        this.bookTypeNumberToIdMap = bookTypeNumberToIdMap;
    }

    public Map<String, Long> getCurrencyNumberToIdMap() {
        return this.currencyNumberToIdMap;
    }

    public void setCurrencyNumberToIdMap(Map<String, Long> currencyNumberToIdMap) {
        this.currencyNumberToIdMap = currencyNumberToIdMap;
    }

    public Map<String, DynamicObject> getAccountBookMap() {
        return this.accountBookMap;
    }

    public void setAccountBookMap(Map<String, DynamicObject> accountBookMap) {
        this.accountBookMap = accountBookMap;
    }

    public Map<String, DynamicObject> getPeriodMap() {
        return this.periodMap;
    }

    public void setPeriodMap(Map<String, DynamicObject> periodMap) {
        this.periodMap = periodMap;
    }

    public Long getPeriodTypeId(String orgNumber, String bookTypeNumber, Map<String, DynamicObject> accountBookMap) {
        DynamicObject accountBook = accountBookMap.get(orgNumber + "*" + bookTypeNumber);
        if (accountBook != null) {
            return accountBook.getLong("periodtype_id");
        }
        return 0L;
    }
}

