/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.common;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.ict.enums.PuchType;
import kd.fi.ict.mservice.formula.common.FormulaCommon;
import kd.fi.ict.mservice.formula.common.FormulaParamIndex;
import kd.fi.ict.mservice.formula.common.exception.FormulaException;
import kd.fi.ict.mservice.formula.common.utils.AcctPeriodUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseFormula {
    private String fKey;
    private String orgNumber;
    private String bootTypeNumber;
    private String opOrgNumber;
    private PuchType puchType;
    private String fetchType;
    private Integer fy;
    private String period;
    private String currencyNumber;
    private boolean isMonthRpt = true;
    private Long startPeriodId;
    private Long endPeriodId;
    private FormulaCommon fCommon;

    public BaseFormula(FormulaCommon fCommon, String fKey, List<String> fParams) {
        this.fKey = fKey;
        this.fCommon = fCommon;
        this.init(fParams);
    }

    private void init(List<String> params) {
        this.setOrgNumber(String.valueOf(params.get(FormulaParamIndex.ORG.getValue())));
        this.setBootTypeNumber(String.valueOf(params.get(FormulaParamIndex.BOOKTYPE.getValue())));
        this.setOpOrgNumber(String.valueOf(params.get(FormulaParamIndex.OPORG.getValue())));
        this.setPuchType(String.valueOf(params.get(FormulaParamIndex.PUCHTYPE.getValue())));
        this.setFetchType(String.valueOf(params.get(FormulaParamIndex.FETCHTYPE.getValue())));
        this.setFy(String.valueOf(params.get(FormulaParamIndex.YEAR.getValue())));
        this.setPeriod(AcctPeriodUtil.getPeriodParam(String.valueOf(params.get(FormulaParamIndex.PERIOD.getValue()))));
        if (params.size() > FormulaParamIndex.CURRENCY.getValue()) {
            this.setCurrencyNumber(String.valueOf(params.get(FormulaParamIndex.CURRENCY.getValue())));
        }
    }

    public String getMarkKey() {
        return this.orgNumber + "," + this.bootTypeNumber + "," + this.fy + "," + this.period;
    }

    public String getfKey() {
        return this.fKey;
    }

    public void setfKey(String fKey) {
        this.fKey = fKey;
    }

    public String getOrgNumber() {
        return this.orgNumber;
    }

    public void setOrgNumber(String orgNumber) {
        if (StringUtils.isEmpty((CharSequence)orgNumber)) {
            if (StringUtils.isEmpty((CharSequence)this.fCommon.getOrgNumber())) {
                throw new FormulaException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u7ec4\u7ec7", (String)"BaseFormula_0", (String)"fi-ict-mservice", (Object[])new Object[0]));
            }
            this.orgNumber = this.fCommon.getOrgNumber();
        } else {
            this.orgNumber = orgNumber;
        }
    }

    public String getBootTypeNumber() {
        return this.bootTypeNumber;
    }

    public void setBootTypeNumber(String bootTypeNumber) {
        if (StringUtils.isEmpty((CharSequence)bootTypeNumber)) {
            if (StringUtils.isEmpty((CharSequence)this.fCommon.getMainBookTypeNumber())) {
                throw new FormulaException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u8d26\u7c3f", (String)"BaseFormula_1", (String)"fi-ict-mservice", (Object[])new Object[0]));
            }
            this.bootTypeNumber = this.fCommon.getMainBookTypeNumber();
        } else {
            this.bootTypeNumber = bootTypeNumber;
        }
    }

    public String getOpOrgNumber() {
        return this.opOrgNumber;
    }

    public void setOpOrgNumber(String opOrgNumber) {
        if (StringUtils.isEmpty((CharSequence)opOrgNumber)) {
            throw new FormulaException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5bf9\u65b9\u7ec4\u7ec7", (String)"BaseFormula_2", (String)"fi-ict-mservice", (Object[])new Object[0]));
        }
        this.opOrgNumber = opOrgNumber;
    }

    public PuchType getPuchType() {
        return this.puchType;
    }

    public void setPuchType(String puchType) {
        if (PuchType.PULL.name().equalsIgnoreCase(puchType)) {
            this.puchType = PuchType.PULL;
        } else if (PuchType.CHECK.name().equalsIgnoreCase(puchType)) {
            this.puchType = PuchType.CHECK;
        } else if (PuchType.NOCHECK.name().equalsIgnoreCase(puchType)) {
            this.puchType = PuchType.NOCHECK;
        } else {
            throw new FormulaException(ResManager.loadKDString((String)"\u5bf9\u8d26\u7c7b\u578b\u9519\u8bef", (String)"BaseFormula_3", (String)"fi-ict-mservice", (Object[])new Object[0]));
        }
    }

    public String getFetchType() {
        return this.fetchType;
    }

    public void setFetchType(String fetchType) {
        this.fetchType = fetchType.toUpperCase();
    }

    public Integer getFy() {
        return this.fy;
    }

    public void setFy(String fy) {
        this.fy = Integer.parseInt(AcctPeriodUtil.getCurYear(fy, String.valueOf(this.fCommon.getFy())));
    }

    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        List<Integer> scopePeriods = this.fCommon.getScopePeriods();
        if (AcctPeriodUtil.checkPeriodFormat(period)) {
            if (!"0".equals(period)) {
                this.period = period;
                this.setMonthRpt(true);
            } else if (Objects.nonNull(scopePeriods) && scopePeriods.size() == 2) {
                this.period = String.valueOf(scopePeriods.get(1));
                this.setMonthRpt(false);
            } else {
                this.period = String.valueOf(this.fCommon.getPeriod());
                this.setMonthRpt(true);
            }
        } else {
            throw new FormulaException(ResManager.loadKDString((String)"\u516c\u5f0f\u671f\u95f4\u683c\u5f0f\u9519\u8bef", (String)"BaseFormula_4", (String)"fi-ict-mservice", (Object[])new Object[0]));
        }
    }

    public boolean isMonthRpt() {
        return this.isMonthRpt;
    }

    public void setMonthRpt(boolean monthRpt) {
        this.isMonthRpt = monthRpt;
    }

    public Long getStartPeriodId() {
        return this.startPeriodId;
    }

    public void setStartPeriodId(Long startPeriodId) {
        this.startPeriodId = startPeriodId;
    }

    public Long getEndPeriodId() {
        return this.endPeriodId;
    }

    public void setEndPeriodId(Long endPeriodId) {
        this.endPeriodId = endPeriodId;
    }

    public FormulaCommon getfCommon() {
        return this.fCommon;
    }

    public void setfCommon(FormulaCommon fCommon) {
        this.fCommon = fCommon;
    }

    public String getCurrencyNumber() {
        return this.currencyNumber;
    }

    public void setCurrencyNumber(String currencyNumber) {
        this.currencyNumber = currencyNumber;
    }

    public String toString() {
        return "BaseFormula{fKey='" + this.fKey + '\'' + ", orgNumber='" + this.orgNumber + '\'' + ", bootTypeNumber='" + this.bootTypeNumber + '\'' + ", opOrgNumber='" + this.opOrgNumber + '\'' + ", puchType=" + this.puchType + ", fetchType='" + this.fetchType + '\'' + ", fy=" + this.fy + ", period='" + this.period + '\'' + ", startPeriodId=" + this.startPeriodId + ", endPeriodId=" + this.endPeriodId + '}';
    }
}

