/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.ict.accsys.AccSysUtil;

public class FormulaCommon {
    private String formulaName;
    private String orgNumber;
    private Integer fy;
    private String adjustPeriod;
    private String currcncyNumber;
    private Integer accountReClass;
    private Integer period;
    private List<Integer> scopePeriods = new ArrayList<Integer>(2);
    private Map<String, Object> refParamMap;
    private Map<String, Set<String>> floatParamMap;
    private String mainBookTypeNumber;

    public FormulaCommon(String formulaName, Map<String, Object> commParam, Map<String, Object> refParamMap, Map<String, Set<String>> floatParamMap) {
        this.formulaName = formulaName;
        this.setOrgNumber(String.valueOf(commParam.get("org")));
        this.setFy(Integer.parseInt(String.valueOf(commParam.get("fy"))));
        if (commParam.get("period") instanceof String) {
            this.setAdjustPeriod(String.valueOf(commParam.get("period")));
            this.setPeriod(0);
        } else {
            this.setAdjustPeriod("");
            this.setPeriod((Integer)commParam.get("period"));
        }
        this.setCurrcncyNumber(String.valueOf(commParam.get("currency")));
        this.setAccountReClass(Integer.parseInt(String.valueOf(commParam.getOrDefault("accountreclass", 6))));
        this.setScopePeriods((List)commParam.get("scopePeriod"));
        this.setRefParamMap(refParamMap);
        this.setFloatParamMap(floatParamMap);
        this.setMainBookTypeNumber();
    }

    public String getFormulaName() {
        return this.formulaName;
    }

    public void setFormulaName(String formulaName) {
        this.formulaName = formulaName;
    }

    public String getOrgNumber() {
        return this.orgNumber;
    }

    public final void setOrgNumber(String orgNumber) {
        this.orgNumber = orgNumber;
    }

    public Integer getFy() {
        return this.fy;
    }

    public final void setFy(Integer fy) {
        this.fy = fy;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public final void setPeriod(Integer period) {
        this.period = period;
    }

    public String getAdjustPeriod() {
        return this.adjustPeriod;
    }

    public final void setAdjustPeriod(String adjustPeriod) {
        this.adjustPeriod = adjustPeriod;
    }

    public String getCurrcncyNumber() {
        return this.currcncyNumber;
    }

    public final void setCurrcncyNumber(String currcncyNumber) {
        this.currcncyNumber = currcncyNumber;
    }

    public Integer getAccountReClass() {
        return this.accountReClass;
    }

    public final void setAccountReClass(Integer accountReClass) {
        this.accountReClass = accountReClass;
    }

    public List<Integer> getScopePeriods() {
        return this.scopePeriods;
    }

    public final void setScopePeriods(List<Integer> scopePeriods) {
        if (Objects.nonNull(scopePeriods)) {
            this.scopePeriods = scopePeriods;
        }
    }

    public String getMainBookTypeNumber() {
        return this.mainBookTypeNumber;
    }

    public final void setMainBookTypeNumber() {
        DynamicObject mainBookType = AccSysUtil.getMainBookType();
        if (Objects.isNull(mainBookType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u7684\u7ec4\u7ec7\u53d6\u4e0d\u5230\u4e3b\u8d26\u7c3f\u7c7b\u578b", (String)"", (String)"", (Object[])new Object[0]));
        }
        this.mainBookTypeNumber = mainBookType.getString("number");
    }

    public Map<String, Object> getRefParamMap() {
        return this.refParamMap;
    }

    public final void setRefParamMap(Map<String, Object> refParamMap) {
        this.refParamMap = refParamMap;
    }

    public final void setFloatParamMap(Map<String, Set<String>> floatParamMap) {
        this.floatParamMap = floatParamMap;
    }

    public Map<String, Set<String>> getFloatParamMap() {
        return this.floatParamMap;
    }
}

