/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.JSONUtils;
import kd.fi.ict.mservice.formula.common.BaseFormula;
import kd.fi.ict.mservice.formula.common.FormulaCommon;
import kd.fi.ict.mservice.formula.common.exception.FormulaException;

public abstract class FormulaParse<T extends BaseFormula> {
    private final FormulaCommon fCommon;
    private final Map<String, List<T>> bookFormulasMap = new HashMap<String, List<T>>();
    private final Map<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>();

    public FormulaParse(String formulasStr) throws IOException {
        Map acctMap = (Map)JSONUtils.cast((String)formulasStr, Map.class);
        Map commParamMap = (Map)acctMap.get("commParam");
        Map refParamMap = (Map)acctMap.get("ref_param");
        Map floatParamMap = (Map)acctMap.get("float_param");
        String formulaName = (String)acctMap.get("formulaName");
        this.fCommon = new FormulaCommon(formulaName, commParamMap, refParamMap, floatParamMap);
        Map fParams = (Map)acctMap.get("param");
        int minParamSize = 0;
        if ("ICTACCT".equalsIgnoreCase(formulaName)) {
            minParamSize = 10;
        } else if ("ICTCF".equalsIgnoreCase(formulaName)) {
            minParamSize = 8;
        }
        int finalMinParamSize = minParamSize;
        fParams.forEach((fKey, fParam) -> {
            try {
                List fParamlst = (List)fParam;
                if (fParamlst.size() >= finalMinParamSize) {
                    T fInstance = this.getFormulaInstance(this.fCommon, (String)fKey, fParamlst);
                    String bookStr = ((BaseFormula)fInstance).getMarkKey();
                    this.bookFormulasMap.computeIfAbsent(bookStr, v -> new ArrayList()).add(fInstance);
                } else {
                    this.buildFailResult((String)fKey, String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u8981\u6c42\u81f3\u5c11%1$s\u4e2a\u53c2\u6570\uff0c\u5b9e\u9645\u4f20\u5165%2$s\u4e2a\u3002", (String)"FormulaParse_0", (String)"fi-ict-mservice", (Object[])new Object[0]), finalMinParamSize, fParamlst.size()));
                }
            }
            catch (FormulaException e) {
                this.buildFailResult((String)fKey, e.getMessage());
            }
        });
    }

    public abstract T getFormulaInstance(FormulaCommon var1, String var2, List<String> var3);

    public abstract void buildFailResult(String var1, String var2);

    public FormulaCommon getfCommon() {
        return this.fCommon;
    }

    public Map<String, List<T>> getBookFormulasMap() {
        return this.bookFormulasMap;
    }

    public Map<String, Map<String, Object>> getResultMap() {
        return this.resultMap;
    }
}

