/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.common.facct;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ict.enums.PuchType;

public class AcctFetchType {
    protected static final Log log = LogFactory.getLog(AcctFetchType.class);
    private static final Map<String, AmtCaluatorField> FETCHTYPE_FIELD = new HashMap<String, AmtCaluatorField>(18);
    private static final Map<String, AmtCaluatorField> FETCHTYPE_FOR_FIELD;
    public static final List<String> FETCHTYPE_CUR;
    public static final List<String> FETCHTYPE_RECLASS;
    private static final List<String> FETCHJTYPE_D;
    private static final List<String> FETCHTYPE_Y;

    public static Map<String, AmtCaluatorField> getFetchTypeField() {
        return Collections.unmodifiableMap(FETCHTYPE_FIELD);
    }

    public static Map<String, AmtCaluatorField> getFetchTypeForField() {
        return Collections.unmodifiableMap(FETCHTYPE_FOR_FIELD);
    }

    public static List<String> getFetchTypeReclass() {
        return Collections.unmodifiableList(FETCHTYPE_RECLASS);
    }

    public static List<String> getFetchTypeD() {
        return Collections.unmodifiableList(FETCHJTYPE_D);
    }

    public static List<String> getFetchType_y() {
        return Collections.unmodifiableList(FETCHTYPE_Y);
    }

    public static BigDecimal rowCountByFetchType(Row row, AmtCaluatorField formulaCalulator) {
        try {
            String field0 = formulaCalulator.getExpression().get(0);
            BigDecimal obj = row.getBigDecimal(field0);
            BigDecimal result = obj == null ? new BigDecimal("0") : obj;
            for (int i = 1; i < formulaCalulator.getExpression().size(); ++i) {
                if (i % 2 != 1) continue;
                String flag = formulaCalulator.getExpression().get(i);
                String field1 = formulaCalulator.getExpression().get(i + 1);
                BigDecimal filed1Amt = row.getBigDecimal(field1);
                if ("+".equals(flag)) {
                    result = result.add(filed1Amt);
                    continue;
                }
                if (!"-".equals(flag)) continue;
                result = result.subtract(filed1Amt);
            }
            return result;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            log.info("==rowCountByFetchType row:{}  formulaCalulator:{}", (Object)row, (Object)formulaCalulator);
            return new BigDecimal("0");
        }
    }

    public static AmtCaluatorField getAmtFieldByType(PuchType puchType, String fetchType, boolean isBaseCurrency) {
        Map<String, AmtCaluatorField> amtCalculatorFieldMap = isBaseCurrency || fetchType.startsWith("L") ? AcctFetchType.getFetchTypeField() : AcctFetchType.getFetchTypeForField();
        String puchPrefix = "";
        switch (puchType) {
            case PULL: {
                if (amtCalculatorFieldMap.containsKey("P_" + fetchType)) {
                    puchPrefix = "P_";
                    break;
                }
                puchPrefix = "P_L";
                break;
            }
            case CHECK: {
                if (amtCalculatorFieldMap.containsKey("C_" + fetchType)) {
                    puchPrefix = "C_";
                    break;
                }
                puchPrefix = "C_L";
                break;
            }
            case NOCHECK: {
                puchPrefix = amtCalculatorFieldMap.containsKey("N_" + fetchType) ? "N_" : "N_L";
            }
        }
        return amtCalculatorFieldMap.get(puchPrefix + fetchType);
    }

    static {
        FETCHTYPE_FIELD.put("P_LCY", new AmtCaluatorField(Arrays.asList("pendlocal", "pyeardebitlocal", "pyearcreditlocal"), Arrays.asList("pendlocal", "+", "pyearcreditlocal", "-", "pyeardebitlocal")));
        FETCHTYPE_FIELD.put("P_LC", new AmtCaluatorField(Collections.singletonList("pbeginlocal"), Collections.singletonList("pbeginlocal")));
        FETCHTYPE_FIELD.put("P_LY", new AmtCaluatorField(Collections.singletonList("pendlocal"), Collections.singletonList("pendlocal")));
        FETCHTYPE_FIELD.put("P_LJFCY", new AmtCaluatorField(Arrays.asList("pendlocal", "pyeardebitlocal", "pyearcreditlocal"), Arrays.asList("pendlocal", "+", "pyearcreditlocal", "-", "pyeardebitlocal")));
        FETCHTYPE_FIELD.put("P_LDFCY", new AmtCaluatorField(Arrays.asList("pendlocal", "pyeardebitlocal", "pyearcreditlocal"), Arrays.asList("pendlocal", "+", "pyearcreditlocal", "-", "pyeardebitlocal")));
        FETCHTYPE_FIELD.put("P_LJC", new AmtCaluatorField(Collections.singletonList("pbeginlocal"), Collections.singletonList("pbeginlocal")));
        FETCHTYPE_FIELD.put("P_LDC", new AmtCaluatorField(Collections.singletonList("pbeginlocal"), Collections.singletonList("pbeginlocal")));
        FETCHTYPE_FIELD.put("P_LJY", new AmtCaluatorField(Collections.singletonList("pendlocal"), Collections.singletonList("pendlocal")));
        FETCHTYPE_FIELD.put("P_LDY", new AmtCaluatorField(Collections.singletonList("pendlocal"), Collections.singletonList("pendlocal")));
        FETCHTYPE_FIELD.put("P_LFS", new AmtCaluatorField(Arrays.asList("pdebitlocal", "pcreditlocal"), Arrays.asList("pdebitlocal", "-", "pcreditlocal")));
        FETCHTYPE_FIELD.put("P_LJF", new AmtCaluatorField(Collections.singletonList("pdebitlocal"), Collections.singletonList("pdebitlocal")));
        FETCHTYPE_FIELD.put("P_LDF", new AmtCaluatorField(Collections.singletonList("pcreditlocal"), Collections.singletonList("pcreditlocal")));
        FETCHTYPE_FIELD.put("P_LLJ", new AmtCaluatorField(Arrays.asList("pyeardebitlocal", "pyearcreditlocal"), Arrays.asList("pyeardebitlocal", "-", "pyearcreditlocal")));
        FETCHTYPE_FIELD.put("P_LJL", new AmtCaluatorField(Collections.singletonList("pyeardebitlocal"), Collections.singletonList("pyeardebitlocal")));
        FETCHTYPE_FIELD.put("P_LDL", new AmtCaluatorField(Collections.singletonList("pyearcreditlocal"), Collections.singletonList("pyearcreditlocal")));
        FETCHTYPE_FIELD.put("C_LCY", new AmtCaluatorField(Arrays.asList("cendlocal", "cyeardebitlocal", "cyearcreditlocal"), Arrays.asList("cendlocal", "+", "cyearcreditlocal", "-", "cyeardebitlocal")));
        FETCHTYPE_FIELD.put("C_LC", new AmtCaluatorField(Collections.singletonList("cbeginlocal"), Collections.singletonList("cbeginlocal")));
        FETCHTYPE_FIELD.put("C_LY", new AmtCaluatorField(Collections.singletonList("cendlocal"), Collections.singletonList("cendlocal")));
        FETCHTYPE_FIELD.put("C_LJFCY", new AmtCaluatorField(Arrays.asList("cendlocal", "cyeardebitlocal", "cyearcreditlocal"), Arrays.asList("cendlocal", "+", "cyearcreditlocal", "-", "cyeardebitlocal")));
        FETCHTYPE_FIELD.put("C_LDFCY", new AmtCaluatorField(Arrays.asList("cendlocal", "cyeardebitlocal", "cyearcreditlocal"), Arrays.asList("cendlocal", "+", "cyearcreditlocal", "-", "cyeardebitlocal")));
        FETCHTYPE_FIELD.put("C_LJC", new AmtCaluatorField(Collections.singletonList("cbeginlocal"), Collections.singletonList("cbeginlocal")));
        FETCHTYPE_FIELD.put("C_LDC", new AmtCaluatorField(Collections.singletonList("cbeginlocal"), Collections.singletonList("cbeginlocal")));
        FETCHTYPE_FIELD.put("C_LJY", new AmtCaluatorField(Collections.singletonList("cendlocal"), Collections.singletonList("cendlocal")));
        FETCHTYPE_FIELD.put("C_LDY", new AmtCaluatorField(Collections.singletonList("cendlocal"), Collections.singletonList("cendlocal")));
        FETCHTYPE_FIELD.put("C_LFS", new AmtCaluatorField(Arrays.asList("cdebitlocal", "ccreditlocal"), Arrays.asList("cdebitlocal", "-", "ccreditlocal")));
        FETCHTYPE_FIELD.put("C_LJF", new AmtCaluatorField(Collections.singletonList("cdebitlocal"), Collections.singletonList("cdebitlocal")));
        FETCHTYPE_FIELD.put("C_LDF", new AmtCaluatorField(Collections.singletonList("ccreditlocal"), Collections.singletonList("ccreditlocal")));
        FETCHTYPE_FIELD.put("C_LLJ", new AmtCaluatorField(Arrays.asList("cyeardebitlocal", "cyearcreditlocal"), Arrays.asList("cyeardebitlocal", "-", "cyearcreditlocal")));
        FETCHTYPE_FIELD.put("C_LJL", new AmtCaluatorField(Collections.singletonList("cyeardebitlocal"), Collections.singletonList("cyeardebitlocal")));
        FETCHTYPE_FIELD.put("C_LDL", new AmtCaluatorField(Collections.singletonList("cyearcreditlocal"), Collections.singletonList("cyearcreditlocal")));
        FETCHTYPE_FIELD.put("C_LQFS", new AmtCaluatorField(Arrays.asList("curcdebitlocal", "curccreditlocal"), Arrays.asList("curcdebitlocal", "-", "curccreditlocal")));
        FETCHTYPE_FIELD.put("C_LQJF", new AmtCaluatorField(Collections.singletonList("curcdebitlocal"), Collections.singletonList("curcdebitlocal")));
        FETCHTYPE_FIELD.put("C_LQDF", new AmtCaluatorField(Collections.singletonList("curccreditlocal"), Collections.singletonList("curccreditlocal")));
        FETCHTYPE_FIELD.put("N_LY", new AmtCaluatorField(Arrays.asList("pendlocal", "cendlocal"), Arrays.asList("pendlocal", "-", "cendlocal")));
        FETCHTYPE_FIELD.put("N_LJY", new AmtCaluatorField(Arrays.asList("pendlocal", "cendlocal"), Arrays.asList("pendlocal", "-", "cendlocal")));
        FETCHTYPE_FIELD.put("N_LDY", new AmtCaluatorField(Arrays.asList("pendlocal", "cendlocal"), Arrays.asList("pendlocal", "-", "cendlocal")));
        FETCHTYPE_FOR_FIELD = new HashMap<String, AmtCaluatorField>(18);
        FETCHTYPE_FOR_FIELD.put("P_CY", new AmtCaluatorField(Arrays.asList("pendfor", "pyeardebitfor", "pyearcreditfor"), Arrays.asList("pendfor", "+", "pyearcreditfor", "-", "pyeardebitfor")));
        FETCHTYPE_FOR_FIELD.put("P_C", new AmtCaluatorField(Collections.singletonList("pbeginfor"), Collections.singletonList("pbeginfor")));
        FETCHTYPE_FOR_FIELD.put("P_Y", new AmtCaluatorField(Collections.singletonList("pendfor"), Collections.singletonList("pendfor")));
        FETCHTYPE_FOR_FIELD.put("P_JFCY", new AmtCaluatorField(Arrays.asList("pendfor", "pyeardebitfor", "pyearcreditfor"), Arrays.asList("pendfor", "+", "pyearcreditfor", "-", "pyeardebitfor")));
        FETCHTYPE_FOR_FIELD.put("P_DFCY", new AmtCaluatorField(Arrays.asList("pendfor", "pyeardebitfor", "pyearcreditfor"), Arrays.asList("pendfor", "+", "pyearcreditfor", "-", "pyeardebitfor")));
        FETCHTYPE_FOR_FIELD.put("P_JC", new AmtCaluatorField(Collections.singletonList("pbeginfor"), Collections.singletonList("pbeginfor")));
        FETCHTYPE_FOR_FIELD.put("P_DC", new AmtCaluatorField(Collections.singletonList("pbeginfor"), Collections.singletonList("pbeginfor")));
        FETCHTYPE_FOR_FIELD.put("P_JY", new AmtCaluatorField(Collections.singletonList("pendfor"), Collections.singletonList("pendfor")));
        FETCHTYPE_FOR_FIELD.put("P_DY", new AmtCaluatorField(Collections.singletonList("pendfor"), Collections.singletonList("pendfor")));
        FETCHTYPE_FOR_FIELD.put("P_FS", new AmtCaluatorField(Arrays.asList("pdebitfor", "pcreditfor"), Arrays.asList("pdebitfor", "-", "pcreditfor")));
        FETCHTYPE_FOR_FIELD.put("P_JF", new AmtCaluatorField(Collections.singletonList("pdebitfor"), Collections.singletonList("pdebitfor")));
        FETCHTYPE_FOR_FIELD.put("P_DF", new AmtCaluatorField(Collections.singletonList("pcreditfor"), Collections.singletonList("pcreditfor")));
        FETCHTYPE_FOR_FIELD.put("P_LJ", new AmtCaluatorField(Arrays.asList("pyeardebitfor", "pyearcreditfor"), Arrays.asList("pyeardebitfor", "-", "pyearcreditfor")));
        FETCHTYPE_FOR_FIELD.put("P_JL", new AmtCaluatorField(Collections.singletonList("pyeardebitfor"), Collections.singletonList("pyeardebitfor")));
        FETCHTYPE_FOR_FIELD.put("P_DL", new AmtCaluatorField(Collections.singletonList("pyearcreditfor"), Collections.singletonList("pyearcreditfor")));
        FETCHTYPE_FOR_FIELD.put("C_CY", new AmtCaluatorField(Arrays.asList("cendfor", "cyeardebitfor", "cyearcreditfor"), Arrays.asList("cendfor", "+", "cyearcreditfor", "-", "cyeardebitfor")));
        FETCHTYPE_FOR_FIELD.put("C_C", new AmtCaluatorField(Collections.singletonList("cbeginfor"), Collections.singletonList("cbeginfor")));
        FETCHTYPE_FOR_FIELD.put("C_Y", new AmtCaluatorField(Collections.singletonList("cendfor"), Collections.singletonList("cendfor")));
        FETCHTYPE_FOR_FIELD.put("C_JFCY", new AmtCaluatorField(Arrays.asList("cendfor", "cyeardebitfor", "cyearcreditfor"), Arrays.asList("cendfor", "+", "cyearcreditfor", "-", "cyeardebitfor")));
        FETCHTYPE_FOR_FIELD.put("C_DFCY", new AmtCaluatorField(Arrays.asList("cendfor", "cyeardebitfor", "cyearcreditfor"), Arrays.asList("cendfor", "+", "cyearcreditfor", "-", "cyeardebitfor")));
        FETCHTYPE_FOR_FIELD.put("C_JC", new AmtCaluatorField(Collections.singletonList("cbeginfor"), Collections.singletonList("cbeginfor")));
        FETCHTYPE_FOR_FIELD.put("C_DC", new AmtCaluatorField(Collections.singletonList("cbeginfor"), Collections.singletonList("cbeginfor")));
        FETCHTYPE_FOR_FIELD.put("C_JY", new AmtCaluatorField(Collections.singletonList("cendfor"), Collections.singletonList("cendfor")));
        FETCHTYPE_FOR_FIELD.put("C_DY", new AmtCaluatorField(Collections.singletonList("cendfor"), Collections.singletonList("cendfor")));
        FETCHTYPE_FOR_FIELD.put("C_FS", new AmtCaluatorField(Arrays.asList("cdebitfor", "ccreditfor"), Arrays.asList("cdebitfor", "-", "ccreditfor")));
        FETCHTYPE_FOR_FIELD.put("C_JF", new AmtCaluatorField(Collections.singletonList("cdebitfor"), Collections.singletonList("cdebitfor")));
        FETCHTYPE_FOR_FIELD.put("C_DF", new AmtCaluatorField(Collections.singletonList("ccreditfor"), Collections.singletonList("ccreditfor")));
        FETCHTYPE_FOR_FIELD.put("C_LJ", new AmtCaluatorField(Arrays.asList("cyeardebitfor", "cyearcreditfor"), Arrays.asList("cyeardebitfor", "-", "cyearcreditfor")));
        FETCHTYPE_FOR_FIELD.put("C_JL", new AmtCaluatorField(Collections.singletonList("cyeardebitfor"), Collections.singletonList("cyeardebitfor")));
        FETCHTYPE_FOR_FIELD.put("C_DL", new AmtCaluatorField(Collections.singletonList("cyearcreditfor"), Collections.singletonList("cyearcreditfor")));
        FETCHTYPE_FOR_FIELD.put("C_QFS", new AmtCaluatorField(Arrays.asList("curcdebitfor", "curccreditfor"), Arrays.asList("curcdebitfor", "-", "curccreditfor")));
        FETCHTYPE_FOR_FIELD.put("C_QJF", new AmtCaluatorField(Collections.singletonList("curcdebitfor"), Collections.singletonList("curcdebitfor")));
        FETCHTYPE_FOR_FIELD.put("C_QDF", new AmtCaluatorField(Collections.singletonList("curccreditfor"), Collections.singletonList("curccreditfor")));
        FETCHTYPE_FOR_FIELD.put("N_Y", new AmtCaluatorField(Arrays.asList("pendfor", "cendfor"), Arrays.asList("pendfor", "-", "cendfor")));
        FETCHTYPE_FOR_FIELD.put("N_JY", new AmtCaluatorField(Arrays.asList("pendfor", "cendfor"), Arrays.asList("pendfor", "-", "cendfor")));
        FETCHTYPE_FOR_FIELD.put("N_DY", new AmtCaluatorField(Arrays.asList("pendfor", "cendfor"), Arrays.asList("pendfor", "-", "cendfor")));
        FETCHTYPE_CUR = Arrays.asList("QFS", "QJF", "QDF", "LQFS", "LQJF", "LQDF");
        FETCHTYPE_RECLASS = Arrays.asList("JFCY", "DFCY", "JC", "DC", "JY", "DY", "LJFCY", "LDFCY", "LJC", "LDC", "LJY", "LDY");
        FETCHJTYPE_D = new ArrayList<String>(){
            private static final long serialVersionUID = 2L;
            {
                this.add("DFCY");
                this.add("DC");
                this.add("DY");
                this.add("LDFCY");
                this.add("LDC");
                this.add("LDY");
            }
        };
        FETCHTYPE_Y = new ArrayList<String>(){
            private static final long serialVersionUID = 4L;
            {
                this.add("C");
                this.add("LC");
                this.add("Y");
                this.add("LY");
                this.add("CY");
                this.add("LCY");
                this.add("QC");
                this.add("QY");
                this.add("LQC");
                this.add("LQY");
                this.add("FS");
                this.add("LFS");
                this.add("LJ");
                this.add("LLJ");
                this.add("SY");
                this.add("SL");
                this.add("LSY");
                this.add("LSL");
                this.add("QFS");
                this.add("LQFS");
            }
        };
    }

    public static class AmtCaluatorField {
        private final List<String> calFields;
        private final List<String> expression;

        public AmtCaluatorField(List<String> calFields, List<String> expression) {
            this.calFields = calFields;
            this.expression = expression;
        }

        public List<String> getCalFields() {
            return this.calFields;
        }

        public List<String> getExpression() {
            return this.expression;
        }

        public String toString() {
            return "AmtCaluatorField{calFields=" + this.calFields + ", expression=" + this.expression + '}';
        }
    }
}

