/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.common.fcf;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.fi.ict.enums.PuchType;

public class CfFetchType {
    private static final Map<String, AmtCaluatorField> FETCHTYPE_FIELD = new HashMap<String, AmtCaluatorField>(18);

    public static Map<String, AmtCaluatorField> getFetchTypeField() {
        return Collections.unmodifiableMap(FETCHTYPE_FIELD);
    }

    public static BigDecimal rowCountByFetchType(Row row, AmtCaluatorField formulaCalulator) {
        String field0 = formulaCalulator.getExpression().get(0);
        BigDecimal obj = row.getBigDecimal(field0);
        BigDecimal result = obj == null ? new BigDecimal("0") : obj;
        for (int i = 1; i < formulaCalulator.getExpression().size(); ++i) {
            if (i % 2 != 1) continue;
            String flag = formulaCalulator.getExpression().get(i);
            String field1 = formulaCalulator.getExpression().get(i + 1);
            if ("+".equals(flag)) {
                result = result.add(row.getBigDecimal(field1));
                continue;
            }
            if (!"-".equals(flag)) continue;
            result = result.subtract(row.getBigDecimal(field1));
        }
        return result;
    }

    public static AmtCaluatorField getAmtFieldByType(PuchType puchType, String fetchType) {
        switch (puchType) {
            case PULL: {
                return CfFetchType.getFetchTypeField().get("P_" + fetchType);
            }
            case CHECK: {
                return CfFetchType.getFetchTypeField().get("C_" + fetchType);
            }
            case NOCHECK: {
                return CfFetchType.getFetchTypeField().get("N_" + fetchType);
            }
        }
        return null;
    }

    static {
        FETCHTYPE_FIELD.put("P_FS", new AmtCaluatorField(Collections.singletonList("pamount"), Collections.singletonList("pamount")));
        FETCHTYPE_FIELD.put("P_LJ", new AmtCaluatorField(Collections.singletonList("pyearamount"), Collections.singletonList("pyearamount")));
        FETCHTYPE_FIELD.put("C_FS", new AmtCaluatorField(Collections.singletonList("camount"), Collections.singletonList("camount")));
        FETCHTYPE_FIELD.put("C_LJ", new AmtCaluatorField(Collections.singletonList("cyearamount"), Collections.singletonList("cyearamount")));
        FETCHTYPE_FIELD.put("C_QFS", new AmtCaluatorField(Collections.singletonList("curamount"), Collections.singletonList("curamount")));
        FETCHTYPE_FIELD.put("N_FS", new AmtCaluatorField(Collections.singletonList("nocheckamount"), Collections.singletonList("nocheckamount")));
        FETCHTYPE_FIELD.put("N_QFS", new AmtCaluatorField(Collections.singletonList("curnamount"), Collections.singletonList("curnamount")));
    }

    public static class AmtCaluatorField {
        private final List<String> calFields;
        private final List<String> expression;

        public AmtCaluatorField(List<String> calFields, List<String> expression) {
            this.calFields = calFields;
            this.expression = expression;
        }

        public List<String> getCalFields() {
            return this.calFields;
        }

        public List<String> getExpression() {
            return this.expression;
        }
    }
}

