/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.common.utils;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.util.CollectionUtils;

public class AcctPeriodUtil {
    private static final String ZERO_PERIOD = "0";
    private static final char MINUS_SGIN = '-';

    public static String getPeriodParam(String periodParam) {
        if (StringUtils.isNotBlank((CharSequence)periodParam)) {
            return periodParam;
        }
        return ZERO_PERIOD;
    }

    public static boolean checkPeriodFormat(String periodStr) {
        if (StringUtils.isBlank((CharSequence)periodStr)) {
            return Boolean.FALSE;
        }
        if (periodStr.endsWith("T")) {
            char[] chars;
            if (StringUtils.isBlank((CharSequence)(periodStr = periodStr.substring(0, periodStr.length() - 1)))) {
                return Boolean.FALSE;
            }
            for (char ch : chars = periodStr.toCharArray()) {
                if (Character.isDigit(ch)) continue;
                return Boolean.FALSE;
            }
        } else {
            char[] chars = periodStr.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (i == 0 && '-' == chars[i] || Character.isDigit(chars[i])) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public static String dealYearAndPeriod(String periodStr, int comPeriod, String comAdjustPeriod, String yearStr, int comYear, Map<String, List<String>> periodFromYearMap) {
        String year = AcctPeriodUtil.getCurYear(yearStr, String.valueOf(comYear));
        String string = periodStr = StringUtils.isBlank((CharSequence)periodStr) ? ZERO_PERIOD : periodStr;
        if (periodStr.endsWith("T")) {
            return AcctPeriodUtil.buildYearAndPeriodKey(year, Integer.parseInt(periodStr.substring(0, periodStr.length() - 1)) + "T");
        }
        int period = Integer.parseInt(periodStr);
        if (period == 0) {
            return AcctPeriodUtil.buildYearAndPeriodKey(year, StringUtils.isNotBlank((CharSequence)comAdjustPeriod) ? comAdjustPeriod : String.valueOf(comPeriod));
        }
        if (period < 0) {
            List<String> curYearPeriodList;
            int index;
            String curPeriod;
            period = Math.abs(period);
            String string2 = curPeriod = StringUtils.isNotBlank((CharSequence)comAdjustPeriod) ? comAdjustPeriod : String.valueOf(comPeriod);
            if (curPeriod.endsWith("T") && Integer.parseInt(curPeriod.substring(0, curPeriod.length() - 1)) > 12) {
                curPeriod = curPeriod.substring(0, curPeriod.length() - 1);
            }
            if ((index = (curYearPeriodList = periodFromYearMap.get(year)).indexOf(curPeriod)) + 1 > period) {
                return AcctPeriodUtil.buildYearAndPeriodKey(year, curYearPeriodList.get(index - period));
            }
            List<String> lastYearPeriodList = periodFromYearMap.get(String.valueOf(Integer.parseInt(year) - 1));
            if (CollectionUtils.isNotEmpty(lastYearPeriodList) && lastYearPeriodList.size() + index + 1 > period) {
                return AcctPeriodUtil.buildYearAndPeriodKey(String.valueOf(Integer.parseInt(year) - 1), lastYearPeriodList.get(lastYearPeriodList.size() + index - period));
            }
            return ZERO_PERIOD;
        }
        return AcctPeriodUtil.buildYearAndPeriodKey(year, String.valueOf(Integer.parseInt(periodStr)));
    }

    public static String getCurYear(String yearStr, String comYear) {
        String year = yearStr = StringUtils.isBlank((CharSequence)yearStr) ? ZERO_PERIOD : yearStr;
        if (Integer.parseInt(yearStr) <= 1000) {
            year = String.valueOf(Integer.parseInt(yearStr) + Integer.parseInt(comYear));
        }
        return year;
    }

    private static String buildYearAndPeriodKey(String year, String period) {
        return year + "-" + period;
    }
}

