/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.common.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ict.mservice.formula.batchquery.param.FormulaFloatKey;
import kd.fi.ict.mservice.formula.common.combination.AssistCombination;
import kd.fi.ict.mservice.formula.single.NumberTransID;
import kd.fi.ict.mservice.formula.single.utils.FormulaUtils;
import kd.fi.ict.util.QFBuilder;

public class AcctUtil {
    public static final String ZERO_PERIOD = "0";
    private static final String ASSIST_SEPARATOR = "\\|";
    private static final String DISPERSED_SEPARATOR = ",";
    private static final String FLOAT_KEY = "@";
    private static final int BATCH_SIZE = 1000;

    public static boolean isContinueNumber(String valueNumber) {
        return valueNumber.startsWith("[") && valueNumber.endsWith("]") || valueNumber.contains("#");
    }

    public static Map<String, Long> numbersToIds(String entityName, Set<String> numbers, List<QFilter> filters) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (filters != null && !filters.isEmpty()) {
            qFilters.addAll(filters);
        }
        HashMap<String, Long> numberToIdMap = new HashMap<String, Long>();
        if (CollectionUtils.isNotEmpty(numbers)) {
            QFilter filter = new QFilter("number", "in", numbers);
            qFilters.add(filter);
        }
        DataSet querySet = QueryServiceHelper.queryDataSet((String)AcctUtil.class.getName(), (String)entityName, (String)"number, id", (QFilter[])qFilters.toArray(new QFilter[0]), null);
        for (Row row : querySet) {
            numberToIdMap.put(row.getString("number"), row.getLong("id"));
        }
        return numberToIdMap;
    }

    public static boolean hasMasteridProp(String entityId) {
        if ("bos_assistantdata_detail".equals(entityId)) {
            return true;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityId);
        DynamicProperty masterid = type.getProperty("masterid");
        return Objects.nonNull(masterid) && Objects.nonNull(masterid.getAlias());
    }

    public static DataSet queryDataSet(String entityName, String selFields, List<QFilter> filters) {
        return QueryServiceHelper.queryDataSet((String)AcctUtil.class.getName(), (String)entityName, (String)selFields, (QFilter[])filters.toArray(new QFilter[0]), null);
    }

    public static DataSet queryAssistValByGroup(String categoryNumber, String entityId, Map<String, Long> standardMap, Map<String, DataSet> groupMap) {
        String groupKey = entityId.substring(3);
        String[] categoryList = categoryNumber.split("#");
        String standardNumber = categoryList[0];
        long standardId = 0L;
        if (standardMap.get(entityId + "*" + standardNumber) == null) {
            DataSet standardSet = QueryServiceHelper.queryDataSet((String)AcctUtil.class.getName(), (String)(entityId + "groupstandard"), (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)standardNumber)}, null);
            for (Row row : standardSet) {
                standardId = row.getLong("id");
            }
            standardMap.put(entityId + "*" + standardNumber, standardId);
        } else {
            standardId = standardMap.get(entityId + "*" + standardNumber);
        }
        String groupNumber = categoryList[1];
        DataSet assistDataSet = null;
        if (groupMap.get(entityId + "*" + groupNumber) == null) {
            Set<Long> allGroupIds = AcctUtil.queryLeafCategory(groupNumber, entityId);
            QFilter groupIdFilter = new QFilter("group", "in", allGroupIds);
            QFilter standardIdFilter = new QFilter("standard", "=", (Object)standardId);
            String sel = groupKey + " masterid";
            assistDataSet = QueryServiceHelper.queryDataSet((String)AcctUtil.class.getName(), (String)(entityId + "groupdetail"), (String)sel, (QFilter[])new QFilter[]{groupIdFilter, standardIdFilter}, null);
            groupMap.put(entityId + "*" + groupNumber, assistDataSet);
        } else {
            assistDataSet = groupMap.get(entityId + "*" + groupNumber);
        }
        return assistDataSet;
    }

    private static Set<Long> queryLeafCategory(String categoryNumber, String entityId) {
        entityId = entityId + "group";
        String[] assistContinueNumbers = null;
        String sel = "parent pid, id, isleaf";
        DataSet dataSet = null;
        if (categoryNumber.startsWith("[")) {
            assistContinueNumbers = (categoryNumber = categoryNumber.substring(1, categoryNumber.length() - 1)).split(DISPERSED_SEPARATOR);
            if (assistContinueNumbers.length == 2) {
                dataSet = AcctUtil.queryContinueNumber(Arrays.asList(assistContinueNumbers), new ArrayList<QFilter>(), sel, entityId);
            }
        } else {
            String[] categoryList = categoryNumber.split(DISPERSED_SEPARATOR);
            QFilter numberFilter = new QFilter("number", "in", (Object)categoryList);
            dataSet = QueryServiceHelper.queryDataSet((String)AcctUtil.class.getName(), (String)entityId, (String)sel, (QFilter[])new QFilter[]{numberFilter}, null);
        }
        HashSet<Long> allIds = new HashSet<Long>();
        HashSet<Long> noLeafIds = new HashSet<Long>();
        AcctUtil.getLeafAndNoLeaf(dataSet, noLeafIds, allIds);
        AcctUtil.getAllLeaf(noLeafIds, entityId, allIds);
        return allIds;
    }

    private static void getLeafAndNoLeaf(DataSet childSet, Set<Long> noLeafIds, Set<Long> allIds) {
        if (childSet == null) {
            return;
        }
        for (Row row : childSet) {
            long id = row.getLong("id");
            if (row.getBoolean("isleaf").booleanValue()) {
                allIds.add(id);
                continue;
            }
            allIds.add(id);
            noLeafIds.add(id);
        }
    }

    private static void getAllLeaf(Set<Long> noLeafIds, String entityId, Set<Long> leafIds) {
        if (noLeafIds.isEmpty()) {
            return;
        }
        QFilter parentFilter = new QFilter("parent", "in", noLeafIds);
        String sel = "id, isleaf";
        DataSet childSet = QueryServiceHelper.queryDataSet((String)AcctUtil.class.getName(), (String)entityId, (String)sel, (QFilter[])new QFilter[]{parentFilter}, null);
        noLeafIds.clear();
        AcctUtil.getLeafAndNoLeaf(childSet, noLeafIds, leafIds);
        AcctUtil.getAllLeaf(noLeafIds, entityId, leafIds);
    }

    public static DataSet queryContinueNumber(List<String> assistNumbers, List<QFilter> filters, String sel, String entityName) {
        String startNumber = assistNumbers.get(0);
        String endNumber = assistNumbers.get(1);
        QFilter filterMin = new QFilter("number", ">=", (Object)startNumber);
        QFilter filterMax = new QFilter("number", "<=", (Object)endNumber);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(filters);
        filterList.add(filterMin);
        filterList.add(filterMax);
        return QueryServiceHelper.queryDataSet((String)AcctUtil.class.getName(), (String)entityName, (String)sel, (QFilter[])filterList.toArray(new QFilter[0]), (String)"number");
    }

    public static List<String> getDataSetCols(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            list.add(field.getName());
        }
        return list;
    }

    public static void parseItemAndAssist(String itemAndAssistStr, Map<String, Object> floatParam, Set<String> itemContinueNumberSet, Map<String, DynamicObject> itemNumberToDynMap, Map<String, List<String>> assistToValueNumberMap, Map<String, List<String>> assistToRangeValueMap, Set<String> allValueAssistNumberSet, List<String> floatTypeNumberList) {
        itemAndAssistStr = itemAndAssistStr.replaceAll(ASSIST_SEPARATOR, "\\| ");
        String[] itemAndAssistSplit = itemAndAssistStr.split(ASSIST_SEPARATOR);
        String itemStr = itemAndAssistSplit[0];
        if (Objects.nonNull(itemContinueNumberSet) && AcctUtil.isContinueNumber(itemStr)) {
            itemContinueNumberSet.add(itemStr);
        } else {
            String[] itemNumbers;
            for (String itemNumber : itemNumbers = itemStr.split(DISPERSED_SEPARATOR)) {
                itemNumberToDynMap.put(itemNumber, null);
            }
        }
        ArrayList<String> tempFloatTypeNumberList = new ArrayList<String>(floatTypeNumberList);
        floatTypeNumberList.clear();
        for (int index = 1; index < itemAndAssistSplit.length; index += 2) {
            String assistNumber = itemAndAssistSplit[index].trim();
            String valueNumber = itemAndAssistSplit[index + 1].trim();
            if (FLOAT_KEY.equals(valueNumber)) {
                assistToValueNumberMap.put(assistNumber, (List)floatParam.get(assistNumber));
                floatTypeNumberList.add(assistNumber);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)valueNumber)) {
                allValueAssistNumberSet.add(assistNumber);
                continue;
            }
            if (AcctUtil.isContinueNumber(valueNumber)) {
                List rangeValueList = assistToRangeValueMap.computeIfAbsent(assistNumber, key -> new ArrayList(8));
                rangeValueList.add(valueNumber);
                continue;
            }
            assistToValueNumberMap.put(assistNumber, new ArrayList<String>(Arrays.asList(valueNumber.split(DISPERSED_SEPARATOR))));
        }
        floatTypeNumberList.addAll(tempFloatTypeNumberList);
    }

    public static DataSet filterBalanceByAssist(DataSet balance, Set<String> assistNumberSet, Map<String, DynamicObject> assistMap) {
        if (!assistNumberSet.isEmpty()) {
            StringBuilder assistFilter = new StringBuilder();
            for (String assistNumber : assistNumberSet) {
                DynamicObject assistDyn = assistMap.get(assistNumber);
                if (assistDyn == null) continue;
                String flexField = assistDyn.getString("flexfield");
                assistFilter.append(flexField).append(" != null and ");
            }
            if (assistFilter.length() > 0) {
                assistFilter.delete(assistFilter.length() - 4, assistFilter.length());
            }
            return balance.filter(assistFilter.toString());
        }
        return balance;
    }

    public static Set<Map<String, Object>> buildAssistValueKeys(List<String> floatTypeNumberList, Map<String, DynamicObject> assistMap, Row row, Map<String, Map<Object, Set<String>>> assistValIdToNumMap) {
        HashMap<String, Set<Object>> combineAssistMap = new HashMap<String, Set<Object>>(8);
        for (String floatTypeNumber : floatTypeNumberList) {
            if ("oporg".equals(floatTypeNumber)) continue;
            String flexField = assistMap.get(floatTypeNumber).getString("flexfield");
            Object assistValueId = row.get(flexField);
            Map<Object, Set<String>> valueIdToNumMap = assistValIdToNumMap.get(floatTypeNumber);
            if (CollectionUtils.isNotEmpty(Collections.singleton(valueIdToNumMap))) {
                Set<String> valueNumberSet = valueIdToNumMap.get(assistValueId);
                if (CollectionUtils.isNotEmpty(valueNumberSet)) {
                    combineAssistMap.put(floatTypeNumber, new HashSet<String>(valueNumberSet));
                    continue;
                }
                return Collections.EMPTY_SET;
            }
            return Collections.EMPTY_SET;
        }
        HashSet<Map<String, Object>> assistCombinationSet = new HashSet<Map<String, Object>>(8);
        AssistCombination.parts(combineAssistMap, assistCombinationSet::add);
        return assistCombinationSet;
    }

    public static Set<FormulaFloatKey> buildFormulaFloatKey(String opOrgNumber, Set<Map<String, Object>> assistValueKeys) {
        HashSet<FormulaFloatKey> formulaFloatKeySet = new HashSet<FormulaFloatKey>(8);
        if (CollectionUtils.isEmpty(assistValueKeys)) {
            formulaFloatKeySet.add(new FormulaFloatKey(opOrgNumber, null));
        } else {
            for (Map<String, Object> assistValueKey : assistValueKeys) {
                formulaFloatKeySet.add(new FormulaFloatKey(opOrgNumber, assistValueKey));
            }
        }
        return formulaFloatKeySet;
    }

    public void acctReClassDeal(int acctReClass, Map<Long, Map<String, Set<Object>>> acctIdToAssistMap, Map<Long, Integer> acctToAssistStyleMap, Map<Long, Set<Long>> acctToRCAcctIdsMap, NumberTransID numberIDParam) {
        Map<Long, Set<Long>> directLeafMap = numberIDParam.getAcctToDirectLeafMap();
        Map<Long, Set<Long>> allLeafMap = numberIDParam.getAcctToAllLeafMap();
        Map<Long, Set<String>> acctToFlexMap = numberIDParam.getAcctToFlexsMap();
        HashMap<Long, Map<String, Set<Object>>> acctIdToAssistMapFor = new HashMap<Long, Map<String, Set<Object>>>(64);
        acctIdToAssistMapFor.putAll(acctIdToAssistMap);
        switch (acctReClass) {
            case 1: {
                for (Map.Entry entry : acctIdToAssistMapFor.entrySet()) {
                    long acctId = (Long)entry.getKey();
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    if (isSelectAssist) {
                        HashSet<Long> acctIds = new HashSet<Long>(64);
                        acctIds.add(acctId);
                        acctToRCAcctIdsMap.put(acctId, acctIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        Set<Long> directLeafIds = directLeafMap.get(acctId);
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    Set<Long> allLeafIds = allLeafMap.get(acctId);
                    acctToRCAcctIdsMap.put(acctId, allLeafIds);
                    acctToAssistStyleMap.put(acctId, 3);
                }
                break;
            }
            case 2: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    Set<Long> allLeafIds;
                    long acctId = entry.getKey();
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    if (isSelectAssist) {
                        allLeafIds = allLeafMap.get(acctId);
                        acctToRCAcctIdsMap.put(acctId, allLeafIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        allLeafIds = allLeafMap.get(acctId);
                        acctToRCAcctIdsMap.put(acctId, allLeafIds);
                        acctToAssistStyleMap.put(acctId, 3);
                        continue;
                    }
                    allLeafIds = allLeafMap.get(acctId);
                    acctToRCAcctIdsMap.put(acctId, allLeafIds);
                    acctToAssistStyleMap.put(acctId, 3);
                }
                break;
            }
            case 3: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    long acctId = entry.getKey();
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    Set<Long> directLeafIds = directLeafMap.get(acctId);
                    if (isSelectAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    acctToRCAcctIdsMap.put(acctId, directLeafIds);
                    acctToAssistStyleMap.put(acctId, 3);
                }
                break;
            }
            case 4: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    long acctId = entry.getKey();
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    Set<Long> allLeafIds = allLeafMap.get(acctId);
                    acctToRCAcctIdsMap.put(acctId, allLeafIds);
                    if (isSelectAssist) {
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    acctToAssistStyleMap.put(acctId, 1);
                }
                break;
            }
            case 5: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    long acctId = entry.getKey();
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    Set<Long> directLeafIds = directLeafMap.get(acctId);
                    if (isSelectAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    acctToRCAcctIdsMap.put(acctId, directLeafIds);
                    acctToAssistStyleMap.put(acctId, 1);
                }
                break;
            }
            case 6: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    HashSet<Long> acctIds;
                    long acctId = entry.getKey();
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    if (isSelectAssist) {
                        Set<Long> allLeafIds = allLeafMap.get(acctId);
                        acctToRCAcctIdsMap.put(acctId, allLeafIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctIds = new HashSet<Long>(16);
                        acctIds.add(acctId);
                        acctToRCAcctIdsMap.put(acctId, acctIds);
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    acctIds = new HashSet(16);
                    acctIds.add(acctId);
                    acctToRCAcctIdsMap.put(acctId, acctIds);
                    acctToAssistStyleMap.put(acctId, 1);
                }
                break;
            }
        }
    }

    private boolean acctIsContainAssistMap(Map<Long, Set<String>> acctToFlexMap, long acctId) {
        boolean isContainAssist = true;
        Set<String> flexs = acctToFlexMap.get(acctId);
        if (flexs == null || flexs.size() == 0) {
            isContainAssist = false;
        }
        return isContainAssist;
    }

    private boolean isSelectAssist(Map<Long, Map<String, Set<Object>>> acctIdToAssistMap, long acctId) {
        Map<String, Set<Object>> assistMap = acctIdToAssistMap.get(acctId);
        boolean isSelectAssist = assistMap != null && !assistMap.isEmpty();
        return isSelectAssist;
    }

    public Map<Long, Map<String, Set<Object>>> parseAcctAssistList(String accountListStr, NumberTransID numberIDParam, String fKey) {
        Map<String, Long> numberToIdMap = numberIDParam.getAcctNumberToIdsMap();
        Map<String, Set<Long>> rangeNumberToIdsMap = numberIDParam.getAcctRangeKeyToIdsMap();
        String[] accountValues = accountListStr.split(ASSIST_SEPARATOR);
        String acctsStr = accountValues[0];
        boolean isContinueAcct = FormulaUtils.isContinueNumber(acctsStr);
        HashMap<Long, Map<String, Set<Object>>> acctIdToAssistMap = new HashMap<Long, Map<String, Set<Object>>>(64);
        HashMap<String, Set<Object>> asstMap = new HashMap<String, Set<Object>>(8);
        Set<Object> acctIds = new HashSet(16);
        String accountNumber = this.parseAssistStr(accountListStr, asstMap, numberIDParam);
        if (isContinueAcct) {
            acctIds = rangeNumberToIdsMap.get(accountNumber);
            Iterator<Object> iterator = acctIds.iterator();
            while (iterator.hasNext()) {
                long acctId = (Long)iterator.next();
                acctIdToAssistMap.put(acctId, asstMap);
            }
        } else if (StringUtils.isEmpty((CharSequence)acctsStr)) {
            StringBuilder flexsStr = new StringBuilder();
            Set flexs = asstMap.keySet();
            for (String flex : flexs) {
                flexsStr = flexsStr.append(flex);
                flexsStr = flexsStr.append("*");
            }
            Iterator<Object> iterator = acctIds.iterator();
            while (iterator.hasNext()) {
                long acctId = (Long)iterator.next();
                acctIdToAssistMap.put(acctId, asstMap);
            }
        } else {
            String[] accountList;
            for (String acctNumberStr : accountList = acctsStr.split(DISPERSED_SEPARATOR)) {
                Long acctId = numberToIdMap.get(acctNumberStr);
                if (acctId == null) continue;
                acctIds.add(acctId);
                acctIdToAssistMap.put(acctId, asstMap);
            }
        }
        return acctIdToAssistMap;
    }

    private String parseAssistStr(String accountStr, Map<String, Set<Object>> asstMap, NumberTransID numberIDParam) {
        accountStr = accountStr.replaceAll(ASSIST_SEPARATOR, "\\| ");
        String[] accountValues = accountStr.split(ASSIST_SEPARATOR);
        String accountNumber = "";
        if (accountValues.length == 1) {
            accountNumber = accountValues[0];
        } else {
            if ((accountValues.length - 1) % 2 != 0) {
                return accountNumber;
            }
            accountNumber = accountValues[0];
        }
        Map<String, String> assistNumberToFlexMap = numberIDParam.getAssistToFlexMap();
        Map<String, Object> valNumberToIdsMap = numberIDParam.getassistValNumberToObjMap();
        Map<String, Set<Object>> valRangeNumberToIdsMap = numberIDParam.getassistValRangeNumberToObjsMap();
        Map<String, Set<Long>> assistFieldValToIdMap = numberIDParam.getAssistFieldValToIdMap();
        Map<String, Set<String>> filedMap = numberIDParam.getFieldToEntryFieldMap();
        for (int i = 1; i < accountValues.length; i += 2) {
            String assistNumber = accountValues[i].trim();
            String flex = assistNumberToFlexMap.get(assistNumber);
            if (StringUtils.isBlank((CharSequence)flex)) continue;
            Set<Object> valIds = new HashSet<Long>(16);
            if (StringUtils.isNotEmpty((CharSequence)accountValues[i + 1].trim())) {
                String valStr = accountValues[i + 1].trim();
                if (valStr.contains(":")) {
                    String[] valStrs = accountValues[i + 1].trim().replaceAll("\\:", "\\,").split("\\,");
                    String fieldNumber = valStrs[0];
                    ArrayList<String> assistFieldVals = new ArrayList<String>(10);
                    for (int j = 1; j < valStrs.length; ++j) {
                        assistFieldVals.add(AcctUtil.buildKey(new Object[]{assistNumber, fieldNumber, valStrs[j]}));
                    }
                    if (null != assistFieldValToIdMap && !assistFieldValToIdMap.isEmpty() && !assistFieldVals.isEmpty()) {
                        for (String assistFieldVal : assistFieldVals) {
                            Set<Long> assistVals = assistFieldValToIdMap.get(assistFieldVal);
                            if (null != assistVals && !assistVals.isEmpty()) {
                                valIds.addAll(assistVals);
                                continue;
                            }
                            for (Map.Entry<String, Set<String>> fieldMapEntry : filedMap.entrySet()) {
                                if (!fieldMapEntry.getValue().contains(assistFieldVal)) continue;
                                assistFieldVal = AcctUtil.buildKey(new Object[]{fieldMapEntry.getKey(), accountValues[2].split(":")[1]});
                                assistVals = assistFieldValToIdMap.get(assistFieldVal);
                            }
                            if (assistVals == null || assistVals.isEmpty()) {
                                valIds.add(0L);
                                continue;
                            }
                            valIds.addAll(assistVals);
                        }
                    } else {
                        valIds.add(0L);
                    }
                } else {
                    boolean isContinue = FormulaUtils.isContinueNumber(valStr);
                    if (isContinue) {
                        Set<Object> valueIdSet = valRangeNumberToIdsMap.get(assistNumber + "*" + valStr);
                        if (valueIdSet != null) {
                            valIds = valueIdSet;
                        } else {
                            valIds.add(0L);
                        }
                    } else {
                        String[] valList;
                        for (String valNumber : valList = valStr.split(DISPERSED_SEPARATOR)) {
                            valIds.add(valNumberToIdsMap.get(assistNumber + "*" + valNumber) == null ? Long.valueOf(0L) : valNumberToIdsMap.get(assistNumber + "*" + valNumber));
                        }
                    }
                }
            }
            asstMap.put(flex, valIds);
        }
        return accountNumber;
    }

    private static String buildKey(Object[] field) {
        return StringUtils.join((Object[])field, (String)"*");
    }

    public static boolean checkPeriodFormat(String periodStr) {
        if (StringUtils.isBlank((CharSequence)periodStr)) {
            return Boolean.FALSE;
        }
        if (periodStr.endsWith("T")) {
            char[] chars;
            if (StringUtils.isBlank((CharSequence)(periodStr = periodStr.substring(0, periodStr.length() - 1)))) {
                return Boolean.FALSE;
            }
            for (char ch : chars = periodStr.toCharArray()) {
                if (Character.isDigit(ch)) continue;
                return Boolean.FALSE;
            }
        } else {
            char[] chars = periodStr.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (i == 0 && '-' == chars[i] || Character.isDigit(chars[i])) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public static String getPeriodParam(String periodParam) {
        if (StringUtils.isNotBlank((CharSequence)periodParam)) {
            return periodParam;
        }
        return ZERO_PERIOD;
    }

    public static Map<String, Long> getOrgNumToIdMap(Set<String> orgNumberSet) {
        HashMap<String, Long> orgNumToIdMap = new HashMap<String, Long>();
        Lists.partition(Arrays.asList(orgNumberSet.toArray()), (int)1000).forEach(batch -> {
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)AcctUtil.class.getName(), (String)"bos_org", (String)"id,number", (QFilter[])new QFBuilder("number", "in", batch).toArray(), null);){
                Row row = null;
                while (dt.hasNext()) {
                    row = dt.next();
                    String number = row.getString("number");
                    long orgId = row.getLong("id");
                    orgNumToIdMap.put(number, orgId);
                }
            }
        });
        return orgNumToIdMap;
    }
}

