/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ict.dataset.TreeNode;
import kd.fi.ict.mservice.formula.common.utils.AcctUtil;

public class MakeBaseDateDetailHelper {
    public Map<String, Set<Long>> getDetailAssists(String entityId, Set<String> numbers, List<QFilter> filters) {
        TreeNode node;
        HashMap<String, Set<Long>> numberToDetailIdsMap = new HashMap<String, Set<Long>>(16);
        Map<String, Long> numberToIdsMap = AcctUtil.numbersToIds(entityId, numbers, filters);
        for (Map.Entry<String, Long> entry : numberToIdsMap.entrySet()) {
            numberToDetailIdsMap.computeIfAbsent(entry.getKey(), v -> new HashSet(16)).add(entry.getValue());
        }
        if (!this.hasParent(entityId)) {
            return numberToDetailIdsMap;
        }
        HashMap<Long, TreeNode> accIdMap = new HashMap<Long, TreeNode>(16);
        this.numbersToMasteridsRecursion(entityId, numbers, filters, accIdMap, null);
        for (Map.Entry entry : accIdMap.entrySet()) {
            ((TreeNode)entry.getValue()).setParent((TreeNode)accIdMap.get(((TreeNode)entry.getValue()).getParentId()));
        }
        HashSet<Long> hashSet = new HashSet<Long>(10);
        for (Map.Entry accIdMapEntry : accIdMap.entrySet()) {
            node = (TreeNode)accIdMapEntry.getValue();
            if (!((Boolean)node.getPropValue("isleaf")).booleanValue()) continue;
            hashSet.add(node.getId());
        }
        for (Long detailId : hashSet) {
            node = (TreeNode)accIdMap.get(detailId);
            Set<Long> detailIdSet = new HashSet<Long>(10);
            Object detailIdObj = node.getPropValue("detailid");
            if (null != detailIdObj) {
                detailIdSet = (Set)detailIdObj;
            }
            detailIdSet.add(detailId);
            detailIdSet.add(node.getMasterId());
            node.setPropValue("detailid", detailIdSet);
            this.rebuildTreeNodeDetail(accIdMap, node);
        }
        for (String number : numbers) {
            node = this.getNodeByNumber(accIdMap, number);
            if (null == node || null == node.getPropValue("detailid")) continue;
            numberToDetailIdsMap.put(number, (Set)node.getPropValue("detailid"));
        }
        return numberToDetailIdsMap;
    }

    private TreeNode getNodeByNumber(Map<Long, TreeNode> accIdMap, String number) {
        for (Map.Entry<Long, TreeNode> entry : accIdMap.entrySet()) {
            TreeNode node = entry.getValue();
            String nodeNumber = (String)node.getPropValue("number");
            if (!nodeNumber.equals(number)) continue;
            return node;
        }
        return null;
    }

    private void rebuildTreeNodeDetail(Map<Long, TreeNode> accIdMap, TreeNode node) {
        Long parentId = node.getParentId();
        if (parentId == 0L) {
            return;
        }
        TreeNode pNode = accIdMap.get(parentId);
        if (null == pNode) {
            return;
        }
        Set<Long> detailIdSet = new HashSet(10);
        Object detailIdObj = pNode.getPropValue("detailid");
        if (null != detailIdObj) {
            detailIdSet = (Set)detailIdObj;
        }
        detailIdSet.addAll((Set)node.getPropValue("detailid"));
        detailIdSet.add(parentId);
        detailIdSet.add(pNode.getMasterId());
        pNode.setPropValue("detailid", detailIdSet);
        this.rebuildTreeNodeDetail(accIdMap, pNode);
    }

    public Set<Object> getDetailAssisttContinueNumbers(String entityId, Set<Object> assistValIds, List<QFilter> filters) {
        HashSet<String> assisttContinueNumberList = new HashSet<String>(assistValIds.size());
        ArrayList<QFilter> detailFilters = new ArrayList<QFilter>(filters);
        detailFilters.add(new QFilter("id", "in", assistValIds));
        HashMap<Long, TreeNode> accIdMap = new HashMap<Long, TreeNode>(16);
        this.numbersToMasteridsRecursion(entityId, assisttContinueNumberList, detailFilters, accIdMap, null);
        for (Map.Entry accIdMapEntry : accIdMap.entrySet()) {
            ((TreeNode)accIdMapEntry.getValue()).setParent((TreeNode)accIdMap.get(((TreeNode)accIdMapEntry.getValue()).getParentId()));
        }
        for (Map.Entry accIdMapEntry : accIdMap.entrySet()) {
            TreeNode node = (TreeNode)accIdMapEntry.getValue();
            if (!((Boolean)node.getPropValue("isleaf")).booleanValue()) continue;
            assistValIds.add(node.getMasterId());
        }
        return assistValIds;
    }

    public boolean hasParent(String entityId) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        DynamicProperty parent = mainEntityType.getProperty("parent");
        DynamicProperty isLeaf = mainEntityType.getProperty("isleaf");
        DynamicProperty level = mainEntityType.getProperty("level");
        return parent != null && !StringUtils.isBlank((CharSequence)parent.getAlias()) && isLeaf != null && !StringUtils.isBlank((CharSequence)isLeaf.getAlias()) && level != null && !StringUtils.isBlank((CharSequence)level.getAlias());
    }

    private void numbersToMasteridsRecursion(String entityName, Set<String> numbers, List<QFilter> filters, Map<Long, TreeNode> accIdMap, Set<Long> finishPId) {
        if (null == finishPId) {
            finishPId = new HashSet<Long>(10);
        }
        HashSet<Long> parentIds = new HashSet<Long>(10);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (filters != null && !filters.isEmpty()) {
            qFilters.addAll(filters);
        }
        String number = "number";
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (mainEntityType instanceof BasedataEntityType) {
            number = ((BasedataEntityType)mainEntityType).getNumberProperty();
        }
        if (null != numbers && numbers.size() > 0) {
            QFilter filter = new QFilter(number, "in", numbers);
            qFilters.add(filter);
        }
        String masteridField = "id";
        String sel = "id,parent,isleaf";
        if (AcctUtil.hasMasteridProp(entityName)) {
            masteridField = "masterid";
            sel = "id,masterid,parent,isleaf";
        }
        sel = sel + "," + number;
        DataSet querySet = AcctUtil.queryDataSet(entityName, sel, qFilters);
        for (Row row : querySet) {
            Long id = row.getLong("id");
            Long masterId = row.getLong(masteridField);
            TreeNode node = new TreeNode(id.longValue());
            node.setParentId(row.getLong("parent").longValue());
            node.setMasterId(masterId.longValue());
            node.setPropValue("number", (Object)row.getString(number));
            node.setPropValue("isleaf", (Object)row.getBoolean("isleaf"));
            accIdMap.put(id, node);
            if (row.getBoolean("isleaf").booleanValue() || finishPId.contains(masterId) && finishPId.contains(id)) continue;
            parentIds.add(masterId);
            parentIds.add(id);
            finishPId.add(masterId);
            finishPId.add(id);
        }
        if (CollectionUtils.isNotEmpty(parentIds)) {
            ArrayList<QFilter> newQFilters = new ArrayList<QFilter>();
            newQFilters.add(new QFilter("parent.id", "in", parentIds));
            this.numbersToMasteridsRecursion(entityName, null, newQFilters, accIdMap, finishPId);
        }
    }
}

