/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.single;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.ict.accsys.AccSysUtil;
import kd.fi.ict.accsys.AccountBookInfo;
import kd.fi.ict.mservice.formula.common.FormulaCommon;
import kd.fi.ict.mservice.formula.common.exception.FormulaException;
import kd.fi.ict.mservice.formula.common.utils.AcctPeriodUtil;
import kd.fi.ict.mservice.formula.common.utils.AcctUtil;
import kd.fi.ict.mservice.formula.common.utils.MakeBaseDateDetailHelper;
import kd.fi.ict.mservice.formula.common.utils.ReClassUtils;
import kd.fi.ict.mservice.formula.single.account.AcctFormula;
import kd.fi.ict.mservice.formula.single.account.AcctFormulaParser;
import kd.fi.ict.mservice.formula.single.param.AcctPropertyParam;
import kd.fi.ict.mservice.formula.single.utils.FormulaUtils;

public class NumberTransID {
    private static final String ASSISTBD = "gl_assist_bd";
    private static final String ASSISTTXT = "gl_assist_txt";
    private static final String ASSIST_TYPE = "bd_asstacttype";
    private static final String FLEXFIELD = "flexfield";
    private static final String VALUETYPE = "valuetype";
    private Set<String> periodNumberSet = new HashSet<String>(32);
    private Set<String> acctNumberSet = new HashSet<String>(128);
    private Set<String> acctRangeNumberSet = new HashSet<String>(128);
    private Map<String, Set<String>> assistToValNumbersMap = new HashMap<String, Set<String>>(8);
    private Map<String, Set<String>> assistToValRangeNumbersMap = new HashMap<String, Set<String>>(8);
    private Map<String, Long> orgNumberToIdsMap = new HashMap<String, Long>(32);
    private Map<String, Long> opOrgNumberToIdsMap = new HashMap<String, Long>(32);
    private Map<String, Long> bookTypeNumberToIdsMap = new HashMap<String, Long>(32);
    private Map<String, Long> currencyNumberToIdsMap = new HashMap<String, Long>(8);
    private Map<String, Long> periodIdsMap = new HashMap<String, Long>(32);
    private Map<String, Long> acctNumberToIdsMap = new HashMap<String, Long>(128);
    private Map<Long, String> acctMasterToDcMap = new HashMap<Long, String>(128);
    private Map<String, Set<Long>> acctRangeKeyToIdsMap = new HashMap<String, Set<Long>>(128);
    private Map<Long, Long> acctIdToMasterIdMap = new HashMap<Long, Long>(128);
    private Map<Long, Set<Long>> acctToDirectLeafMap = new HashMap<Long, Set<Long>>(128);
    private Map<Long, Set<Long>> acctToAllLeafMap = new HashMap<Long, Set<Long>>(128);
    private Map<Long, Set<String>> acctToFlexsMap = new HashMap<Long, Set<String>>(128);
    private Map<Long, String> acctToNumberMap = new HashMap<Long, String>(128);
    private Map<String, String> assistToFlexMap = new HashMap<String, String>(8);
    private Map<String, String> flexToAssistEntityMap = new HashMap<String, String>(8);
    private Map<String, Object> assistValNumberToObjMap = new HashMap<String, Object>(8);
    private Map<String, Set<Object>> assistValRangeNumberToObjsMap = new HashMap<String, Set<Object>>(8);
    private Map<String, DataSet> flexToIDHgSet = new HashMap<String, DataSet>(8);
    private Set<String> assistNumberAllVal = new HashSet<String>(8);
    private Set<String> flexAllVal = new HashSet<String>(8);
    private Set<String> periodYearAndMonthSet = new HashSet<String>(8);
    private Map<String, Long> seasonPeriodIdMap = new HashMap<String, Long>(8);
    private Map<String, Set<String>> assistNumToDocumentFiledMap = new HashMap<String, Set<String>>(16);
    private Map<String, Set<String>> assistFieldToPropertyValMap = new HashMap<String, Set<String>>(16);
    private Map<String, Set<Long>> assistFieldValToIdMap = new HashMap<String, Set<Long>>(16);
    private Map<String, Set<String>> fieldToEntryFieldMap = new HashMap<String, Set<String>>(8);
    private Map<String, List<String>> periodFromYearMap = new HashMap<String, List<String>>(8);
    private long orgId = 0L;
    private long bookTypeId = 0L;
    private long acctTableId = 0L;
    private static final Log log = LogFactory.getLog(NumberTransID.class);
    private AcctFormulaParser parser;

    public NumberTransID(AcctFormulaParser parser, List<AcctFormula> acctflst, String bookStr) {
        this.parser = parser;
        this.parseAcctFormula(acctflst, bookStr);
    }

    private void parseAcctFormula(List<AcctFormula> acctflst, String bookStr) {
        FormulaCommon fCommon = this.parser.getfCommon();
        String[] orgBookTypes = bookStr.split(",");
        String orgNumber = orgBookTypes[0];
        this.orgNumberToIdsMap.put(orgNumber, 0L);
        String bookTypeNumber = orgBookTypes[1];
        this.bookTypeNumberToIdsMap.put(bookTypeNumber, 0L);
        for (AcctFormula accf : acctflst) {
            this.opOrgNumberToIdsMap.put(accf.getOpOrgNumber(), 0L);
            String acctToAssistStr = accf.getAccountAndassgrp();
            this.getBatchAcctAndAssist(acctToAssistStr, accf.getfKey());
            if (accf.getfCommon().getScopePeriods().size() == 2) {
                for (Integer month : accf.getfCommon().getScopePeriods()) {
                    this.periodYearAndMonthSet.add(accf.getFy() + "," + month);
                }
            } else {
                this.periodNumberSet.add(accf.getFy() + "," + accf.getPeriod());
            }
            this.currencyNumberToIdsMap.put(accf.getCurrencyNumber(), 0L);
        }
        this.numberToIDParam();
        if (this.orgNumberToIdsMap.get(orgNumber) == null) {
            throw new FormulaException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801:%s\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7ec4\u7ec7\u4fe1\u606f;", (String)"", (String)"", (Object[])new Object[0]), orgNumber));
        }
        this.orgId = this.orgNumberToIdsMap.get(orgNumber);
        if (this.bookTypeNumberToIdsMap.get(bookTypeNumber) == null) {
            throw new FormulaException(String.format(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801:%s\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u8d26\u7c3f\u7c7b\u578b\u4fe1\u606f;", (String)"", (String)"", (Object[])new Object[0]), orgNumber));
        }
        this.bookTypeId = this.bookTypeNumberToIdsMap.get(bookTypeNumber);
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)this.orgNumberToIdsMap.get(orgNumber), (long)this.bookTypeNumberToIdsMap.get(bookTypeNumber));
        if (bookInfo == null) {
            throw new FormulaException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7:%1$s\u548c\u8d26\u7c3f\u7c7b\u578b:%2$s\uff0c\u672a\u5efa\u7acb\u8d26\u7c3f", (String)"", (String)"", (Object[])new Object[0]), orgNumber, bookTypeNumber));
        }
        int comFy = fCommon.getFy();
        this.initPeriodFromYear(comFy);
        int comPeriod = fCommon.getPeriod();
        String comAdjustPeriod = fCommon.getAdjustPeriod();
        this.queryPeriodIdByBook(comFy, comPeriod, comAdjustPeriod);
        this.querySeasonPeriodId();
        long periodId = 0L;
        if (this.periodIdsMap.get(comFy + "," + comPeriod) != null) {
            periodId = this.periodIdsMap.get(comFy + "," + comPeriod);
        } else {
            if (this.periodIdsMap.isEmpty() && this.seasonPeriodIdMap.isEmpty()) {
                log.info("ACCT\u91cd\u5206\u7c7bparseAcctFormula:orgNumber:" + orgNumber + "," + this.orgId + ";bookTypeNumber:" + bookTypeNumber + "," + this.bookTypeId + ";accountTableId:" + this.acctTableId + ";periodNumber:" + this.periodNumberSet);
                throw new FormulaException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u671f\u95f4\uff0c\u8bf7\u786e\u8ba4\u671f\u95f4\u662f\u5426\u5b58\u5728\uff1a%s", (String)"NumberTransID_0", (String)"fi-ict-mservice", (Object[])new Object[]{this.periodNumberSet}));
            }
            if (!this.periodIdsMap.isEmpty()) {
                periodId = this.periodIdsMap.values().iterator().next();
            } else {
                for (Long tempPeriodId : this.seasonPeriodIdMap.values()) {
                    if (periodId != 0L && tempPeriodId <= periodId) continue;
                    periodId = tempPeriodId;
                }
            }
        }
        if (!this.periodIdsMap.isEmpty()) {
            this.acctTableId = AccSysUtil.getCurPeriodAccountTableId((long)this.orgId, (long)this.bookTypeId, (long)periodId);
        }
        if (this.acctTableId == 0L) {
            this.acctTableId = bookInfo.getAccountTableId();
        }
        QFilter facctBaseData = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)this.orgId);
        if (this.periodIdsMap.size() > 1 && comPeriod < 13) {
            this.periodIdsMap.remove(comFy + "," + comPeriod);
            periodId = this.periodIdsMap.values().iterator().next();
        }
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter("id", "=", (Object)periodId).toArray());
        facctBaseData = facctBaseData.and(new QFilter("startdate", "<=", (Object)period.getDate("enddate"))).and(new QFilter("enddate", ">=", (Object)period.getDate("enddate")));
        facctBaseData = facctBaseData.and(new QFilter("accounttable", "=", (Object)this.acctTableId));
        log.info("ACCT\u91cd\u5206\u7c7bparseAcctFormula:orgNumber:" + orgNumber + "," + this.orgId + ";bookTypeNumber:" + bookTypeNumber + "," + this.bookTypeId + ";accountTableId:" + this.acctTableId + ";periodId:" + periodId);
        this.queryAcctId(facctBaseData.copy());
        this.queryDLAndALAcct(facctBaseData.copy());
        this.queryAssistId();
    }

    private void queryAllAcctFlexs(Set<Long> acctIds) {
        DataSet acctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, number, masterid, checkitementry.asstactitem.flexfield flexfield, checkitementry.asstactitem.valuetype valuetype", new QFilter[]{new QFilter("id", "in", acctIds)});
        for (Row row : acctSet) {
            long acctId = row.getLong("id");
            long masterId = row.getLong("masterid");
            this.acctToNumberMap.put(acctId, row.getString("number"));
            String flexField = row.getString(FLEXFIELD);
            this.acctIdToMasterIdMap.put(acctId, masterId);
            if (flexField == null) {
                this.acctToFlexsMap.put(acctId, null);
                continue;
            }
            HashSet<String> flexMap = this.acctToFlexsMap.get(acctId) == null ? new HashSet<String>(8) : this.acctToFlexsMap.get(acctId);
            flexMap.add(flexField);
            this.acctToFlexsMap.put(acctId, flexMap);
            String valueType = row.getString(VALUETYPE);
            if ("3".equals(valueType)) {
                this.flexToAssistEntityMap.put(flexField, ASSISTTXT);
                continue;
            }
            this.flexToAssistEntityMap.put(flexField, ASSISTBD);
        }
    }

    private void queryDLAndALAcct(QFilter facctBaseData) {
        HashSet<Long> acctIds = new HashSet<Long>(128);
        acctIds.addAll(this.acctNumberToIdsMap.values());
        for (Collection collection : this.acctRangeKeyToIdsMap.values()) {
            acctIds.addAll(collection);
        }
        this.getMasterIdByAcctId(acctIds);
        this.queryDirectLeafAcct(acctIds, facctBaseData);
        Map<Long, Set<Long>> idToLeafMap = this.queryAcctAllLeaf(facctBaseData);
        this.uLeafAcctIdAndMid(idToLeafMap, facctBaseData);
        Iterator iterator = acctIds.iterator();
        while (iterator.hasNext()) {
            HashSet<Long> allLeafAcctIds;
            HashSet<Long> leafAcctIds;
            long acctId = (Long)iterator.next();
            Set<Long> set = leafAcctIds = this.acctToDirectLeafMap.get(acctId) == null ? new HashSet<Long>(128) : this.acctToDirectLeafMap.get(acctId);
            if (leafAcctIds.isEmpty()) {
                leafAcctIds.add(acctId);
                this.acctToDirectLeafMap.put(acctId, leafAcctIds);
            }
            if (!(allLeafAcctIds = this.acctToAllLeafMap.get(acctId) == null ? new HashSet<Long>(128) : this.acctToAllLeafMap.get(acctId)).isEmpty()) continue;
            allLeafAcctIds.add(acctId);
            this.acctToAllLeafMap.put(acctId, allLeafAcctIds);
        }
        HashSet<Long> hashSet = new HashSet<Long>(128);
        for (Map.Entry<Long, Set<Long>> entry : this.acctToDirectLeafMap.entrySet()) {
            hashSet.add(entry.getKey());
            hashSet.addAll((Collection)entry.getValue());
        }
        for (Map.Entry<Long, Set<Long>> entry : this.acctToAllLeafMap.entrySet()) {
            hashSet.add(entry.getKey());
            hashSet.addAll((Collection)entry.getValue());
        }
        log.info("ACCT\u91cd\u5206\u7c7b\u79d1\u76ee\u8fc7\u6ee4\u540eacctToAllLeafMap\uff1a" + this.acctToAllLeafMap);
        log.info("ACCT\u91cd\u5206\u7c7b\u79d1\u76ee\u8fc7\u6ee4\u540eacctToDirectLeafMap\uff1a" + this.acctToDirectLeafMap);
        this.queryAllAcctFlexs(hashSet);
    }

    private void uLeafAcctIdAndMid(Map<Long, Set<Long>> idToLeafMap, QFilter fbasedata) {
        Object number;
        Set<Long> idSet = idToLeafMap.keySet();
        DataSet acctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, number, masterid, parent", new QFilter[]{new QFilter("id", "in", idSet)});
        HashMap<Long, String> idToNumberMap = new HashMap<Long, String>(16);
        for (Object row : acctSet) {
            idToNumberMap.put(row.getLong("id"), row.getString("number"));
        }
        HashMap<String, Set> numberToLeafMap = new HashMap<String, Set>(128);
        for (Map.Entry entry : idToLeafMap.entrySet()) {
            number = (String)idToNumberMap.get(entry.getKey());
            Set set = numberToLeafMap.computeIfAbsent((String)number, x -> new HashSet(128));
            set.addAll((Collection)entry.getValue());
        }
        for (Map.Entry entry : numberToLeafMap.entrySet()) {
            number = (String)entry.getKey();
            long l = this.acctNumberToIdsMap.get(number);
            idToLeafMap.put(l, (Set<Long>)entry.getValue());
        }
        HashSet allLeafSet = new HashSet(128);
        Collection<Set<Long>> collection = idToLeafMap.values();
        for (Set set : collection) {
            allLeafSet.addAll(set);
        }
        DataSet leafAcctDS = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, number, masterid, parent", new QFilter[]{new QFilter("id", "in", allLeafSet), fbasedata});
        HashSet<Long> hashSet = new HashSet<Long>(128);
        for (Row row : leafAcctDS) {
            hashSet.add(row.getLong("id"));
        }
        for (Map.Entry<Long, Set<Long>> entry : idToLeafMap.entrySet()) {
            Set<Long> leafSet = entry.getValue();
            leafSet.retainAll(hashSet);
            this.acctToAllLeafMap.put(entry.getKey(), leafSet);
        }
    }

    private void queryDirectLeafAcct(Set<Long> acctIds, QFilter fbasedata) {
        DataSet filterAcctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, masterid, parent", new QFilter[]{new QFilter("parent", "in", acctIds), fbasedata.copy()});
        for (Row row : filterAcctSet) {
            long leafAcctId = row.getLong("id");
            long acctId = row.getLong("parent");
            HashSet<Long> directLeafAcctIds = this.acctToDirectLeafMap.get(acctId) == null ? new HashSet<Long>(128) : this.acctToDirectLeafMap.get(acctId);
            directLeafAcctIds.add(leafAcctId);
            this.acctToDirectLeafMap.put(acctId, directLeafAcctIds);
        }
    }

    private void getMasterIdByAcctId(Set<Long> acctIds) {
        DataSet acctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, masterid, number", new QFilter[]{new QFilter("id", "in", acctIds)});
        for (Row row : acctSet) {
            long id = row.getLong("id");
            long masterId = row.getLong("masterid");
            acctIds.add(masterId);
            this.acctIdToMasterIdMap.put(id, masterId);
        }
        DataSet numebrAcctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, masterid", new QFilter[]{new QFilter("masterid", "in", acctIds)});
        for (Row row : numebrAcctSet) {
            acctIds.add(row.getLong("id"));
        }
    }

    private Map<Long, Set<Long>> queryAcctAllLeaf(QFilter baseFilter) {
        HashMap<Long, Set<Long>> idToAllLeafMap = new HashMap<Long, Set<Long>>(128);
        DataSet leafAcctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, masterid, number, longnumber", new QFilter[]{baseFilter, new QFilter("isleaf", "=", (Object)Character.valueOf('1'))});
        for (Row row : leafAcctSet) {
            String[] split;
            String longNumber = row.getString("longnumber");
            for (String number : split = longNumber.split("_")) {
                if (this.acctNumberToIdsMap.get(number) == null) continue;
                long acctId = this.acctNumberToIdsMap.get(number);
                Set leafSet = idToAllLeafMap.computeIfAbsent(acctId, x -> new HashSet(128));
                leafSet.add(row.getLong("id"));
            }
        }
        return idToAllLeafMap;
    }

    /*
     * WARNING - void declaration
     */
    private void queryAssistId() {
        Object flex;
        QFilter fbasedata;
        String entityId;
        HashMap<String, Set<Object>> flexToValIdsMap = new HashMap<String, Set<Object>>(this.assistNumberAllVal.size());
        HashSet<String> asstactTypeNumbers = new HashSet<String>();
        asstactTypeNumbers.addAll(this.assistNumberAllVal);
        if (!this.assistToValNumbersMap.isEmpty()) {
            asstactTypeNumbers.addAll(this.assistToValNumbersMap.keySet());
        }
        if (!this.assistToValRangeNumbersMap.isEmpty()) {
            asstactTypeNumbers.addAll(this.assistToValRangeNumbersMap.keySet());
        }
        if (!this.assistNumToDocumentFiledMap.isEmpty()) {
            asstactTypeNumbers.addAll(this.assistNumToDocumentFiledMap.keySet());
        }
        HashMap<String, Long> numberToDetailGroupMap = new HashMap<String, Long>(8);
        HashMap<String, String> assistNnumberToEntityMap = new HashMap<String, String>(8);
        this.getFlexToAssistTypeMap(assistNnumberToEntityMap, numberToDetailGroupMap, asstactTypeNumbers);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        if (!this.assistNumToDocumentFiledMap.isEmpty()) {
            AcctPropertyParam acctPropertyParam = new AcctPropertyParam(this.assistNumToDocumentFiledMap, assistNnumberToEntityMap, this.assistFieldToPropertyValMap, this.orgId, numberToDetailGroupMap);
            this.assistFieldValToIdMap = acctPropertyParam.getAssistFieldValToIdMap();
            this.assistValNumberToObjMap = acctPropertyParam.getAssistNumToIdsMap();
            this.fieldToEntryFieldMap = acctPropertyParam.getFiledMap();
            Map<String, Set<String>> assistFieldToNumbersMap = acctPropertyParam.getAssistFieldToNumbersMap();
            for (String assistNumber : asstactTypeNumbers) {
                Set<String> valNumbers = assistFieldToNumbersMap.get(assistNumber);
                String flex2 = this.assistToFlexMap.get(assistNumber);
                if (StringUtils.isBlank((CharSequence)flex2)) continue;
                if (null == valNumbers || valNumbers.isEmpty()) {
                    flexToValIdsMap.computeIfAbsent(flex2, k -> new HashSet()).add(0L);
                    continue;
                }
                for (String valNumber : valNumbers) {
                    flexToValIdsMap.computeIfAbsent(flex2, k -> new HashSet()).add(this.assistValNumberToObjMap.get(assistNumber + "*" + valNumber));
                }
            }
        }
        MakeBaseDateDetailHelper detailHelper = new MakeBaseDateDetailHelper();
        for (Map.Entry<String, Set<String>> entry : this.assistToValNumbersMap.entrySet()) {
            String assistNumber2 = entry.getKey();
            entityId = (String)assistNnumberToEntityMap.get(assistNumber2);
            Set<String> valNumbers = entry.getValue();
            filters.clear();
            fbasedata = null;
            if (this.orgId != 0L && entityId != null && (fbasedata = this.dealBasedataFilter(entityId, this.orgId)) != null) {
                filters.add(fbasedata);
            }
            if ("bos_assistantdata_detail".equals(entityId)) {
                long assistGroupId = (Long)numberToDetailGroupMap.get(assistNumber2);
                filters.add(new QFilter("group", "=", (Object)assistGroupId));
            }
            HashMap<String, Object> numberToObjsMap = new HashMap<String, Object>(64);
            if (entityId == null) {
                for (String string : valNumbers) {
                    numberToObjsMap.put(string, string);
                }
            } else {
                Map<String, Set<Long>> numberToIdsMap1 = detailHelper.getDetailAssists(entityId, valNumbers, filters);
                numberToObjsMap.putAll(numberToIdsMap1);
            }
            for (Map.Entry entry2 : numberToObjsMap.entrySet()) {
                this.assistValNumberToObjMap.put(assistNumber2 + "*" + (String)entry2.getKey(), entry2.getValue());
            }
            flex = this.assistToFlexMap.get(assistNumber2);
            if (StringUtils.isBlank((CharSequence)flex)) continue;
            flexToValIdsMap.put((String)flex, new HashSet(numberToObjsMap.values()));
        }
        for (Map.Entry<String, Set<String>> entry : this.assistToValRangeNumbersMap.entrySet()) {
            String assistNumber;
            assistNumber = entry.getKey();
            entityId = (String)assistNnumberToEntityMap.get(assistNumber);
            Set<String> rangeValNumber = entry.getValue();
            filters.clear();
            fbasedata = null;
            if (this.orgId != 0L && entityId != null) {
                fbasedata = this.dealBasedataFilter(entityId, this.orgId);
            }
            if ("bos_assistantdata_detail".equals(entityId)) {
                long assistGroupId = (Long)numberToDetailGroupMap.get(assistNumber);
                filters.add(new QFilter("group", "=", (Object)assistGroupId));
            }
            HashSet<Object> allValIds = new HashSet<Object>(128);
            flex = rangeValNumber.iterator();
            while (flex.hasNext()) {
                void var15_23;
                String string;
                String key = string = flex.next();
                HashSet<Object> assistValIds = new HashSet<Object>(128);
                ArrayList<QFilter> rangFilters = new ArrayList<QFilter>(8);
                rangFilters.addAll(filters);
                boolean isNoCategory = string.contains("#");
                if (!isNoCategory) {
                    String string2 = string.substring(1, string.length() - 1);
                }
                String[] assisttContinueNumbers = var15_23.split(",");
                if (entityId == null) {
                    assistValIds.addAll(Arrays.asList(assisttContinueNumbers));
                    allValIds.addAll(assistValIds);
                    this.assistValRangeNumberToObjsMap.put(assistNumber + "*" + key, assistValIds);
                    continue;
                }
                DataSet assistSet = null;
                if (!isNoCategory) {
                    if (fbasedata != null) {
                        rangFilters.add(fbasedata.copy());
                    }
                    assistSet = this.queryContinueNumber(Arrays.asList(assisttContinueNumbers), rangFilters, "masterid", entityId);
                }
                if (assistSet == null) continue;
                for (Row row : assistSet) {
                    assistValIds.add(row.getLong("masterid"));
                }
                if (assistValIds.size() == 0) continue;
                if (!isNoCategory && detailHelper.hasParent(entityId)) {
                    Set<Object> assistValIds1 = detailHelper.getDetailAssisttContinueNumbers(entityId, assistValIds, filters);
                    assistValIds.addAll(assistValIds1);
                }
                this.assistValRangeNumberToObjsMap.put(assistNumber + "*" + key, assistValIds);
                allValIds.addAll(assistValIds);
            }
            flex = this.assistToFlexMap.get(assistNumber);
            if (StringUtils.isBlank((CharSequence)flex)) continue;
            Set<Object> set = flexToValIdsMap.get(flex) == null ? new HashSet(128) : (Set)flexToValIdsMap.get(flex);
            set.addAll(allValIds);
            flexToValIdsMap.put((String)flex, set);
        }
        for (String assistNumber3 : this.assistNumberAllVal) {
            String flex3 = this.assistToFlexMap.get(assistNumber3);
            if (StringUtils.isBlank((CharSequence)flex3)) continue;
            this.flexAllVal.add(flex3);
        }
        for (String flex4 : this.flexAllVal) {
            flexToValIdsMap.put(flex4, new HashSet(128));
        }
        this.addFlexAllVal(flexToValIdsMap);
    }

    public void addFlexAllVal(Map<String, Set<Object>> flexToValIdsMap) {
        for (Map.Entry<String, Set<Object>> assistEntry : flexToValIdsMap.entrySet()) {
            boolean isFilterVal;
            ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
            String flex = assistEntry.getKey();
            Set<Object> valIds = assistEntry.getValue();
            QFilter typeFilter = new QFilter("asstype", "=", (Object)flex);
            filters.add(typeFilter);
            if (valIds == null) {
                valIds = new HashSet<Object>(128);
            }
            HashSet<Object> newValIds = new HashSet<Object>(valIds.size());
            for (Object valId : valIds) {
                if (valId instanceof Collection) {
                    newValIds.addAll((Collection)valId);
                    continue;
                }
                newValIds.add(valId);
            }
            String entityId = this.flexToAssistEntityMap.get(flex);
            boolean bl = isFilterVal = newValIds.size() < 1000;
            if (isFilterVal && newValIds.size() != 0 && !this.flexAllVal.contains(flex)) {
                QFilter ValFilter = new QFilter("assval", "in", newValIds);
                filters.add(ValFilter);
            } else if (newValIds.size() == 0) {
                this.flexAllVal.add(flex);
            }
            DataSet hgSet = ReClassUtils.queryDataSet(entityId, "hg, assval " + flex, filters);
            if (!isFilterVal && newValIds.size() != 0 && !this.flexAllVal.contains(flex)) {
                HashMap<String, HashSet<Object>> filterMap = new HashMap<String, HashSet<Object>>(8);
                filterMap.put("valIds", newValIds);
                hgSet = hgSet.filter(flex + " in valIds", filterMap);
            }
            this.flexToIDHgSet.put(flex, hgSet);
        }
    }

    private QFilter dealBasedataFilter(String entityId, long orgId) {
        QFilter qf = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)orgId);
        return qf;
    }

    private void getFlexToAssistTypeMap(Map<String, String> numberToEntityMap, Map<String, Long> numberToDetailGroupMap, Set<String> asstactTypeNumbers) {
        QFilter fnumber = new QFilter("number", "in", asstactTypeNumbers);
        QFilter fflexid = new QFilter("flexid", "=", (Object)2L);
        DataSet asstactSet = this.queryDataSet(this.getClass().getName(), ASSIST_TYPE, "number,valuetype,assistanttype,valuesource,flexfield", new QFilter[]{fnumber, fflexid});
        for (Row row : asstactSet) {
            long assistGroupId = 0L;
            String valType = row.getString(VALUETYPE);
            String entityId = null;
            switch (valType) {
                case "1": {
                    entityId = row.getString("valuesource");
                    break;
                }
                case "2": {
                    entityId = "bos_assistantdata_detail";
                    assistGroupId = row.getLong("assistanttype");
                    break;
                }
                case "3": {
                    entityId = null;
                }
            }
            String number = row.getString("number");
            String flex = row.getString(FLEXFIELD);
            if (entityId != null) {
                this.flexToAssistEntityMap.put(flex, ASSISTBD);
            } else {
                this.flexToAssistEntityMap.put(flex, ASSISTTXT);
            }
            this.assistToFlexMap.put(number, flex);
            if (assistGroupId != 0L) {
                numberToDetailGroupMap.put(number, assistGroupId);
            }
            numberToEntityMap.put(number, entityId);
        }
    }

    private void getBatchAcctAndAssist(String acctAssistListStr, String fKey) {
        String[] accountValues = (acctAssistListStr = acctAssistListStr.replaceAll("\\|", "\\| ")).split("\\|");
        String accountNumberStr = accountValues[0];
        boolean isContinueAcct = FormulaUtils.isContinueNumber(accountNumberStr);
        if (isContinueAcct) {
            this.acctRangeNumberSet.add(accountNumberStr);
        } else {
            String[] accts = accountNumberStr.split(",");
            this.acctNumberSet.addAll(Arrays.asList(accts));
        }
        for (int i = 1; i < accountValues.length; i += 2) {
            String assistNumber = accountValues[i].trim();
            if (StringUtils.isBlank((CharSequence)assistNumber)) continue;
            HashSet<String> vals = new HashSet<String>(128);
            String rangeVals = "";
            String valStr = accountValues[i + 1].trim();
            if (!StringUtils.isBlank((CharSequence)valStr)) {
                if (valStr.startsWith("[") && valStr.endsWith("]") || valStr.contains("#")) {
                    rangeVals = valStr;
                    Set<Object> rangeValNumbers = this.assistToValRangeNumbersMap.get(assistNumber) == null ? new HashSet(128) : this.assistToValRangeNumbersMap.get(assistNumber);
                    rangeValNumbers.add(rangeVals);
                    this.assistToValRangeNumbersMap.put(assistNumber, rangeValNumbers);
                    continue;
                }
                if (valStr.contains(":")) {
                    String[] documentFieldAndPropertyVals = valStr.replaceAll(":", ",").split(",");
                    String documentField = documentFieldAndPropertyVals[0];
                    this.assistNumToDocumentFiledMap.computeIfAbsent(assistNumber, k -> new HashSet(16)).add(documentField);
                    Set propertyValuesSet = this.assistFieldToPropertyValMap.computeIfAbsent(this.buildAssistAndFiledKey(new Object[]{assistNumber, documentField}, "*"), k -> new HashSet(16));
                    for (int j = 1; j < documentFieldAndPropertyVals.length; ++j) {
                        propertyValuesSet.add(documentFieldAndPropertyVals[j].trim());
                    }
                    continue;
                }
                String[] valList = valStr.split(",");
                vals.addAll(Arrays.asList(valList));
                Set<String> valNumbers = this.assistToValNumbersMap.get(assistNumber);
                if (valNumbers == null) {
                    valNumbers = new HashSet<String>(128);
                    valNumbers.addAll(vals);
                } else {
                    if (valNumbers.size() == 0) continue;
                    valNumbers.addAll(vals);
                }
                this.assistToValNumbersMap.put(assistNumber, valNumbers);
                continue;
            }
            this.assistNumberAllVal.add(assistNumber);
        }
    }

    private String buildAssistAndFiledKey(Object[] fields, String separator) {
        return StringUtils.join((Object[])Arrays.stream(fields).toArray(), (String)separator);
    }

    private void numberToIDParam() {
        this.orgNumberToIdsMap = ReClassUtils.numbersToIds("bos_org", this.orgNumberToIdsMap.keySet(), null);
        this.opOrgNumberToIdsMap = ReClassUtils.numbersToIds("bos_org", this.opOrgNumberToIdsMap.keySet(), null);
        this.bookTypeNumberToIdsMap = ReClassUtils.numbersToIds("bd_accountbookstype", this.bookTypeNumberToIdsMap.keySet(), null);
        this.currencyNumberToIdsMap = ReClassUtils.numbersToIds("bd_currency", this.currencyNumberToIdsMap.keySet(), null);
    }

    private void initPeriodFromYear(int comYear) {
        HashSet<Integer> yearSet = new HashSet<Integer>(8);
        for (String periodNumber : this.periodNumberSet) {
            String[] yearPeriodNumber = periodNumber.split(",");
            if (yearPeriodNumber.length != 2 || StringUtils.isBlank((CharSequence)yearPeriodNumber[0])) continue;
            if (Integer.parseInt(yearPeriodNumber[0]) > 1000) {
                yearSet.add(Integer.parseInt(yearPeriodNumber[0]));
                yearSet.add(Integer.parseInt(yearPeriodNumber[0]) - 1);
                continue;
            }
            yearSet.add(comYear + Integer.parseInt(yearPeriodNumber[0]));
            yearSet.add(comYear + Integer.parseInt(yearPeriodNumber[0]) - 1);
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter("periodyear", "in", yearSet));
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)this.orgId, (long)this.bookTypeId);
        if (bookInfo == null) {
            return;
        }
        qFilters.add(new QFilter("periodtype", "=", (Object)bookInfo.getPeriodTypeId()));
        DataSet periodDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"id, number, periodnumber, periodyear, isadjustperiod", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"number");
        if (periodDataSet != null) {
            for (Row row : periodDataSet) {
                String periodYear = String.valueOf(row.getInteger("periodyear"));
                boolean isAdjustPeriod = row.getBoolean("isadjustperiod");
                String periodNumber = String.valueOf(row.getInteger("periodnumber"));
                if (isAdjustPeriod && Integer.parseInt(periodNumber) <= 12) {
                    periodNumber = periodNumber + "T";
                }
                if (this.periodFromYearMap.containsKey(String.valueOf(periodYear))) {
                    this.periodFromYearMap.get(periodYear).add(periodNumber);
                    continue;
                }
                ArrayList<String> periodNumberList = new ArrayList<String>(8);
                periodNumberList.add(periodNumber);
                this.periodFromYearMap.put(periodYear, periodNumberList);
            }
        }
        if (DebugTrace.enable()) {
            log.info("ReClassNumberIDParam_periodFromYearMap : " + this.periodFromYearMap);
        }
    }

    private void queryPeriodIdByBook(int comFy, int comPeriod, String comAdjustPeriod) {
        HashSet<Integer> yearList = new HashSet<Integer>(this.periodNumberSet.size());
        HashSet<String> periodList = new HashSet<String>(this.periodNumberSet.size());
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)this.orgId, (long)this.bookTypeId);
        if (bookInfo == null) {
            return;
        }
        HashMap negativePeriodMap = new HashMap(32);
        for (String str : this.periodNumberSet) {
            String periodAndYearKey;
            String[] yearAndPeriod;
            String[] yearPeriodNumber = str.split(",");
            if (yearPeriodNumber.length != 2) continue;
            String yearStr = yearPeriodNumber[0];
            String periodStr = yearPeriodNumber[1];
            if (!AcctUtil.checkPeriodFormat(periodStr) || (yearAndPeriod = (periodAndYearKey = AcctPeriodUtil.dealYearAndPeriod(periodStr, comPeriod, comAdjustPeriod, yearStr, comFy, this.periodFromYearMap)).split("-")).length != 2) continue;
            yearList.add(Integer.valueOf(yearAndPeriod[0]));
            periodList.add(yearAndPeriod[1]);
        }
        long periodTypeId = bookInfo.getPeriodTypeId();
        HashMap<Integer, Integer> yearMaxPeriodMap = new HashMap<Integer, Integer>(32);
        DataSet periodDataSet = this.queryPeriodByNumber("periodyear, periodnumber, id, isadjustperiod", yearList, periodList, periodTypeId);
        for (Row row : periodDataSet) {
            int maxPeriod;
            int year = row.getInteger("periodyear");
            int periodNumber = row.getInteger("periodnumber");
            boolean isAdjustPeriod = row.getBoolean("isadjustperiod");
            if (periodNumber >= 13) {
                this.periodIdsMap.put(year + "," + periodNumber, row.getLong("id"));
                this.periodIdsMap.put(year + "," + periodNumber + "T", row.getLong("id"));
            } else if (isAdjustPeriod) {
                this.periodIdsMap.put(year + "," + periodNumber + "T", row.getLong("id"));
            } else {
                this.periodIdsMap.put(year + "," + periodNumber, row.getLong("id"));
            }
            int n = maxPeriod = yearMaxPeriodMap.get(year) == null ? 1 : (Integer)yearMaxPeriodMap.get(year);
            if (periodNumber > maxPeriod) {
                maxPeriod = periodNumber;
            }
            yearMaxPeriodMap.put(year, maxPeriod);
        }
        if (!negativePeriodMap.isEmpty()) {
            for (Map.Entry nEntry : negativePeriodMap.entrySet()) {
                int year = (Integer)nEntry.getKey();
                Set periodNumberSet = (Set)nEntry.getValue();
                for (Integer nperiod : periodNumberSet) {
                    if (yearMaxPeriodMap.get(year) == null) continue;
                    int maxPeriod = (Integer)yearMaxPeriodMap.get(year);
                    int period = maxPeriod + nperiod;
                    if (this.periodIdsMap.get(year + "," + period) == null) continue;
                    long periodId = this.periodIdsMap.get(year + "," + period);
                    this.periodIdsMap.put(year + "," + nperiod, periodId);
                }
            }
        }
    }

    private DataSet queryPeriodByNumber(String selFields, Set<Integer> fys, Set<String> periodNumbers, long periodTypeId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        QFilter fperiodTypeId = new QFilter("periodtype", "=", (Object)periodTypeId);
        QFilter ffy = new QFilter("periodyear", "in", fys);
        filters.add(fperiodTypeId);
        filters.add(ffy);
        if (periodNumbers != null && periodNumbers.size() > 0) {
            HashSet<Integer> adjPeriodNumbers = new HashSet<Integer>(8);
            HashSet<Integer> nAdjPeriodNumbers = new HashSet<Integer>(8);
            for (String periodStr : periodNumbers) {
                if (!periodStr.endsWith("T") && Integer.parseInt(periodStr) <= 12) {
                    nAdjPeriodNumbers.add(Integer.parseInt(periodStr));
                    continue;
                }
                if (periodStr.endsWith("T")) {
                    adjPeriodNumbers.add(Integer.parseInt(periodStr.substring(0, periodStr.length() - 1)));
                    continue;
                }
                adjPeriodNumbers.add(Integer.parseInt(periodStr));
            }
            QFilter fperiod = null;
            if (!nAdjPeriodNumbers.isEmpty()) {
                fperiod = new QFilter("periodnumber", "in", nAdjPeriodNumbers).and(new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0')));
            }
            if (!adjPeriodNumbers.isEmpty()) {
                QFilter qFilter = fperiod = fperiod == null ? new QFilter("periodnumber", "in", adjPeriodNumbers) : fperiod.or(new QFilter("periodnumber", "in", adjPeriodNumbers));
            }
            if (fperiod != null) {
                filters.add(fperiod);
            }
        }
        DataSet periodSet = this.queryDataSet(this.getClass().getName(), "bd_period", selFields, filters.toArray(new QFilter[0]));
        return periodSet;
    }

    private void queryAcctId(QFilter facctBaseData) {
        QFilter filterAcctTable = new QFilter("accounttable", "=", (Object)this.acctTableId);
        QFilter fnumbers = new QFilter("number", "in", this.acctNumberSet);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        filters.add(filterAcctTable);
        filters.add(facctBaseData.copy());
        filters.add(fnumbers);
        DataSet acctSet = ReClassUtils.queryDataSet("bd_accountview", "id, number, masterid,dc", filters);
        for (Row row : acctSet) {
            long acctId = row.getLong("id");
            String number = row.getString("number");
            this.acctNumberToIdsMap.put(number, acctId);
            this.acctMasterToDcMap.put(acctId, row.getString("dc"));
        }
        boolean isOnlyRange = this.acctRangeNumberSet.size() == 1;
        ArrayList<String> allRangeNumbers = new ArrayList<String>(128);
        for (String acctRangeNumber : this.acctRangeNumberSet) {
            ArrayList<QFilter> rangFilters = new ArrayList<QFilter>(8);
            rangFilters.add(filterAcctTable);
            rangFilters.add(facctBaseData.copy());
            if (isOnlyRange) {
                log.info("ACCT\u91cd\u5206\u7c7b\u53d6\u6570isOnlyRange\uff1a" + facctBaseData.toString());
            }
            String key = acctRangeNumber;
            String[] acctContinueNumbers = (acctRangeNumber = acctRangeNumber.substring(1, acctRangeNumber.length() - 1)).split(",");
            DataSet rangeAcctSet = this.queryContinueNumber(Arrays.asList(acctContinueNumbers), rangFilters, "id,masterid,dc,level,number", "bd_accountview");
            if (rangeAcctSet == null) continue;
            HashSet<Long> acctIds = new HashSet<Long>(128);
            String cNumber = acctContinueNumbers[0];
            int cNumberLength = cNumber.length();
            for (Row row : rangeAcctSet) {
                String number = row.getString("number");
                allRangeNumbers.add(number);
                if (cNumberLength != number.length()) continue;
                String dc = row.getString("dc");
                long acctId = row.getLong("id");
                acctIds.add(acctId);
                this.acctMasterToDcMap.put(acctId, dc);
                this.acctNumberToIdsMap.put(number, acctId);
            }
            this.acctRangeKeyToIdsMap.put(key, acctIds);
        }
        log.info("ICTACCT\u91cd\u5206\u7c7b\u53d6\u6570acctMasterToDcMap\uff1a" + this.acctMasterToDcMap.toString());
        log.info("ICTACCT\u91cd\u5206\u7c7b\u53d6\u6570acctNumberToIdsMap\uff1a" + this.acctNumberToIdsMap.toString());
        log.info("ICTACCT\u91cd\u5206\u7c7b\u53d6\u6570acctRangeKeyToIdsMap\uff1a" + this.acctRangeKeyToIdsMap.toString());
        if (isOnlyRange) {
            log.info("ICTACCT\u91cd\u5206\u7c7b\u53d6\u6570isOnlyRange-allRangeNumbers\uff1a" + ((Object)allRangeNumbers).toString());
        }
    }

    private DataSet queryContinueNumber(List<String> acctNumbers, List<QFilter> filters, String sel, String entityName) {
        if (acctNumbers != null && acctNumbers.size() == 2) {
            String acctNumber0 = acctNumbers.get(0);
            String acctNumber1 = acctNumbers.get(1);
            QFilter filterMin = new QFilter("number", ">=", (Object)acctNumber0);
            QFilter filterMax = new QFilter("number", "<=", (Object)acctNumber1);
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(8);
            filterList.addAll(filters);
            filterList.add(filterMin);
            filterList.add(filterMax);
            DataSet acctSet = QueryServiceHelper.queryDataSet((String)"ReClassUtils.queryDataSet", (String)entityName, (String)sel, (QFilter[])filterList.toArray(new QFilter[0]), (String)"number");
            return acctSet;
        }
        return null;
    }

    private DataSet queryDataSet(String algoKey, String entityId, String sel, QFilter[] filters) {
        DataSet assistSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityId, (String)sel, (QFilter[])filters, null);
        return assistSet;
    }

    private void querySeasonPeriodId() {
        String month;
        String year;
        HashSet<Integer> periodYearSet = new HashSet<Integer>(this.periodNumberSet.size());
        for (String periodYearAndMonth : this.periodYearAndMonthSet) {
            String[] yearAndMonth = periodYearAndMonth.split(",");
            if (yearAndMonth.length != 2) continue;
            periodYearSet.add(Integer.parseInt(yearAndMonth[0]));
        }
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)this.orgId, (long)this.bookTypeId);
        long periodTypeId = bookInfo.getPeriodTypeId();
        DataSet dataSet = this.queryPeriodByNumber("periodyear, periodnumber, id, isadjustperiod", periodYearSet, null, periodTypeId);
        HashMap<String, String> maxNoAdjustPeriodKeyMap = new HashMap<String, String>(8);
        HashMap<String, String> maxAdjustPeriodKeyMap = new HashMap<String, String>(8);
        HashMap<String, Long> maxAdjustPeriodIdMap = new HashMap<String, Long>(8);
        HashMap<String, Long> allPeriodIdMap = new HashMap<String, Long>(8);
        for (Row period : dataSet) {
            year = period.getString("periodyear");
            month = period.getString("periodnumber");
            Boolean isAdjustPeriod = period.getBoolean("isadjustperiod");
            Long periodId = period.getLong("id");
            if (!allPeriodIdMap.containsKey(year + "," + month) || isAdjustPeriod != null && isAdjustPeriod.booleanValue()) {
                allPeriodIdMap.put(year + "," + month, periodId);
            }
            if (isAdjustPeriod != null && isAdjustPeriod.booleanValue()) {
                if (!StringUtils.isBlank((CharSequence)((CharSequence)maxAdjustPeriodKeyMap.get(year))) && Integer.parseInt(month) <= Integer.parseInt((String)maxAdjustPeriodKeyMap.get(year))) continue;
                maxAdjustPeriodKeyMap.put(year, month);
                maxAdjustPeriodIdMap.put(year, periodId);
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)((CharSequence)maxNoAdjustPeriodKeyMap.get(year))) && Integer.parseInt(month) <= Integer.parseInt((String)maxNoAdjustPeriodKeyMap.get(year))) continue;
            maxNoAdjustPeriodKeyMap.put(year, month);
        }
        for (Map.Entry maxAdjustPeriodKeyEntry : maxAdjustPeriodKeyMap.entrySet()) {
            year = (String)maxAdjustPeriodKeyEntry.getKey();
            month = (String)maxAdjustPeriodKeyEntry.getValue();
            String noAdjustPeriodNum = (String)maxNoAdjustPeriodKeyMap.get(year);
            if (!StringUtils.isNotBlank((CharSequence)noAdjustPeriodNum) || Integer.parseInt(month) <= Integer.parseInt(noAdjustPeriodNum)) continue;
            allPeriodIdMap.put(year + "," + noAdjustPeriodNum, (Long)maxAdjustPeriodIdMap.get(year));
        }
        for (String periodYearAndMonth : this.periodYearAndMonthSet) {
            if (allPeriodIdMap.get(periodYearAndMonth) == null) continue;
            this.seasonPeriodIdMap.put(periodYearAndMonth, (Long)allPeriodIdMap.get(periodYearAndMonth));
        }
    }

    public Map<String, Long> getOpOrgNumberToIdsMap() {
        return this.opOrgNumberToIdsMap;
    }

    public Map<String, Long> getCurrencyNumberToIdsMap() {
        return this.currencyNumberToIdsMap;
    }

    public Map<Long, String> getAcctMasterToDcMap() {
        return this.acctMasterToDcMap;
    }

    public Map<String, Long> getAcctNumberToIdsMap() {
        return this.acctNumberToIdsMap;
    }

    public Map<String, Long> getPeriodIdsMap() {
        return this.periodIdsMap;
    }

    public long getOrgId() {
        return this.orgId;
    }

    public long getBookTypeId() {
        return this.bookTypeId;
    }

    public long getAcctTableId() {
        return this.acctTableId;
    }

    public Map<String, Set<Long>> getAcctRangeKeyToIdsMap() {
        return this.acctRangeKeyToIdsMap;
    }

    public Map<Long, Set<Long>> getAcctToDirectLeafMap() {
        return this.acctToDirectLeafMap;
    }

    public Map<Long, Set<Long>> getAcctToAllLeafMap() {
        return this.acctToAllLeafMap;
    }

    public Map<Long, Set<String>> getAcctToFlexsMap() {
        return this.acctToFlexsMap;
    }

    public Map<Long, String> getAcctToNumberMap() {
        return this.acctToNumberMap;
    }

    public Map<String, String> getAssistToFlexMap() {
        return this.assistToFlexMap;
    }

    public Map<String, Object> getassistValNumberToObjMap() {
        return this.assistValNumberToObjMap;
    }

    public Map<String, Set<Object>> getassistValRangeNumberToObjsMap() {
        return this.assistValRangeNumberToObjsMap;
    }

    public Map<String, DataSet> getFlexToIDHgSet() {
        return this.flexToIDHgSet;
    }

    public void setOrgId(long orgId) {
        this.orgId = orgId;
    }

    public void setBookTypeId(long bookTypeId) {
        this.bookTypeId = bookTypeId;
    }

    public Map<String, Long> getSeasonPeriodIdMap() {
        return this.seasonPeriodIdMap;
    }

    public Map<String, Set<Long>> getAssistFieldValToIdMap() {
        return this.assistFieldValToIdMap;
    }

    public Map<String, Set<String>> getFieldToEntryFieldMap() {
        return this.fieldToEntryFieldMap;
    }

    public Map<String, List<String>> getPeriodFromYearMap() {
        return this.periodFromYearMap;
    }

    public AcctFormulaParser getParser() {
        return this.parser;
    }
}

