/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.single;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.ict.enums.PuchType;
import kd.fi.ict.mservice.formula.common.facct.AcctFetchType;
import kd.fi.ict.mservice.formula.single.AcctKeyObject;
import kd.fi.ict.mservice.formula.single.NumberTransID;
import kd.fi.ict.mservice.formula.single.param.FormulaParam;
import kd.fi.ict.puchamt.AcctPuchAmtQueryExecutor;
import kd.fi.ict.puchamt.acct.AcctPuchAmtQueryParam;

public class QueryTask {
    private NumberTransID param;
    private Map<AcctKeyObject, Set<FormulaParam>> formulasMap;
    private Set<Set<String>> valFlexsSet = new HashSet<Set<String>>(64);
    private static final Log log = LogFactory.getLog(QueryTask.class);
    private AcctQueryTaskParams taskParams = new AcctQueryTaskParams();

    public QueryTask(long bookTypeId, long startPeriodId, long endPeriodId, long accountTableId, Map<AcctKeyObject, Set<FormulaParam>> formulasMap, NumberTransID param, Set<String> allFlexs) {
        this.taskParams.bookTypeId = bookTypeId;
        this.taskParams.accountTableId = accountTableId;
        this.taskParams.startPeriodId = startPeriodId;
        this.taskParams.endPeriodId = endPeriodId;
        this.formulasMap = formulasMap;
        this.param = param;
        this.taskParams.allFlexs = allFlexs;
    }

    public Map<AcctKeyObject, Set<FormulaParam>> getMap() {
        return this.formulasMap;
    }

    public void setMap(Map<AcctKeyObject, Set<FormulaParam>> table) {
        this.formulasMap = table;
    }

    public void addOrgIds(long orgId) {
        this.taskParams.orgIds.add(orgId);
    }

    public void addOpOrgIds(long opOrgId) {
        this.taskParams.opOrgIds.add(opOrgId);
    }

    public void addCurrencyIds(long currencyId) {
        this.taskParams.currencyIds.add(currencyId);
    }

    public void addAcctIds(String acctNumber) {
        this.taskParams.acctNumbers.add(acctNumber);
    }

    public void addLeafAcctIds(Set<Long> leafAccts) {
        this.taskParams.leafAcctIds.addAll(leafAccts);
    }

    public void addPuchType(PuchType puchType) {
        this.taskParams.puchTypes.add(puchType);
    }

    public void addFetchTypes(String fetchType) {
        this.taskParams.fetchTypes.add(fetchType);
    }

    public void addValFlexsSet(Set<Set<String>> valFlexsSet) {
        this.valFlexsSet.addAll(valFlexsSet);
    }

    public void query() {
        try (DataSet ds = this.queryPuch();){
            for (Row row : ds) {
                for (Set<String> assistSet : this.valFlexsSet) {
                    AcctKeyObject key = this.buildKeyByRow(row, assistSet, this.taskParams.isBaseCurrency());
                    Set<FormulaParam> ps = this.formulasMap.get(key);
                    if (null == ps) continue;
                    for (FormulaParam p : ps) {
                        p.addValue(row);
                    }
                }
            }
        }
    }

    private AcctKeyObject buildKeyByRow(Row row, Set<String> flexs, boolean isBaseCurrency) {
        HashMap<String, Object> assgrpMap = new HashMap<String, Object>(flexs.size());
        for (String flex : flexs) {
            assgrpMap.put(flex, row.get(flex));
        }
        long currencyId = isBaseCurrency ? 0L : row.getLong("currency");
        AcctKeyObject key = new AcctKeyObject(row.getLong("org"), row.getLong("oporg"), currencyId, row.getString("account"), assgrpMap);
        return key;
    }

    private DataSet queryPuch() {
        Set<String> sumFileds = this.getSumFields();
        AcctPuchAmtQueryParam queryParam = this.taskParams.buildQueryParam();
        this.taskParams.setReClass();
        queryParam.setSelector(this.getSelectFields(sumFileds));
        DataSet balSet = AcctPuchAmtQueryExecutor.getInstance().getPuchAmt(queryParam);
        balSet = this.balJoinAssist(balSet, sumFileds, this.taskParams);
        return balSet;
    }

    private Set<String> getSumFields() {
        HashSet<String> sumFileds = new HashSet<String>();
        for (PuchType puchType : this.taskParams.puchTypes) {
            sumFileds.addAll(this.getSelFields(PuchType.getPrefix((PuchType)puchType)));
        }
        return sumFileds;
    }

    private Set<String> getSelFields(String prefix) {
        HashSet<String> sumFileds = new HashSet<String>();
        Map<String, AcctFetchType.AmtCaluatorField> fetchjtypeFieldMap = AcctFetchType.getFetchTypeField();
        Map<String, AcctFetchType.AmtCaluatorField> fetchjtypeForFieldMap = AcctFetchType.getFetchTypeForField();
        for (String fetchType : this.taskParams.fetchTypes) {
            String curFeatch = prefix + fetchType;
            AcctFetchType.AmtCaluatorField formulaCalulator = AcctFetchType.FETCHTYPE_CUR.contains(fetchType) ? (fetchjtypeFieldMap.containsKey(curFeatch) ? fetchjtypeFieldMap.get(curFeatch) : (this.taskParams.isBaseCurrency() ? fetchjtypeFieldMap.get("C_L" + fetchType) : fetchjtypeForFieldMap.get("C_" + fetchType))) : (fetchjtypeFieldMap.containsKey(curFeatch) ? fetchjtypeFieldMap.get(curFeatch) : (this.taskParams.isBaseCurrency() ? fetchjtypeFieldMap.get(prefix + "L" + fetchType) : fetchjtypeForFieldMap.get(prefix + fetchType)));
            if (!Objects.nonNull(formulaCalulator)) continue;
            sumFileds.addAll(formulaCalulator.getCalFields());
        }
        return sumFileds;
    }

    public String getSelectFields(Set<String> sumFileds) {
        HashSet<String> balFields = new HashSet<String>();
        balFields.add("org");
        if (this.taskParams.opOrgIds.size() > 0) {
            balFields.add("oporg");
        }
        if (!this.taskParams.isBaseCurrency()) {
            balFields.add("currency");
        }
        balFields.add("account.number account");
        if (this.taskParams.isReClass() || this.taskParams.allFlexs.size() > 0) {
            balFields.add("assgrp hg");
        }
        balFields.addAll(sumFileds);
        String selFields = ((Object)balFields).toString();
        selFields = selFields.substring(1, selFields.length() - 1);
        if (DebugTrace.enable()) {
            log.info("QueryTask_queryBalance : selFields = " + selFields);
        }
        return selFields;
    }

    private DataSet balJoinAssist(DataSet balSet, Set<String> sumFileds, AcctQueryTaskParams taskParams) {
        HashSet<String> flexFields = new HashSet<String>();
        for (String flex : taskParams.allFlexs) {
            if (null == this.param.getFlexToIDHgSet().get(flex)) continue;
            DataSet assistSet = this.param.getFlexToIDHgSet().get(flex).copy();
            List<String> balFields = QueryTask.getDataSetCols(balSet);
            flexFields.add(flex);
            List<String> assistList = QueryTask.getDataSetCols(assistSet);
            assistList.remove("hg");
            balSet = balSet.join(assistSet, JoinType.LEFT).on("hg", "hg").select(balFields.toArray(new String[0]), assistList.toArray(new String[0])).finish();
        }
        if (taskParams.isReClass() && !flexFields.isEmpty()) {
            List<String> balFields = QueryTask.getDataSetCols(balSet);
            balFields.removeAll(sumFileds);
            balFields.remove("hg");
            GroupbyDataSet gDataSet = balSet.groupBy(balFields.toArray(new String[0]));
            for (String sumField : sumFileds) {
                gDataSet.sum(sumField);
            }
            balSet = gDataSet.finish();
        }
        return balSet;
    }

    public static List<String> getDataSetCols(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            list.add(field.getName());
        }
        return list;
    }

    class AcctQueryTaskParams {
        private Set<Long> orgIds = new HashSet<Long>(8);
        private long bookTypeId;
        private long accountTableId;
        private Set<Long> opOrgIds = new HashSet<Long>(8);
        private Set<String> acctNumbers = new HashSet<String>(128);
        private Set<Long> currencyIds = new HashSet<Long>(8);
        private long startPeriodId;
        private long endPeriodId;
        private Set<PuchType> puchTypes = new HashSet<PuchType>(3);
        private Set<String> fetchTypes = new HashSet<String>(8);
        private boolean isReClass = false;
        private Set<String> allFlexs = new HashSet<String>(8);
        private Set<Long> leafAcctIds = new HashSet<Long>(128);

        AcctQueryTaskParams() {
        }

        public AcctQueryTaskParams setOrgIds(Set<Long> orgIds) {
            this.orgIds = orgIds;
            return this;
        }

        public AcctQueryTaskParams setBookTypeId(long bookTypeId) {
            this.bookTypeId = bookTypeId;
            return this;
        }

        public AcctQueryTaskParams setAccountTableId(long accountTableId) {
            this.accountTableId = accountTableId;
            return this;
        }

        public AcctQueryTaskParams setEndPeriodId(long endPeriodId) {
            this.endPeriodId = endPeriodId;
            return this;
        }

        public boolean isReClass() {
            return this.isReClass;
        }

        public AcctQueryTaskParams setReClass() {
            String fetchField = ((QueryTask)QueryTask.this).taskParams.fetchTypes.iterator().next();
            this.isReClass = AcctFetchType.getFetchTypeReclass().contains(fetchField);
            return this;
        }

        public boolean isBaseCurrency() {
            return this.currencyIds == null || this.currencyIds.iterator().next() == 0L;
        }

        public AcctPuchAmtQueryParam.AcctParam getAcctParam() {
            AcctPuchAmtQueryParam.AcctParam acctParam = new AcctPuchAmtQueryParam.AcctParam();
            acctParam.setSpecialAccount(false);
            if (this.acctNumbers != null && !this.acctNumbers.isEmpty()) {
                this.dealLeafAcctNumbers();
                acctParam.setOnlyLeafAcctAmt(false);
                acctParam.setAccountFilter(new QFilter("number", "in", this.acctNumbers));
            }
            if (!this.isBaseCurrency()) {
                acctParam.setCurrencyIds(this.currencyIds.toArray(new Long[0]));
            }
            return acctParam;
        }

        private void dealLeafAcctNumbers() {
            if (!this.allFlexs.isEmpty()) {
                Set<String> allAcctNumbers = this.getAcctMumbersByFlexFields();
                this.acctNumbers.clear();
                this.acctNumbers.addAll(allAcctNumbers);
            }
        }

        public Set<String> getAcctMumbersByFlexFields() {
            if (this.leafAcctIds.isEmpty()) {
                return new HashSet<String>();
            }
            DynamicObjectCollection acttypeColl = QueryServiceHelper.query((String)"bd_asstacttype", (String)"id,flexfield", (QFilter[])new QFilter("flexfield", "in", this.allFlexs).toArray());
            HashMap<String, Long> typeMap = new HashMap<String, Long>();
            for (DynamicObject acttype : acttypeColl) {
                typeMap.put(acttype.getString("flexfield"), acttype.getLong("id"));
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select a.fnumber from T_BD_Account a ");
            StringBuffer where = new StringBuffer();
            where.append(" WHERE a.faccounttableid = ? ");
            ArrayList<Long> sp = new ArrayList<Long>(this.allFlexs.size());
            sp.add(((QueryTask)QueryTask.this).taskParams.accountTableId);
            where.append(" AND a.fid in (");
            for (Long acctId : this.leafAcctIds) {
                where.append("?,");
                sp.add(acctId);
            }
            where = where.deleteCharAt(where.length() - 1);
            where.append(')');
            HashSet<String> acctNumbers = new HashSet<String>(32);
            int i = 1;
            for (String s : this.allFlexs) {
                sql.append(" INNER JOIN T_BD_AccountAsstActItem a").append(i).append(" ON a.fid=a").append(i).append(".fid");
                where.append(" and a").append(i).append(".fasstactitemid = ? ");
                sp.add((Long)typeMap.get(s));
                ++i;
            }
            try (DataSet dataSet = DB.queryDataSet((String)"getAcctMumbersByFlexFields", (DBRoute)DBRoute.of((String)"gl"), (String)sql.append(where).toString(), (Object[])sp.toArray());){
                while (dataSet.hasNext()) {
                    acctNumbers.add(dataSet.next().getString("fnumber"));
                }
            }
            return acctNumbers;
        }

        public AcctPuchAmtQueryParam buildQueryParam() {
            AcctPuchAmtQueryParam queryParam = new AcctPuchAmtQueryParam();
            queryParam.setOrgIds(this.orgIds.toArray(new Long[0]));
            queryParam.setBookTypeId(Long.valueOf(this.bookTypeId));
            queryParam.setOpOrgIds(this.opOrgIds.toArray(new Long[0]));
            queryParam.setAccountTableId(Long.valueOf(this.accountTableId));
            queryParam.setBeginPeriodId(Long.valueOf(this.startPeriodId));
            queryParam.setEndPeriodID(Long.valueOf(this.endPeriodId));
            queryParam.setAcctParam(this.getAcctParam());
            return queryParam;
        }
    }
}

