/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.single.account;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.DebugTraceHelper;
import kd.fi.ict.mservice.formula.common.FormulaCommon;
import kd.fi.ict.mservice.formula.common.exception.FormulaException;
import kd.fi.ict.mservice.formula.common.facct.AcctFetchType;
import kd.fi.ict.mservice.formula.common.utils.AcctPeriodUtil;
import kd.fi.ict.mservice.formula.common.utils.AcctUtil;
import kd.fi.ict.mservice.formula.single.BuildParamMap;
import kd.fi.ict.mservice.formula.single.LoopExcuteAcctMapBalanceQueryHandle;
import kd.fi.ict.mservice.formula.single.NumberTransID;
import kd.fi.ict.mservice.formula.single.account.AcctFormula;
import kd.fi.ict.mservice.formula.single.account.AcctFormulaParser;
import kd.fi.ict.mservice.formula.single.context.AcctMapContext;
import kd.fi.ict.mservice.formula.single.context.BuildAcctMapContext;
import kd.fi.ict.mservice.formula.single.utils.FormulaUtils;

public class AcctFormulaAction {
    private static final Log log = LogFactory.getLog(AcctFormulaAction.class);

    public Map<String, Map<String, Object>> parseParam(AcctFormulaParser parser) {
        this.printFormulaParams(parser);
        FormulaCommon fCommon = parser.getfCommon();
        AcctUtil acctUtil = new AcctUtil();
        for (Map.Entry bookFormulas : parser.getBookFormulasMap().entrySet()) {
            String bookStr = bookFormulas.getKey();
            List<AcctFormula> accflst = bookFormulas.getValue();
            try {
                NumberTransID numberIDParam = new NumberTransID(parser, accflst, bookStr);
                BuildAcctMapContext buildAcctMapContext = new BuildAcctMapContext();
                for (AcctFormula acctFormula : accflst) {
                    String currencyNumber = acctFormula.getCurrencyNumber();
                    long currencyId = 0L;
                    if (!StringUtils.isBlank((CharSequence)currencyNumber)) {
                        currencyId = numberIDParam.getCurrencyNumberToIdsMap().get(currencyNumber) == null ? 0L : numberIDParam.getCurrencyNumberToIdsMap().get(currencyNumber);
                    }
                    try {
                        this.setAcctFormulaPeriod(fCommon, acctFormula, numberIDParam);
                        String acctToAssistList = acctFormula.getAccountAndassgrp();
                        Map<Long, Map<String, Set<Object>>> assistToAcctMap = acctUtil.parseAcctAssistList(acctToAssistList, numberIDParam, acctFormula.getfKey());
                        if (DebugTrace.enable()) {
                            log.info("acctUtil_assistToAcctMap : " + DebugTraceHelper.toString(assistToAcctMap));
                        }
                        if (assistToAcctMap.isEmpty()) {
                            FormulaUtils.failResult(parser.getResultMap(), acctFormula.getfKey(), String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7\u65e0\u6cd5\u89e3\u6790\u7f16\u7801\u4e3a%2$s\u7684\u79d1\u76ee\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f", (String)"", (String)"", (Object[])new Object[0]), acctFormula.getOrgNumber(), acctToAssistList));
                            continue;
                        }
                        HashMap<Long, Integer> acctToAssistStyleMap = new HashMap<Long, Integer>(64);
                        HashMap<Long, Set<Long>> acctToRCAcctIdsMap = new HashMap<Long, Set<Long>>(64);
                        if (AcctFetchType.getFetchTypeReclass().contains(acctFormula.getFetchType())) {
                            acctUtil.acctReClassDeal(acctFormula.getAccountReClass(), assistToAcctMap, acctToAssistStyleMap, acctToRCAcctIdsMap, numberIDParam);
                        } else {
                            Map<Long, Set<Long>> leafMap = numberIDParam.getAcctToAllLeafMap();
                            Set<Long> acctIds = assistToAcctMap.keySet();
                            for (Long acctId : acctIds) {
                                acctToAssistStyleMap.put(acctId, 2);
                                acctToRCAcctIdsMap.put(acctId, leafMap.get(acctId));
                            }
                        }
                        if (acctToAssistStyleMap.isEmpty()) {
                            String[] accountValues = acctToAssistList.split("\\|");
                            String acctsStr = accountValues[0];
                            FormulaUtils.failResult(parser.getResultMap(), acctFormula.getfKey(), String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7\u6ca1\u6709\u5206\u914d%2$s\u79d1\u76ee\u6743\u9650", (String)"", (String)"", (Object[])new Object[0]), acctFormula.getOrgNumber(), acctsStr));
                            continue;
                        }
                        Long opOrgIdLong = numberIDParam.getOpOrgNumberToIdsMap().get(acctFormula.getOpOrgNumber());
                        long opOrgId = Objects.isNull(opOrgIdLong) ? 0L : opOrgIdLong;
                        new BuildParamMap().buildContext(buildAcctMapContext, assistToAcctMap, acctToAssistStyleMap, acctToRCAcctIdsMap, numberIDParam, acctFormula.getPuchType(), acctFormula.getFetchType(), currencyId, numberIDParam.getOrgId(), opOrgId, acctFormula.getfKey(), numberIDParam.getBookTypeId(), numberIDParam.getAcctTableId(), acctFormula.getStartPeriodId(), acctFormula.getEndPeriodId(), acctFormula.getAccountReClass());
                    }
                    catch (FormulaException fe) {
                        log.error((Throwable)fe);
                        FormulaUtils.failResult(parser.getResultMap(), acctFormula.getfKey(), fe.getMessage());
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                        FormulaUtils.failResult(parser.getResultMap(), acctFormula.getfKey(), String.format(ResManager.loadKDString((String)"\u5f53\u524d\u516c\u5f0f\uff1a %s \u5f02\u5e38  ", (String)"", (String)"", (Object[])new Object[0]), acctFormula));
                    }
                }
                if (buildAcctMapContext.getAssistAcctGroupMapContext().getSize() > 0) {
                    for (Map.Entry entry : buildAcctMapContext.getAssistAcctGroupMapContext().getGroupMap().entrySet()) {
                        AcctMapContext contextValue = (AcctMapContext)entry.getValue();
                        new LoopExcuteAcctMapBalanceQueryHandle().handle(buildAcctMapContext, contextValue);
                    }
                    buildAcctMapContext.getAssistAcctGroupMapContext().clear();
                }
                this.setFormulaAmt(buildAcctMapContext, parser.getResultMap());
            }
            catch (Exception e) {
                accflst.forEach(acctf -> FormulaUtils.failResult(parser.getResultMap(), acctf.getfKey(), e.getMessage()));
                log.error((Throwable)e);
                log.info(ResManager.loadKDString((String)"\u91cd\u5206\u7c7b\u53d6\u6570\u5f02\u5e38\u4fe1\u606f\uff1a", (String)"AcctBalParseAction_7", (String)"fi-gl-mservice", (Object[])new Object[0]) + e);
            }
        }
        return parser.getResultMap();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setAcctFormulaPeriod(FormulaCommon fCommon, AcctFormula acctf, NumberTransID numberIDParam) {
        if (acctf.isMonthRpt()) {
            String comAdjustPeriod = fCommon.getAdjustPeriod();
            int fy = -1;
            String periodStr = StringUtils.isNotBlank((CharSequence)comAdjustPeriod) ? comAdjustPeriod : String.valueOf(fCommon.getPeriod());
            String yearAndPeriodKey = AcctPeriodUtil.dealYearAndPeriod(AcctUtil.getPeriodParam(acctf.getPeriod()), fCommon.getPeriod(), comAdjustPeriod, String.valueOf(acctf.getFy()), fCommon.getFy(), numberIDParam.getPeriodFromYearMap());
            String[] yearAndPeriod = yearAndPeriodKey.split("-");
            if (yearAndPeriod.length == 2) {
                fy = Integer.parseInt(yearAndPeriod[0]);
                periodStr = yearAndPeriod[1];
            }
            if (!periodStr.endsWith("T") && fy == -1) throw new FormulaException(String.format(ResManager.loadKDString((String)"\u671f\u95f4\u8d1f\u6570\u4e0d\u80fd\u8de8\u5ea6\u4e24\u5e74", (String)"", (String)"", (Object[])new Object[0]), new Object[0]));
            Long startPeriodId = numberIDParam.getPeriodIdsMap().get(fy + "," + periodStr);
            if (startPeriodId == null) {
                throw new FormulaException(String.format(ResManager.loadKDString((String)"\u53d6\u4e0d\u5230\u671f\u95f4\uff0c\u8bf7\u67e5\u770b\u516c\u5f0f\u671f\u95f4\u8bbe\u7f6e\u662f\u5426\u6b63\u786e", (String)"", (String)"", (Object[])new Object[0]), new Object[0]));
            }
            acctf.setStartPeriodId(startPeriodId);
            acctf.setEndPeriodId(startPeriodId);
        } else {
            acctf.setStartPeriodId(numberIDParam.getSeasonPeriodIdMap().get(acctf.getfKey() + "," + fCommon.getScopePeriods().get(0)));
            acctf.setEndPeriodId(numberIDParam.getSeasonPeriodIdMap().get(acctf.getfKey() + "," + fCommon.getScopePeriods().get(1)));
        }
        if (!Objects.isNull(acctf.getStartPeriodId()) && !Objects.isNull(acctf.getEndPeriodId())) return;
        throw new FormulaException(String.format(ResManager.loadKDString((String)"\u53d6\u4e0d\u5230\u671f\u95f4\uff0c\u8bf7\u67e5\u770b\u516c\u5f0f\u671f\u95f4\u8bbe\u7f6e\u662f\u5426\u6b63\u786e", (String)"", (String)"", (Object[])new Object[0]), new Object[0]));
    }

    private void setFormulaAmt(BuildAcctMapContext buildAcctMapContext, Map<String, Map<String, Object>> resultMap) {
        Map<String, Map<String, Object>> builMap = buildAcctMapContext.getResultMap();
        log.info(ResManager.loadKDString((String)"\u91cd\u5206\u7c7b\u5206\u6279\u53d6\u6570\u7ed3\u679c\uff1a", (String)"AcctBalParseAction_18", (String)"fi-gl-mservice", (Object[])new Object[0]) + builMap.toString());
        resultMap.putAll(builMap);
    }

    private void printFormulaParams(AcctFormulaParser fParser) {
        log.info("ictacct \u53d6\u6570\uff0c\u62a5\u8868\u53c2\u6570\uff1a" + fParser.getfCommon().getAccountReClass() + ",\u7ec4\u7ec7\u7f16\u7801\uff1a" + fParser.getfCommon().getOrgNumber() + ",\u671f\u95f4\uff1a" + fParser.getfCommon().getPeriod());
        ArrayList acctfs = new ArrayList(fParser.getBookFormulasMap().size());
        fParser.getBookFormulasMap().forEach((bookStr, fLst) -> acctfs.addAll(fLst));
        StringBuilder logBuilder = new StringBuilder();
        for (int index = 1; index <= acctfs.size(); ++index) {
            logBuilder.append(acctfs.get(index - 1));
            if (index % 100 != 0 && index != acctfs.size()) continue;
            log.info("ictacct \u516c\u5f0f" + index + "\uff1a" + logBuilder);
            logBuilder = new StringBuilder();
        }
    }
}

