/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.single.build.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ict.enums.PuchType;
import kd.fi.ict.mservice.formula.single.AcctKeyObject;
import kd.fi.ict.mservice.formula.single.NumberTransID;
import kd.fi.ict.mservice.formula.single.QueryTask;
import kd.fi.ict.mservice.formula.single.build.AbstractBuildParamMapAction;
import kd.fi.ict.mservice.formula.single.context.AcctMapContext;
import kd.fi.ict.mservice.formula.single.context.AcctMapContextKey;
import kd.fi.ict.mservice.formula.single.context.AssistAcctGroupMapContext;
import kd.fi.ict.mservice.formula.single.context.BuildParamMapContext;
import kd.fi.ict.mservice.formula.single.param.AcctParam;
import kd.fi.ict.mservice.formula.single.param.DetailAcctParam;
import kd.fi.ict.mservice.formula.single.param.FormulaParam;

public class BuildQueryTask
extends AbstractBuildParamMapAction {
    private static final Log log = LogFactory.getLog(BuildQueryTask.class);

    public BuildQueryTask(BuildParamMapContext ctx) {
        super(ctx);
    }

    @Override
    protected void action() {
        AssistAcctGroupMapContext assistAcctGroupMapContext = this.ctx.getBuildAcctMapContext().getAssistAcctGroupMapContext();
        Map<Set<String>, AcctMapContext> groupMap = assistAcctGroupMapContext.getGroupMap();
        List<AcctParam> acctParams = this.ctx.getAcctParams();
        Set<String> allFlexs = this.ctx.getAllFlexs();
        FormulaParam formulaParam = this.ctx.getFormulaParam();
        List<Set<String>> valFlexsSet = this.ctx.getValFlexsSet();
        long orgId = this.ctx.getOrgId();
        long opOrgId = this.ctx.getOpOrgId();
        long currencyId = this.ctx.getCurrencyId();
        PuchType puchType = this.ctx.getPuchType();
        String fetchType = this.ctx.getFetchType();
        long bookTypeId = this.ctx.getBookTypeId();
        Long startPeriodId = this.ctx.getStartPeriodId();
        Long endPeriodId = this.ctx.getEndPeriodId();
        long acctTableId = this.ctx.getAcctTableId();
        NumberTransID numberIDParam = this.ctx.getNumberIDParam();
        QueryTask queryTask = null;
        for (AcctParam acctParam : acctParams) {
            List<DetailAcctParam> detailAcctPatams = acctParam.getDetailAcctPatams();
            for (DetailAcctParam detailAcctPatam : detailAcctPatams) {
                Map<String, Object> singleAssistMap = detailAcctPatam.getAssistGroup();
                String acctNumber = detailAcctPatam.getAcctNumber();
                AcctMapContext acctMapContext = null;
                if (groupMap.containsKey(allFlexs)) {
                    acctMapContext = groupMap.get(allFlexs);
                } else {
                    acctMapContext = new AcctMapContext();
                    groupMap.put(allFlexs, acctMapContext);
                }
                Map<AcctMapContextKey, QueryTask> acctMap = acctMapContext.getAcctKeyObjectObjectMap(fetchType, currencyId);
                Map<AcctKeyObject, Set<FormulaParam>> fomulaMap = null;
                AcctMapContextKey acctMapContextKey = new AcctMapContextKey(bookTypeId, startPeriodId, endPeriodId, acctTableId);
                AcctKeyObject acctObject = new AcctKeyObject(orgId, opOrgId, currencyId, acctNumber, singleAssistMap);
                if (acctMap.containsKey(acctMapContextKey)) {
                    queryTask = acctMap.get(acctMapContextKey);
                    fomulaMap = queryTask.getMap();
                    fomulaMap.computeIfAbsent(acctObject, p -> new HashSet(10)).add(formulaParam);
                } else {
                    HashSet<FormulaParam> formulaParams = new HashSet<FormulaParam>(10);
                    formulaParams.add(formulaParam);
                    fomulaMap = new HashMap<AcctKeyObject, Set<FormulaParam>>(16);
                    fomulaMap.put(acctObject, formulaParams);
                    queryTask = new QueryTask(bookTypeId, startPeriodId, endPeriodId, acctTableId, fomulaMap, numberIDParam, allFlexs);
                }
                queryTask = this.addQueryTaskPropertyVal(queryTask, orgId, opOrgId, currencyId, acctNumber, puchType, fetchType, valFlexsSet);
                acctMap.put(acctMapContextKey, queryTask);
                assistAcctGroupMapContext.autoIncrease();
            }
        }
        Set<Long> acctIds = this.ctx.getAcctToRCAcctIdsMap().keySet();
        Map<Long, Set<Long>> acctToLeafAcctMap = numberIDParam.getAcctToAllLeafMap();
        HashSet<Long> allLeafIds = new HashSet<Long>();
        for (Long acctId : acctIds) {
            allLeafIds.addAll((Collection<Long>)acctToLeafAcctMap.get(acctId));
        }
        if (queryTask == null) {
            return;
        }
        queryTask.addLeafAcctIds(allLeafIds);
    }

    private QueryTask addQueryTaskPropertyVal(QueryTask queryTask, long orgId, long opOrgId, long currencyId, String acctNumber, PuchType puchType, String fetchType, List<Set<String>> valFlexsSet) {
        queryTask.addOrgIds(orgId);
        queryTask.addOpOrgIds(opOrgId);
        queryTask.addCurrencyIds(currencyId);
        queryTask.addAcctIds(acctNumber);
        queryTask.addPuchType(puchType);
        queryTask.addFetchTypes(fetchType);
        queryTask.addValFlexsSet(new HashSet<Set<String>>(valFlexsSet));
        return queryTask;
    }
}

