/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.single.cashflow;

import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;

public class CfBalanceFilter {
    private final Set<Long> opOrgIsSet;
    private final Set<Long> cashFlowItemIdSet;
    private final Map<String, Set<Object>> assistValIdSet;

    public CfBalanceFilter(Set<Long> opOrgIsSet, Set<Long> cashFlowItemIdSet, Map<String, Set<Object>> assistValIdSet) {
        this.opOrgIsSet = opOrgIsSet;
        this.cashFlowItemIdSet = cashFlowItemIdSet;
        this.assistValIdSet = assistValIdSet;
    }

    public boolean contains(Row row) {
        Long opOrgId = row.getLong("oporg");
        Long cashFlowItemId = row.getLong("cfitem");
        return this.opOrgIsSet.contains(opOrgId) && this.cashFlowItemIdSet.contains(cashFlowItemId) && this.containAssist(row);
    }

    private boolean containAssist(Row row) {
        for (Map.Entry<String, Set<Object>> assistValIdEntry : this.assistValIdSet.entrySet()) {
            Object valueId = row.get(assistValIdEntry.getKey());
            if (assistValIdEntry.getValue().contains(valueId)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "CfBalanceFilter{opOrgIsSet=" + this.opOrgIsSet + ", cashFlowItemIdSet=" + this.cashFlowItemIdSet + ", assistValIdSet=" + this.assistValIdSet + '}';
    }
}

