/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.single.cashflow;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.ict.mservice.formula.common.BaseFormula;
import kd.fi.ict.mservice.formula.common.FormulaCommon;
import kd.fi.ict.mservice.formula.common.exception.FormulaException;
import kd.fi.ict.mservice.formula.common.fcf.CfFetchType;
import org.apache.commons.lang3.StringUtils;

public class CfFormula
extends BaseFormula {
    private String cfitemAndAssgrp;
    private Set<String> cashFlowNumSet;
    private Map<String, Set<String>> assistNumToValNumMap;

    public CfFormula(FormulaCommon fCommon, String fKey, List<String> fParams) {
        super(fCommon, fKey, fParams);
        this.init(fParams);
    }

    private void init(List<String> fParams) {
        this.setCfitemAndAssgrp(String.valueOf(fParams.get(3)));
        this.parseCfItemAndAssgrp(this.cfitemAndAssgrp);
    }

    public void setCfitemAndAssgrp(String cfitemAndAssgrp) {
        String[] cfitemValues = cfitemAndAssgrp.replaceAll("\\|", "\\| ").split("\\|");
        if (StringUtils.isEmpty((CharSequence)cfitemAndAssgrp)) {
            throw new FormulaException(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CfFormula_0", (String)"fi-ict-mservice", (Object[])new Object[0]));
        }
        if (cfitemValues.length == 1 && StringUtils.isEmpty((CharSequence)cfitemValues[0])) {
            throw new FormulaException(ResManager.loadKDString((String)"\u516c\u5f0f\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CfFormula_1", (String)"fi-ict-mservice", (Object[])new Object[0]));
        }
        if ((cfitemValues.length - 1) % 2 != 0) {
            throw new FormulaException(ResManager.loadKDString((String)"\u516c\u5f0f\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u6838\u7b97\u7ef4\u5ea6\u683c\u5f0f\u9519\u8bef\u3002", (String)"CfFormula_2", (String)"fi-ict-mservice", (Object[])new Object[0]));
        }
        this.cfitemAndAssgrp = cfitemAndAssgrp;
    }

    private void parseCfItemAndAssgrp(String cfItemAndAssgrp) {
        this.cashFlowNumSet = new HashSet<String>(8);
        this.assistNumToValNumMap = new HashMap<String, Set<String>>(8);
        String[] cfItemAndAssgrps = cfItemAndAssgrp.replaceAll("\\|", "\\| ").split("\\|");
        this.cashFlowNumSet.addAll(Arrays.asList(cfItemAndAssgrps[0].trim().split(",")));
        if (cfItemAndAssgrps.length > 1) {
            for (int i = 1; i < cfItemAndAssgrps.length; i += 2) {
                if (!StringUtils.isNotBlank((CharSequence)cfItemAndAssgrps[i + 1])) continue;
                String assistNum = cfItemAndAssgrps[i].trim();
                String[] assistValNums = cfItemAndAssgrps[i + 1].trim().split(",");
                Set assistValNumSet = this.assistNumToValNumMap.computeIfAbsent(assistNum, k -> new HashSet(8));
                assistValNumSet.addAll(Arrays.asList(assistValNums));
            }
        }
    }

    @Override
    public String getMarkKey() {
        return this.getOrgNumber() + "," + this.getBootTypeNumber() + "," + this.getFy() + "," + this.getPeriod() + "," + this.isMonthRpt();
    }

    @Override
    public void setFetchType(String fetchType) {
        if (StringUtils.isEmpty((CharSequence)fetchType)) {
            throw new FormulaException(ResManager.loadKDString((String)"\u53d6\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CfFormula_3", (String)"fi-ict-mservice", (Object[])new Object[0]));
        }
        if (Objects.isNull(CfFetchType.getAmtFieldByType(this.getPuchType(), fetchType))) {
            throw new FormulaException(String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u7c7b\u578b'%1$s'\u548c\u53d6\u6570\u7c7b\u578b'%2$s'\u4e3a\u9519\u8bef\u7ec4\u5408\u3002", (String)"", (String)"fi-ict-mservice", (Object[])new Object[0]), this.getPuchType().name(), fetchType));
        }
        super.setFetchType(fetchType);
    }

    public String getCfitemAndAssgrp() {
        return this.cfitemAndAssgrp;
    }

    public Set<String> getCashFlowNumSet() {
        return this.cashFlowNumSet;
    }

    public Map<String, Set<String>> getAssistNumToValNumMap() {
        return this.assistNumToValNumMap;
    }
}

