/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.single.cashflow;

import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.ict.mservice.formula.common.exception.FormulaException;
import kd.fi.ict.mservice.formula.common.fcf.CfFetchType;
import kd.fi.ict.mservice.formula.common.utils.AcctUtil;
import kd.fi.ict.mservice.formula.single.cashflow.CfBalanceFilter;
import kd.fi.ict.mservice.formula.single.cashflow.CfFormula;
import kd.fi.ict.mservice.formula.single.cashflow.CfFormulaParser;
import kd.fi.ict.mservice.formula.single.cashflow.context.CfFormulaContext;
import kd.fi.ict.mservice.formula.single.utils.FormulaUtils;
import kd.fi.ict.puchamt.CfPuchAmtQueryExecutor;
import kd.fi.ict.puchamt.cf.CfPuchAmtQueryParam;

public class CfFormulaAction {
    private static final Log LOGGER = LogFactory.getLog(CfFormulaAction.class);

    public Map<String, Map<String, Object>> parseParam(CfFormulaParser parser) {
        CfFormulaContext ctx = new CfFormulaContext(parser);
        for (Map.Entry bookFormulas : parser.getBookFormulasMap().entrySet()) {
            List<CfFormula> formulaList = bookFormulas.getValue();
            try {
                this.checkFormula(formulaList, parser, ctx);
                List<CfFormula> legalFormulaList = this.getLegalFormulas(formulaList, parser.getResultMap());
                if (!CollectionUtils.isNotEmpty(legalFormulaList)) continue;
                DataSet balance = this.getCashFlowBalance(legalFormulaList, ctx);
                Map<String, CfBalanceFilter> balanceFilterMap = this.getBalanceFilter(legalFormulaList, ctx);
                this.buildResult(balance, balanceFilterMap, legalFormulaList, parser.getResultMap());
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                throw e;
            }
        }
        return parser.getResultMap();
    }

    private void checkFormula(List<CfFormula> formulaList, CfFormulaParser parser, CfFormulaContext ctx) {
        Map<String, Long> orgNumToIdMap = ctx.getOrgNumToIdMap();
        Map<String, Object[]> assistNumToAssistInfoMap = ctx.getAssistNumToAssistInfoMap();
        for (CfFormula cfFormula : formulaList) {
            try {
                this.checkOrgIsExist(cfFormula.getOrgNumber(), cfFormula.getOpOrgNumber(), orgNumToIdMap);
                this.checkPeriodIsExist(cfFormula.getStartPeriodId(), cfFormula.getEndPeriodId());
                this.checkAssistTypeIsExist(cfFormula.getAssistNumToValNumMap().keySet(), assistNumToAssistInfoMap);
            }
            catch (FormulaException fe) {
                LOGGER.error((Throwable)fe);
                FormulaUtils.failResult(parser.getResultMap(), cfFormula.getfKey(), fe.getMessage());
            }
        }
    }

    private void checkOrgIsExist(String orgNumber, String opOrgNumber, Map<String, Long> orgNumToIdMap) {
        Long orgId = orgNumToIdMap.get(orgNumber);
        if (Objects.isNull(orgId) || orgId == 0L) {
            throw new FormulaException(String.format(ResManager.loadKDString((String)"\u672c\u65b9\u7ec4\u7ec7%s\u4e0d\u5b58\u5728\u3002", (String)"CfFormulaAction_3", (String)"fi-ict-mservice", (Object[])new Object[0]), orgNumber));
        }
        Long opOrgId = orgNumToIdMap.get(opOrgNumber);
        if (Objects.isNull(opOrgId) || opOrgId == 0L) {
            throw new FormulaException(String.format(ResManager.loadKDString((String)"\u5bf9\u65b9\u7ec4\u7ec7%s\u4e0d\u5b58\u5728\u3002", (String)"CfFormulaAction_2", (String)"fi-ict-mservice", (Object[])new Object[0]), opOrgNumber));
        }
    }

    private void checkPeriodIsExist(Long startPeriodId, Long endPeriodId) {
        if (Objects.isNull(startPeriodId) || startPeriodId == 0L || Objects.isNull(endPeriodId) || endPeriodId == 0L) {
            throw new FormulaException(ResManager.loadKDString((String)"\u516c\u5f0f\u8bbe\u7f6e\u7684\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"CfFormulaAction_1", (String)"fi-ict-mservice", (Object[])new Object[0]));
        }
    }

    private void checkAssistTypeIsExist(Set<String> assistTypeNumSet, Map<String, Object[]> assistNumToAssistInfoMap) {
        for (String assistTypeNum : assistTypeNumSet) {
            if (!Objects.isNull(assistNumToAssistInfoMap.get(assistTypeNum))) continue;
            throw new FormulaException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7f16\u7801\u4e3a%s\u7684\u7ef4\u5ea6\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u8bbe\u7f6e\u3002", (String)"CfFormulaAction_0", (String)"fi-ict-mservice", (Object[])new Object[]{assistTypeNum}));
        }
    }

    private List<CfFormula> getLegalFormulas(List<CfFormula> formulaList, Map<String, Map<String, Object>> resultMap) {
        ArrayList<CfFormula> legalFormulaList = new ArrayList<CfFormula>(8);
        formulaList.forEach(cfFormula -> {
            if (!resultMap.containsKey(cfFormula.getfKey())) {
                legalFormulaList.add((CfFormula)cfFormula);
            }
        });
        return legalFormulaList;
    }

    private DataSet getCashFlowBalance(List<CfFormula> formulaList, CfFormulaContext ctx) {
        CfPuchAmtQueryParam cfParam = new CfPuchAmtQueryParam();
        HashSet<String> selectorSet = new HashSet<String>(Arrays.asList("cfitem", "oporg", "assgrp"));
        for (CfFormula cfFormula : formulaList) {
            CfFetchType.AmtCaluatorField amtCalculatorField = CfFetchType.getAmtFieldByType(cfFormula.getPuchType(), cfFormula.getFetchType());
            if (!Objects.nonNull(amtCalculatorField)) continue;
            selectorSet.addAll(amtCalculatorField.getCalFields());
        }
        cfParam.setSelector(String.join((CharSequence)",", selectorSet));
        Map<String, Long> orgNumToIdMap = ctx.getOrgNumToIdMap();
        String orgNum = formulaList.get(0).getOrgNumber();
        Long orgId = orgNumToIdMap.get(orgNum);
        cfParam.setOrgIds(new long[]{orgId});
        HashSet<Long> opOrgIdSet = new HashSet<Long>(8);
        for (CfFormula cfFormula : formulaList) {
            opOrgIdSet.add(orgNumToIdMap.get(cfFormula.getOpOrgNumber()));
        }
        if (Objects.isNull(cfParam.getFilters())) {
            cfParam.setFilters(new QFilter[]{new QFilter("oporg", "in", opOrgIdSet)});
        } else {
            List<QFilter> filterList = Arrays.asList(cfParam.getFilters());
            filterList.add(new QFilter("oporg", "in", opOrgIdSet));
            cfParam.setFilters(filterList.toArray(new QFilter[0]));
        }
        Map<String, Long> bookTypeNumToIdMap = ctx.getBookTypeNumToIdMap();
        String bookTypeNum = formulaList.get(0).getBootTypeNumber();
        Long bookTypeId = bookTypeNumToIdMap.getOrDefault(bookTypeNum, 0L);
        cfParam.setBookTypeId(bookTypeId.longValue());
        Long startPeriodId = formulaList.get(0).getStartPeriodId();
        Long endPeriodId = formulaList.get(0).getEndPeriodId();
        cfParam.setBeginPeriodId(startPeriodId.longValue());
        cfParam.setEndPeriodId(endPeriodId.longValue());
        Table<String, String, Set<Long>> orgAndCashFlowNumToIdsTable = ctx.getOrgAndCashFlowNumToIdsTable();
        HashSet cashFlowItemIdSet = new HashSet(8);
        for (CfFormula cfFormula : formulaList) {
            cfFormula.getCashFlowNumSet().forEach(cashFlowNum -> {
                Set valueIdSet = (Set)orgAndCashFlowNumToIdsTable.get((Object)orgNum, cashFlowNum);
                if (CollectionUtils.isNotEmpty((Collection)valueIdSet)) {
                    cashFlowItemIdSet.addAll(valueIdSet);
                }
            });
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(Arrays.asList(cfParam.getFilters()));
        filterList.add(new QFilter("cfitem", "in", cashFlowItemIdSet));
        cfParam.setFilters(filterList.toArray(new QFilter[0]));
        DataSet balance = CfPuchAmtQueryExecutor.getInstance().getCfPuchAmt(cfParam);
        balance = this.balanceJoinAssist(balance, formulaList, ctx);
        return balance;
    }

    private DataSet balanceJoinAssist(DataSet balance, List<CfFormula> formulaList, CfFormulaContext ctx) {
        Map<String, Object[]> assistNumToAssistInfoMap = ctx.getAssistNumToAssistInfoMap();
        HashSet<String> assistNumSet = new HashSet<String>(8);
        for (CfFormula cfFormula : formulaList) {
            assistNumSet.addAll(cfFormula.getAssistNumToValNumMap().keySet());
        }
        Map<String, DataSet> assistNumToHgDtMap = ctx.getAssistNumToHgDtMap();
        for (String assistNum : assistNumSet) {
            Object[] assistInfos = assistNumToAssistInfoMap.get(assistNum);
            if (Objects.isNull(assistInfos)) continue;
            String flexField = (String)assistInfos[0];
            DataSet hgDataSet = assistNumToHgDtMap.get(assistNum);
            if (hgDataSet != null) {
                hgDataSet = hgDataSet.copy();
                List<String> balFields = AcctUtil.getDataSetCols(balance);
                List<String> assistList = AcctUtil.getDataSetCols(hgDataSet);
                assistList.remove("hg");
                balance = balance.join(hgDataSet, JoinType.LEFT).on("assgrp", "hg").select(balFields.toArray(new String[0]), assistList.toArray(new String[0])).finish();
                continue;
            }
            balance = balance.addNullField(flexField);
        }
        return balance;
    }

    private Map<String, CfBalanceFilter> getBalanceFilter(List<CfFormula> formulaList, CfFormulaContext ctx) {
        HashMap<String, CfBalanceFilter> formulaFilterMap = new HashMap<String, CfBalanceFilter>(8);
        Map<String, Long> orgNumToIdMap = ctx.getOrgNumToIdMap();
        Table<String, String, Set<Long>> orgAndCashFlowNumToIdsTable = ctx.getOrgAndCashFlowNumToIdsTable();
        Table<String, String, Map<String, Set<Long>>> assistValueIdTable = ctx.getAssistValueIdTable();
        Map<String, Object[]> assistNumToAssistInfoMap = ctx.getAssistNumToAssistInfoMap();
        for (CfFormula cfFormula : formulaList) {
            HashSet<Long> opOrgIdSet = new HashSet<Long>(8);
            opOrgIdSet.add(orgNumToIdMap.getOrDefault(cfFormula.getOpOrgNumber(), 0L));
            HashSet<Long> allCashFlowIdSet = new HashSet<Long>(8);
            Map cashFlowNumToIdMap = orgAndCashFlowNumToIdsTable.row((Object)cfFormula.getOrgNumber());
            if (Objects.nonNull(cashFlowNumToIdMap)) {
                for (String cashFlowNum : cfFormula.getCashFlowNumSet()) {
                    allCashFlowIdSet.addAll((Collection)cashFlowNumToIdMap.getOrDefault(cashFlowNum, Collections.singleton(0L)));
                }
            } else {
                allCashFlowIdSet.add(0L);
            }
            HashMap<String, Set<Object>> assistValIdMap = new HashMap<String, Set<Object>>(8);
            for (Map.Entry<String, Set<String>> assistNumToValNumEntry : cfFormula.getAssistNumToValNumMap().entrySet()) {
                HashSet assistValIdSet = new HashSet(8);
                String assistNum = assistNumToValNumEntry.getKey();
                Set<String> assistValNumSet = assistNumToValNumEntry.getValue();
                Object[] assistInfos = assistNumToAssistInfoMap.get(assistNum);
                Map assistNumToIdMap = (Map)assistValueIdTable.get((Object)cfFormula.getOrgNumber(), (Object)assistNum);
                if (Objects.nonNull(assistNumToIdMap)) {
                    assistValNumSet.forEach(assistValNum -> {
                        Set valueIdSet = (Set)assistNumToIdMap.get(assistValNum);
                        if (CollectionUtils.isNotEmpty((Collection)valueIdSet)) {
                            assistValIdSet.addAll(valueIdSet);
                        } else {
                            assistValIdSet.add(0L);
                        }
                    });
                }
                if (!CollectionUtils.isNotEmpty(assistValIdSet)) continue;
                assistValIdMap.put((String)assistInfos[0], assistValIdSet);
            }
            formulaFilterMap.put(cfFormula.getfKey(), new CfBalanceFilter(opOrgIdSet, allCashFlowIdSet, assistValIdMap));
        }
        LOGGER.info("CfFormulaAction_getBalanceFilter formulaFilterMap:" + formulaFilterMap);
        return formulaFilterMap;
    }

    private void buildResult(DataSet balance, Map<String, CfBalanceFilter> balanceFilterMap, List<CfFormula> formulaList, Map<String, Map<String, Object>> resultMap) {
        while (balance.hasNext()) {
            Row row = balance.next();
            for (CfFormula cfFormula : formulaList) {
                CfFetchType.AmtCaluatorField amtFieldByType;
                CfBalanceFilter cfBalanceFilter = balanceFilterMap.get(cfFormula.getfKey());
                if (!cfBalanceFilter.contains(row) || Objects.isNull(amtFieldByType = CfFetchType.getAmtFieldByType(cfFormula.getPuchType(), cfFormula.getFetchType()))) continue;
                Map<String, Object> formulaResultMap = resultMap.get(cfFormula.getfKey());
                BigDecimal amount = null;
                amount = Objects.isNull(formulaResultMap) ? BigDecimal.ZERO : (BigDecimal)formulaResultMap.getOrDefault("v", BigDecimal.ZERO);
                amount = amount.add(CfFetchType.rowCountByFetchType(row, amtFieldByType));
                FormulaUtils.successResult(resultMap, cfFormula.getfKey(), amount);
            }
        }
    }
}

