/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.mservice.formula.single.cashflow.context;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ict.mservice.formula.common.FormulaCommon;
import kd.fi.ict.mservice.formula.common.utils.AcctPeriodUtil;
import kd.fi.ict.mservice.formula.common.utils.AcctUtil;
import kd.fi.ict.mservice.formula.common.utils.MakeBaseDateDetailHelper;
import kd.fi.ict.mservice.formula.single.cashflow.CfFormula;
import kd.fi.ict.mservice.formula.single.cashflow.CfFormulaParser;

public class CfFormulaContext {
    private static final Log LOGGER = LogFactory.getLog(CfFormulaContext.class);
    private Map<String, Long> orgNumToIdMap;
    private Map<String, Long> bookTypeNumToIdMap;
    private Table<String, String, Long> periodTypeIdTable;
    private Map<Long, Table<String, String, Long>> periodTypeToPeriodIdMap;
    private Table<String, String, Set<Long>> orgAndCashFlowNumToIdsTable;
    private Map<String, Object[]> assistNumToAssistInfoMap;
    private Table<String, String, Map<String, Set<Long>>> assistValueIdTable;
    private Map<String, DataSet> assistNumToHgDtMap;

    public CfFormulaContext(CfFormulaParser parser) {
        this.initOrgNumToId(parser.getBookFormulasMap());
        this.initAccountBookTypeId(parser.getBookFormulasMap());
        this.initPeriodTypeId(parser.getBookFormulasMap());
        this.initPeriod(parser.getBookFormulasMap(), parser.getfCommon());
        this.initCashFlowItemNumToId(parser.getBookFormulasMap());
        this.initAssistInfo(parser.getBookFormulasMap());
        this.initAssistValueId(parser.getBookFormulasMap());
        this.initAssistNumToHg();
    }

    private void initOrgNumToId(Map<String, List<CfFormula>> bookFormulasMap) {
        HashSet<String> allOrgNumberSet = new HashSet<String>(8);
        for (Map.Entry<String, List<CfFormula>> bookFormulasEntry : bookFormulasMap.entrySet()) {
            for (CfFormula cfFormula : bookFormulasEntry.getValue()) {
                allOrgNumberSet.add(cfFormula.getOrgNumber());
                allOrgNumberSet.add(cfFormula.getOpOrgNumber());
            }
        }
        this.orgNumToIdMap = AcctUtil.getOrgNumToIdMap(allOrgNumberSet);
        LOGGER.info("CfFormulaContext_initOrgNumToId orgNumToIdMap:" + this.orgNumToIdMap);
    }

    private void initAccountBookTypeId(Map<String, List<CfFormula>> bookFormulasMap) {
        HashSet<String> accountBookTypeNumSet = new HashSet<String>(8);
        for (Map.Entry<String, List<CfFormula>> bookFormulasEntry : bookFormulasMap.entrySet()) {
            String[] formulaInfos = bookFormulasEntry.getKey().split(",");
            accountBookTypeNumSet.add(formulaInfos[1]);
        }
        this.bookTypeNumToIdMap = AcctUtil.numbersToIds("bd_accountbookstype", accountBookTypeNumSet, null);
        LOGGER.info("CfFormulaContext_initAccountBookTypeId bookTypeNumToIdMap:" + this.bookTypeNumToIdMap);
    }

    private void initPeriodTypeId(Map<String, List<CfFormula>> bookFormulasMap) {
        this.periodTypeIdTable = HashBasedTable.create();
        HashSet<Long> orgIdSet = new HashSet<Long>(8);
        HashSet<Long> bookTypeIdSet = new HashSet<Long>(8);
        for (Map.Entry<String, List<CfFormula>> bookFormulasEntry : bookFormulasMap.entrySet()) {
            String[] formulaInfos = bookFormulasEntry.getKey().split(",");
            orgIdSet.add(this.orgNumToIdMap.getOrDefault(formulaInfos[0], 0L));
            bookTypeIdSet.add(this.bookTypeNumToIdMap.getOrDefault(formulaInfos[1], 0L));
        }
        QFilter orgIdFilter = new QFilter("org", "in", orgIdSet);
        QFilter bookTypeFilter = new QFilter("bookstype", "in", bookTypeIdSet);
        try (DataSet accountBookDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_accountbook", (String)"org.number, bookstype.number, periodtype.id", (QFilter[])new QFilter[]{orgIdFilter, bookTypeFilter}, null);){
            while (accountBookDataSet.hasNext()) {
                Row row = accountBookDataSet.next();
                this.periodTypeIdTable.put((Object)row.getString("org.number"), (Object)row.getString("bookstype.number"), (Object)row.getLong("periodtype.id"));
            }
        }
        LOGGER.info("CfFormulaContext_initPeriodTypeId periodTypeIdTable:" + this.periodTypeIdTable);
    }

    private void initPeriod(Map<String, List<CfFormula>> bookFormulasMap, FormulaCommon formulaCommon) {
        this.periodTypeToPeriodIdMap = new HashMap<Long, Table<String, String, Long>>(8);
        HashSet<Integer> allYearSet = new HashSet<Integer>(8);
        for (Map.Entry<String, List<CfFormula>> bookFormulasEntry : bookFormulasMap.entrySet()) {
            for (CfFormula cfFormula : bookFormulasEntry.getValue()) {
                allYearSet.add(cfFormula.getFy());
                allYearSet.add(cfFormula.getFy() - 1);
            }
        }
        this.queryPeriodIdByYear(allYearSet);
        this.setFormulaPeriodId(formulaCommon, bookFormulasMap);
        LOGGER.info("CfFormulaContext_initPeriod periodTypeToPeriodIdMap:" + this.periodTypeToPeriodIdMap);
    }

    private void queryPeriodIdByYear(Set<Integer> allYearSet) {
        try (DataSet periodDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"id, periodyear, periodnumber, periodtype, isadjustperiod", (QFilter[])new QFilter[]{new QFilter("periodyear", "in", allYearSet)}, (String)"id");){
            while (periodDataSet.hasNext()) {
                Row row = periodDataSet.next();
                Long periodTypeId = row.getLong("periodtype");
                HashBasedTable periodIdTable = this.periodTypeToPeriodIdMap.get(periodTypeId);
                if (Objects.isNull(periodIdTable)) {
                    periodIdTable = HashBasedTable.create();
                    this.periodTypeToPeriodIdMap.put(periodTypeId, (Table<String, String, Long>)periodIdTable);
                }
                if (row.getBoolean("isadjustperiod").booleanValue()) {
                    periodIdTable.put((Object)row.getString("periodyear"), (Object)(row.getString("periodnumber") + "T"), (Object)row.getLong("id"));
                }
                if (row.getBoolean("isadjustperiod").booleanValue() && Integer.parseInt(row.getString("periodnumber")) <= 12) continue;
                periodIdTable.put((Object)row.getString("periodyear"), (Object)row.getString("periodnumber"), (Object)row.getLong("id"));
            }
        }
    }

    private void setFormulaPeriodId(FormulaCommon formulaCommon, Map<String, List<CfFormula>> bookFormulasMap) {
        Integer comYear = formulaCommon.getFy();
        Integer comPeriod = formulaCommon.getPeriod();
        String comAdjustPeriod = formulaCommon.getAdjustPeriod();
        for (Map.Entry<String, List<CfFormula>> bookFormulasEntry : bookFormulasMap.entrySet()) {
            Table<String, String, Long> periodIdTable;
            String[] formulaInfos = bookFormulasEntry.getKey().split(",");
            Long periodTypeId = (Long)this.periodTypeIdTable.get((Object)formulaInfos[0], (Object)formulaInfos[1]);
            if (Objects.isNull(periodTypeId) || periodTypeId == 0L || Objects.isNull(periodIdTable = this.periodTypeToPeriodIdMap.get(periodTypeId))) continue;
            if (Boolean.parseBoolean(formulaInfos[4])) {
                HashMap<String, List<String>> yearToPeriodNumMap = new HashMap<String, List<String>>(8);
                for (Table.Cell periodIdCell : periodIdTable.cellSet()) {
                    String year = (String)periodIdCell.getRowKey();
                    String period = (String)periodIdCell.getColumnKey();
                    List periodNumList = yearToPeriodNumMap.computeIfAbsent(year, k -> new ArrayList());
                    if (Objects.isNull(period) || period.endsWith("T") && Integer.parseInt(period.substring(0, period.length() - 1)) > 12) continue;
                    periodNumList.add(period);
                }
                String yearAndPeriodKey = AcctPeriodUtil.dealYearAndPeriod(formulaInfos[3], comPeriod, comAdjustPeriod, formulaInfos[2], comYear, yearToPeriodNumMap);
                String[] yearAndPeriod = yearAndPeriodKey.split("-");
                if (yearAndPeriod.length != 2) continue;
                Long periodId = (Long)periodIdTable.get((Object)yearAndPeriod[0], (Object)yearAndPeriod[1]);
                for (CfFormula cfFormula : bookFormulasEntry.getValue()) {
                    cfFormula.setStartPeriodId(periodId);
                    cfFormula.setEndPeriodId(periodId);
                }
                continue;
            }
            Long startPeriodId = (Long)periodIdTable.get((Object)formulaInfos[2], (Object)String.valueOf(formulaCommon.getScopePeriods().get(0)));
            Long endPeriodId = (Long)periodIdTable.get((Object)formulaInfos[2], (Object)String.valueOf(formulaCommon.getScopePeriods().get(1)));
            for (CfFormula cfFormula : bookFormulasEntry.getValue()) {
                cfFormula.setStartPeriodId(startPeriodId);
                cfFormula.setEndPeriodId(endPeriodId);
            }
        }
    }

    private void initCashFlowItemNumToId(Map<String, List<CfFormula>> bookFormulasMap) {
        this.orgAndCashFlowNumToIdsTable = HashBasedTable.create();
        HashMap<String, Set> orgNumToCashFlowsMap = new HashMap<String, Set>(8);
        for (Map.Entry<String, List<CfFormula>> entry : bookFormulasMap.entrySet()) {
            for (CfFormula cfFormula : entry.getValue()) {
                if (!CollectionUtils.isNotEmpty(cfFormula.getCashFlowNumSet())) continue;
                Set cashFlowItemNumSet = orgNumToCashFlowsMap.computeIfAbsent(cfFormula.getOrgNumber(), k -> new HashSet(8));
                cashFlowItemNumSet.addAll(cfFormula.getCashFlowNumSet());
            }
        }
        for (Map.Entry<String, List<CfFormula>> entry : orgNumToCashFlowsMap.entrySet()) {
            String orgNum = entry.getKey();
            Long orgId = this.orgNumToIdMap.getOrDefault(orgNum, 0L);
            if (orgId == 0L) continue;
            QFilter qids = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
            QFilter[] qfs = new QFilter[]{qids, new QFilter("number", "in", entry.getValue())};
            DataSet dt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_cashflowitem", (String)"id, masterid, number", (QFilter[])qfs, null);
            Throwable throwable = null;
            try {
                Row row = null;
                while (dt.hasNext()) {
                    row = dt.next();
                    String cashFlowNum = row.getString("number");
                    if (Objects.nonNull(this.orgAndCashFlowNumToIdsTable.get((Object)orgNum, (Object)cashFlowNum))) {
                        ((Set)this.orgAndCashFlowNumToIdsTable.get((Object)orgNum, (Object)cashFlowNum)).add(row.getLong("id"));
                        continue;
                    }
                    HashSet<Long> cashFlowIdSet = new HashSet<Long>(8);
                    cashFlowIdSet.add(row.getLong("id"));
                    this.orgAndCashFlowNumToIdsTable.put((Object)orgNum, (Object)cashFlowNum, cashFlowIdSet);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dt == null) continue;
                if (throwable != null) {
                    try {
                        dt.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dt.close();
            }
        }
        LOGGER.info("CfFormulaContext_initCashFlowItemNumToId orgAndCashFlowNumToIdsTable:" + this.orgAndCashFlowNumToIdsTable);
    }

    private void initAssistInfo(Map<String, List<CfFormula>> bookFormulasMap) {
        this.assistNumToAssistInfoMap = new HashMap<String, Object[]>(8);
        HashSet<String> allAssistNumSet = new HashSet<String>(8);
        for (Map.Entry<String, List<CfFormula>> bookFormulasEntry : bookFormulasMap.entrySet()) {
            for (CfFormula cfFormula : bookFormulasEntry.getValue()) {
                allAssistNumSet.addAll(cfFormula.getAssistNumToValNumMap().keySet());
            }
        }
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_asstacttype", (String)"number, assistanttype, valuesource, flexfield", (QFilter[])new QFilter("number", "in", allAssistNumSet).toArray(), null, (int)-1);){
            Row row = null;
            while (dt.hasNext()) {
                row = dt.next();
                String assistNum = row.getString("number");
                this.assistNumToAssistInfoMap.put(assistNum, new Object[]{row.getString("flexfield"), row.getString("valuesource"), row.getLong("assistanttype")});
            }
        }
        LOGGER.info("CfFormulaContext_initAssistInfo assistNumToAssistInfoMap:" + this.assistNumToAssistInfoMap);
    }

    private void initAssistValueId(Map<String, List<CfFormula>> bookFormulasMap) {
        this.assistValueIdTable = HashBasedTable.create();
        HashBasedTable allAssistValNumTable = HashBasedTable.create();
        for (Map.Entry<String, List<CfFormula>> bookFormulasEntry : bookFormulasMap.entrySet()) {
            for (CfFormula cfFormula : bookFormulasEntry.getValue()) {
                HashMap<String, Set<String>> assistNumToValNumMap = allAssistValNumTable.row((Object)cfFormula.getOrgNumber());
                if (Objects.nonNull(assistNumToValNumMap)) {
                    for (Map.Entry<String, Set<String>> entry : cfFormula.getAssistNumToValNumMap().entrySet()) {
                        Set allAssistNumSet = assistNumToValNumMap.computeIfAbsent(entry.getKey(), k -> new HashSet());
                        allAssistNumSet.addAll((Collection)entry.getValue());
                    }
                    continue;
                }
                assistNumToValNumMap = new HashMap<String, Set<String>>(8);
                assistNumToValNumMap.putAll(cfFormula.getAssistNumToValNumMap());
                for (Map.Entry<String, Set<String>> entry : assistNumToValNumMap.entrySet()) {
                    allAssistValNumTable.put((Object)cfFormula.getOrgNumber(), (Object)entry.getKey(), entry.getValue());
                }
            }
        }
        for (Table.Cell allAssistValNumCell : allAssistValNumTable.cellSet()) {
            String orgNum = (String)allAssistValNumCell.getRowKey();
            String assistNum = (String)allAssistValNumCell.getColumnKey();
            Set assistValNumSet = (Set)allAssistValNumCell.getValue();
            Long orgId = this.orgNumToIdMap.getOrDefault(orgNum, 0L);
            Object[] objectArray = this.assistNumToAssistInfoMap.get(assistNum);
            if (orgId == 0L || Objects.isNull(objectArray)) continue;
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
            String valueSource = (String)objectArray[1];
            qFilters.add(BaseDataServiceHelper.getBaseDataFilter((String)valueSource, (Long)orgId));
            if ("bos_assistantdata_detail".equals(valueSource)) {
                qFilters.add(new QFilter("group", "=", objectArray[2]));
            }
            MakeBaseDateDetailHelper helper = new MakeBaseDateDetailHelper();
            Map<String, Set<Long>> assistNumToIdMap = helper.getDetailAssists(valueSource, assistValNumSet, qFilters);
            this.assistValueIdTable.put((Object)orgNum, (Object)assistNum, assistNumToIdMap);
        }
        LOGGER.info("CfFormulaContext_initAssistValueId assistValueIdTable:" + this.assistValueIdTable);
    }

    private void initAssistNumToHg() {
        this.assistNumToHgDtMap = new HashMap<String, DataSet>();
        HashMap<String, Set> allAssistNumToIdMap = new HashMap<String, Set>(8);
        for (Table.Cell cell : this.assistValueIdTable.cellSet()) {
            Set allAssistValIdSet = allAssistNumToIdMap.computeIfAbsent((String)cell.getColumnKey(), k -> new HashSet(8));
            if (!Objects.nonNull(cell.getValue())) continue;
            ((Map)cell.getValue()).values().forEach(allAssistValIdSet::addAll);
        }
        for (Map.Entry entry : allAssistNumToIdMap.entrySet()) {
            String assistNum = (String)entry.getKey();
            if (!Objects.nonNull(this.assistNumToAssistInfoMap.get(assistNum))) continue;
            Object[] flexToValueSource = this.assistNumToAssistInfoMap.get(assistNum);
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(8);
            filterList.add(new QFilter("asstype", "=", flexToValueSource[0]));
            filterList.add(new QFilter("assval", "in", entry.getValue()));
            this.assistNumToHgDtMap.put(assistNum, QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_assist_bd", (String)("hg, assval " + flexToValueSource[0]), (QFilter[])filterList.toArray(new QFilter[0]), null));
        }
        LOGGER.info("CfFormulaContext_initAssistNumToHg assistNumToHgDtMap:" + this.assistNumToHgDtMap);
    }

    public Map<String, Long> getOrgNumToIdMap() {
        return this.orgNumToIdMap;
    }

    public Map<String, Long> getBookTypeNumToIdMap() {
        return this.bookTypeNumToIdMap;
    }

    public Table<String, String, Long> getPeriodTypeIdTable() {
        return this.periodTypeIdTable;
    }

    public Map<Long, Table<String, String, Long>> getPeriodTypeToPeriodIdMap() {
        return this.periodTypeToPeriodIdMap;
    }

    public Table<String, String, Set<Long>> getOrgAndCashFlowNumToIdsTable() {
        return this.orgAndCashFlowNumToIdsTable;
    }

    public Map<String, Object[]> getAssistNumToAssistInfoMap() {
        return this.assistNumToAssistInfoMap;
    }

    public Table<String, String, Map<String, Set<Long>>> getAssistValueIdTable() {
        return this.assistValueIdTable;
    }

    public Map<String, DataSet> getAssistNumToHgDtMap() {
        return this.assistNumToHgDtMap;
    }
}

